@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")

<div class="row">

  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewDelivery') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>

    <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <!-- begin sale order modal -->
      <!-- end sale order modal -->
      <!-- BEGIN FORM-->
      {{Form::open(['route' => 'delivery.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
      {{ csrf_field() }}
      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label"> @lang('layout.SelectProject')</label>
                  <v-select label="name" v-model="selectedProject" :options="project_items" @input="getFormulaItem(this)" @search="ProjectSearch"></v-select>
                  <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.project_id">
                  <input type="hidden" name="customer_id" :value="(!selectedProject)?null:selectedProject.customer_id">
                </div>
              </div>

              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">@lang('layout.Date')</label>
                  <input type="text" name="date" class="form-control date" autocomplete="off">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">@lang('layout.Code') </label>
                  <input type="number" name="number" value="{{$number}}" class="form-control">
                </div>
              </div>

            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
              <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <div class="form-group">
                    <label class="control-label">@lang('layout.Description')</label>
                    <textarea name="description" class="form-control" rows="2"></textarea>
                </div>
              </div>
            </div>
            <!-- end inputs -->
          </div>
          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
            <!-- begin total -->
            <div class="dashboard-stat2 ">
              <table class="dashboard-tabel" width="100%">
                <tr>
                  <td>
                    <small>@lang('layout.Total') :</small>
                  </td>
                  <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                  </td>
                </tr>
              </table>
            </div>
          </div>
        </div>

        <div class="row" v-if="inventories.length>0" style="">
          <li class="list-group-item bg-green bg-font-green"> @lang('layout.StuffDetails') </li>
          <table id="table_content" class="table table-bordered table-advance">
            <thead>
              <tr>
                <th class="text-center" style="min-width: 8px;"> # </th>
                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.QutOut')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                <!-- th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th -->
                <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>

                <th style="min-width: 20px;"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(item,index) in inventories">
                <td>@{{index+1}}</td>
                <td class="highlight">
                  <v-select label="name" v-model="item.item" :options="temp_items" @click.native="addNew('inventory',index)" @input="checkExistingService(index)"></v-select>
                  <input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">
                </td>
                <td class="highlight">
                  <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                    <option value="null">@lang('layout.Select')</option>
                    <span v-if="(item.item != null)">
                      <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                        @{{site.site_name}}
                      </option>
                    </span>
                  </select>

                  <input type="hidden" name="from_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                </td>
                <td>
                  <input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                </td>

                <td>
                  @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                </td>
                <td class="highlight">
                  <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                    <option value="null">@lang('layout.Select')</option>
                    <span v-if="(item.item ==null)?false:true">
                      <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                        @{{measure.measure_name}}
                      </option>
                    </span>
                  </select>
                  <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                </td>
                <td>
                  <div class="input-group">
                    <input type="hidden" name="cost[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:(item.item.cost)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                    <input type="number" class="form-control inner_input" :value="myRound(((item.item==null)?0:item.item.cost)*((item.item==null)?0:item.item.quantity))" placeholder="@lang('layout.Total')" disabled>

                  </div>
                </td>
                <td>
                  <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                </td>
              </tr>
            </tbody>
          </table>

          <!-- end payments -->
        </div>
        <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addItems('delivery')">@lang('layout.AddItem')
        </button>




        <div class="row" v-if="projectInventories.length>0" style="">
          <li class="list-group-item bg-green bg-font-green"> @lang('layout.ProjectItems') </li>
          <table id="table_content" class="table table-bordered table-advance">
            <thead>
              <tr>
                <th class="text-center" style="min-width: 8px;"> # </th>
                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.QutOut')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                <!-- th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th -->
                <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                <th style="min-width: 20px;"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(item,index) in projectInventories">
                <td>@{{index+1}}</td>
                <td class="highlight">
                  <v-select label="name" v-model="item.item" :options="projectNewItem" @click.native="addNew('project_inventory',index)" ></v-select>
                  <input type="hidden" name="project_item[]" :value="(!item.item)?null:item.item.id">
                  <input type="hidden" name="project_item_name[]" :value="(!item.item)?null:item.item.name">
                </td>
                <td>
                  <input type="number" name="project_quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                </td>

                <td>
                  @{{myRound((item.item==null)?null:item.item.qty)}}
                </td>
                <td class="highlight">
                  <input type="text" class="form-control" name="project_measure[]" :value="(item.item==null)?null:item.item.measure_unit">
                </td>
                <td>
                  <div class="input-group">
                    <input type="hidden" name="project_cost[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:(item.item.new_rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                    <input type="number" class="form-control inner_input" :value="(item.item==null)?null:((item.item.new_rate)*((item.item==null)?null:item.item.quantity)).toFixed(precision())" placeholder="@lang('layout.Total')" disabled>

                  </div>
                </td>
                <td>
                  <span v-on:click="deleteItem('project_inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                </td>
              </tr>
            </tbody>
          </table>

          <hr>

          <!-- end payments -->
        </div>
        <button v-if="projectInventories.length <= 0 " type="button" class="btn default" @click="addItems('project_inventory')">@lang('layout.AddItem')
        </button>

        <div class="row">
          <div class="col-md-offset-3 col-md-9">
            <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
            <a href="{{route('delivery.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

          </div>
        </div>


      </div>

      {!! Form::close() !!}

    </div>
    <!-- END FORM-->
  </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
  @if(App::getLocale())
  Vue.use(VeeValidate, {
    locale: '{{App::getLocale()}}',
  });
  @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif

  Vue.component('v-select', VueSelect.VueSelect);

  // end new member

  var v = new Vue({
    el: '#appInvoice',
    data: {

      expenseAccount: null,
      temp_items: [],
      AllTemp_items: [],
      projectNewItem: [],
      project_items: [],
      selectedProject: null,
      selected_item: null,
      items: [],
      selected_formula: null,
      formula_list: [],

      newCost: [
        null,
        null
      ],
      inventories: [{
          item: null
        },
        {
          item: null
        },
      ],
      projectInventories: [{
          item: null
        },
        {
          item: null
        },
      ],

    },
    computed: {


      // calculate subtotal
      subtotal: function() {
        var sum = 0;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item && this.inventories[i].item != null) {
            var quantity = this.inventories[i]['item']['quantity'];
            var rate = this.inventories[i]['item']['rate'];
            var new_rate = this.inventories[i]['item']['new_rate'];
            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
            var measure_unit = this.inventories[i]['item']['measure_unit'];
            if (new_rate != rate && quantity > 0) {
              sum += new_rate * quantity;
            } else {
              sum += quantity * ((rate * smeasure_unit / measure_unit));
            }

          }

        }
        for (var i = 0; i < this.projectInventories.length; i++) {
          //console.log('33',this.projectInventories);
          if (this.projectInventories[i].item && this.projectInventories[i].item != null) {
            var quantity = this.projectInventories[i]['item']['quantity'];
            var new_rate = this.projectInventories[i]['item']['new_rate'];
            if (new_rate && quantity > 0) {
              sum += new_rate * quantity;
            }
          }

        }

        return sum.toFixed(precision());
      },

      // check payed amount

      // check data validation
      isError: function() {
        var isError = false;
        var flag = false;
        for (var i = 0; i < this.projectInventories.length; i++) {

          if (this.projectInventories[i].item) {
            flag = true;
          }
        }
        for (var i = 0; i < this.inventories.length; i++) {

          if (this.inventories[i].item) {
            flag = true;
            if (((this.inventories[i]['item']['rate'] <= 0))) {
              rate = this.inventories[i]['item']['rate'];
              new_rate = this.inventories[i]['item']['new_rate'];
              // if (rate <= 0 && new_rate <= 0) {
              //   isError = true;
              // }

            }
          }
        }
        if (this.inventories.length == 0 || flag == false) {
          isError = true;
        }
        return isError;


      },
    },
    methods: {

      // Search Project 

      ProjectSearch: _.debounce((search, loading) => {
        v.project_items = [];
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'serarchProject',
              keyword: search,
            }
          })
          .then(function(response) {
            this.project_items = [];
            if (response.data.length > 0) {
              v.project_items = response.data;
              console.log('test 22', v.project_items);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),


      getFormulaItem(e) {
        if (this.selectedProject && this.selectedProject != null) {
          this.onProjectItemSearch(this.selectedProject.project_id, this);
        }
      },


      //ajax call to get items
      onProjectItemSearch: _.debounce((project_id, vm) => {
        v.formula_list = [];
        v.selected_formula = null;
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'serarchDeliveryItem',
              project_id: project_id,
            }
          })
          .then(function(response) {
            // console.log('sssss', response.data.projectItem);
            v.items = [];
            if (response.data.length > 0) {
              vm.items = response.data;
            }
            //v.temp_items=[];
            if (response.data.projectItem.length > 0) {
              v.temp_items = response.data.projectItem;
              v.AllTemp_items = response.data.projectItem;
              // console.log('new data', v.temp_items);
            }
            //v.projectNewItem=[];
            if (response.data.projectNewItem.length > 0) {
              v.projectNewItem = response.data.projectNewItem;
              console.log('new data1', v.projectNewItem);
            }
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),

          checkExistingService(index = null, name = '') {
          var item_temp = this.AllTemp_items.slice();
          var item_temp1 = [];
          for (var i = 0; i < this.inventories.length; i++) {
              if (this.inventories[i].item != null) {
                  var fined = item_temp.findIndex((item) => item.name == this.inventories[i].item.name);
                  if (fined != -1) {
                      var o = item_temp.splice(item_temp.findIndex((item) => item.name == this.inventories[i].item.name), 1);
                  }
              }
          }
          this.temp_items = item_temp.filter((item) => {
              return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
          });
      },


      handleSubmit(e) {
        this.$validator.validate().then(valid => {
          if (valid) {
            // alert(e.target);
            regForm(e.target);
          }
        });
      },

      // set new price
      setNewRate(type = null, index) {
        if (type == 'inventory') {
          if (this.inventories[index].item) {
            this.inventories[index].item.new_rate = this.$refs.in[index].value;
          }
        }

      },
      // calculate item price based on measure change
      measureChange(index) {

        if (this.inventories[index].item != null) {
          var item = this.inventories[index].item;

          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
          result = Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate = result;

          // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

        }
      },

      // calculate item price based on measure change

      // detect member change and searh



      //ajax call to get items
      onItemSearch: _.debounce((search, loading) => {
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'itemSearchProcurment',
              keyword: search,
            }
          })
          .then(function(response) {
            //v.temp_items=[];
            if (response.data.length > 0) {
              v.temp_items = response.data;
              v.AllTemp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),

      addItems(type) {
        if (type != null) {
          if (type == "delivery") {
            //this.temp_items=[];
            this.inventories.push({
              item: null
            });
          }
          if (type == "project_inventory") {
            //this.temp_items=[];
            this.projectInventories.push({
              item: null
            });
          }

        }

      },

      // end item search

      // contract search

      // end contract search

      // generic function for adding item to list
      addNew(type = null, index) {
        if (type != null) {
          if (type == 'inventory') {
            this.checkExistingService(index, '');
            if (this.inventories[index + 1] == undefined) {
              this.inventories.push({
                item: null
              });
            }
          }
          if (type == 'project_inventory') {
            if (this.projectInventories[index + 1] == undefined) {
              this.projectInventories.push({
                item: null
              });
            }
          }
        }
      },

      // in here you can check and decide to allow duplicate bank for payment or not


      // delete item from list
      deleteItem(type = null, index) {
        if (type != null) {
          console.log(type);
          if (type == 'inventory') {
            this.inventories.splice(index, 1);
          }
          if (type == 'project_inventory') {
            this.projectInventories.splice(index, 1);
          }

        }

      },
      // submit the form
      
  

    },


  });
</script>



@endpush