@section('styles')
    <style>
        .sorting {
            background-image: url('./datatable_icons/sort_both.png');
            background-repeat: no-repeat;
            background-position: center right;
        }

        .sorting_asc {
            background-image: url('./datatable_icons/sort_asc.png');
            background-repeat: no-repeat;
            background-position: center right;
        }

        .sorting_desc {
            background-image: url('./datatable_icons/sort_desc.png');
            background-repeat: no-repeat;
            background-position: center right;
        }
    </style>
@endsection
@push('scripts')
    <script>
        Vue.component('datatable',{
            props: ['columns', 'sortKey', 'sortOrders'],
            template:
            `
       
             <table class="table table-bordered table-hover">
             <thead>
            <tr>
                <th v-for="column in columns" :key="column.name" @click="$emit('sort', column.name)"
                    :class="sortKey == column.name ? (sortOrders[column.name] > 0 ? 'sorting_asc' : 'sorting_desc') : 'sorting'"
                    style="cursor:pointer">
                   
                    <span style="margin:5px">@{{column.label}}</span>
                    
                </th>
            </tr>
            </thead>
              <tbody>
            <slot></slot>
             </tbody>

        </table>

            `,
        });
    </script>
@endpush