@extends('layouts.app')
@section('content')
<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.DailyExpenseInfo')
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
            {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.ID') 
                        </th>
                        <th class="">
                            <i class="fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th> 
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                        </th> 
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                        </th>
                        @if(getExpenseFromToDate()=="true")
                            @if($expenseInfo->from_date)
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.FromDate')
                            </th> 
                            @endif
                            @if($expenseInfo->to_date)
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.ToDate')
                            </th>
                            @endif
                        @endif
                        <th>
                            @lang('layout.Issue')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.ReceiptFactor')
                        </th> 
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.BuildExpense')
                        </th> 
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.ExpenseAccount')
                        </th> 
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.BankAccount')
                        </th>
                        <th> 
                            <i class="fa "></i> @lang('layout.TotalAmount') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Currency') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th> 
                        @if(systemConfig()[5] != 0 )
                        <th>
                            <i class="fa  "></i> @lang('layout.Status')
                        </th> 
                        @endif 
                        <th>
                            <i class="fa  "></i> @lang('layout.By')
                        </th> 
                        <th>
                            <i class="fa  "></i> @lang('layout.AttachmentCount')
                        </th> 
                    </tr>
                </thead>
                <tbody>
                    <tr>  
                        <td class=""> {{ $expenseInfo->number}}  </td>
                        <td class=""> {{ $expenseInfo->Description }}  </td> 
                        <td class=""> {{ convertDate($expenseInfo->Date) }} </td>
                        <td class=""> {{ convertDate($expenseInfo->overdue_date) }} </td>
                        <td class=""> {{ $expenseInfo->hour }}  </td> 
                        @if(getExpenseFromToDate()=="true")
                        @if($expenseInfo->from_date)
                        <td class=""> {{ convertDate($expenseInfo->from_date) }} </td>
                        @endif
                        @if($expenseInfo->to_date)
                        <td class=""> {{ convertDate($expenseInfo->to_date) }} </td>
                        @endif
                        @endif
                        <td class="">
                            {{$expenseInfo->issue}}
                        </td>
                        <td class=""> {{ $expenseInfo->receipt_number }}  </td>

                        @if($expenseInfo->build_expense_confirm)
                        <td class="">
                            {{__('layout.'.ucfirst($expenseInfo->build_expense_confirm))}}
                        </td>
                        @else
                            <td>

                            </td>
                        @endif
                        
                        <td class=""> {{ $expenseInfo->expense_account }}  </td>
                        <td class=""> {{ $expenseInfo->Bank}}  </td>
                        <td class=""> {{ $expenseInfo->amount}}  </td>
                        <td class=""> {{ $expenseInfo->Currency }}  </td>
                        <td class=""> {{ $expenseInfo->Rate }}  </td>
                        @if(systemConfig()[5] != 0 )
                        <td class=""> @if($expenseInfo->status){{__('type.'.$expenseInfo->status)}} @endif </td>
                        @endif
                        <td class=""> {{ $expenseInfo->person_by }}  </td>
                        <td class=""> {{ $expenseInfo->attachment_count }}  </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        @if(systemConfig()[20] == 1)
                        <th>
                            @lang('menu.Contract')
                        </th>
                        @endif
                        <th width="">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th width=" ">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        @if(systemConfig()[20] == 1)
                        <td>{{ $expenseInfo->contract}}</td>
                        @endif
                        <td class=" "> {{ $expenseInfo->description}}  </td>
                        <td class=" "> {{ $expenseInfo->memo}}  </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
    <div class="tabbable tabbable-tabdrop">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.DailyExpenseDetails')</a>
            </li>
            <li class="">
                <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab1">
                <div class="row">
                    <!-- app -->
                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.DailyExpenseDetails')</span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="daily_expense_Details"/>
                                    <input type="hidden" name="id" value="{{$expenseInfo->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}} 

                                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="daily_expense_Details"/>
                                    <input type="hidden" name="id" value="{{$expenseInfo->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}  
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="sales">
                                    <thead>
                                        <tr>  
                                            <th>@lang('layout.Details')</th>
                                            @if(QuantityInDailyExpense() == 'true')
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.PerPrice')</th>
                                            <th>@lang('layout.Measure')</th>
                                            @endif
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.CreatedAt')</th>
                                            <th>@lang('layout.UpdatedAt')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>
            <div class="tab-pane" id="tab2"> 
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="portlet light bordered">
                            <div class="portlet-body">
                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">                       
                                    @csrf
                                    <input type="hidden" name="redirect_route" value="dailyExpense.show">
                                    <input type="hidden" name="foreign_data_id" value="{{$expenseInfo->id}}">
                                    <input type="hidden" name="path" value="uploads/dailyExpense">
                                    <input type="hidden" name="table_name" value="daily_expenses">
                                    <div class="row">
                                        <div class="col-lg-12 col-md-12">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                <input type="text" name="title" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                <textarea name="description" rows="7" style="resize: none" class="form-control"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                    <div style="margin-top: 5px">
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                    </div>
                                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 146px;">
                                                        <img src="" alt=""> 
                                                    </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px; line-height: 10px;"> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="margin-top-10 text-center">
                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                        <a href="{{route('dailyExpense.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="attachment">
                            <thead>
                            <tr>  
                            <th>@lang('layout.AttachmentTitle')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Action')</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#sales').DataTable({
        ajax:{
            url:'{{route("dailyExpense.show",$expenseInfo->id)}}',
            data:{type:'expense'}
        },
        scrollCollapse: true,
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        serverSide: true,
        paging: true,
        columns: [
            { data: 'description', name: 'expense_details.description' },
            @if(QuantityInDailyExpense() == 'true')
            { data: 'quantity', name: 'quantity',orderable:false,searchable:false },
            { data: 'price_fe', name: 'price_fe',orderable:false,searchable:false },
            { data: 'measure', name: 'measure',orderable:false,searchable:false },
            @endif
            { data: 'amount', name: 'amount',orderable:false,searchable:false },
            { data: 'created_at', name: 'created_at',orderable:false,searchable:false },
            { data: 'updated_at', name: 'updated_at',orderable:false,searchable:false },
        ]
    });       
    $('#attachment').DataTable({
        ajax:{
            url:'{{route("dailyExpense.show",$expenseInfo->id)}}',
            data:{type:'attachment'}
        },
        scrollCollapse: true,
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        serverSide: true,
        paging: true,
        columns: [
            { data: 'title', name: 'attachments.title'},
            { data: 'description', name: 'attachments.description'},
            { data: 'actions',         name: 'actions', orderable:false,searchable:false},
        ]
    });
});
</script>
@endpush 