@extends('layouts.app')
@section('style')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
<style type="text/css">
    .v-select .selected-tag {
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection 
<?php 
    $report =customeReportNew('daily_expense_index');
    $_category= !in_array('category', $report);
    $_overdueDate= !in_array('overdueDate', $report);
    $_user= !in_array('user', $report);
    $_hour = !in_array('hour', $report);
    $_issue = !in_array('issue', $report); 
?>
@section('content')
@include('dailyExpense.modal')
    <!-- END PAGE HEADER-->
    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'dailyExpenses'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">                                
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Category') </label>
                                                <v-select class="vue-select2"
                                                        v-model="selected_expense_category"
                                                        label="name"
                                                        :options="expense_category"
                                                        @search="onCategorySearch"
                                                        >
                                                </v-select>
                                                <input type="hidden" name="category_id" :value="(!selected_expense_category)?null:selected_expense_category.id">
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Bank') </label>
                                                <v-select class="vue-select2"
                                                        v-model="selected_bank"
                                                        label="name"
                                                        :multiple="true"
                                                        :options="bank"
                                                        @search="searchAccount"
                                                        >
                                                </v-select>
                                                {{-- <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id"> --}}
                                                <input type="hidden" name="bank_id" :value="bank_id.length > 0 ? bank_id:null">
                                            </div> 
                                            {{-- <div class="col-md-3">
                                                <label class="control-label">@lang('layout.By'):</label>
                                                <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_customer"></v-select>
                                                <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id">
                                            </div>   --}}
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.AllCategory') </label>
                                                <select name="all_categories" id="" class="form-control">
                                                    <option value="">@lang('layout.SelectCategory')</option>
                                                    <option value="all">@lang('layout.AllCategory')</option>
                                                    <option value="total_by_category">@lang('layout.TotalByExpenseCategory')</option>
                                                    <option value="total_by_category_and_class">@lang('layout.TotalByExpenseCategoryAndClass')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                            @if(getFinancialClass() =='true') 
                                                @permission('financialClass-list')
                                                <div class="col-md-4">
                                                    <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                    <select name="financial_class_id" class="form-control" >
                                                        <option value="">@lang('layout.SelectClass')</option>
                                                        <option value="Unclassified">Unclassified</option>
                                                        <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                    </select>
                                                </div>
                                                @endpermission
                                            @endif
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Type') </label>
                                                <select name="report_type" id="" class="form-control">
                                                    <option value="">@lang('layout.Select')</option>
                                                    <option value="details">@lang('layout.Details')</option>
                                                    <option value="total_by_account">@lang('layout.TotalByExpenseAccount')</option>                 
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.Expense') </label>
                                                <v-select
                                                    label="name"
                                                    :options="expenses" 
                                                    v-model="selected_expense_account"
                                                    :multiple="true"
                                                    ></v-select>
                                                {{-- <input type="hidden" name="expense_id" v-bind:value="(!selected_expense_account)?null:selected_expense_account.id"/> --}}
                                                <input type="hidden" name="expense_id" :value="expense_id.length > 0 ? expense_id:null">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> 
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="daily_expense_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        <!-- <label> @{{ row.Name }}</label>
                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                        <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                        </label> -->
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->    
    
    <!-- END PAGE HEADER-->
    <div id="settingModal" v-cloak>
        <setting-modal :pdf-route="route" v-if="is_show" :value-type="'dailyExpenses'" @closed="closeModal">
            <div slot="header" class="text-center">
                <h4 style="font-weight: bold;">@lang('layout.CustomForms')</h4>
            </div>
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                            <div class="form-group">
                                <table class="table table-striped table-bordered table-advance">
                                    <tr style="background-color: rgba(227, 227, 227, 0.757)">
                                        <th style="text-align: center;">@{{ row.Name }}</th>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center;">
                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                            <label class="switch">
                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                :checked="row.checkedColumn" >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </setting-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.DailyExpense')</span>
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="portlet-title">
                <div class="caption font-dark">
                    <!-- <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase"> @lang('layout.DailyExpense') </span> --> 
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <span id="setting-modal">
                        <button type="submit" @click.prevent="showModal" class="btn" style="background-color: rgb(80, 129, 141);color: white;">
                            <i class="fa fa-wrench"></i>
                        </button>
                    </span>
                    <span onclick="getRecord();" class="btn blue">
                        <i class="fa fa-refresh" ></i>
                    </span>
                    <span id="anchore-modal">
                        <button type="submit" @click.prevent="showModal" class="btn btn-success">
                            <i class="fa fa-print"></i>
                        </button>
                    </span>
                    {{-- <a href="{{route('dailyExpense.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a> --}}
                    <span id="create-modal">
                        <a href="#" @click.prevent="showModal">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                    </span>
                </div>
            </div>
            <div class="portlet-body">
                <!--Begin Form-->
                {{Form::open(['route' => 'dailyExpense.store','method' => 'POST','class' => 'form-horizontal','id'=>'bill-submit','files'=> true])}}
                <div class="well well-lg" id="app" v-cloak v-show="show_create" style="background: transparent; border: 1px solid rgba(206, 206, 206, 0.323); padding: 10px 20px 40px; !important;">
                    <div class="row" style="padding: 0px !important;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row container" v-if="statusAttachment">
                                <div class="col-md-6">
                                    <span style="color: red;"> @lang('message.SaveAttachmentMessage') </span>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-md-4">
                                    <label class="control-label" style="cursor: pointer;" for="attachment">@lang('layout.Attachment') </label>
                                    <input type="checkbox" v-model="statusAttachment" id="attachment" name="attachment" style="transform: scale(1.8);cursor: pointer; margin-right: 10px;">
                                </div>
                            </div>
                            <div class="row" id="header_feilds" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" :options="setRates" v-model="selectedCurrency" @input="accountUpdates()"></v-select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Bank')</label>
                                            <select class="form-control select_style" name="bank" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                                </option>
                                            </select>
                                        </div>			
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Expense') </label>
                                            <v-select label="name" :options="expenses" v-model="selected_expense_account" @input="setAmount(selected_expense_account)"></v-select>
                                            <input type="hidden" name="expense_id" v-bind:value="(!selected_expense_account)?null:selected_expense_account.id"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3': 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div class="input-group">
                                                <input v-model="selectedCurrency.exchange_rate" class="form-control" :readonly="averageRate" type="number" step="any" min="0">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                                </div>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ') </label>
                                                <div class="input-group">
                                                    <input v-model="selectedCurrency.hq_rate" class="form-control" type="number" step="any" min="0">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="currency_rate_hq" :value="selectedCurrency.hq_rate">
                                    </div>
                                @endif
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? "col-lg-3 col-md-3" : 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Amount')</label>
                                            <span v-show="false">@{{defaultAmount=((!selectedBank?0:selectedBank.balance) -subtotal)}}</span>
                                            <input type="number" class="form-control" v-model="Number.parseFloat(defaultAmount).toFixed(precision())" disabled>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12 ">
                                            <label class="control-label">@lang('layout.Amount') </label>
                                            <span v-show="false">@{{totalExpense=(expenseAmount+subtotal)}}</span>
                                            <input type="number" v-model="Number.parseFloat(totalExpense).toFixed(precision())" class="form-control" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-2 col-md-4 col-sm-7 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'date')) displayNone @endif " >
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" class="form-control date" name="date" id="date" autocomplete="off" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                            <span class="required">@{{ errors.first('date') }}</span>
                                            {{-- {{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off' , 'v-validate' => 'required'])}} --}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-7 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'hour')) displayNone @endif ">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'category')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Category')</label>
                                            <v-select class="vue-select2" v-model="selected_category" label="name" :options="category" >
                                            </v-select>
                                            <input type="hidden" name="category_id" :value="(!selected_category)?null:selected_category.id">
                                        </div>
                                    </div>
                                </div>							
								<div class="col-lg-4 col-md-4 col-sm-7 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'issue')) displayNone @endif">
                                    <label class="control-label">@lang('layout.Issue')</label>
                                    <input type="text" class="form-control" name="issue">
                                </div>
                            </div>
							<div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-2 col-md-2 col-sm-7 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'number')) displayNone @endif">
									<label class="control-label">@lang('layout.Number')</label>
									{{Form::number('number',$number,['class' => 'form-control','v-model'=>'number'])}}
								</div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'overdueDate')) displayNone @endif ">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.OverdueDate')</label>
                                            {{Form::text('overdue_date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
								<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'description')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {!! Form::textarea('gDescription', null, array('placeholder' => __('layout.Description'),'class' => 'form-control description','rows' => 1, 'cols' => 30,'v-model'=>'gDescription')) !!}
                                        </div>
                                    </div>
                                </div>
                                @if(systemConfig()[5] != 0 )
                                    <div class="col-lg-4 col-md-4 @if(!getCustomeForm('dailyExpenses', 'project')) displayNone @endif"> 
                                        <label class="control-label">@lang('layout.Project')</label>
                                        <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                                        </v-select>
                                        <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                    </div>
                                @endif
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                @if(systemConfig()[20] == 1) 
                                    <div class="col-lg-4 col-md-4 @if(!getCustomeForm('dailyExpenses', 'contractName')) displayNone @endif">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="contract">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                @endif
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'by')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.By'):</label>
                                            {{-- <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_customer"></v-select>
                                            <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id"> --}}
                                            <input type="text" name="customer_id" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'attachmentCount')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.AttachmentCount')</label>
                                            {{-- <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_customer"></v-select>
                                            <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id"> --}}
                                            <input type="text" name="attachment_count" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'memo')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="1" v-model="memo"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                @if(getExpenseFromToDate()=="true")
                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'fromDate')) displayNone @endif">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.FromDate')</label>
                                                {{Form::text('from_date_expense',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'toDate')) displayNone @endif">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ToDate')</label>
                                                {{Form::text('to_date_expense',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'receipt_number')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReceiptFactor')</label>
                                            {{Form::text('receipt_number',null,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'buildExpense')) displayNone @endif">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.BuildExpense')</label>
                                            <input type="checkbox" name="build_expense_confirm" id="" value="On">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-10">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="dashboard-stat2">
                                    <table class="dashboard-tabel table-bordered" width="100%" style="">
                                        <tr style="background: rgba(128, 128, 128, 0.271);">
                                            <td class="text-center">
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-center">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{ Number.parseFloat(subtotal).toFixed(2)}}
                                                </span>
                                                <input type="hidden" name="total" :value="subtotal">
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                                <br>
                                                <span data-counter="counterup" data-value="7800">
                                                    @if(systemConfig()[30] == 1)
                                                    @{{myRound(Number.parseFloat(subtotal).toFixed(2)/selectedCurrency.static_rate * selectedCurrency.exchange_rate)}}
                                                    @else
                                                    @{{myRound(Number.parseFloat(subtotal).toFixed(2)/selectedCurrency.exchange_rate)}}
                                                    @endif
                                                    <small class="font-green-sharp"> {{getHomeCurrency()['code']}} </small>
                                                </span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- Attachment Started .................................................. --}}
                    {{-- <div class="col-md-9" v-if="statusAttachment">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                    <input type="text" name="attachment_title" class="form-control">
                                </div>
                                <input type="hidden" name="attachment_path" value="uploads/dailyExpense">
                                <input type="hidden" name="attachment_table_name" value="daily_expenses">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="attachment_description" rows="8" style="resize: none" class="form-control"></textarea>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                        <div>
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" value="" name=""><input type="file" name="attachment_photo"> </span>    
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                        </div>
                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                            <img src="" alt=""> 
                                        </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 165px; line-height: 10px;"> </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                    <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                        <div class="row">
                            <div class="container"  v-if="statusAttachment"> 
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" name="attachment_title" class="form-control">
                                    </div>
                                </div>     
                                <input type="hidden" name="attachment_path" value="uploads/dailyExpense">
                                <input type="hidden" name="attachment_table_name" value="daily_expenses">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="attachment_description" rows="8" style="resize: none" class="form-control"></textarea>
                                </div>
                                <div class="col-md-6">
                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                        <div>
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" value="" name=""><input type="file" name="attachment_photo"> </span>    
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                        </div>
                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                            <img src="" alt=""> 
                                        </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 165px; line-height: 10px;"> </div>
                                    </div>
                                </div> 
                            </div>
                            {{-- <div class="container"   v-if="statusAttachment"> 
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="attachment_description" rows="3" style="resize: none" class="form-control"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-5" style="margin-top: 5px;">
                                    <div class="form-group">
                                        <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                            <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <input type="hidden" value="" name=""><input type="file" name="attachment_photo"> </span>    
                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                            </div>
                                            <div class="fileinput-new thumbnail" style="width: 100%; height: 75px;">
                                                <img src="" alt=""> 
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 80; line-height: 10px;"> </div>
                                        </div>
                                    </div>
                                </div> 
                                <div class="col-md-1"></div>
                            </div> --}}
                        </div>
                    </div>
                    {{-- End Attachment ......................................................... --}}
                    <br>
                    <!-- <div class="form-section"></div> -->
                    <div class="row" style="padding: 0px 10px;">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                        <tr style="background-color: rgb(84, 199, 211);color:white">
                                            <th class="text-center" style="width:3px;">#</th>
                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.Description')
                                            </th>
                                            @if(QuantityInDailyExpense() == 'true')
                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.Quantity')
                                            </th>
                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.PerPrice')
                                            </th>
                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.Measure')
                                            </th> 
                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.TotalAmount')
                                            </th>
                                            @else 
                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.Quantity')
                                            </th>
                                            @endif
                                            <th style="min-width: 4px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for=" (row,itemIndex) in rows" class="even">
                                            <td class="td_one"><span span v-if="rows.length >1 "
                                            class="badge badge3 badge-roundless" style="background-color: transparent !important; color: black;">@{{itemIndex+1}} </span>
                                            </td>
                                            <td>
                                                {{Form::text('description[]',null,['class' => 'form-control','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null',
                                                'placeholder' =>__('layout.Description'),'autocomplete'=>'off'])}}
                                            </td>
                                            @if(QuantityInDailyExpense() == 'true')
                                            <td width="20%;" class="td_one">
                                                <div class="input-group"> 
                                                    <input type="number" step="any" name="quantity[]" class="form-control" v-model="row.quantity" step="any" min="0" @input="GiveTotal('row',itemIndex)" 
                                                     placeholder="@lang('layout.PerPrice')"
                                                     v-validate="''" data-vv-as="@lang('layout.PerPrice')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                            </td>
                                            <td width="20%;" class="td_one">
                                                <div class="input-group"> 
                                                    <input type="number" step="any" name="price_fe[]" class="form-control" v-model="row.price_fe" step="any" min="0" @input="GiveTotal('row',itemIndex)"
                                                     placeholder="@lang('layout.Quantity')"
                                                    v-validate="''" data-vv-as="@lang('layout.Quantity')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                            </td>
                                            <td width="20%;" class="td_one">
                                                <v-select class="vue-select2" v-model="row.selectedMeasure" label="name" :options="(measure)" class="form-control"> 
                                                </v-select>
                                                <input type="hidden" name="measure_id[]" v-model.number="(!row.selectedMeasure)?null:row.selectedMeasure.id">
                                            </td>
                                            <td width="20%;" class="td_one">
                                                <div class="input-group"> 
                                                    <input type="number" step="any" name="total_amount[]" class="form-control" v-model="row.total_amount" step="any" min="0"  readonly placeholder="@lang('layout.TotalAmount')"
                                                    data-vv-as="@lang('layout.TotalAmount')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                {{-- <span v-if="row.amount" style="color: blue; font-size:12px">@{{(row.amount==null)? 0:numFormatter(row.amount).result}}</span> --}}
                                            </td>
                                            @else 
                                            <td width="50%;" class="td_one"> 
                                                <div class="input-group">
                                                    <vue-numeric
                                                        v-on:focus="(rows.length-1 == itemIndex)?addRow():null"
                                                        class="form-control"
                                                        v-model="row.amount"
                                                        :max="99999999999999"
                                                        :currency="selectedCurrency.code"
                                                        :precision="precision()"
                                                        >
                                                    </vue-numeric> 
                                                    <input type="hidden" name="amount[]" class="form-control" v-model="row.amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                {{-- <span v-if="row.amount" style="color: blue; font-size:12px">@{{(row.amount==null)? 0:numFormatter(row.amount).result}}</span> --}}
                                            </td>
                                            @endif
                                            <td class="text-center">
                                                <span span v-if="rows.length >1 " v-on:click="deleteRow(itemIndex)">
                                                    <i class="paddint-both fa fa-trash" style="color: red"></i>
                                                </span> 
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin: 10px 0px;">
                        <button type="button" class="btn green" :disabled="disabled" @click="handleSubmit($event)" >@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" :disabled="disabled" @click="checkRepeat($event)">@lang('layout.SaveAndNew')</button>
                        <a @click="show_create = false" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>
            </div>
            {{Form::close()}}
            <!--End Form-->
            <table class="table table-striped table-bordered table-hover" id="dailyExpenses">
                <thead>
                    <tr>
                        <th>@lang('layout.Record')</th>
                        @if(getCustomeForm('dailyExpenses', 'number'))
                        <th>@lang('layout.Number')</th>
                        @endif
                        @if(getCustomeForm('dailyExpenses', 'date'))
                        <th>@lang('layout.Date')</th>
                        @endif
                        @if(getCustomeForm('dailyExpenses', 'description'))
                        <th>@lang('layout.Description')</th>
                        @endif
                        <th>@lang('layout.ExpenseAccount')</th>
                        @if(getCustomeForm('dailyExpenses', 'category'))
                        <th>@lang('layout.Category')</th>
                        @endif
                        @if(getCustomeForm('dailyExpenses', 'issue'))
                        <th>@lang('layout.Issue')</th>
                        @endif
                        <th>@lang('layout.BankAccount')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        @if(getCustomeForm('dailyExpenses', 'overdueDate')) 
                        <th>@lang('layout.OverdueDate')</th>
                        @endif
                        @if(getCustomeForm('dailyExpenses', 'hour'))
                        <th>@lang('layout.Hour')</th>
                        @endif
                        @if(getCustomeForm('dailyExpenses','status'))
                        @if(systemConfig()[5] != 0 )
                        <th>@lang('layout.Status')</th>
                        @endif
                        @endif
                        @if(getCustomeForm('dailyExpenses', 'user'))
                        <th>@lang('layout.User')</th>
                        @endif
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@endsection
@include('print.modal')
@include('layouts.setting_model')
@include('groupCompanyFilter.select')
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script>
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);
        @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        function printVoucher(id,sendWhatsapp = null) {
            var a = document.createElement('a');
            a.href = "{{url('printDailyExpense')}}/" + id ;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        var expense_category = {!! json_encode($category) !!}
        var cust_rep = {!!customeReportNewData('daily_expense_index')!!};
        let data_table;
        function getRecord() { 
            data_table = $('#dailyExpenses').DataTable({
                ajax: {
                    ajax: '{{route("dailyExpense.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                }, 
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?1:2}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                destroy: true,             
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [  
                    {data: 'id', name: 'daily_expenses.id', searchable: false},
                    @if(getCustomeForm('dailyExpenses', 'number'))
                    {data: 'number', name: 'daily_expenses.number'},
                    @endif
                    @if(getCustomeForm('dailyExpenses', 'date'))
                    {data: 'Date', name: 'daily_expenses.Date' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    @if(getCustomeForm('dailyExpenses', 'description'))
                    {data: 'Description', name: 'daily_expenses.description'},
                    @endif
                    {data: 'expense_account', name: 'exA.name'},
                    @if(getCustomeForm('dailyExpenses', 'category'))
                    {data: 'Name', name: 'expense_categories.name' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    @if(getCustomeForm('dailyExpenses', 'issue'))
                    {data: 'issue', name: 'issue'},
                    @endif
                    {data: 'Bank', name: 'accounts.name'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'Currency', name: 'transactions.unit'},
                    {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                    @if(getCustomeForm('dailyExpenses', 'overdueDate')) 
                    {data: 'overdue_date', name: 'daily_expenses.overdue_date' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    @if(getCustomeForm('dailyExpenses', 'hour'))
                    {data: 'hour', name: 'daily_expenses.hour'},
                    @endif
                    @if(getCustomeForm('dailyExpenses','status'))
                    @if(systemConfig()[5] != 0 )
                    {data: 'status', name: 'daily_expenses.status', searchable: false},
                    @endif
                    @endif
                    @if(getCustomeForm('dailyExpenses', 'user'))
                    {data: 'username', name: 'users.name'},
                    @endif
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();
        });
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                financial_classes: {!!getFinancialClassList()!!},
                selectedMember: null,
                memberlist: [],
                selected_expense_category:null,
                expense_category:[],
                // selected_bank:null,
                selected_bank:[],
                customer: [],
                selected_customer: null,
                bank_id:[],
                bank:[],
                date: null,
                expense_id:[],
                selected_expense_account:[],
                expenses: {!! $expense !!},
                customReportData:
                [    
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.ReceiptFactor")', column_name: 'receipt_number',checkedColumn:(cust_rep.receipt_number)?'checked':'',column_percentage:(cust_rep.receipt_number___percent)?cust_rep.receipt_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.OverdueDate")', column_name: 'overdueDate',checkedColumn:(cust_rep.overdueDate)?'checked':'',column_percentage:(cust_rep.overdueDate___percent)?cust_rep.overdueDate___percent:''},
                 @if(getExpenseFromToDate()=="true")
                 {Name: '@lang("layout.FromDate")', column_name: 'fromDate',checkedColumn:(cust_rep.fromDate)?'checked':'',column_percentage:(cust_rep.fromDate___percent)?cust_rep.fromDate___percent:''},
                 {Name: '@lang("layout.ToDate")', column_name: 'toDate',checkedColumn:(cust_rep.toDate)?'checked':'',column_percentage:(cust_rep.toDate___percent)?cust_rep.toDate___percent:''},
                 @endif
                 {Name: '@lang("layout.ExpenseAccount")', column_name: 'expense_account',checkedColumn:(cust_rep.expense_account)?'checked':'',column_percentage:(cust_rep.expense_account___percent)?cust_rep.expense_account___percent:''},
                 {Name: '@lang("layout.BankAccount")', column_name: 'bank_account',checkedColumn:(cust_rep.bank_account)?'checked':'',column_percentage:(cust_rep.bank_account___percent)?cust_rep.bank_account___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Amount") $', column_name: 'amount1',checkedColumn:(cust_rep.amount1)?'checked':'',column_percentage:(cust_rep.amount1___percent)?cust_rep.amount1___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                 {Name: '@lang("layout.Issue")', column_name: 'issue',checkedColumn:(cust_rep.issue)?'checked':'',column_percentage:(cust_rep.issue___percent)?cust_rep.issue___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.BuildExpense")', column_name: 'build_expense',checkedColumn:(cust_rep.build_expense)?'checked':'',column_percentage:(cust_rep.build_expense___percent)?cust_rep.build_expense___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Details")', column_name: 'details',checkedColumn:(cust_rep.details)?'checked':'',column_percentage:(cust_rep.details___percent)?cust_rep.details___percent:''},
                 {Name: '@lang("layout.By")', column_name: 'by',checkedColumn:(cust_rep.by)?'checked':'',column_percentage:(cust_rep.by___percent)?cust_rep.by___percent:''},
                 {Name: '@lang("layout.AttachmentCount")', column_name: 'attachment_count',checkedColumn:(cust_rep.attachment_count)?'checked':'',column_percentage:(cust_rep.attachment_count___percent)?cust_rep.attachment_count___percent:''},
                 {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_rep.project)?'checked':'',column_percentage:(cust_rep.project___percent)?cust_rep.project___percent:''},
                 {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                ],
                cust_rep:cust_rep
            },
            watch: {
                selected_bank: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });
                    this.bank_id = x;
                    console.log('x value');
                    console.log(x);
                },
                selected_expense_account: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });
                    this.expense_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                MemberSearch: _.debounce((search, loading) => {   
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.customer = [];
                            vm.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                onCategorySearch(search, loading) {
                    loading(true);
                    this.searchCategory(search, loading, this);
                },
                //ajax call to get expense_categories
                searchCategory(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'expense_categories',

                        }
                    })
                    .then(function (response) {
                        this.expense_category = [];
                        if (response.data.length > 0) {
                            vm.expense_category = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get expense_categories
                searchAccount(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'accounts',
                            filterColumn: 'type',
                            filterValue: 'bank',
                        }
                    })
                    .then(function (response) {
                        this.bank = [];
                        if (response.data.length > 0) {
                            vm.bank = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                            console.log('data', vm.memberlist);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });
        /// custom form
        var cust_form = {!!customeForm('dailyExpenses')!!};
        var sm = new Vue({
            el: '#settingModal',
            data: {
                is_show: false,
                route: '{!!route("customForm.store") !!}',
                customReportData:
                [    
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_form.date)?'checked':''},
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_form.hour)?'checked':''},
                    {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_form.category)?'checked':''},
                    {Name: '@lang("layout.Issue")', column_name: 'issue',checkedColumn:(cust_form.issue)?'checked':''},
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_form.number)?'checked':''},
                    {Name: '@lang("layout.OverdueDate")', column_name: 'overdueDate',checkedColumn:(cust_form.overdueDate)?'checked':''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_form.description)?'checked':''},
                    {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_form.project)?'checked':''},
                    {Name: '@lang("layout.ContractName")', column_name: 'contractName',checkedColumn:(cust_form.contractName)?'checked':''},
                    {Name: '@lang("layout.By")', column_name: 'by',checkedColumn:(cust_form.by)?'checked':''},
                    {Name: '@lang("layout.AttachmentCount")', column_name: 'attachmentCount',checkedColumn:(cust_form.attachmentCount)?'checked':''},
                    {Name: '@lang("layout.Memo")', column_name: 'memo',checkedColumn:(cust_form.memo)?'checked':''},
                    {Name: '@lang("layout.ReceiptFactor")', column_name: 'receipt_number',checkedColumn:(cust_form.receipt_number)?'checked':''},
                    {Name: '@lang("layout.BuildExpense")', column_name: 'buildExpense',checkedColumn:(cust_form.buildExpense)?'checked':''},
                    @if(getExpenseFromToDate()=="true")
                    {Name: '@lang("layout.FromDate")', column_name: 'fromDate',checkedColumn:(cust_form.fromDate)?'checked':''},
                    {Name: '@lang("layout.ToDate")', column_name: 'toDate',checkedColumn:(cust_form.toDate)?'checked':''},
                    @endif
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_form.status)?'checked':''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_form.user)?'checked':''},                
                ],
                cust_form:cust_form
            },
            watch: {
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#setting-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    sm.$data.is_show = true
                }
            }
        });
        /// custom form

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                   getRecord();
                }
            }
        });
        new Vue({
            el: '#create-modal',
            methods: {
                showModal: function() {
                    console.log('trr')
                    sales.$data.show_create = true;
                }
            }
        });
      //////////////////////////////

        
        var Banks = {!! $bank!!};
        var Currency ={!! $currency!!};
        var category ={!! $category!!};
        let home = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        let contract = {!! $contract !!};
        let measure = {!! $measure !!};


        var sales = new Vue({
            el: '#app',
            data: {
                dynamic_time:'',
                selectedCurrency: home,
                currency: Currency,
                measure: measure,
                selectedMeasure: null,
                bankes: {!! $banks !!},
                selectedBank: null,
                statusAttachment: false,
                customer: [],
                selected_customer: null,
                defuilt_banks: null,
                averageRate: false,
                disabled: false,
                defaultValue: 0,
                defaultAmount: 0,
                defaultAccount: 0,
                amount: null,
                selected_expense_account:null,
                expenses: {!! $expense !!},
                expenseAmount: 0,
                totalExpense: null,
                expenseId: 0,
                selectedProject: null,
                selectedContract: null,
                contract: contract,
                project_list: [], 
                listAccounts: [],
                accountUpdate: [],
                currencyList: Currency,
                category: category,
                selected_category: null,
                type: 'bank',
                description: null,
                rows: [
                    {
                        amount: null,
                        quantity: null,
                        price_fe: null,
                        total_amount: null,
                        description: null,
                        selectedMeasure: null
                    },
                    {
                        amount: null,
                        quantity: null,
                        price_fe: null,
                        total_amount: null,
                        description: null,
                        selectedMeasure: null
                    },
                ],
                account: {},
                show_create: false,
                number: "{{$number}}",
                old_number: "{{$number}}",
                gDescription:null,
                memo:null,
                isRepeatData: false,
                amount_check: null,
            },
            computed: {
                setRates() {
                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {
                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });
                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });
                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                   /* this.banks = [];
                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });*/
                    return rates;
                },

                @if(QuantityInDailyExpense() == 'true')
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseFloat(this.rows[i].total_amount)) ? parseFloat(this.rows[i].total_amount) : 0
                    }
                    // console.log(sum);S
                    this.amount_check = sum;
                    return sum;
                }
                @else 
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseFloat(this.rows[i].amount)) ? parseFloat(this.rows[i].amount) : 0
                    }
                    // console.log(sum);S
                    this.amount_check = sum;
                    return sum;
                }
                @endif

                
            },
            created() {
                this.expenseAmount = this.expenses[0].Amount;
                this.expenseId = this.expenses[0].id;
            }, 
            mounted: function () {
                var selected_banks=_.find(this.bankes,(v)=>v.id=={!! getDropdown('dailyExpense', 'bank') !!});
                if(selected_banks){
                    this.defaultAccount = selected_banks.id;
                    var selected_currency=_.find(this.setRates,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selectedCurrency = selected_currency;
                    this.defuilt_banks = selected_banks;
                }
                this.selected_category=_.find(this.category,(v)=>v.id=={!! getDropdown('dailyExpense', 'category') !!});
                var account=_.find(this.expenses,(v)=>v.id=={!! getDropdown('dailyExpense', 'account') !!});
                if (account) {
                    this.selected_expense_account = account;
                }
                this.dynamicTime()
            },
            methods: {  

                GiveTotal(row,itemIndex){  
                    this.rows[itemIndex].total_amount = this.rows[itemIndex].quantity * this.rows[itemIndex].price_fe;
                },

                //BEGIN - Used for dynamic input time
                MemberSearch: _.debounce((search, loading) => {  
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            sales.customer = [];
                            sales.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(sales.time_interval)
                        },
                        changeTime()
                        {
                            sales.dynamic_time = sales.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
				accountUpdates() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })

                    if (this.defuilt_banks) {
                        this.defaultValue = this.defuilt_banks.id;
                        this.defuilt_banks = null;
                    }else{
                        if(test[0]){
                            this.defaultValue = test[0].id;
                        }
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                this.averageRate = false;
                                @if(getAverageRate() =="true")
                                if (this.bankes[x].avg_rate) {
                                    this.set_avg_rate(this.bankes[x].avg_rate);
                                }
                                @endif
                                break;
                            }
                        } 
                    }
                    // return test;
					this.accountUpdate = test;
                },
                set_avg_rate(avg_rate) {
                    setTimeout(() => {
                        this.averageRate = true;
                        this.selectedCurrency.exchange_rate = avg_rate;
                    }, 300);
                },
                // Search Project
				ProjectSearch:_.debounce((search,loading)=>{
				   sales.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						sales.project_list=response.data;
						console.log('test 22',sales.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                onComplete: function () {
                    document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
                },
                addRow: function () {
                    this.rows.push(   
                        { 
                            amount: null,
                            quantity: null,
                            price_fe: null,
                            total_amount: null,
                            selectedMeasure: null,
                            description: null
                        }
                    )
                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.averageRate = false;
                                @if(getAverageRate() =="true")
                                if (this.bankes[x].avg_rate) {
                                    this.set_avg_rate(this.bankes[x].avg_rate);
                                }
                                @endif
                                break;
                            }
                        }
                    }
                },
                deleteRow: function (index) {
                    this.rows.splice(index, 1)
                },
                submitform() {
                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("bill-submit").submit()
                            } else {
                            }
                        });
                },
                setAmount(expense_account) {
                    if (expense_account) {
                        if (expense_account.exp_category_id) {
                            this.selected_category=_.find(this.category,(v)=>v.id==expense_account.exp_category_id);
                        }
                    }
                    for (var x in this.expenses) {
                        for (z in this.expenses[x]) {
                            if (this.expenses[x][z] == this.expenseId) {
                                this.expenseAmount = this.expenses[x].Amount;
                                this.expenseId = this.expenses[x].id;
                                break;
                            }
                        }
                    }
                },
				saveAndNew() {
                    console.log('eee'); 
                    sales.disabled = true;
                    var url = "{{route('dailyExpense.store')}}";
                    form_id = 'bill-submit';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                        .then(function (response) {
                            toggleBlock(0);
                            if (response.data.result == 1) {
                                $('#' + form_id).trigger('reset');
                                //$('#success-sound')[0].play();
                                toastr.success('', response.data.message);
                                sales.number = Number(sales.old_number) + 1;
                                sales.old_number = Number(sales.old_number) + 1;
                                // location.reload();
                                sales.clearData();
                                getRecord();
                                // sales.defaultValueM();
                            }
                            else {
                            //     swal({
                            //     title: "Are you sure?",
                            //     text: "",
                            //     icon: "info",
                            //     buttons: true,
                            //     dangerMode: true,
                            // })
                            //     .then((willDelete) => {
                            //         if (willDelete) {
                            //             document.getElementById("bill-submit").submit()
                            //         } else {
                            //         }
                            //     });
                                var message = "{{__('message.Warning')}}";
                                sales.disabled = false;
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                            }
                            sales.disabled = false;
                        })
                        .catch(function (error) {
                            toggleBlock(0);
                            sales.disabled = false;
                            console.log(error);
                            
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        });
                },
                checkRepeat(){ 
                    this.$validator.validate().then(valid => {
                        if (valid) {
                    var bank = this.defaultAccount;
                    // var amount = this.subtotal();
                    var date = document.getElementById('date');
                    var date_value = date.value;
                    var amount_check = this.amount_check;
                    // console.log(amount_check); 
                    if (bank && this.selectedCurrency && this.selected_expense_account && amount_check) {
                        sales.disabled = true;
                        var currencies = this.selectedCurrency.code;
                        var expense = this.selected_expense_account.id;
                        axios.get("{{route('dailyExpense.checkOldValue')}}", {
                        params: {
                            bank: bank,
                            currencies: currencies,
                            expense: expense,
                            date_value: date_value,
                            amount_check: amount_check
                            }}).then(function (response) {
                            // this.expense_category = [];
                            // console.log(response.data);
                            if (response.data) {
                                swal({
                                title: "{{__('layout.DuplicateData')}}",
                                text: "",
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                infoMode: true,
                            })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        sales.saveAndNew(); 
                                    } else {
                                        sales.disabled = false;
                                    }
                                });
                            }else{
                                sales.saveAndNew(); 
                            }
                            // loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                            sales.disabled = false;
                        })  
                    }
                }
                    });
                },
                handleSubmit(e) {
                    // console.log(123);
                    this.$validator.validate().then(valid => {
                        if (valid) {  
                    var bank = this.defaultAccount; 
                    var date = document.getElementById('date');
                    var date_value = date.value;
                    var amount_check = this.amount_check; 
                    // console.log(123, bank && this.selectedCurrency && this.selected_expense_account && amount_check);
                    if (bank && this.selectedCurrency && this.selected_expense_account && amount_check) {      
                        sales.disabled = true;
                        var currencies = this.selectedCurrency.code;
                        var expense = this.selected_expense_account.id; 
                        axios.get("{{route('dailyExpense.checkOldValue')}}", {
                            params: {
                                bank: bank,
                                currencies: currencies,
                                expense: expense,
                                date_value: date_value,
                                amount_check: amount_check
                                }}).then(function (response) {
                                if (response.data) {
                                    swal({
                                    title: "{{__('layout.DuplicateData')}}",
                                    text: "",  
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    warningMode: true,
                                })
                                    .then((willDelete) => {
                                        if (willDelete) {
                                            regForm(e.target);
                                            sales.disabled = false;
                                        } else {
                                            sales.disabled = false;
                                        }
                                    });
                                }else{                                
                                    regForm(e.target);      
                                    sales.disabled = false;  
                                }
                            }) .catch(function (error) {
                                console.log(error);
                                sales.disabled = false;
                            })    
                        }
                        }
                    });
                    },
                clearData: function() {
                sales.gDescription = null;
                sales.memo = null;
                sales.rows = [
                    {
                        amount: null,
                        quantity: null,
                        price_fe: null,
                        total_amount: null,
                        description: null
                    } 
                ]
            },
            }
        });
    </script>
@endpush