@extends('layouts.app')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<style>
    .select_style{
        outline:1px solid #c2cad8 !important
    }
</style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title" >
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateDailyExpense')</span>
                    @else 
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditDailyExpense')</span>
                    @endif
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" id="app" v-cloak>
                @if($duplicate)
                {{Form::open(['route' => 'dailyExpense.store','method' => 'POST','class' => 'form-horizontal','id'=>'bill-submit'])}}
                @else
                {{Form::model($expenseInfo,['route' => ['dailyExpense.update',$expenseInfo->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'bill-submit'])}}
               @endif
                {{ csrf_field() }} 
                <div>
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row" id="header_feilds" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">                                       
                                     <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Currency') </label>
                                         <v-select  label="code" v-model="selectedCurrency" :options="currency" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?set_avg_rate_by_currency():''" >
                                         </v-select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12" style="padding:0px;">
                                            <label class="control-label">@lang('layout.Bank')</label>
                                            <select class="form-control select_style" name="bank" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Expense') </label>
                                            <select class="form-control select_style" name="expense_id" v-model="defaultExpense.id" @change="setAmount(defaultExpense.id)">
                                                <option v-for="expense in expenses" :value="expense.id">@{{ expense.AccountName }}
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div  class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div class="input-group">
                                                <input  v-model="selectedCurrency.exchange_rate" class="form-control" :readonly="averageRate" type="number" step="any" min="0" >
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12" style="padding:0px;">
                                            <label class="control-label">@lang('layout.Amount')</label>
                                            <span v-show="false">@{{defaultAmount=(selectedBank.balance-(subtotal-discountedAmount))}}</span>
                                            <input type="number" class="form-control" v-model="defaultAmount.toFixed(precision())" disabled>
                                        </div>
                                    </div>
                                </div>
                                <div  class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12 ">
                                            <label class="control-label">@lang('layout.Amount') </label>
                                            <span v-show="false">@{{totalExpense=((expenseAmount)+(subtotal))}}</span>
                                            <input type="number" v-model="totalExpense.toFixed(precision())" class="form-control" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                
                                <div class="col-lg-2 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'date')) displayNone @endif " >
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            @if(getDateRequired() == 'true')
                                            {{Form::text('date',$expenseInfo->date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.Date')])}}
                                            <span class="required">@{{ errors.first('date') }}</span>
                                            @else 
                                            {{Form::text('date',$expenseInfo->date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                           @endif
                                        </div>
                                    </div>
                                </div> 
                                
                                <div class="col-lg-2 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'hour')) displayNone @endif ">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group">
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$expenseInfo->hour}}">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$expenseInfo->hour}}" >
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div> 
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'category')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>
                                            <v-select class="vue-select2" v-model="selected_category" label="name" :options="category" >
                                            </v-select>
                                            <input type="hidden" name="category_id" :value="(!selected_category)?null:selected_category.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'issue')) displayNone @endif">
                                    <label class="control-label">@lang('layout.Issue')</label>
                                    {{Form::text('issue', $expenseInfo->issue, ['class' => 'form-control'])}}
                                    {{-- <input type="text" class="form-control" value="{{$expenseInfo->issue}}"> --}}
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'number')) displayNone @endif">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    {{Form::number('number',$expenseInfo->number,['class' => 'form-control'])}}
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'overdueDate')) displayNone @endif ">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.OverdueDate')</label>
                                            {{Form::text('overdue_date',$expenseInfo->overdue_date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'description')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {!! Form::textarea('gDescription', $expenseInfo->description, array('placeholder' => __('layout.Description'),'class' => 'form-control description','rows' => 1, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                                @if(systemConfig()[5] != 0 )
                                    <div class="col-md-4 @if(!getCustomeForm('dailyExpenses', 'project')) displayNone @endif">
                                        <label class="control-label">@lang('layout.Project')</label>
                                        <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                                        </v-select>
                                        <input type="hidden" name="project_id"  v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                    </div>
                                @endif
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                @if(systemConfig()[20] == 1)
                                    <div class="col-lg-4 @if(!getCustomeForm('dailyExpenses', 'contractName')) displayNone @endif">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name"
                                                :options="contract">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                @endif
                                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'memo')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="2">{{$expenseInfo->memo}}</textarea>
                                        </div>
                                    </div>
                                </div>
                                @if(getExpenseFromToDate()=="true")
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'fromDate')) displayNone @endif">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.FromDate')</label>
                                                {{Form::text('from_date_expense',$expenseInfo->from_date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'toDate')) displayNone @endif">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ToDate')</label>
                                                {{Form::text('to_date_expense',$expenseInfo->to_date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'receipt_number')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReceiptFactor')</label>
                                            {{Form::text('receipt_number',$expenseInfo->receipt_number,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'by')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.By'):</label> 
                                            {{Form::text('customer_id',$expenseInfo->person_by,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'attachmentCount')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.AttachmentCount'):</label> 
                                            {{Form::text('attachment_count',$expenseInfo->attachment_count,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('dailyExpenses', 'buildExpense')) displayNone @endif">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.BuildExpense')</label>
                                            <input type="checkbox" name="build_expense_confirm" v-model="show_build_expense_confirm_checked" id="" value="On">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-3 col-xs-10">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="dashboard-stat2" style="margin-top: 20px;background: transparent;">
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <tr style="background: rgba(128, 128, 128, 0.271);">
                                            <td class="text-center">
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-center">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{ Number.parseFloat(subtotal).toFixed(2)}}
                                                </span>
                                                <input type="hidden" name="total" :value="subtotal">
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                                <br>
                                                <span data-counter="counterup" data-value="7800">
                                                    @if(systemConfig()[30] == 1)
                                                    @{{myRound(Number.parseFloat(subtotal).toFixed(2)/selectedCurrency.static_rate * selectedCurrency.exchange_rate)}}
                                                    @else
                                                    @{{myRound(Number.parseFloat(subtotal).toFixed(2)/selectedCurrency.exchange_rate)}}
                                                    @endif
                                                    <small class="font-green-sharp"> {{getHomeCurrency()['code']}} </small>
                                                </span>
                                            </td>
                                        </tr> 
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                   <br>
                    <!-- <div class="form-section"></div> -->
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="width:3px;">#</th>
                                            <th class="text-center" style="min-width: 200px;">
                                                @lang('layout.Description')
                                            </th>

                                            @if(QuantityInDailyExpense() == 'true')
                                            <th class="text-center" style="min-width: 90px;">
                                                @lang('layout.Quantity')
                                            </th>
                                            <th class="text-center" style="min-width: 90px;">
                                                @lang('layout.PerPrice')
                                            </th>
                                            <th class="text-center" style="min-width: 90px;">
                                                @lang('layout.Measure')
                                            </th>
                                            {{-- <th class="text-center" style="min-width: 90px;">
                                                @lang('layout.TotalAmount')
                                            </th> --}}
                                            @endif



                                            <th class="text-center" style="min-width: 130px;">
                                                @lang('layout.Amount')
                                            </th>
                                            <th style="min-width: 4px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for=" (row,itemIndex) in rows" class="even"> 
                                            <td class="td_one"> 
                                                <span span v-if="rows.length >1 " class="badge badge3 badge-roundless" style="background: transparent !important; color: black;">@{{itemIndex+1}} </span>
                                            </td>
                                            <td>
                                            {{Form::text('description[]',null,['class' => 'form-control','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','v-model'=>'row.description','placeholder' =>__('layout.Description'),'autocomplete'=>'off'])}}
                                            <input type="hidden" name="exp_id[]" :value="(row.id != -1) ? row.id : -1">
                                            </td>
                                            @if(QuantityInDailyExpense() == 'true') 
                                            <td  class="td_one">
                                                <div class="input-group"> 
                                                    <input type="number" step="any" name="quantity[]" class="form-control" v-model="row.quantity" step="any" min="0" @input="GiveTotal('row',itemIndex)" 
                                                     placeholder="@lang('layout.PerPrice')"
                                                     v-validate="''" data-vv-as="@lang('layout.PerPrice')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                {{-- <span v-if="row.amount" style="color: blue; font-size:12px">@{{(row.amount==null)? 0:numFormatter(row.amount).result}}</span> --}}
                                            </td>
                                            <td  class="td_one">
                                                <div class="input-group"> 
                                                    <input type="number" step="any" name="price_fe[]" class="form-control" v-model="row.price_fe" step="any" min="0" @input="GiveTotal('row',itemIndex)"
                                                     placeholder="@lang('layout.Quantity')"
                                                    v-validate="''" data-vv-as="@lang('layout.Quantity')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                {{-- <span v-if="row.amount" style="color: blue; font-size:12px">@{{(row.amount==null)? 0:numFormatter(row.amount).result}}</span> --}}
                                            </td>
 

                                            <td  class="td_one">
                                                <v-select class="vue-select2" v-model="row.selectedMeasure" label="name" :options="measure" @input="showmm()" class="form-control"> 
                                                </v-select>
                                                <input type="hidden" name="measure_id[]" :value="(!row.selectedMeasure)?null:row.selectedMeasure.id">
                                            </td>  


                                            <td  class="td_one">
                                                <div class="input-group"> 
                                                    <input type="number" step="any" name="total_amount[]" class="form-control" v-model="row.amount" step="any" min="0"  readonly placeholder="@lang('layout.TotalAmount')"
                                                    data-vv-as="@lang('layout.TotalAmount')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                {{-- <span v-if="row.amount" style="color: blue; font-size:12px">@{{(row.amount==null)? 0:numFormatter(row.amount).result}}</span> --}}
                                            </td>  
                                            @else 
                                            <td width="50%;" class="td_one">
                                                <div class="input-group">
                                                    <vue-numeric
                                                        v-on:focus="(rows.length-1 == itemIndex)?addRow():null"
                                                        class="form-control"
                                                        v-model="row.amount"
                                                        :max="99999999999999"
                                                        :currency="selectedCurrency.code" 
                                                        :precision="precision()"
                                                        >
                                                    </vue-numeric>
                                                    <input type="hidden" name="amount[]" class="form-control" v-model="row.amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                            </td>
                                            @endif

                                            <td class="text-center">
                                            <span span v-if="rows.length >1 " v-on:click="deleteRow(itemIndex,row.id)"><i class="paddint-both fa fa-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                    <input v-for="del in deletedRow" type="hidden" name="mustDel[]" :value="del.check">
                                </table>
                            </div>
                        </div>
                    </div>
                </div>  
               <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                    <button type="button" class="btn green"  @click="handleSubmit($event)" >@lang('layout.Submit')</button>

                    <a href="{{route('dailyExpense.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
               </div> 
            </div>
                {{Form::close()}}
        </div>
    </div>
@endsection

@push('scripts')
<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
<script>

    Vue.component('v-select', VueSelect.VueSelect);
    Vue.use(VueNumeric.default);

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    var Banks     = {!! $bank!!}
    var Currency ={!! $currency!!}
    var dailyExpense = {!! $dailyExpense !!}
    var category ={!! $category!!};
    var expenseInfo ={!! $expenseInfo!!};
    var selectProject ={!! $selectProject!!};
    var contract        = {!! $contract!!}
    var measure        = {!! $measure!!}



   var sales = new Vue({
        el: '#app',
        data: {
            show_build_expense_confirm_checked: "{{$expenseInfo->build_expense_confirm == 'On'}}",
            contract: contract,
            selectedContract: null,
            selectedCurrency:{!! json_encode(getHomeCurrency()) !!},
            currency:Currency,
            bankes: {!! $banks !!},
            measure: measure,
            editKey: false,
            selectedBank: null,
            selectedProject: selectProject,
            project_list: [],
            customer: [],
            selected_customer:{!!$selectedMember!!},
            defaultValue: 0,
            defaultAmount:0,
            defaultAccount: 0,
            amount:0,
            discountedAmount:0,
            ConstdiscountedAmount:0,
            category: category,
            expenses: {!! $expense !!},
            expenseAmount: {!! $dailyExpense2->Amount !!},
            ConstexpenseAmount: {!! $dailyExpense2->Amount !!},
            expenseId: {!! $dailyExpense2->id!!},
            expenseId1: {!! $dailyExpense1->account_id !!},
            totalExpense:0,
            listAccounts:[],
            myBank:Banks,
            currencyList: Currency,
            selected_category:null,
            dailyExpense: dailyExpense,
            defaultExpense: {!! $dailyExpense2 !!},
            type: 'bank',
            description:null,
            averageRate:false,
            expenseInfo:expenseInfo,
            firstAccount: {!! $dailyExpense1->account_id !!},
            ConstAccount: {!! $dailyExpense1->account_id !!},
            amount:null,
            defaultExpenseAmount:0,
             rows: [
                { 
                    amount: null,
                    quantity: null,
                    price_fe: null,
                    total_amount: null,
                    description: null,
                    selectedMeasure: null
                },
            ],
            deletedRow: [],
                account: {},
        },
        created(){  
            if (expenseInfo.category_id) {
                this.selected_category=_.find(this.category,(v)=>v.id==expenseInfo.category_id);
            }
            @if($expenseInfo->contract_id != null)    
                this.selectedContract = _.find(this.contract, (e) => e.id == {{$expenseInfo->contract_id}});
            @endif
             var b = _.clone(Banks)
                var test =  this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                if(this.defaultAccount)
                { 
                }
                else
                {
                    this.defaultValue = test[0].id;
                }
                       
                for(var x in this.bankes){
                    for(z in this.bankes[x]){
                        if(this.bankes[x][z] == this.expenseId1 && z == 'id'){
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.bankes[x];                                    
                            break;
                        }
                    }

                }
            
            this.checkSelected();
            this.expenseAmount = this.expenseAmount - ({!! $dailyExpense1->amount !!}/this.selectedCurrency.exchange_rate);
            this.ConstexpenseAmount = this.expenseAmount;
            // console.log('how',this.expenseAmount)
            @if(QuantityInDailyExpense() == 'true')
                var sum = 0;
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].amount))?parseInt(this.rows[i].amount):0
                        // this.rows[i].selectedMeasure = _.find(this.measure, (c) => c.id == this.rows[i].measure_id);
                }

            
            @else 
                var sum = 0;
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].amount))?parseInt(this.rows[i].amount):0
                }
            @endif

                                        
        },


        mounted: function () { 
            this.setData();
        },


        computed: {
            @if(QuantityInDailyExpense() == 'true')
              subtotal: function () { 
                var sum = 0;
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].amount))?parseInt(this.rows[i].amount):0
                } 
                return sum;
             },
            @else 
            subtotal: function () {
                if(this.defaultAccount == this.ConstAccount){
                    this.discountedAmount = this.ConstdiscountedAmount;
                    this.defaultExpenseAmount = this.ConstdiscountedAmount;
                }
                else{
                    this.discountedAmount = 0;
                    this.defaultExpenseAmount = 0;
                }
                var sum = 0;
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].amount))?parseInt(this.rows[i].amount):0
                }
                
                return sum;
             },
            @endif

            accountUpdate() {
                var b = _.clone(Banks)
                var test =  this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    this.defaultValue = test[0].id;
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.firstAccount != -1){
                                    if(this.bankes[x][z] == this.firstAccount && z == 'id'){
                                        this.selectedBank = this.bankes[x];
                                        this.defaultAccount = this.firstAccount;
                                        this.firstAccount = -1;
                                        break;
                                    }
                                }
                                else if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;
                                    break;
                                }
                            }

                        }
                return test;
            },
        },
        methods: { 
 
            GiveTotal(row,itemIndex){  
                    if(this.rows[itemIndex].quantity > 0 && this.rows[itemIndex].price_fe > 0)
                    {
                        this.rows[itemIndex].amount = this.rows[itemIndex].quantity * this.rows[itemIndex].price_fe; 
                    }
                },


            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) { 
                        regForm(e.target);
                    }
                });
            }, 
                checkSelected(){ 
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for(var x in allCarrencies){
                        for(z in allCarrencies[x]){
                            if(allCarrencies[x][z] == "{!! $dailyExpense1->Currency !!}"){

                                this.selectedCurrency = allCarrencies[x];
                                this.selectedCurrency.rate="{!! $dailyExpense1->rate !!}";
                                this.selectedCurrency.exchange_rate="{!! $dailyExpense1->rate !!}";
                                
                                break;
                            }
                        } 
                    } 
                },
                MemberSearch: _.debounce((search, loading) => {  
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            sales.customer = [];
                            sales.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()), 

            setData: function(){
                this.rows = dailyExpense;
                @if(QuantityInDailyExpense() == 'true')
                var sum = 0; 
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].total_amount))?parseInt(this.rows[i].total_amount):0
                        this.rows[i].selectedMeasure = _.find(this.measure, (c) => c.id == this.rows[i].measure_id);
                }


                @else 
                var sum = 0; 
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].amount))?parseInt(this.rows[i].amount):0
                }
                @endif
                this.discountedAmount = sum;
                this.ConstdiscountedAmount = sum;
                this.defaultExpenseAmount = sum; 
                this.rows.push({amount: null});
                // alert(this.rows); 

            },

            // Search Project

				ProjectSearch:_.debounce((search,loading)=>{
				   sales.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						sales.project_list=response.data; 
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

             onComplete: function () {
                document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
            },
            addRow: function () { 
                this.rows.push(   
                    { 
                        amount: null,
                        quantity: null,
                        price_fe: null,
                        total_amount: null,
                        selectedMeasure: null,
                        description: null
                    }
                )
            },
            showmm: function () { 
                console.log(123, this.rows);
            },
        
            deleteRow: function (index,id) {
                this.deletedRow.push({check: id});
                this.rows.splice(index, 1)
            },
             sxubmitform (){
                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                // console.log("");
                                document.getElementById("bill-submit").submit()
                            } else {
                            }
                        });
            },

            setAmount(expenseId){
                for(var x in this.expenses){
                    for(z in this.expenses[x]){
                        if(this.expenses[x][z] == expenseId){
                            this.expenseAmount = this.expenses[x].Amount;
                            this.expenseId     = this.expenses[x].id;
                            break;
                        }
                    }
                } 
            },

            test(defaultAccount){
                for(var x in this.bankes){
                    for(z in this.bankes[x]){
                        if(this.bankes[x][z] == defaultAccount && z == 'id'){
                            this.selectedBank = this.bankes[x];
                            this.averageRate = false;
                            @if(getAverageRate() =="true")
                            if (this.bankes[x].avg_rate) {
                                this.set_avg_rate(this.bankes[x].avg_rate);
                            }
                            @endif
                            break;
                        }
                    }
                }
            },
            set_avg_rate(avg_rate) {
                setTimeout(() => {
                    this.averageRate = true;
                    this.selectedCurrency.exchange_rate = avg_rate;
                }, 300);
            },
            set_avg_rate_by_currency() {
                // console.log(32);
                this.averageRate = false;
                @if(getAverageRate() =="true")
                setTimeout(() => {
                    if (this.selectedBank && this.selectedBank.avg_rate) {
                        this.averageRate = true;
                        this.selectedCurrency.exchange_rate = this.selectedBank.avg_rate;
                    }
                }, 300);
                @endif
            },
        }
    });   


</script>


@endpush