@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<style>
    .select_style{
            outline:1px solid #c2cad8 !important
        }
</style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateDailyExpense')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;">
                {{Form::open(['route' => 'dailyExpense.store','method' => 'POST','class' => 'form-horizontal','id'=>'bill-submit'])}}
                <div id="app" v-cloak>
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <div class="row" id="header_feilds">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>

                                            <v-select label="code" :options="setRates"
                                                      v-model="selectedCurrency" @input="accountUpdates()"></v-select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Bank')</label>
                                            <select class="form-control select_style" name="bank" v-model="defaultAccount"
                                                    v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                    Account.name }}
                                                </option>
                                            </select>
                                        </div>
										
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Expense') </label>
                                            <v-select label="name" :options="expenses"
                                                      v-model="selected_expense_account" @change="setAmount(selected_expense_account)"></v-select>
                                            <input type="hidden" name="expense_id" v-bind:value="(!selected_expense_account)?null:selected_expense_account.id"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3': 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div class="input-group">
                                                <input v-model="selectedCurrency.exchange_rate" class="form-control"
                                                       type="number" step="any" min="0">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                                </div>

                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                        <div class="form-group">

                                            <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ') </label>
                                                <div class="input-group">
                                                    <input v-model="selectedCurrency.hq_rate" class="form-control"
                                                           type="number" step="any" min="0">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                            </div>
                                        </div>

                                        <input type="hidden" name="currency_rate_hq" :value="selectedCurrency.hq_rate">
                                    </div>
                                @endif


                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? "col-lg-3 col-md-3" : 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Amount')</label>
                                            <span v-show="false">@{{defaultAmount=((!selectedBank?0:selectedBank.balance) -subtotal)}}</span>
                                            <input type="number" class="form-control"
                                                   v-model="Number.parseFloat(defaultAmount).toFixed(precision())" disabled>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12 ">
                                            <label class="control-label">@lang('layout.Amount') </label>

                                            <span v-show="false">@{{totalExpense=(expenseAmount+subtotal)}}</span>
                                            <input type="number" v-model="Number.parseFloat(totalExpense).toFixed(precision())"
                                                   class="form-control" disabled>

                                        </div>
                                    </div>
                                </div>


                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Category')</label>
                                            <!-- <div v-for="cat in category">
                                                <p>@{{cat.name}}</p>
                                            </div> -->
                                            <select class="form-control select_style" name="category_id" v-model="selected_category">
                                                <option value="">@lang('layout.SelectCategory')</option>
                                                <option v-for="cat in category" :value="cat.id">
                                                    <span class="input-group-addon">@{{cat.name}}</span>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
								
								<div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
									<label class="control-label">@lang('layout.Number')</label>
									{{Form::number('number',$number,['class' => 'form-control'])}}
								</div>
                            </div>
							<div class="row">
								<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {!! Form::textarea('gDescription', null, array('placeholder' => __('layout.Description'),'class' => 'form-control description','rows' => 1, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>
                                @if(systemConfig()[5] != 0 )
                                    <div class="col-md-4"> 
                                        <label class="control-label">@lang('layout.Project')</label>
                                        <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                                :options="project_list" v-model="selectedProject">
                                        </v-select>
                                        <input type="hidden" name="project_id"
                                            v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                    </div>
                                @endif 
                            </div>
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="2"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-4 col-sm-12 col-xs-10">
                                <div class="dashboard-stat2">
                                    <table class="dashboard-tabel" width="100%">

                                        <tr>
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{ Number.parseFloat(subtotal).toFixed(2)}}
                                                </span>
                                                <input type="hidden" name="total" :value="subtotal">
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="row">


                    </div>
                    <br>
                    <!-- <div class="form-section"></div> -->
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width:3px;">#</th>
                                        <th class="text-center" style="min-width: 130px;">
                                            @lang('layout.Description')
                                        </th>
                                        <th class="text-center" style="min-width: 130px;">
                                            @lang('layout.Quantity')
                                        </th>
                                        <th style="min-width: 4px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for=" (row,itemIndex) in rows" class="even">
                                        <td class="td_one"><span span v-if="rows.length >1 "
                                                                 class="badge badge3 badge-success badge-roundless">@{{itemIndex+1}} </span>
                                        </td>
                                        <td>
                                            {{Form::text('description[]',null,['class' => 'form-control','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','placeholder' =>__('layout.Description')])}}

                                        </td>
                                        <td width="50%;" class="td_one">
                                            <div class="input-group">
                                                {!! Form::number('amount[]',null, array('placeholder' => __('layout.Amount'),'class' => 'form-control','step'=>'any','min'=>'0','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','v-model'=>'row.amount')) !!}
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span span v-if="rows.length >1 " v-on:click="deleteRow(itemIndex)"><i
                                                        class="paddint-both fa fa-trash"></i></span> 
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                <div class="col-xs-12 col-sm-12 col-md-10 text-center">
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
					<button type="button" class="btn blue"
                    :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('dailyExpense.index')}}" class="btn default">
                        <i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                </div>
            </div>
            {{Form::close()}}
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script>
        Vue.component('v-select', VueSelect.VueSelect);


        var Banks = {!! $bank!!};
        var Currency ={!! $currency!!};
        var category ={!! $category!!};

        let home = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};

        var sales = new Vue({
            el: '#app',
            data: {
                selectedCurrency: home,
                selected_expense_account:null,
                currency: Currency,
                bankes: {!! $banks !!},
                selectedBank: null,
                defuilt_banks: null,
                disabled: false,
                defaultValue: 0,
                defaultAmount: 0,
                defaultAccount: 0,
                amount: null,
                expenses: {!! $expense !!},
                expenseAmount: 0,
                totalExpense: null,
                expenseId: 0,
                selectedProject: null,
                project_list: [], 
                listAccounts: [],
                accountUpdate: [],
                currencyList: Currency,
                category: category,
                selected_category: null,
                type: 'bank',
                description: null,
                rows: [
                    {
                        amount: null,
                        description: null
                    },
                    {
                        amount: null,
                        description: null
                    },
                ],
                account: {},
            },
            computed: {
                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                   /* this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });*/

                    return rates;

                },
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseFloat(this.rows[i].amount)) ? parseFloat(this.rows[i].amount) : 0
                    }
                    return sum;
                },
                
            },
            created() {
                this.expenseAmount = this.expenses[0].Amount;
                this.expenseId = this.expenses[0].id;
            }, 
            mounted: function () {
                var selected_category=_.find(this.category,(v)=>v.id=={!! getDropdown('dailyExpense', 'category') !!});
                if(selected_category){
                    this.selected_category = selected_category.id;
                }

                var selected_banks=_.find(this.bankes,(v)=>v.id=={!! getDropdown('dailyExpense', 'bank') !!});
                if(selected_banks){
                    this.defaultAccount = selected_banks.id;
                    var selected_currency=_.find(this.setRates,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selectedCurrency = selected_currency;
                    this.defuilt_banks = selected_banks;
                }

                var account=_.find(this.expenses,(v)=>v.id=={!! getDropdown('dailyExpense', 'account') !!});
                if (account) {
                    this.selected_expense_account = account;
                }

                console.log(123, selected_category);
            },
            methods: {
				
				accountUpdates() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })

                    if (this.defuilt_banks) {
                        this.defaultValue = this.defuilt_banks.id;
                        this.defuilt_banks = null;
                    }else{
                        if(test[0]){
                            this.defaultValue = test[0].id;
                        }
                    }
					

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;

                                //  console.log('selected bankes',this.selectedBank);
                                break;
                            }
                        }

                    }
                    // return test;
					this.accountUpdate = test;
                },
                // Search Project

				ProjectSearch:_.debounce((search,loading)=>{
				   sales.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						sales.project_list=response.data;
						console.log('test 22',sales.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                onComplete: function () {
                    document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
                },
                addRow: function () {
                    this.rows.push(
                        {amount: null}
                    )
                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }
                    }
                },
                deleteRow: function (index) {
                    this.rows.splice(index, 1)
                },
                submitform() {
                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("bill-submit").submit()
                            } else {
                            }
                        });
                },
                setAmount(expenseId) {
                    for (var x in this.expenses) {
                        for (z in this.expenses[x]) {
                            if (this.expenses[x][z] == this.expenseId) {
                                this.expenseAmount = this.expenses[x].Amount;
                                this.expenseId = this.expenses[x].id;
                                break;
                            }
                        }
                    }
                },
				saveAndNew() {
                    console.log('eee');
                    sales.disabled = true;
                    var url = "{{route('dailyExpense.store')}}";
                    form_id = 'bill-submit';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                        .then(function (response) {
                            toggleBlock(0);
                            if (response.data.result == 1) {
                                $('#' + form_id).trigger('reset');
                                //$('#success-sound')[0].play();
                                toastr.success('', response.data.message);
                                location.reload();
                                // sales.defaultValueM();
                            }
                            else {
                                var message = "{{__('message.Warning')}}";
                                sales.disabled = false;
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                            }
                        })
                        .catch(function (error) {
                            toggleBlock(0);
                            sales.disabled = false;
                            console.log(error);
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        });

                },
            }
        });


    </script>


@endpush