@extends('layouts.factor-master')


@section('content')
<?php
$report = customeReportNew('daily_expense_index'); 
$_number= !in_array('number', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_amount = !in_array('amount', $report);
$_currency = !in_array('currency', $report);
$_rate = !in_array('rate', $report);
$_category = !in_array('category', $report);
$_expense_account = !in_array('expense_account', $report);
$_bank_account = !in_array('bank_account', $report);
$_total = !in_array('total', $report);
$_build_expense = !in_array('build_expense', $report);
$_user= !in_array('user', $report);
$_details= !in_array('details', $report);
  
$report_percent = customeReportNewPercent('daily_expense_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
    $_expense_account_percent= (array_key_exists('expense_account___percent', $report_percent))?$report_percent['expense_account___percent']:null;
    $_bank_account_percent= (array_key_exists('bank_account___percent', $report_percent))?$report_percent['bank_account___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_build_expense_percent= (array_key_exists('build_expense___percent', $report_percent))?$report_percent['build_expense___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_details_percent= (array_key_exists('details___percent', $report_percent))?$report_percent['details___percent']:null;
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.DailyExpenseReport')</h3>
@if($from_date || $to_date)
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
@endif

@if($ClassName || count($expense_account_name)>0 || count($bank_account_name)>0 || $expense_category_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if(count($expense_account_name)>0)
      <td>
        <span>@lang('layout.ExpenseAccount')</span>: 
        @foreach($expense_account_name as $expense_a)
        {{$expense_a->name}} , 
        @endforeach 
      </td>
      @endif
      @if(count($bank_account_name)>0)
      <td>
        <span>@lang('layout.BankAccount')</span>: 
        @foreach($bank_account_name as $bank)
        {{$bank['name']}} , 
        @endforeach
      </td>
      @endif
      @if($expense_category_name)
      <td>
        <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif

<table class="main-table">
    <thead>
        <tr class="bg"> 
            <td class="center">@lang('layout.Record')</td>
            @if($_number)<td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</td>@endif
            @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</td>@endif
            @if($_description)<td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</td>@endif
            @if($_user)<td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</td>@endif
            
            @if($_category)<td class="center" @if($_category_percent) width="{{$_category_percent}}%" @endif>@lang('layout.Category')</td>@endif
            @if($_amount)<td class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif>@lang('layout.Amount')</td>@endif
            @if($_currency)<td class="center" @if($_currency_percent) width="{{$_currency_percent}}%" @endif>@lang('layout.Currency')</td>@endif
            @if($_rate)<td class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif>@lang('layout.Rate')</td>@endif
            @if($_expense_account)<td class="center" @if($_expense_account_percent) width="{{$_expense_account_percent}}%" @endif>@lang('layout.ExpenseAccount')</td>@endif
            @if($_bank_account)<td class="center" @if($_bank_account_percent) width="{{$_bank_account_percent}}%" @endif>@lang('layout.BankAccount')</td>@endif
            @if(systemConfig()[5] != 0 )
            <td class="center">@lang('layout.Project')</td>
            <td class="center">@lang('layout.Status')</td>
            @endif
            @if($_details)<td class="center" @if($_details_percent) width="{{$_details_percent}}%" @endif colspan="2">@lang('layout.Details')</td>@endif
           

        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
        <tr>

            <?php
            $total_home_currency += $record->exchanged_amount;
            if (array_key_exists($record->Currency, $currencies)) {
                $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
            } else {

                $currencies[$record->Currency] = $record->Amount;
            }

            ?>

            <td class="center" rowspan="{{count($record->detail)+1}}">{{++$count}}</td>
            @if($_number)<td class="center" rowspan="{{count($record->detail)+1}}">{{$record->number}}</td>@endif
            @if($_date)<td class="center" rowspan="{{count($record->detail)+1}}">{{convertDate($record->Date)}}</td>@endif
            @if($_description)<td rowspan="{{count($record->detail)+1}}" style="@if($_description_percent) text-align: justify @endif">{{$record->Description}}</td>@endif
            @if($_user)<td class="center" rowspan="{{count($record->detail)+1}}">{{$record->user}}</td>@endif
            @if($_category)<td rowspan="{{count($record->detail)+1}}">{{$record->Name}}</td>@endif
            @if($_amount)<td class="center" rowspan="{{count($record->detail)+1}}">{{myRound($record->Amount)}}</td>@endif
            @if($_currency)<td class="center" rowspan="{{count($record->detail)+1}}">{{$record->Currency}}</td>@endif
            @if($_rate)<td class="center" rowspan="{{count($record->detail)+1}}">{{myRound($record->Rate)}}</td>@endif
            @if($_expense_account)<td rowspan="{{count($record->detail)+1}}">{{$record->Expense_account}}</td>@endif
            @if($_bank_account) <td rowspan="{{count($record->detail)+1}}">{{$record->Bank}}</td>@endif
            @if(systemConfig()[5] != 0 )
            <td class="center" rowspan="{{count($record->detail)+1}}">{{$record->project}}</td>
            <td class="center" rowspan="{{count($record->detail)+1}}">
                @if($record->status){{__('type.'.$record->status)}} @endif
            </td>
            @endif 
            @if($_details)
            <td style="padding:0px; margin:0px">
                @foreach($record->detail AS $key1=>$rec)
                <tr>
                    <td>{{$rec->description}}</td>
                    <td>{{myRound($rec->amount)}}</td>
                </tr>
                @endforeach
            </td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>

@if($_total)
<table class="main-table">
    <tr class="bg">
        <td colspan="3">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center">  @lang('layout.Record') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{myRound($currency)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>

    <tr>

        <td colspan="2">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{myRound($total_home_currency)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>

    </tr>
</table>
@endif



<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection