@extends('layouts.factor-master')


@section('content')
<?php
$report = customeReportNew('daily_expense_index');

$_number= !in_array('number', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_amount = !in_array('amount', $report);
$_currency = !in_array('currency', $report);
$_rate = !in_array('rate', $report);
$_category = !in_array('category', $report);
$_expense_account = !in_array('expense_account', $report);
$_bank_account = !in_array('bank_account', $report);
$_total = !in_array('total', $report);
$_build_expense = !in_array('build_expense', $report);

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.DailyExpenseReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
@endif
@if($ClassName || count($expense_account_name)>0 || count($bank_account_name)>0  || $expense_category_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if(count($expense_account_name)>0)
      <td>
        <span>@lang('layout.ExpenseAccount')</span>: 
        @foreach($expense_account_name as $expense_a)
        {{$expense_a->name}} , 
        @endforeach

      </td>
      @endif
      @if(count($bank_account_name)>0)
      <td>
        <span>@lang('layout.BankAccount')</span>: 
        @foreach($bank_account_name as $bank)
        {{$bank['name']}} , 
        @endforeach
      </td>
      @endif
      @if($expense_category_name)
      <td>
        <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif

<table class="main-table">
    <tr class="bg">
        <td colspan="9">
            <div class="center">@lang('layout.TotalByExpenseCategory')</div>
        </td>
    </tr>
    <tr class="bg">
        <td class="center">@lang('layout.Record')</td>
        <td class="center">@lang('layout.ExpenseCategory')</td>
        <td class="center">@lang('layout.FirstExpenseDate')</td>
        <td class="center">@lang('layout.LastExpenseDate')</td>
        <td class="center">@lang('layout.Quantity1')</td>
        <td class="center">@lang('layout.HomeCurrencyTotal')   {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td class="center" colspan="2">@lang('menu.FinancialClass')</td>
        <td class="center">@lang('layout.Amount')
            @if(count($bank_account_name)>0)
                @if($is_same_currency != false)
                    {{$bank_account_name[0]['currency']}}
                @endif
            @endif

        </td>
    </tr>
    <?php
    $count = 0;
    $total_home_currency = 0;
    $total_records = 0;
    $currencies=[];    
    ?>
    @foreach ($count_data as $key => $expense)
    <?php
        $total_home_currency += $expense['total_exchanged_amount'];
        $total_records += $expense['total'];
    ?>
        <tr>
            <td class="center" rowspan="{{count($expense['by_currency'])+1}}">{{++$count}}</td>
            <td class="center" rowspan="{{count($expense['by_currency'])+1}}">{{$expense['category']}}</td>
            <td class="center" rowspan="{{count($expense['by_currency'])+1}}">{{convertDate($expense['min_date'])}}</td>
            <td class="center" rowspan="{{count($expense['by_currency'])+1}}">{{convertDate($expense['max_date'])}}</td>
            <td class="center" rowspan="{{count($expense['by_currency'])+1}}">
                {{$expense['total']}}
            </td>
            <td class="center" rowspan="{{count($expense['by_currency'])+1}}">
                {{myRound($expense['total_exchanged_amount'])}}
            </td>

        </tr>
        <?php
            $count2 = 0;
        ?>
        @if($expense['by_currency'])
        @foreach($expense['by_currency'] AS $key1=>$rec)
        <tr>
            <?php
            if(array_key_exists($rec->Currency, $currencies))
            {
                $currencies[$rec->Currency]=$currencies[$rec->Currency]+$rec->Amount;
            } else {
                $currencies[$rec->Currency]=$rec->Amount;
            }
            ?>
            <td class="center">{{++$count2}}</td>
            <td class="center"> @lang('layout.Class') : {{$rec->class_name}}</td>
            <td class="center"> {{myRound($rec->Amount)}}
                @if($is_same_currency == false){{$rec->Currency}}@endif
            </td>
        </tr>
        @endforeach
        @endif
    @endforeach

    <tr class="bg">
        <td colspan="4" rowspan="{{count($currencies)+1}}" ></td>
        <td  class="center" rowspan="{{count($currencies)+1}}">{{ $total_records }}</td>
        <td  class="center" rowspan="{{count($currencies)+1}}">{{myRound($total_home_currency)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>

        <?php
        foreach($currencies As $key=>$currency)
        {
        ?>
        <tr class="bg">
            <td colspan="2" ></td>
            <td colspan="1" class="center">{{myRound($currency)}} {{$key}}</td>
        </tr>
        <?php
        }
        ?>

</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection