
@extends('layouts.factor-master')


@section('content')
<?php
$report =customeReportNew('daily_expense_index');

$_date= !in_array('date', $report);
$_description= !in_array('description', $report);
$_amount= !in_array('amount', $report);
$_currency= !in_array('currency', $report);
$_rate= !in_array('rate', $report);
$_category= !in_array('category', $report);
$_expense_account= !in_array('expense_account', $report);
$_bank_account= !in_array('bank_account', $report);
$_total= !in_array('total', $report);
$_build_expense= !in_array('build_expense', $report);


?>
 <h3 class="table-caption" style="text-align: center;">@lang('layout.DailyExpenseReport')</h3>
 @if($from_date || $to_date)
<table   class="main-table">
  <tr>
      @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
@endif
@if($ClassName || count($expense_account_name)>0 || count($bank_account_name)>0 || $expense_category_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if(count($expense_account_name)>0)
      <td>
        <span>@lang('layout.ExpenseAccount')</span>: 
        @foreach($expense_account_name as $expense_a)
        {{$expense_a->name}} , 
        @endforeach

      </td>
      @endif
      @if(count($bank_account_name)>0)
      <td>
        <span>@lang('layout.BankAccount')</span>: 
        @foreach($bank_account_name as $bank)
        {{$bank['name']}} , 
        @endforeach
      </td>
      @endif
      @if($expense_category_name)
      <td>
        <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif

  <table class="main-table">
<thead>
    <tr class="bg">

   <td><div class="center"> @lang('layout.Record') </div></td>
   <td><div class="center"> @lang('layout.Category')</div></td>
   <td><div class="center"> @lang('layout.Description')</div></td>
   <td><div class="center"> @lang('layout.Amount')</div></td>
   <td><div class="center"> @lang('layout.Currency')</div></td>
   <td><div class="center"> @lang('layout.Rate')</div></td>
   <td><div class="center"> @lang('layout.By')</div></td>
  <td><div class="center"> @lang('layout.User')</div></td>

 </tr>
</thead>
<tbody>
 <?php
 $count = 0;
 $total_home_currency=0;
 $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>

  <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>

<td  >{{$record->id}}</td>
 <td  >{{$record->Name}}</td>
 <td>
  
    @if(isset($report_format))
    {{$record->Description}}
    @else
    {!! wordwrap($record->Description,40,"<br/>\n",false) !!}
    @endif

  </td>
 <td  >{{myRound($record->Amount)}}</td>
 <td >{{$record->Currency}}</td>
 <td >{{$record->Rate}}</td>
 <td >{{$record->customer_name}}</td>
 <td >{{$record->user}}</td>
 
</tr>
  @endforeach   
</tbody>
</table>



<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>


<tr>

<td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>

 <td><div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}  </div></td>


</tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection