@extends('layouts.app')

@section('style')
    <style>
        .iconStyle{
            font-size: 20px;
        }
    </style>
@endsection

@section('content')

<div id="print-modal">

<report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
    v-if="is_show" 
    :value-type="'cloth_category_details'"
    
    @closed="closeModal">

    <div slot="body">
         <input type="hidden" name="id" value="{{$clothCategory->id}}"/>
    </div>
</report-modal>
</div>


  





    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ClothCategoryShow')
            </div>
            <div class="tools">
            </div>
        </div>

    </div>

<div class="row">
        <div class="col-md-2">
            <ul class="list-unstyled profile-nav">
                <li>
                <div title="" class="twPc-avatarLink">

                                    @if($clothCategory->image ==Null)
                                            <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                                    style="width:170px; height:170px;">
                                        @else
                                            <img class=" twPc-avatarImg"
                                                    src="{!!url('/uploads/'.$clothCategory->image)!!}"
                                                    style="width:170px; height:170px;">
                                        @endif
                    </div>  
                </li> 
            </ul>
        </div>
        <div class="col-md-10 profile-info">
                    <div class="portlet ">
                        
                        <div class="portlet-body">
                            <div class="table-scrollable">
                            <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Name')</th>
                                    <th>@lang('layout.Description')</th>
                                </tr> 
                                </thead>
                                <tbody>
                                <tr>
                                    <td> {{$clothCategory->name}}  </td>
                                    <td>  {{$clothCategory->description}} </td>
                                </tr>
                                </tbody>
                            </table>  
                            </div>

                        </div>
                    </div>

            <!--end row-->
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered"> 
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                        @permission('clothCategory-export')
                            <span id="anchore-modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                    <i class="fa fa-print"></i>
                                </a>
                            </span>
                            @endpermission
                     </div>

                </div>
                <div class="portlet-body">
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="size_tab">@lang('layout.ClothSize')</a>
                        </li>
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="style_tab">@lang('layout.ClothStyle')</a>
                        </li>
                    </ul>
                    
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                        
                                    
                                </div>

                            </div>
                            <div class="portlet-body">

                                <table class="table table-striped table-bordered table-hover" id="member_cloth_size">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>@lang('layout.DataOrder') </th>
                                        <th>@lang('layout.Name') </th>
                                        <th>@lang('layout.Description') </th>
                                        <th>@lang('layout.Actions') </th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>


                        </div>
                        <div class="tab-pane" id="tab2">
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                                </div>
                                <div class="tools"></div>
                                <div class="btn-group pull-right">

                                    @permission('clothProperty-create')
                                    <a href="{{route('clothStyle.create', ['id' => $clothCategory->id])}}">
                                        <button class="btn btn-success">
                                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                        </button>
                                    </a>


                                    @endpermission
                                </div>

                            </div>
                            <div class="portlet-body">

                            <table class="table table-striped table-bordered table-hover" id="member_cloth_style">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>@lang('layout.Name') </th>
                                    <th>@lang('layout.Description') </th>
                                    <th>@lang('layout.Actions') </th>
                                </tr>
                                </thead>
                            </table>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>

                    
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET--> 
        </div>
    </div>


@endsection
@include('print.modal')
@push('scripts')

    <script>
 

$(document).ready(function () {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#member_cloth_size').DataTable({
                ajax: {
                    url: '{{route("clothCategory.show",$clothCategory->id)}}',
                    data: {type: 'size'}
                },
                scrollCollapse: true,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'property_order', name: 'cloth_properties.property_order'},
                    {data: 'name', name: 'cloth_properties.name'},
                    {data: 'description', name: 'cloth_properties.description'},
                    {data: 'actions', name: 'actions',orderable:false,searchable:false},

                ]

            }); 
        });      
        
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#member_cloth_style').DataTable({
                    ajax: {
                        url: '{{route("clothCategory.show",$clothCategory->id)}}',
                        data: {type: 'style'}
                    },
                    scrollCollapse: true,
                    serverSide: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    paging: true,
                    columns: [
                        {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                        {data: 'name', name: 'cloth_styles.name'},
                        {data: 'description', name: 'cloth_styles.description'},
                        {data: 'action', name: 'action',orderable:false,searchable:false},


                        // "style_order" => 1
                        // "name" => "yakhan"
                        // "description" => ""
                        // "cloth_category_id" => 2
                        // "user_id" => 1
                        // "company_id" => 1
                        // "created_at" => "2021-12-22 08:52:28"
                        // "updated_at" => "2021-12-22 08:52:28"


                    ]

                });
        });

        


    var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
            },

            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
            });

            new Vue({
            el:'#anchore-modal',
            methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
            }
            });
    </script>


@endpush
