@extends('layouts.app')
@section('content')
    @include('receives.modal')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'customs_expense_category'"
                      @closed="closeModal"> 

            <div slot="body">
                <div class="row">
                    <div class="form-group">

                    </div>
                </div>

                  <div class="row">
               
                </div>
            </div>
        </report-modal>
    </div>


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.CustomsExpenseOptionList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    {{-- @permission('CustomsExpenseCategory-export') 
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                        </span>
                    @endpermission --}}

                    @permission('customsExpenseOption-create')
                    <a href="{{route('customsExpenseOption.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="customsExpenseOption">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.CustomsAmount')</th>
                        <th>@lang('layout.CustomsPercent')</th>
                        <th>@lang('layout.TaxPercent')</th>
                        <th>@lang('layout.StaticTax')</th>
                        <th>@lang('layout.HelalAhmarPercent')</th>
                        <th>@lang('layout.AllocationOfPetroleumProduct') %</th>
                        <th>@lang('layout.CreatedAt')</th>
                        <th>@lang('layout.Action')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#customsExpenseOption').DataTable({
                ajax: '{{route("customsExpenseOption.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'name', name: 'inventory_categories.name'},
                    {data: 'currency', name: 'customs_expense_options.currency'},
                    {data: 'customs_amount', name: 'customs_expense_options.customs_amount'},
                    {data: 'customs_percent', name: 'customs_expense_options.customs_percent'},
                    {data: 'tax_percent', name: 'customs_expense_options.tax_percent'},
                    {data: 'static_tax', name: 'customs_expense_options.static_tax'},
                    {data: 'helal_ahmar_percent', name: 'customs_expense_options.helal_ahmar_percent'},
                    {data: 'allocation_petroleum', name: 'customs_expense_options.allocation_petroleum'},
                    {data: 'created_at', name: 'customs_expense_options.created_at', searchable: false},
                    {data: 'action', searchable: false, orderable: false}
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>


@endpush
