@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomsExpenseCategoryEdit')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::model($customsExpenseCategory, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['customsExpenseCategory.update',$customsExpenseCategory->id]]) !!}
            <div class="form-body" id="app">

                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Name'):</label>
                            <div class="col-md-9">
                                {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('name') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9">
                                {{Form::text('amount',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Amount')])}}
                                <span class="required">@{{ errors.first('amount') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.AmountType'):</label>
                            <div class="col-md-9">
                                <select name="amount_type" v-model="amount_type" v-validate="'required'" data-vv-as="{{__('layout.AmountType')}}" id="" class="form-control form-select">
                                    <option value="Amount">@lang('layout.Amount')</option>
                                    <option value="Percentage">@lang('layout.Percentage')</option>
                                    <option value="Liter">@lang('layout.Liter')</option>
                                </select>
                                <span class="required">@{{ errors.first('amount_type') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.CalculateType'):</label>
                            <div class="col-md-9">
                                <select name="calculate_type" v-model="calculate_type" v-validate="'required'" data-vv-as="{{__('layout.CalculateType')}}" id="" class="form-control form-select">
                                    <option value="PerPrice">@lang('layout.PerPrice')</option>
                                    <option value="Total">@lang('layout.Total')</option>
                                </select>
                                <span class="required">@{{ errors.first('calculate_type') }}</span>
                            </div>
                        </div>
                        {{-- <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.CalculateAmount'):</label>
                            <div class="col-md-9">
                                <select name="calculate_amount" v-model="calculate_amount" v-validate="'required'" data-vv-as="{{__('layout.CalculateAmount')}}" id="" class="form-control form-select">
                                    <option value="CustomsQuantity">@lang('layout.CustomsQuantity')</option>
                                    <option value="CustomsCost">@lang('layout.CustomsCost')</option>
                                </select>
                                <span class="required">@{{ errors.first('calculate_amount') }}</span>
                            </div>
                        </div> --}}
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 2)) !!}
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                <button href="{{url('customsExpenseCategory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        let vu = new Vue({
        el: '#app',
        data: {
            amount_type: "{{$customsExpenseCategory->amount_type}}",
            calculate_type: "{{$customsExpenseCategory->calculate_type}}",
            calculate_amount: "{{$customsExpenseCategory->calculate_amount}}",
        },
        methods: {

        }
    })


    </script>
@endpush