@extends('layouts.app')
@section('content')
@section('style')

@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomsExpenseOptionCreate')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="cloth_category" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'customsExpenseOption.store','method'=>'POST','class'=>'form-horizontal','id'=>'CustomsExpenseOption-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.Category')</label>
                            
                            <v-select placeholder="@lang('layout.SelectInventoryCategory')" label="name" tabindex='1' :options="categories" v-model="category" ></v-select>
                            <input type="hidden" name="category_id" :value="(category)?category.id:null">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.Currency')</label>
                            <v-select label="code" :options="currency" v-model="selected_currency"></v-select>
                            <input type="hidden" name="currency" :value="selected_currency.code">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.CustomsAmount'):</label>
                            
                            {{Form::number('customs_amount', null,['class' => 'form-control','v-model' =>'customs_amount','v-validate' =>'"required"','data-vv-as' => __('layout.CustomsAmount')])}}
                            <span class="required">@{{ errors.first('customs_amount') }}</span>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.CustomsPercent'):</label>
                            
                            {{Form::number('customs_percent',null,['class' => 'form-control','v-model' =>'customs_percent','v-validate' =>'"required"','data-vv-as' => __('layout.CustomsPercent')])}}
                            <span class="required">@{{ errors.first('customs_percent') }}</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.TaxPercent'):</label>
                            {{Form::number('tax_percent',null,['class' => 'form-control','v-model' =>'tax_percent','v-validate' =>'"required"','data-vv-as' => __('layout.TaxPercent')])}}
                            <span class="required">@{{ errors.first('tax_percent') }}</span>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.StaticTax'):</label>
                            {{Form::number('static_tax',null,['class' => 'form-control','v-model' =>'static_tax','v-validate' =>'""','data-vv-as' => __('layout.StaticTax')])}}
                            <span class="required">@{{ errors.first('static_tax') }}</span>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.HelalAhmarPercent'):</label>
                            {{Form::number('helal_ahmar_percent',null,['class' => 'form-control','v-model' =>'helal_ahmar_percent','v-validate' =>'"required"','data-vv-as' => __('layout.HelalAhmarPercent')])}}
                            <span class="required">@{{ errors.first('helal_ahmar_percent') }}</span>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.AllocationOfPetroleumProduct') %:</label>
                            {{Form::number('allocation_petroleum',null,['class' => 'form-control','v-model' =>'allocation_petroleum','v-validate' =>'"required"','data-vv-as' => __('layout.AllocationOfPetroleumProduct')])}}
                            <span class="required">@{{ errors.first('allocation_petroleum') }}</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                {{-- <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> --}}
                <a href="{{route('customsExpenseOption.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        var currency = {!! $currency !!};

        let vu = new Vue({
                el: '#cloth_category',
                data: {
                    id: null,
                    customs_amount: null,
                    customs_percent: null,
                    tax_percent: null,
                    static_tax: null,
                    allocation_petroleum: null,
                    helal_ahmar_percent: null,
                    currency: currency,
                    selected_currency: defaultCurrency(),
                    categories:{!! json_encode($category) !!},
                    category:null
                },
                mounted() {
                    
                },
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                    saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('customsExpenseOption.store')}}";
                                form_id = 'CustomsExpenseOption-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                }
            })
    </script>
@endpush
