@extends('layouts.app')
@section('content')
@section('style')

@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomsExpenseCategoryCreate')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="cloth_category" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'customsExpenseCategory.store','method'=>'POST','class'=>'form-horizontal','id'=>'customsExpenseCategory-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Name'):</label>
                            <div class="col-md-9">
                                {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('name') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9">
                                {{Form::text('amount',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Amount')])}}
                                <span class="required">@{{ errors.first('amount') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.AmountType'):</label>
                            <div class="col-md-9">
                                <select name="amount_type" v-validate="'required'" data-vv-as="{{__('layout.AmountType')}}" id="" class="form-control form-select">
                                    <option value="Amount">@lang('layout.Amount')</option>
                                    <option value="Percentage">@lang('layout.Percentage')</option>
                                    <option value="Liter">@lang('layout.Liter')</option>
                                </select>
                                <span class="required">@{{ errors.first('amount_type') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.CalculateType'):</label>
                            <div class="col-md-9">
                                <select name="calculate_type" v-validate="'required'" data-vv-as="{{__('layout.CalculateType')}}" id="" class="form-control form-select">
                                    <option value="PerPrice">@lang('layout.PerPrice')</option>
                                    <option value="Total">@lang('layout.Total')</option>
                                </select>
                                <span class="required">@{{ errors.first('calculate_type') }}</span>
                            </div>
                        </div>
                        {{-- <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.CalculateAmount'):</label>
                            <div class="col-md-9">
                                <select name="calculate_amount" v-validate="'required'" data-vv-as="{{__('layout.CalculateAmount')}}" id="" class="form-control form-select">
                                    <option value="CustomsQuantity">@lang('layout.CustomsQuantity')</option>
                                    <option value="CustomsCost">@lang('layout.CustomsCost')</option>
                                </select>
                                <span class="required">@{{ errors.first('calculate_amount') }}</span>
                            </div>
                        </div> --}}
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 2)) !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('customsExpenseCategory.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        let vu = new Vue({
                el: '#cloth_category',
                data: {},
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                    saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('customsExpenseCategory.store')}}";
                                form_id = 'customsExpenseCategory-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                }
            })
    </script>
@endpush
