@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.CustomsExpenseShow')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.CompanyLicense')</th>
                        <th>@lang('layout.Vehicle')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ $itemExpense->number}}  </td>
                        <td class=" "> {{ convertDate($itemExpense->date)}}  </td>
                        <td class=" "> {{ $itemExpense->hour }}  </td> 
                        <td class=" "> {{ __('layout.'.ucfirst($itemExpense->expense_type ))}}  </td>
                        <td class=" "> {{ $itemExpense->license_name }}  </td> 
                        <td class=" "> {{ $itemExpense->vehicle_name }}  </td> 
                        <td class=" "> {{ $itemExpense->description }}  </td> 
                        <td class=" "> {{ $itemExpense->user }}  </td> 
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.TotalAmount')</th>
                        <th>@lang('layout.AmountPayable')</th>
                        <th>@lang('layout.Differ') @lang('layout.Amount')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Vendor')</th>
                        <th>@lang('layout.Item')</th>
                        <th>@lang('layout.Quantity') (@lang('layout.SeamerTonnage'))</th>
                        <th>@lang('layout.CustomsQuantity')</th>
                        <th>@lang('layout.Measure')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ $itemExpense->currency}}  </td>
                        <td class=" "> {{ $itemExpense->rate}}  </td>
                        <td class=" "> {{ myRound($itemExpense->total_amount)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->amount)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->total_amount - $itemExpense->amount)}}  </td>
                        <td class=" "> {{ $itemExpense->account}}  </td>
                        <td class=" "> {{ $itemExpense->member}}  </td>
                        <td class=" "> {{ $itemExpense->item}}  </td>
                        <td class=" "> {{ $itemExpense->quantity}}  </td>
                        <td class=" "> {{ $itemExpense->customs_quantity}}  </td>
                        <td class=" "> {{ $itemExpense->measure}}  </td>
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <tr>
                            <th style="min-width: 120px" >@lang('layout.CustomsAmount') ({{ myRound($itemExpense->customs_amount)}}) </th>
                            <th style="min-width: 120px">@lang('layout.CustomsPercent') ({{ myRound($itemExpense->customs_percent)}}) </th>
                            <th style="min-width: 120px">@lang('layout.TaxPercent') ({{ myRound($itemExpense->tax_percent)}}) </th>
                            <th style="min-width: 120px">@lang('layout.StaticTax') ({{ myRound($itemExpense->static_tax)}}) </th>
                            <th style="min-width: 120px">@lang('layout.HelalAhmarPercent') ({{ myRound($itemExpense->helal_ahmar_percent)}}) </th>
                            <th style="min-width: 120px">@lang('layout.AllocationOfPetroleumProduct') ({{ myRound($itemExpense->allocation_petroleum)}}) -- @lang('layout.PerPrice') ({{ myRound($itemExpense->allocation_petroleum_price)}}) </th>
                            <th style="min-width: 120px">@lang('layout.Liter') </th>
                            <th style="min-width: 120px">@lang('layout.Density') </th>
                        </tr>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ myRound($itemExpense->customs_amount1)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->customs_percent1)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->tax_percent1)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->static_tax1)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->helal_ahmar_percent1)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->allocation_petroleum1)}}  </td>

                        <td class=" "> {{ myRound($itemExpense->liter)}}  </td>
                        <td class=" "> {{ myRound($itemExpense->density)}}  </td>
                    </tr>
                    </tbody>
                </table>

                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            @foreach ($category as $item)
                            <th>{{$item->name}}</th>
                            @endforeach
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                            @foreach ($category as $item)
                            <td class=" "> {{ myRound($item->total_amount)}}  </td>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                {{-- <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.ItemExpenseDetail')</a>
                </li> --}}
                <li class="active">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
                {{-- <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ItemExpenseDetail') </span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_expense_detail"/>
                                        <input type="hidden" name="item_expense_id" value="{{$itemExpense->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_expense_detail"/>
                                        <input type="hidden" name="item_expense_id" value="{{$itemExpense->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="item_expense">
                                        <thead>
                                        <tr>

                                            <th>@lang('layout.Category')</th>
                                            <th>@lang('layout.FromDate')</th>
                                            <th>@lang('layout.ToDate')</th>
                                            <th>@lang('layout.Day')</th>
                                            <th>@lang('layout.RemoveDays')</th>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Unit/M')</th>
                                            <th>@lang('layout.Quantity')</th>

                                            <th>@lang('layout.Total')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
                </div> --}}
                <div class="tab-pane active" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="customsExpense.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$itemExpense->id}}">
                                        <input type="hidden" name="path" value="uploads/customsExpense">
                                        <input type="hidden" name="table_name" value="customs_expenses">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('customsExpense.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            // $('#item_expense').DataTable({
            //     ajax: {
            //         url: '{{route("customsExpense.show",$itemExpense->id)}}',
            //         data: {type: 'itemExpense'}
            //     },
            //     scrollCollapse: true,
            //     responsive:'{{responsiveDataTable()}}',
            //     pagingType:'{{paginationType()}}',
            //     serverSide: true,
            //     paging: true,
            //     columns: [

            //         {data: 'category', name: 'category', orderable: false, searchable: false},
            //         {data: 'from_date', name: 'from_date', searchable: false},
            //         {data: 'to_date', name: 'to_date', searchable: false},
            //         {data: 'holdingDays', name: 'holdingDays', searchable: false},
            //         {data: 'remove_days', name: 'remove_days', searchable: false},
            //         {data: 'item_name', name: 'items.name'},
            //         {data: 'measure_name', name: 'symbol', orderable: false, searchable: false},
            //         {data: 'quantity', name: 'quantity', orderable: false, searchable: false},
            //         {data: 'total', name: 'total', orderable: false, searchable: false},

            //     ]
            // });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("customsExpense.show",$itemExpense->id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });


        });
    </script>


@endpush
