@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense_detail');
$_name=in_array('name', $report);
$_symbol=in_array('symbol', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_total=in_array('total', $report);
$_otherCost=in_array('otherCost', $report);

?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseDetail')</h3>
@if($from_date || $to_date)
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
@endif

@if($expense_category_name  || $currency)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($currency)
      <td>
        <span>@lang('layout.Currency')</span>: {{$currency}}
      </td>
      @endif
      @if($expense_category_name)
      <td>
        <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif


<h4>@lang('layout.PaletNumber') : {{$palet_number}}   ---  @lang('layout.Driver') : {{$driver_name}}</h4>



<table class="main-table">

<thead>
  <tr class="bg">
 <td><div class="center"> #</div></td>

 <td><div class="center"> @lang('layout.Type')</div></td>
 <td><div class="center"> @lang('layout.TypeNumber')</div></td>
 <td><div class="center"> @lang('layout.Number')</div></td>
 <td><div class="center"> @lang('layout.Date')</div></td>
 <td><div class="center"> @lang('layout.Member')</div></td>
 <td><div class="center"> @lang('layout.Description')</div></td>
 <td><div class="center"> @lang('layout.ItemName')</div></td>
  <td><div class="center"> @lang('layout.Measure')</div></td>
 <td><div class="center"> @lang('layout.Quantity')</div></td>
 @foreach($itemExpenseCategory AS $rec)
<td><div class="center"> {{$rec->name}}</div></td>
 @endforeach
 @if($_total)<td><div class="center"> @lang('layout.Currency')</div></td>@endif
 @if($_total)<td><div class="center"> @lang('layout.Rate')</div></td>@endif
 @if($_total)<td><div class="center"> @lang('layout.Total')</div></td>@endif
 @if($_total && !$currency)<td><div class="center"> @lang('layout.Total') {{Currency()->symbol}}</div></td>@endif

</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
$per_category=[];

?>
@foreach($data AS $record)

@if(is_array($record['itemExpenseCategory']))
 
   @foreach($record['itemExpenseCategory'][0] AS $rec)
    <?php
	// dd($rec['item']->items);
      $sub_total=0;
    ?>
    <tr>
    <td class="center">{{++$count}}</td>
    <td  class="center">{{__('layout.'.ucfirst($record['info'][0]['type']))}}</td>
    <td  class="center">{{$record['info'][0]['type_number']}}</td>
    <td  class="center">{{$record['number']}}</td>
    <td  class="center">{{convertDate($record['date'])}}</td>
    <td  class="center">{{$record['member_name']}}</td>
    <td  class="center">{{$record['description']}}</td>
    <td  class="center">@if($rec['item']) {{$rec['item']->items}} @endif</td>
    <td  class="center">@if($rec['item']) {{$rec['item']->measure}} @endif</td>

    <td class="center">@if($rec['item']) {{$rec['item']->qty}} @endif</td>

    @if(is_array($rec['itemExpenseCategory']))
       @foreach($rec['itemExpenseCategory'] AS $cat)
       
       <?php
	  //  dd($record['info'][0]);
       $t=$cat['amount'];
       if($rec['item'] && $record['info'][0])
       {
        if($record['info'][0]->category =='perUnit')
       {
          $t=$t*$rec['item']->qty;
       }
       else
       {
          $t=$t;
       }
      }
       $sub_total+=$t;

       if($currency){
         $ratee = 1;
       } else {
        $ratee = $record['rate'];
       }

       $total_home_currency+=$t/$ratee;

       if(array_key_exists($cat['name'], $per_category) && $t>0)
       {
        $per_category[$cat['name']]=$per_category[$cat['name']]+$t/$ratee;
      }
      else
      {
        if($t>0)
        {
          $per_category[$cat['name']]=$t/$ratee;
        }
      }

       ?>
        <td><div class="center"> {{$cat['amount']}}</div></td>
       @endforeach
    @endif  
    @if($_total)<td class="center">{{$record['currency']}}</td>@endif
    @if($_total)<td class="center">{{$record['rate']}}</td>@endif
    @if($_total)<td class="center">{{myRound($sub_total)}} </td>@endif
    @if($_total && !$currency)<td class="center">{{myRound($sub_total/$record['rate'])}} {{Currency()->symbol}}</td>@endif


    </tr>
   @endforeach

@endif

@endforeach  
</table>

<table class="main-table">
<thead>
  <tr>
  <th>@lang('layout.Name')</th>
  <th>@lang('layout.Amount')</th>
</tr>
</thead>
<tbody>
  @foreach($per_category AS $key=>$value)
  <tr>

    <td>{{$key}}</td>
    <td>{{myRound($value)}} @if($currency) {{$currency}} @else {{getHomeCurrency()[getCurrencyType()]}} @endif</td>
  </tr>
  @endforeach

</tbody>

</table>

<?php
$totals = 0;
?>

@if (count($finedForeign)>0)
<h3>@lang('layout.Fine')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($finedForeign AS $record3)
    <tr>
        <?php
        if($currency){
          $totals += $record3->total_base;
        } else {
          $totals += $record3->total;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record3->item_name}}</td>
        <td class="center">{{myRound($record3->fined_quantity)}}</td>
        <td class="center">{{$record3->Measure}}</td>
        <td class="center">{{($currency)?myRound($record3->total_base):myRound($record3->total)}}</td>
    </tr>
    @endforeach
</table>
@endif
<br/>
<table class="main-table">
  <tr class="bg">
      <td  class="center"> @lang('layout.Total') </td>
      <td class="center">{{myRound($total_home_currency - $totals)}} @if($currency) {{$currency}} @else {{getHomeCurrency()[getCurrencyType()]}} @endif</td>
  </tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection
