@extends('layouts.factor-master')

@section('content')
<?php
 $report = customeReportNew('customsExpense');
$_record  =  !in_array('record', $report);
$_number  =  !in_array('number', $report);
$_date  =  !in_array('date', $report);
$_member  =  !in_array('member', $report);
$_license_name  =  !in_array('license_name', $report);
$_description  =  !in_array('description', $report);
$_vehicle  =  !in_array('vehicle', $report);
$_type  =  !in_array('type', $report);
$_item  =  !in_array('item', $report);
$_quantity  =  !in_array('quantity', $report);
$_customsQuantity  =  !in_array('customsQuantity', $report);
$_measure  =  !in_array('measure', $report);
$_category  =  !in_array('category', $report);
$_currency  =  !in_array('currency', $report);
$_account  =  !in_array('account', $report);
$_rate  =  !in_array('rate', $report);
$_total  =  !in_array('total', $report);
$_perPrice  =  !in_array('perPrice', $report);
$_user  =  !in_array('user', $report);
$_hour = !in_array('hour', $report);
 
$report_percent = customeReportNewPercent('customsExpense');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_license_name_percent= (array_key_exists('license_name___percent', $report_percent))?$report_percent['license_name___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_vehicle_percent= (array_key_exists('vehicle___percent', $report_percent))?$report_percent['vehicle___percent']:null;
    $_item_percent= (array_key_exists('item___percent', $report_percent))?$report_percent['item___percent']:null;
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_customsQuantity_percent= (array_key_exists('customsQuantity___percent', $report_percent))?$report_percent['customsQuantity___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_perPrice_percent= (array_key_exists('perPrice___percent', $report_percent))?$report_percent['perPrice___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_hour_percent= (array_key_exists('hour___percent', $report_percent))?$report_percent['hour___percent']:null;
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.CustomsExpenseReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true') {{convertDate($from_date, null, null,
        ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}} <span dir="rtl"> &nbsp;&nbsp;&nbsp;
          @lang('layout.MarchingAt') </span> @endif {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true') {{convertDate($to_date, null, null,
        ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}} <span dir="rtl"> &nbsp;&nbsp;&nbsp;
          @lang('layout.MarchingAt') </span> @endif {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
@endif

@if($expense_category_name || $currency || $contract_name || $companyLicenseName)
<table class="main-table" style="margin: 6px 0px;">
  <tr>
    @if($currency)
    <td>
      <span>@lang('layout.Currency')</span>: {{$currency}}
    </td>
    @endif
    @if($expense_category_name)
    <td>
      <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
    </td>
    @endif
    @if($contract_name)
    <td>
      <span>@lang('menu.Contract')</span>: {{$contract_name}}
    </td>
    @endif
    @if($companyLicenseName)
    <td>
      <span>@lang('layout.CompanyLicense')</span>: {{$companyLicenseName}}
    </td>
    @endif

  </tr>
</table>
@endif

<table class="main-table">

  <thead>

    <tr class="bg">
      <td @if($_record_percent) width="{{$_record_percent}}%" @endif class="center">
        <div> @lang('layout.Record') </div>
      </td>
      @if($_number)<td @if($_number_percent) width="{{$_number_percent}}%" @endif class="center">
        <div> @lang('layout.Number')</div>
      </td>@endif
      @if($_date)<td @if($_date_percent) width="{{$_date_percent}}%" @endif class="center">
        <div> @lang('layout.Date')</div>
      </td>@endif
      @if($_hour)<td class="center" @if($_hour_percent) width="{{$_hour_percent}}%" @endif>
        <div> @lang('layout.Hour')</div>
      </td>@endif
      @if($_description)<td @if($_description_percent) width="{{$_description_percent}}%" @endif class="center">
        <div> @lang('layout.Description')</div>
      </td>@endif
      @if($_vehicle)<td @if($_vehicle_percent) width="{{$_vehicle_percent}}%" @endif class="center">
        <div> @lang('layout.Vehicle')</div>
      </td>@endif
      @if($_item)<td @if($_item_percent) width="{{$_item_percent}}%" @endif class="center">
        <div> @lang('layout.Item')</div>
      </td>@endif
      @if($_quantity)<td @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif class="center">
        <div> @lang('layout.Quantity') (@lang('layout.SeamerTonnage'))</div>
      </td>@endif
      @if($_customsQuantity)<td @if($_customsQuantity_percent) width="{{$_customsQuantity_percent}}%" @endif
        class="center">
        <div> @lang('layout.CustomsQuantity') </div>
      </td>@endif
      @if($_customsQuantity)<td @if($_customsQuantity_percent) width="{{$_customsQuantity_percent}}%" @endif
        class="center">
        <div> @lang('layout.Differ') </div>
      </td>@endif
      @if($_measure)<td @if($_measure_percent) width="{{$_measure_percent}}%" @endif class="center">
        <div> @lang('layout.Measure') </div>
      </td>@endif

      @if(array_search('customs_amount', $no_ex_category) === false) <td class="center"> @lang('layout.CustomsAmount') </td> @endif
      @if(array_search('customs_percent', $no_ex_category) === false) <td class="center"> @lang('layout.Customs') </td> @endif
      @if(array_search('tax_percent', $no_ex_category) === false) <td class="center"> @lang('layout.TaxPercent') </td> @endif
      @if(array_search('static_tax', $no_ex_category) === false) <td class="center"> @lang('layout.StaticTax') </td> @endif
      @if(array_search('helal_ahmar_percent', $no_ex_category) === false) <td class="center"> @lang('layout.HelalAhmar') </td> @endif
      @if(array_search('allocation_petroleum', $no_ex_category) === false) <td class="center"> @lang('layout.AllocationOfPetroleumProduct') </td> @endif

      @if ($all_category)
        @foreach ($all_category as $item)
        @if(array_search($item->id, $no_ex_category) === false) <td class="center" >{{$item->name}}</td> @endif
        @endforeach
      @endif

      @if(!$expense_category_name) @if($_category)<td @if($_category_percent) width="{{$_category_percent}}%" @endif
        class="center">
        <div> @lang('layout.Category')</div>
      </td>@endif @endif
      @if($_type)<td @if($_type_percent) width="{{$_type_percent}}%" @endif class="center">
        <div> @lang('layout.Type')</div>
      </td>@endif
      @if($_license_name)<td @if($_license_name_percent) width="{{$_license_name_percent}}%" @endif class="center">
        <div> @lang('layout.CompanyLicense')</div>
      </td>@endif
      @if($_member)<td @if($_member_percent) width="{{$_member_percent}}%" @endif class="center">
        <div> @lang('layout.Vendor')</div>
      </td>@endif
      @if($_account)<td @if($_account_percent) width="{{$_account_percent}}%" @endif class="center">
        <div> @lang('layout.Account')</div>
      </td>@endif
      @if(!$currency) @if($_currency)<td @if($_currency_percent) width="{{$_currency_percent}}%" @endif class="center">
        <div> @lang('layout.Currency')</div>
      </td>@endif @endif
      @if($_rate)<td @if($_rate_percent) width="{{$_rate_percent}}%" @endif class="center">
        <div> @lang('layout.Rate')</div>
      </td>@endif
      @if($_total)<td @if($_total_percent) width="{{$_total_percent}}%" @endif class="center">
        <div> @lang('layout.TotalAmount')</div>
      </td>@endif
      @if($_total)<td @if($_total_percent) width="{{$_total_percent}}%" @endif class="center">
        <div> @lang('layout.OverCustomsAmount')</div>
      </td>@endif
      @if($_total)<td @if($_total_percent) width="{{$_total_percent}}%" @endif class="center">
        <div> @lang('layout.AmountPayable')</div>
      </td>@endif
      @if($_total)<td @if($_total_percent) width="{{$_total_percent}}%" @endif class="center">
        <div> @lang('layout.AmountPayable') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>@endif
      @if($_perPrice)<td @if($_perPrice_percent) width="{{$_perPrice_percent}}%" @endif class="center">
        <div> @lang('layout.PerPrice')</div>
      </td>@endif
      @if($_perPrice)<td @if($_perPrice_percent) width="{{$_perPrice_percent}}%" @endif class="center">
        <div> @lang('layout.PerPrice') {{getHomeCurrency()[getCurrencyType()]}}</div>
      </td>@endif
      @if($_user)<td @if($_user_percent) width="{{$_user_percent}}%" @endif class="center">
        <div> @lang('layout.User')</div>
      </td>@endif
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency=0;
  $currencies=[];
  $details=[];
  $quantity=0;
  $customs_quantity=0;
  $customs_amount1=0;
  $customs_percent1=0;
  $tax_percent1=0;
  $static_tax1=0;
  $helal_ahmar_percent1=0;
  $allocation_petroleum1=0;
  $total_customs_amount=0;
  $over_customs_amount=0;
  $amount=0;
  $colunm=1;

?>
  @foreach($data AS $record)
  <?php

   $total_home_currency+=$record->amount/$record->rate;
   if(array_key_exists($record->currency, $currencies))
   {
    $currencies[$record->currency]=$currencies[$record->currency]+$record->amount;
  }
  else
  {
    $currencies[$record->currency]=$record->amount;
  }
  
  $quantity += $record->quantity;
  $customs_quantity += $record->customs_quantity;
  $customs_amount1 += $record->customs_amount1;
  $customs_percent1 += $record->customs_percent1;
  $tax_percent1 += $record->tax_percent1;
  $static_tax1 += $record->static_tax1;
  $helal_ahmar_percent1 += $record->helal_ahmar_percent1;
  $allocation_petroleum1 += $record->allocation_petroleum1;
  $total_customs_amount += $record->total_customs_amount;
  $over_customs_amount += $record->over_customs_amount;
  $amount += $record->amount;

  ?>
  <tr>

    <td class="center">{{++$count}}</td>
    @if($_number)<td class="center">{{$record->number}}</td>@endif
    @if($_date)<td class="center"> {{convertDate($record->date)}}</td>@endif
    @if($_hour)
    <td class="center">
      @if(getHourType() == 24)
      {{ (($record->hour != null)?(date_format(date_create($record->hour), 'H:i')):'') }}
      @else
      {{ (($record->hour != null)?(date_format(date_create($record->hour), 'h:i:a')):'') }}
      @endif
    </td>
    @endif
    @if($_description)<td class="center" style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
    @if($_vehicle)<td class="center">{{$record->vehicle_name}}</td>@endif
    @if($_item)<td class="center">{{$record->item}}</td>@endif
    @if($_quantity)<td class="center">{{$record->quantity}}</td>@endif
    @if($_customsQuantity)<td class="center">{{$record->customs_quantity}}</td>@endif
    @if($_customsQuantity)<td class="center">{{($record->quantity - $record->customs_quantity)}}</td>@endif
    @if($_measure)<td class="center">{{$record->measure}}</td>@endif
    
    @if(array_search('customs_amount', $no_ex_category) === false) <td class="center"> {{ myRound($record->customs_amount1)}} </td> @endif
    @if(array_search('customs_percent', $no_ex_category) === false) <td class="center"> {{ myRound($record->customs_percent1)}} </td> @endif
    @if(array_search('tax_percent', $no_ex_category) === false) <td class="center"> {{ myRound($record->tax_percent1)}} </td> @endif
    @if(array_search('static_tax', $no_ex_category) === false) <td class="center"> {{ myRound($record->static_tax1)}} </td> @endif
    @if(array_search('helal_ahmar_percent', $no_ex_category) === false) <td class="center"> {{ myRound($record->helal_ahmar_percent1)}} </td> @endif
    @if(array_search('allocation_petroleum', $no_ex_category) === false) <td class="center"> {{ myRound($record->allocation_petroleum1)}} </td> @endif

    @if ($all_category)
      @foreach ($all_category as $item)
      @if(array_search($item->id, $no_ex_category) === false)
        @if (count($record->details) > 0)
          @if ($record->details->where('id',$item->id)->first())
          <td class="center" >{{myRound($record->details->where('id',$item->id)->first()->total_amount)}}</td>
          <?php
          if(array_key_exists($item->id, $details)){
            $details[$item->id]=$details[$item->id]+($record->details->where('id',$item->id)->first()->total_amount);
          } else {
            $details[$item->id]=($record->details->where('id',$item->id)->first()->total_amount);
          }
          ?>
          @else
          <td class="center" ></td>
          <?php
          if(array_key_exists($item->id, $details)){
          } else {
            $details[$item->id]=0;
          }
          ?>
          @endif
        @else
        <td class="center" ></td>
        <?php
          if(array_key_exists($item->id, $details)){
          } else {
            $details[$item->id]=0;
          }
          ?>
        @endif
      @endif
      @endforeach
    @endif

    @if(!$expense_category_name) @if($_category)<td class="center">{{$record->category}}</td>@endif @endif
    @if($_type)<td class="center">{{__('layout.'.ucfirst($record->expense_type))}}</td>@endif
    @if($_license_name)<td class="center">{{$record->license_name}}</td>@endif
    @if($_member)<td class="center">{{$record->member}}</td>@endif
    @if($_account)<td class="center">{{$record->account}}</td>@endif
    @if(!$currency) @if($_currency)<td class="center">{{$record->currency}}</td>@endif @endif
    @if($_rate)<td class="center">{{$record->rate}}</td>@endif
    @if($_total)<td class="center">{{myRound($record->total_customs_amount)}}</td>@endif
    @if($_total)<td class="center">{{myRound($record->over_customs_amount)}}</td>@endif
    @if($_total)<td class="center">{{myRound($record->amount)}}</td>@endif
    @if($_total)<td class="center">{{myRound($record->amount / $record->rate)}}</td>@endif
    @if($_perPrice)<td class="center">{{myRound($record->amount / $record->quantity)}}</td>@endif
    @if($_perPrice)<td class="center">{{myRound(($record->amount / $record->quantity) / $record->rate)}}</td>@endif
    @if($_user)<td class="center">{{$record->user}}</td>@endif

  </tr>  
  @endforeach
  
  <tr class="bg">
    @if($_number)<?php $colunm++; ?>@endif
    @if($_date)<?php $colunm++; ?>@endif
    @if($_hour)<?php $colunm++; ?>@endif
    @if($_description)<?php $colunm++; ?>@endif

    <td colspan="{{$colunm}}" class="center">@lang('layout.Total')</td>
    @if($_vehicle)<td class="center">{{++$count}}</td>@endif
    @if($_item)<td class="center"></td>@endif
    @if($_quantity)<td class="center">{{myRound($quantity)}}</td>@endif
    @if($_customsQuantity)<td class="center">{{myRound($customs_quantity)}}</td>@endif
    @if($_customsQuantity)<td class="center">{{myRound($quantity - $customs_quantity)}}</td>@endif
    @if($_measure)<td class="center"></td>@endif
    
    @if(array_search('customs_amount', $no_ex_category) === false) <td class="center"> {{ myRound($customs_amount1)}} </td> @endif
    @if(array_search('customs_percent', $no_ex_category) === false) <td class="center"> {{ myRound($customs_percent1)}} </td> @endif
    @if(array_search('tax_percent', $no_ex_category) === false) <td class="center"> {{ myRound($tax_percent1)}} </td> @endif
    @if(array_search('static_tax', $no_ex_category) === false) <td class="center"> {{ myRound($static_tax1)}} </td> @endif
    @if(array_search('helal_ahmar_percent', $no_ex_category) === false) <td class="center"> {{ myRound($helal_ahmar_percent1)}} </td> @endif
    @if(array_search('allocation_petroleum', $no_ex_category) === false) <td class="center"> {{ myRound($allocation_petroleum1)}} </td> @endif

    @if ($all_category)
      @foreach ($all_category as $item)
      @if(array_search($item->id, $no_ex_category) === false)
        @if (count($details) > 0)
          @if (isset($details[$item->id]))
          <td class="center" >@if (count($currencies) <= 1){{myRound($details[$item->id])}}@endif</td>
          @else
          <td class="center" ></td>
          @endif
        @else
        <td class="center" ></td>
        @endif
      @endif
      @endforeach
    @endif

    @if(!$expense_category_name) @if($_category)<td class="center"></td>@endif @endif
    @if($_type)<td class="center"></td>@endif
    @if($_license_name)<td class="center"></td>@endif
    @if($_member)<td class="center"></td>@endif
    @if($_account)<td class="center"></td>@endif
    @if(!$currency) @if($_currency)<td class="center"></td>@endif @endif
    @if($_rate)<td class="center"></td>@endif
    @if($_total)<td class="center">@if (count($currencies) <= 1){{myRound($total_customs_amount)}}@endif</td>@endif
    @if($_total)<td class="center">@if (count($currencies) <= 1){{myRound($over_customs_amount)}}@endif</td>@endif
    @if($_total)<td class="center">@if (count($currencies) <= 1){{myRound($amount)}}@endif</td>@endif
    @if($_total)<td class="center">{{myRound($total_home_currency)}}</td>@endif
    @if($_perPrice)<td class="center"></td>@endif
    @if($_perPrice)<td class="center"></td>@endif
    @if($_user)<td class="center"></td>@endif

  </tr>
</table>
<table class="main-table">
  <tr class="bg">
    <td colspan="3">
      <div class="center">@lang('layout.PerCurrency')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
  </tr>
  <?php
$count=0;
foreach($currencies As $key=>$currency )
{
  ?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency)}}</div>
    </td>

  </tr>
  <?php
}
?>
  <tr>
    <td colspan="2">
      <div class="center">@lang('layout.HomeCurrencyTotal')</div>
    </td>
    <td>
      <div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>

  </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection