@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 70% !important;
    }

    .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection
@section('content')
    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'customsExpense'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('menu.ExpenseCategory') </label>
                                <select name="category_id" id="" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    @foreach($category as  $rec)
                                        <option value="{{$rec->id}}">{{$rec->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Category') </label>
                                <select name="ex_category_id" id="" class="form-control">
                                    <option value="">@lang('layout.SelectCategory')</option>
                                    @foreach($ex_category as  $rec)
                                        <option value="{{$rec->id}}">{{$rec->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="control-label ">@lang('layout.PaletNumber') </label>
                                <input class="form-control" name="palet_number" type="text">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Currency')</label>
                                <select name="currency" id="" class="form-control">
                                    <option value="">@lang('layout.SelectCategory')</option>
                                    @foreach($currency as  $cu)
                                        <option value="{{$cu->code}}">{{$cu->code}}</option>
                                    @endforeach
                                </select>
                            </div>

                             <div class="col-md-4">
                                <label class="control-label ">@lang('layout.Type') </label>
                                 <div class="input-group">
                                    <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                    <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                </div>
                                
                            </div>

                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off"
                                               name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off"
                                               name="to_date">

                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div> --}}


    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'customsExpense'" @closed="closeModal">
            <div slot="body">
    
                <!----------------------------------------------
                    ----Begin Report Body And Custome Report-------
                    ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
    
                        <ul class="nav nav-tabs">
    
                            @permission(['customsExpense-export'])
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @endpermission
                            @if(systemConfig()[2] != 0 )
                            @permission(['customsExpense-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
    
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="form-group">
                        
                                                <div class="col-md-12">
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('menu.ExpenseCategory') </label>
                                                        <select name="category_id" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectType')</option>
                                                            @foreach($category as  $rec)
                                                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    {{-- <div class="col-md-4">
                                                        <label class="control-label">@lang('layout.Category')</label>
                                                        <v-select class="vue-select2" label="name" :options="ex_category" v-model="selected_ex_category" :multiple="true"></v-select>
                                                        <input type="hidden" name="ex_category_id" :value="ex_category_id.length > 0 ? ex_category_id:null">
                                                    </div> --}}
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.NotShowCategory') </label>
                                                        <v-select class="vue-select2" v-model="selectedCategoryNo" label="name" :options="ex_category_no" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="no_ex_category_id" :value="item_id.length > 0 ? item_id:null">
                                                    </div>
                        
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Currency')</label>
                                                        <select name="currency" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectCategory')</option>
                                                            @foreach($currency as  $cu)
                                                                <option value="{{$cu->code}}">{{$cu->code}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.CompanyLicense')</label>
                                                        <v-select label="name" :options="companyLicense" v-model="selected_companyLicense"></v-select>
                                                        <input type="hidden" name="company_license_id" :value="(selected_companyLicense==null)?null:selected_companyLicense.id">
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.SelectItem') </label>
                                                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" >
                                                        </v-select>
                                                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id" >
                                                    </div>
                        
                                                     <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Type') </label>
                                                         <div class="input-group">
                                                            <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                                            <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                                        </div>
                                                        
                                                    </div>
                        
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                        
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off"
                                                                       name="from_date">
                        
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off"
                                                                       name="to_date">
                        
                                                            </div>
                                                        </div> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                                                                     
    
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
    
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="customsExpense">
    
                                          
                                            <div class="col-md-12 col-sm-12 col-xs-12">
    
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
    
                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
    
    
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                    </div>
                                                </div>
                                            </div>
                                         
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
    
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                        class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
    
                        </div>
                    </div>
                </div>
    
    
            </div>
        </report-modal>
    </div>
    
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CustomsExpenseList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CustomsExpenseCategory-list')
                    <a href="{{route('customsExpenseCategory.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('layout.CustomsExpenseCategory')
                        </button>
                    </a>
                    @endpermission
                    @permission('customsExpenseOption-list')
                    <a href="{{route('customsExpenseOption.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('layout.CustomsExpenseOption')
                        </button>
                    </a>
                    @endpermission
                    @permission('customsExpense-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('customsExpense-create')
                    <a href="{{route('customsExpense.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission

                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="itemExpense">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Vendor')</th>
                        <th>@lang('layout.Vehicle')</th>
                        <th>@lang('layout.Item')</th>
                        <th>@lang('layout.Quantity') (@lang('layout.SeamerTonnage'))</th>
                        <th>@lang('layout.CustomsQuantity')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        var cust_rep = {!!customeReportNewData('customsExpense')!!}; 
        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#itemExpense').DataTable({
                ajax: '{{route("customsExpense.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:9}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'customs_expenses.number'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'rate', name: 'transactions.rate', searchable: false},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'account', name: 'accounts.name'},
                    {data: 'member', name: 'members.name'},
                    {data: 'vehicle_name', name: 'vehicle_name', searchable: false},
                    {data: 'item', name: 'items.name'},
                    {data: 'quantity', name: 'customs_expenses.quantity'},
                    {data: 'customs_quantity', name: 'customs_expenses.customs_quantity'},
                    {data: 'measure', name: 'measure_units.name'},
                    {data: 'date', name: 'customs_expenses.date', searchable: false},
                    {data: 'hour', name: 'purchases.hour', searchable: false},
                    {data: 'expense_type', name: 'customs_expenses.expense_type', orderable: false, searchable: false},
                    {data: 'description', name: 'customs_expenses.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });

        var companyLicense = {!! $companyLicense !!};

        var ex_category_no = {!! $ex_category_no !!};
        var ex_category = {!! $ex_category !!};

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                selected_currency: null,
                companyLicense: companyLicense,
                selected_companyLicense: null,
                ex_category: ex_category,
                selected_ex_category: null,
                ex_category_id: [],
                itemlist: [],
                selectedItem: null,
                selectedCategoryNo: null,
                ex_category_no: ex_category_no,
                item_id: [],
                pdfRoute: '{!!route('customsExpense.report') !!}',
                excelRoute: '{!! route('customsExpense.report') !!}',
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                 {Name: '@lang("layout.CompanyLicense")', column_name: 'license_name',checkedColumn:(cust_rep.license_name)?'checked':'',column_percentage:(cust_rep.license_name___percent)?cust_rep.license_name___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Vehicle")', column_name: 'vehicle',checkedColumn:(cust_rep.vehicle)?'checked':'',column_percentage:(cust_rep.vehicle___percent)?cust_rep.vehicle___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.CustomsQuantity")', column_name: 'customsQuantity',checkedColumn:(cust_rep.customsQuantity)?'checked':'',column_percentage:(cust_rep.customsQuantity___percent)?cust_rep.customsQuantity___percent:''},
                 {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                    
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                 {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_rep.item)?'checked':'',column_percentage:(cust_rep.item___percent)?cust_rep.item___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.PerPrice")', column_name: 'perPrice',checkedColumn:(cust_rep.perPrice)?'checked':'',column_percentage:(cust_rep.perPrice___percent)?cust_rep.perPrice___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.ReferenceName")', column_name: 'reference_name',checkedColumn:(cust_rep.reference_name)?'checked':'',column_percentage:(cust_rep.reference_name___percent)?cust_rep.reference_name___percent:''},
              
                ],
                  cust_rep:cust_rep


            },
            watch: {
                selectedCategoryNo: function(newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function(e) {
                        x.push(e.id);
                    });
                    this.item_id = x;
                    // console.log('x value');
                    // console.log(x);
                },
                selected_ex_category: function(newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function(e) {
                        x.push(e.id);
                    });
                    this.ex_category_id = x;
                }
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onItemSearch(search, loading) {
                    loading(true);
                    this.searchItem(search, loading, this);
                },
                //ajax call to get items
                searchItem(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                            vm.itemlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush
