@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
    <style>

        input {
            border: 1px solid #c2cad8;
            border-radius: 4px;
        }
        input[readonly] {
            background-color: #eef1f5;
            opacity: 1;
        }
    </style>
@stop
@section('content')
@include('inventories.cmodal')  

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('layout.CustomsExpenseCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div id="itemexpense" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'customsExpense.store','method'=>'POST','id' => 'customsExpense-form','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class=" col-md-9">
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label ">@lang('layout.Type')</label>
                                    <select name="type" class="form-control" v-model="selected_type" @click="carChange()" >
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="purchase">@lang('layout.Purchases')</option>
                                        <option value="transferAndLoading">@lang('layout.TransferAndLoading')</option>
                                        <option value="discharge">@lang('layout.Discharge')</option>
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <input type="number" v-model="type_number" name="type_number" id="number" @input="searchVehicle()" class="form-control">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label ">@lang('layout.Vehicle')</label>
                                    <v-select label="name" v-model="item" :options="temp_vehicle" @input="setMeasure(),setQuantity()" @search="onItemSearchVehicle" ></v-select>
                                    <input type="hidden" name="type_id" :value="(!item)?null:item.type_id" >
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <input type="number" name="number" v-model="number" class="form-control">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Hour')</label>
                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                        @if(getHourType() == 24)
                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @else
                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @endif
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-clock-o"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency"
                                              v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>

                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="rate"
                                           v-model="!selected_currency?rate:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                    <span v-if="differentRate && selected_expense_type == 'bill'" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ExpenseType')</label>

                                                <select name="expense_type" v-model="selected_expense_type"
                                                        class="form-control">
                                                    <option value="writeCheck">@lang('layout.Writecheck')</option>
                                                    <option value="bill">@lang('layout.Bill')</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12"  v-if="selected_expense_type =='bill'">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Vendor')</label>

                                                <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                                <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" v-if="selected_expense_type =='writeCheck'">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Account')</label>

                                                <v-select label="name" :options="approperiateBank" v-model="selected_banks" @input="set_avg_rate_by_bank(selected_banks)"></v-select>
                                                <input type="hidden" name="bank_account"
                                                    :value="(selected_banks==null)?null:selected_banks.id">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.ReferenceName')</label>
                                    <input type="text" name="referencen_name" class="form-control">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control">
                                </div>
                            </div>
                        </div>

                        <!-- bgin pay -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ myRound(Total - payeds - differ_amount)}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                        <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ myRound(payeds)}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Differ'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ myRound(differ_amount)}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ myRound(Total)}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                   
                                </table>

                            </div>

                            <!-- end total -->
                        </div>
                        <!-- end pay -->
                        
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.CustomsExpenseOption')</label>
                                            <v-select label="name" :options="customsExpenseOption" v-model="selectedOption" @input="setCurrency()" ></v-select>
                                            <input type="hidden" name="customs_option_id" :value="(selectedOption==null)?null:selectedOption.id">
                                        </div>
                                    </div>
                                </div>
                                <div v-show="selectedOption" class="col-md-2">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" :options="option_currency" v-model="option_selected_currency"></v-select>
                                    <input type="hidden" name="option_currency" :value="option_selected_currency.code">
                                </div>
                                <div v-show="selectedOption" class="col-md-2">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="option_rate" v-model="!option_selected_currency?rate:option_selected_currency.rate" class="form-control">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseCategory')</label>
                                            <div class="input-group">
                                                <v-select label="name" :options="expenseCategory" v-model="selected_category"></v-select>
                                                <input type="hidden" name="expense_category_id" :value="(this.selected_category==null)?null:selected_category.id">
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showcModal = true" id="show-cmodal" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.CompanyLicense')</label>

                                            <v-select label="name" :options="companyLicense" v-model="selected_companyLicense"></v-select>
                                            <input type="hidden" name="company_license_id" :value="(selected_companyLicense==null)?null:selected_companyLicense.id">
                                        </div>
                                    </div>
                                </div>
                            
                        

                            </div>
                            


                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control" rows="1"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <!-- begin items -->
                    <div class="row" v-if="item" >
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                                <tr>
                                    <th style="min-width: 120px" >@lang('layout.ItemName') </th>
                                    <th style="min-width: 120px">@lang('layout.SiteName') </th>
                                    <th style="min-width: 100px">@lang('layout.PurchaseCost') </th>
                                    <th>@lang('layout.Quantity') (@lang('layout.SeamerTonnage')) </th>
                                    <th style="min-width: 100px">@lang('layout.Measure') </th>
                                    <th style="min-width: 120px" >@lang('layout.CustomsQuantity') </th>
                                    <th style="min-width: 120px" >@lang('layout.Differ') </th>
                                </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>
                                    <input type="hidden" name="purch_id" :value="(!item)?null:item.purchase_id">
									<input type="hidden" name="stock_id" :value="(!item)?null:item.stock_id">
									<input type="hidden" name="quantity" :value="(!item && !selected_measure)?null:((item.qty * item.measureUnit) / selected_measure.measure_unit)">
									<input type="hidden" name="inventory_id" :value="(!item)?null:item.inventory_id">
									<input type="hidden" name="load_id" :value="(!item)?null:item.load_id">
                                    <input type="hidden" name="transfer_and_loading_id" :value="(!item)?null:item.id">
                                    
                                    @{{(!item)?null:item.items}}
                                </td>
                                <td>@{{(!item)?null:item.site}}</td>
                                <td>@{{(!item && !selected_measure)?null:myRound((item.cost / item.measureUnit) * selected_measure.measure_unit)}}</td>
                                <td>@{{(!item && !selected_measure)?null:((item.qty * item.measureUnit) / selected_measure.measure_unit)}}</td>
                                <td>
                                    <select name="measure" class="form-control" @click="setQuantity()" v-model="selected_measure">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(!item)?false:true">
                                            <option v-for="measure in measureList" :value="measure">
                                                @{{measure.measure_name}}
                                            </option>
                                        </span>
                                    </select>
                                    <input type="hidden" name="measure_id" :value="(!selected_measure)?null:selected_measure.measure_id">
                                </td>
                                <td>
                                    <input type="number" name="quantity_in" step="any" v-model="quantity" @input="setDifferQuantity()" oninput = "autowidths(event)" class="form-control chan_length" >
                                </td>
                                <td>
                                    <input type="number" name="differ_quantity" step="any" v-model="differ_quantity" oninput = "autowidths(event)" class="form-control chan_length" >
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <br/>
                        <br/>
                    </div>
                    <!-- end items -->
                    <br>
                    <!-- begin items -->
                    <div class="row" v-if="item && selectedOption" >
                        <table class="table table-bordered table-advance">
                            <thead>
                                <tr>
                                    <th style="min-width: 120px" >@lang('layout.CustomsAmount') </th>
                                    <th style="min-width: 120px">@lang('layout.CustomsPercent') %</th>
                                    <th style="min-width: 120px">@lang('layout.TaxPercent') %</th>
                                    <th style="min-width: 120px">@lang('layout.StaticTax') %</th>
                                    <th style="min-width: 120px">@lang('layout.HelalAhmarPercent') %</th>
                                    <th style="min-width: 120px">@lang('layout.AllocationOfPetroleumProduct') % -- @lang('layout.PerPrice')</th>
                                    <th style="min-width: 120px">@lang('layout.Liter') </th>
                                    <th style="min-width: 120px">@lang('layout.Density') </th>
                                </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="customs_amount" step="any" v-model="(!selectedOption)?null:selectedOption.customs_amount" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="customs_amount1" step="any" style="width: 100%;" readonly :value="Number.parseFloat(Number.parseFloat(CustomsAmount).toFixed(7))">
                                    </div>
                                </td>
                                <td>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="customs_percent" step="any" v-model="(!selectedOption)?null:selectedOption.customs_percent" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="customs_percent1" step="any" style="width: 100%;" readonly :value="(!selectedOption)?null:Number.parseFloat(Number.parseFloat((CustomsAmount * selectedOption.customs_percent) / 100).toFixed(7))" >
                                    </div>
                                </td>
                                <td>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="tax_percent" step="any" v-model="(!selectedOption)?null:selectedOption.tax_percent" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="tax_percent1" step="any" style="width: 100%;" readonly :value="(!selectedOption)?null:Number.parseFloat(Number.parseFloat(((((CustomsAmount * selectedOption.customs_percent) / 100) + CustomsAmount) * selectedOption.tax_percent) / 100).toFixed(7))" >
                                    </div>
                                </td>
                                <td>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="static_tax" step="any" v-model="(!selectedOption)?null:selectedOption.static_tax" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="static_tax1" step="any" style="width: 100%;" readonly :value="(!selectedOption)?null:Number.parseFloat(Number.parseFloat(((((CustomsAmount * selectedOption.customs_percent) / 100) + CustomsAmount) * selectedOption.static_tax) / 100).toFixed(7))" >
                                    </div>
                                </td>
                                <td>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="helal_ahmar_percent" step="any" v-model="(!selectedOption)?null:selectedOption.helal_ahmar_percent" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="helal_ahmar_percent1" step="any" style="width: 100%;" readonly :value="(!selectedOption)?null:Number.parseFloat(Number.parseFloat((((CustomsAmount * selectedOption.customs_percent) / 100) * selectedOption.helal_ahmar_percent) / 100).toFixed(7))" >
                                    </div>
                                </td>
                                <td>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                                        <input type="number" name="allocation_petroleum" step="any" v-model="(!selectedOption)?null:selectedOption.allocation_petroleum" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                                        <input type="number" name="allocation_petroleum_price" step="any" v-model="(!selectedOption)?null:selectedOption.allocation_petroleum_price" oninput = "autowidths(event)" class="form-control chan_length" >
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <input type="number" name="allocation_petroleum1" step="any" style="width: 100%;" readonly :value="(!selectedOption)?null:Number.parseFloat(Number.parseFloat(((quantity * selectedOption.allocation_petroleum) / 100) * selectedOption.allocation_petroleum_price).toFixed(7))" >
                                    </div>
                                </td>
                                <td>
                                    <input type="number" name="liter" step="any" v-model="liter" oninput = "autowidths(event)" class="form-control chan_length" >
                                </td>
                                <td>
                                    <input type="number" name="density" step="any" v-model="density" oninput = "autowidths(event)" class="form-control chan_length" >
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <br/>
                        <br/>
                    </div>
                    <!-- end items -->

                    <!-- begin items -->
                    <div class="row" v-if="item && selectedOption && itemExpenseCategory" style="overflow-x: scroll;" >
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                                <tr>
                                    <th style="min-width: 120px"  v-for="cat in itemExpenseCategory">
                                        @{{ cat.name }}
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td v-for="(cat,indexes) in itemExpenseCategory">
                                    <input type="hidden" v-model="(!cat)?null:cat.id" :name="'item_expense_category_id['+indexes+']'" >
                                    <input type="number" class="form-control" v-model="(!cat)?null:cat.amount" :name="'item_expense_category_amount['+indexes+']'" >
                                    <input type="number" class="form-control" :name="'item_expense_category_total['+indexes+']'" step="any" readonly :value="(!cat)?null:Number.parseFloat(Number.parseFloat(CategoryAmount(cat, indexes)).toFixed(7))" >
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <br/>
                        <br/>
                    </div>
                    <!-- end items -->

                    <div v-show="selected_expense_type=='bill'">
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                    <span v-if="payment.item !=null">
                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                    </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->

                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" v-if="!isError" :disabled="disabled" @click="submitForm()" >@lang('layout.Submit')</button>
						<button type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)" v-if="!isError">@lang('layout.SaveAndNew')</button>
                        <a href="{{route('customsExpense.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>


                {!! Form::close() !!}

                <!--Begin Modal -->
                {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                    {{ csrf_field() }}                                        
                    <cmodal :show="showcModal" @close="showcModal = false">
                        <h3 slot='cheader'>@lang('layout.CreateNewExpenseCategory')</h3>
                        <div slot="cbody">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description")</label>
                                            <textarea class="form-control" name="description" v-model="description">
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <div slot="cfooter">
                            <button type="button" class="modal-default-button btn btn-success" @click="addExpenseCategory">
                                @lang('layout.Submit')
                            </button>
                        </div>
                    </cmodal>
                    {!! Form::close() !!}
                    <!--End Modal-->

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script type="text/javascript">
        Vue.use(VueInputAutowidth);
        Vue.component('v-select', VueSelect.VueSelect);

            var Modal = Vue.component('cmodal',
                {
                    template:'#cmodal-template',
                    props: ['show'],
                });

        var currency = {!! $currency !!};
        var banks = {!! $banks !!};
        var expenseCategory = {!! $expenseCategory !!};
        var category = {!! $category !!};
        var inventoryCategory = {!! $inventoryCategory !!};
        var customsExpenseOption = {!! $customsExpenseOption !!};
        var measureList = {!! $measureList !!};
        var companyLicense = {!! $companyLicense !!};
        
        var vm = new Vue({
            el: '#itemexpense',
            data: {
                dynamic_time:'',
                selected_type: 'purchase',
                selected_cost_type: 'posting',
                temp_vehicle:[],
                type_number:null,
                item:null,
                quantity:0,
                differ_quantity:0,
                differ_amount:0,
                density:0,
                liter:0,
                inventories: [{item:null, itemExpenseCategory:{!! $category !!}, vehicle:null, temp_vehicle:[], selected_type:'', number:null, category:'total', quantity:0}],
                typeInfo: null,
                selected_expense_type: 'writeCheck',
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                option_currency: currency,
                option_selected_currency: {!!json_encode(getHomeCurrency()) !!},
                banks: banks,
                editKey: false,
                averageRate: false,
                differentRate: false,
                holding: false,
                vendor: [],
                selected_vendor: null,
                measureList: measureList,
                selected_measure: null,
                companyLicense: companyLicense,
                selected_companyLicense: null,
                selected_banks: null,
                number: {!! $number !!},
                old_number: {!! $number !!},
                selected_index: 0,
                rate: 1,
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],
                expenseCategory: expenseCategory,
                selected_category: null,
                disabled: false,
                showcModal: false,
                errorMessage: '',
                fieldErrors: [],
                className: null,
                description: null,
                vehicle:[],
                itemExpenseCategory:category,
                customsExpenseOption:customsExpenseOption,
                selectedOption:null,
            },
            computed: {
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    // if (this.selected_vendor == null) {
                    //     isError = true;
                    // }
                    return isError;


                },
                Total: function () {
                    var sum = 0;
                    var total_amount = this.CustomsAmount;
                    for (var i = 0; i < this.itemExpenseCategory.length; i++) {
                        var cat = this.itemExpenseCategory[i];
                        if (cat && total_amount) {
                            if (cat.amount && cat.amount_type == 'Amount') {
                                if (cat.amount && cat.calculate_type == 'PerPrice') {
                                    sum += Number.parseFloat(cat.amount * this.quantity);
                                } else {
                                    sum += Number.parseFloat(cat.amount);
                                }
                            } else if (cat.amount && cat.amount_type == 'Percentage') {
                                sum += Number.parseFloat((cat.amount * total_amount) / 100);
                            } else if (cat.amount && cat.amount_type == 'Liter') {
                                if (cat.amount && this.liter && cat.calculate_type == 'PerPrice') {
                                    sum += Number.parseFloat(cat.amount * this.liter);
                                } else {
                                    sum += Number.parseFloat(cat.amount);
                                }
                            } else {
                                sum += Number.parseFloat(cat.amount);
                            }
                        }
                    }

                    if (this.selectedOption && total_amount) {
                        sum += Number.parseFloat((total_amount * this.selectedOption.customs_percent) / 100);
                        sum += Number.parseFloat(((((total_amount * this.selectedOption.customs_percent) / 100) + total_amount) * this.selectedOption.tax_percent) / 100);
                        sum += Number.parseFloat(((((total_amount * this.selectedOption.customs_percent) / 100) + total_amount) * this.selectedOption.static_tax) / 100);
                        sum += Number.parseFloat((((total_amount * this.selectedOption.customs_percent) / 100) * this.selectedOption.helal_ahmar_percent) / 100);
                        sum += Number.parseFloat(((this.quantity * this.selectedOption.allocation_petroleum) / 100) * this.selectedOption.allocation_petroleum_price);
                    }

                    if (this.differ_quantity > 0) {
                        var fe_am = sum / this.quantity;
                        this.differ_amount = fe_am * this.differ_quantity;
                    }

                    return sum;
                },
                CustomsAmount: function () {
                    var sum = 0;
                    if (this.selectedOption && this.quantity && this.option_selected_currency) {
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        var op_rate = (this.option_selected_currency) ? this.option_selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        sum = ((this.selectedOption.customs_amount / this.option_selected_currency.static_rate  * op_rate) * this.selected_currency.static_rate / rate) * this.quantity;
                        @else 
                        sum = (this.selectedOption.customs_amount / op_rate) * this.quantity * rate;
                        @endif

                    }
                    return sum;
                },

                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },

                payeds: function () {
                    this.differentRate = false;
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                                if (this.selected_currency.code == this.payments[i]['item']['code'] && this.payments[i]['item']['amount']) {
                                    if (this.selected_currency.rate != this.payments[i]['item']['rate']) {
                                    this.differentRate = true;
                                    }
                                }
                            }
                        }
                    }
                    return sum;
                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    this.selected_banks=null;
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                        this.averageRate = false;
                        @if(getAverageRate() =="true")
                        if (tempBank[0].avg_rate && this.selected_expense_type =='writeCheck') {
                            this.set_avg_rate(tempBank[0].avg_rate);
                        }
                        @endif
                    }
                    return tempBank;
                },
                
            },
            mounted: function () {
                
                this.dynamicTime()
            },
            methods: {
                setCurrency(){
                    if (vm.selectedOption) {
                        vm.option_selected_currency = _.find(vm.option_currency,(o) => o.code == vm.selectedOption.currency);
                    }
                },

                CategoryAmount(cat, indexe) {
                    var total_amount = this.CustomsAmount;
                    var sum = 0;
                    if (cat && total_amount) {
                        // console.log(23, cat.amount_type);
                        if (cat.amount && cat.amount_type == 'Amount') {
                            if (cat.amount && cat.calculate_type == 'PerPrice') {
                                sum = cat.amount * this.quantity;
                            } else {
                                sum = cat.amount;
                            }
                        } else if (cat.amount && cat.amount_type == 'Percentage') {
                            sum = ((cat.amount * total_amount) / 100);
                        } else if (cat.amount && cat.amount_type == 'Liter') {
                            if (cat.amount && this.liter && cat.calculate_type == 'PerPrice') {
                                sum = cat.amount * this.liter;
                            } else {
                                sum = cat.amount;
                            }
                        } else {
                            sum = cat.amount;
                        }
                    }
                    return sum;
                },

                //BEGIN - Used for dynamic input time
                dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(vm.time_interval)
                        },
                        changeTime()
                        {
                            vm.dynamic_time = vm.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
                    //Function to add MemberCLass
                addExpenseCategory:function(){
                    axios.post("{{route('expenseCategory.store')}}",{
                        name:vm.className,
                        description:vm.description
                    })
                    .then(function(response){
                        
                        // location.reload();

                          var data = {id: response.data.id,name: response.data.name};
                        // vu.categories = response.data;
                        axios.get("{{route('expenseCategory.create')}}").then(function (response) {
                            
                            vm.className = null;
                             vm.description = null;
                            vm.expenseCategory     = response.data;
                        });


                    });
                    vm.showcModal = false;
                },

                set_avg_rate(avg_rate) {
                    setTimeout(() => {
                        this.averageRate = true;
                        this.selected_currency.rate = avg_rate;
                    }, 300);
                },

                set_avg_rate_by_bank(bank) {
                    this.averageRate = false;
                    @if(getAverageRate() =="true")
                    if (bank) {
                        if (bank.avg_rate && this.selected_expense_type =='writeCheck') {
                            this.set_avg_rate(bank.avg_rate);
                        }
                    }
                    @endif
                },

                numberChange() {
                    this.inventories = [];
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.vendor = [];
                            vm.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
				
				carChange(index) {
                        // if (vm.inventories[index].selected_type != null) {
						// 	var selected_type = vm.inventories[index].selected_type;
                                    
                        //     axios.get("{{route('callOilItemExpense.search')}}",{
                        //         params:{
                        //         method_name:'selectRefNumber',
                        //         type:selected_type,
                        //         }
                        //     })
                        //     .then(function (response)
                        //     {
                        //         vm.vehicleManagement=[];
                        //         if(response.data != null)
                        //         {
                        //             vm.inventories[index].number = response.data.number;
                        //         }
                        //     })
                        //     .catch(function (error)
                        //     {
                        //         console.log(error);
                        //     });
							
                        // }
                },
					
				searchVehicle() {

                    // selected_type: 'purchase',
                    // temp_vehicle:[],
                    // type_number:null,
                    // item:null,

                    if (vm.type_number != null && vm.selected_type != null) {
                        // console.log('rrrnn', vm.selected_type);
                        vm.temp_vehicle = [];
                        var selected_type = vm.selected_type;
                        var type_number = vm.type_number;
                        // console.log('rrrnn', type_number, selected_type);
                        
                        axios.get("{{route('callOilItemExpense.search')}}",{
                            params:{
                            method_name:'selectVehicle',
                            type:selected_type,
                            number:type_number,
                            status:'{{(getAddExpenseAfterSale() == "true" && systemConfig()[11] == 1)?"true":"false"}}',
                            }
                        })
                        .then(function (response)
                        {
                            // console.log('test 999', response);
                            if(response.data.vehicle.length > 0)
                            {
                                vm.temp_vehicle = response.data.vehicle;
                                // console.log('test 999',vm.temp_vehicle);
                            }
                        })
                        .catch(function (error)
                        {
                            console.log(error);
                        });
                        
                    }
                },

                onItemSearchVehicle: _.debounce((search, loading) => {
                    loading(true);
                    var index = vm.selected_index;
                    if (vm.type_number != null && vm.selected_type != null) {
                        var selected_type = vm.selected_type;
                        var number = vm.type_number;

                        axios.get("{{route('callOilItemExpense.search')}}",{
                            params:{
                            method_name:'selectVehicle',
                            type:selected_type,
                            number:number,
                            keyword: search
                            }
                        })
                        .then(function (response)
                        {
                            if(response.data.vehicle.length > 0)
                            {
                                vm.temp_vehicle = [];
                                vm.temp_vehicle = response.data.vehicle;
                            }
                            loading(false);
                        })
                        .catch(function (error)
                        {
                            loading(false);
                            console.log(error);
                        });
                        
                    } else {
                        loading(false);
                    }
                }, getDebounceTime()),

                setIndex(index) {
                    vm.selected_index = index;
                },

                setMeasure() {
                    if (vm.item) {
                        var measureLists = measureList.slice();
                        vm.measureList = measureLists.filter((measure) => {
                            return (new RegExp(vm.item.metric_id)).test(measure.metric_id)
                        });

                        vm.selected_measure = _.find(vm.measureList, (c) => c.measure_id == vm.item.measure_id);
                        vm.quantity = vm.item.qty
                    }
                    vm.setDifferQuantity();
                },

                setQuantity() {
                    if (vm.item && vm.selected_measure) {
                        if (vm.selected_measure && vm.item) {
                            vm.quantity = ((vm.item.qty * vm.item.measureUnit) / vm.selected_measure.measure_unit)
                        }
                    }
                    vm.setDifferQuantity();
                },
                setDifferQuantity() {
                    if (vm.item && vm.selected_measure) {
                        if (vm.selected_measure && vm.item) {
                            vm.differ_quantity = myRound(vm.quantity - ((vm.item.qty * vm.item.measureUnit) / vm.selected_measure.measure_unit));
                        }
                    }
                },
				
                getTotal(item = null) {
                    var total = 0;
                    if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += Number.parseFloat(item.itemExpenseCategory[i].amount);
							}
						}
					}
                        // var materialCost = Number(item.materialCost);
                        // var transportCost = Number(item.transportCost);
                        // var customeCost = Number(item.customeCost);
                        // var laborCost = Number(item.laborCost);
                        // var subContractorCost = Number(item.subContractorCost);
                        // var manufacturingCost = Number(item.manufacturingCost);
                        // var otherCost = Number(item.otherCost);
						
					if (item.item != null) {
						
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        var cost = item.item.cost * this.selected_currency.static_rate / rate;
                        @else 
                        var cost = item.item.cost * rate;
                        @endif
                        if (item.category == 'total') {
                            expenses = expenses / item.quantity;
                        }
                        else {

                        }
                        total = cost + expenses;
                    }
                    }
                    return total;
                },
				
			itemExpenseTotalItems(items=null,item=null,itemExpenseCategory=[])
            {
                let amount=0;
                if(item !=null && itemExpenseCategory.length>0)
                {
                    var category=items.category;  

                    for(var i=0;i<itemExpenseCategory.length;i++)
                    {
                        amount+=Number(itemExpenseCategory[i].amount);   
                    }
                    if(category=='total')
                    {
                        // amount=amount/item.qty;
                        amount=amount;
                    }
                    else
                    {
                        amount=amount*items.quantity;
                    }
                }
                return Number.parseFloat(amount).toFixed(precision());
            },			
            
            itemExpenseCogs(items=null,item=null,itemExpenseCategory=[])
            {
                let amount=0;
                if(item !=null && itemExpenseCategory.length>0)
                {
                    var category=items.category;  

                    for(var i=0;i<itemExpenseCategory.length;i++)
                    {
                        amount+=Number(itemExpenseCategory[i].amount);   
                    }
                    if(category=='total')
                    {
                        // amount=amount/item.qty;
                        amount=amount/items.quantity
                    }
                    else
                    {
                        amount=amount;
                    }
                }
                return Number.parseFloat(amount).toFixed(precision());
            },
                //getTotalExpense
                getTotalExpense(item = null) {
                    var total = 0;
					if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += item.itemExpenseCategory[i].amount;
							}
						}
					}
					if (item.item != null) {
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        var cost = item.item.cost * this.selected_currency.static_rate / rate;
                        @else 
                        var cost = item.item.cost * rate;
                        @endif
                        if (item.category == 'total') {
                            expenses = expenses;
                        }
                        else {

                        }
                        total = expenses;
                    }
                    }
                    return total;
                },

                // search stock based on type purchase/build/opening
                searchType() {
                    var id = document.getElementById('number').value;
                    this.inventories = [];
                    this.typeInfo = null;
                    if (id && this.selected_type) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemExpenseSearch',
                                type: this.selected_type,
                                number: id,
                            }
                        })
                            .then(function (response) {
                                // console.log('123', response.data);

                                if (response.data.length > 0) {

                                    if (response.data[0]) {
                                        vm.typeInfo = response.data[0].typeInfo;
                                        var myDataArray=response.data[0].myData;
                                        for(var i=0;i<myDataArray.length;i++)
                                        {
                                            vm.inventories.push({item:myDataArray[i].items, temp_vehicle:[], itemExpenseCategory:myDataArray[i].itemExpenseCategory, quantity:myDataArray[i].items.qty});
                                            vm.itemExpenseCategory=myDataArray[i].itemExpenseCategory;
                                        }
                                    }
                                }
                                else {
                                    var id = response.data.id;
                                    if (id) {
                                        var url = "{{url('itemExpense')}}/" + id + '/edit';

                                        window.location.href = url;
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }

                },
                // end search type


                // in here you can check and decide to allow duplicate bank for payment or not
                checkExistingPayment(index = null, name = '') {
                    var bank_temp = this.banks.slice();
                    var bank_temp1 = [];
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                            if (fined != -1) {
                                var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                            }
                        }
                    }
                    this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
                    //this.payments[index].items =bank_temp;


                },


                // generic function for adding item to list
                addNew(type = null, index) {
                    this.temp_items = [];
                    if (type != null) {
                        if (type == 'inventory') {
                            if (this.inventories[index + 1] == undefined) {
                                this.temp_items = [];
                                vm.vehicle = [];
                                this.inventories.push({item:null, itemExpenseCategory:{!! $category !!}, temp_vehicle:[], vehicle:null, selected_type:'', number:null, category:'total', quantity:0});
                            }
                        }
                        if (type == 'payment') {
                            if (this.payments[index + 1] == undefined) {
                                this.checkExistingPayment(index, '');
                                this.payments.push({
                                    items: this.banks,
                                    item: null,
                                });
                            }
                        }
                    }

                },

                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        console.log(type);
                        if (type == 'inventory') {
                            this.inventories.splice(index, 1);
                        }
                        if (type == 'payment') {
                            this.payments.splice(index, 1);
                        }
                    }

                },

                // submit the form
                submitForm() {
                    vm.disabled = true;
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("customsExpense-form").submit()
                        } else {
                            vm.disabled = false;
                        }
                    });
                },
				
		saveAndNew()
		  {
                vm.disabled = true;
                var url="{{route('customsExpense.store')}}";
                form_id='customsExpense-form';
                var data= $('#'+form_id).serialize();
                toggleBlock(true);
                axios.post(url,data)
                .then(function(response){
                         toggleBlock(0);
                         if(response.data.result==1)
                         {
                            $('#'+form_id).trigger('reset');
                            
                            
                            toastr.success('',response.data.message); 
                            vm.number=Number(vm.old_number)+1;
                            vm.old_number=Number(vm.old_number)+1;

                            for (var i = 0; i < vm.inventories.length; i++) {
								if (vm.inventories[i] && vm.inventories[i] != null) {
								if (vm.inventories[i].itemExpenseCategory != null) {
									for(var z=0;z<vm.inventories[i].itemExpenseCategory.length;z++)
									{
										vm.inventories[i].itemExpenseCategory[z].amount = 0;
									}
								}
								}
							}
                            vm.disabled = false;
                         }
                         else
                         {
                            vm.disabled = false;
                            var message="{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('',message);
                         }
                })
                .catch(function(error){
                    vm.disabled = false;
                    toggleBlock(0);
                    console.log(error);
                    var message="{{__('message.Warning')}}";
                    //$('#error-sound')[0].play();
                    toastr.warning('',message);
                });
               
		},



            }
        });

    </script>
@endpush
 