@extends('layouts.factor-master')

@section('content')
<?php
 $report = customeReportNew('customsExpense');
$_record  =  !in_array('record', $report);
$_number  =  !in_array('number', $report);
$_date  =  !in_array('date', $report);
$_member  =  !in_array('member', $report);
$_license_name  =  !in_array('license_name', $report);
$_description  =  !in_array('description', $report);
$_vehicle  =  !in_array('vehicle', $report);
$_type  =  !in_array('type', $report);
$_item  =  !in_array('item', $report);
$_quantity  =  !in_array('quantity', $report);
$_customsQuantity  =  !in_array('customsQuantity', $report);
$_measure  =  !in_array('measure', $report);
$_category  =  !in_array('category', $report);
$_currency  =  !in_array('currency', $report);
$_account  =  !in_array('account', $report);
$_rate  =  !in_array('rate', $report);
$_total  =  !in_array('total', $report);
$_user  =  !in_array('user', $report);
$_hour = !in_array('hour', $report);
$_reference_number = !in_array('reference_number', $report);
$_reference_name = !in_array('reference_name', $report);
 
$report_percent = customeReportNewPercent('customsExpense');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_license_name_percent= (array_key_exists('license_name___percent', $report_percent))?$report_percent['license_name___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_vehicle_percent= (array_key_exists('vehicle___percent', $report_percent))?$report_percent['vehicle___percent']:null;
    $_item_percent= (array_key_exists('item___percent', $report_percent))?$report_percent['item___percent']:null;
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_customsQuantity_percent= (array_key_exists('customsQuantity___percent', $report_percent))?$report_percent['customsQuantity___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_hour_percent= (array_key_exists('hour___percent', $report_percent))?$report_percent['hour___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_reference_name_percent= (array_key_exists('reference_name___percent', $report_percent))?$report_percent['reference_name___percent']:null;
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.CustomsExpenseReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true') {{convertDate($from_date, null, null,
        ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}} <span dir="rtl"> &nbsp;&nbsp;&nbsp;
          @lang('layout.MarchingAt') </span> @endif {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true') {{convertDate($to_date, null, null,
        ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}} <span dir="rtl"> &nbsp;&nbsp;&nbsp;
          @lang('layout.MarchingAt') </span> @endif {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
@endif

@if($expense_category_name || $currency)
<table class="main-table" style="margin: 6px 0px;">
  <tr>
    @if($currency)
    <td>
      <span>@lang('layout.Currency')</span>: {{$currency}}
    </td>
    @endif
    @if($expense_category_name)
    <td>
      <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
    </td>
    @endif

  </tr>
</table>
@endif

<table class="main-table">

  <thead>

    <tr class="bg">
      @if($_record)<td @if($_record_percent) width="{{$_record_percent}}%" @endif class="center">
        <div> @lang('layout.Record') </div>
      </td>@endif
      @if($_number)<td @if($_number_percent) width="{{$_number_percent}}%" @endif class="center">
        <div> @lang('layout.Number')</div>
      </td>@endif
      @if($_date)<td @if($_date_percent) width="{{$_date_percent}}%" @endif class="center">
        <div> @lang('layout.Date')</div>
      </td>@endif
      @if($_hour)<td class="center" @if($_hour_percent) width="{{$_hour_percent}}%" @endif>
        <div> @lang('layout.Hour')</div>
      </td>@endif
      @if($_description)<td @if($_description_percent) width="{{$_description_percent}}%" @endif class="center">
        <div> @lang('layout.Description')</div>
      </td>@endif
      @if($_vehicle)<td @if($_vehicle_percent) width="{{$_vehicle_percent}}%" @endif class="center">
        <div> @lang('layout.Vehicle')</div>
      </td>@endif
      @if($_item)<td @if($_item_percent) width="{{$_item_percent}}%" @endif class="center">
        <div> @lang('layout.Item')</div>
      </td>@endif
      @if($_quantity)<td @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif class="center">
        <div> @lang('layout.Quantity') (@lang('layout.SeamerTonnage'))</div>
      </td>@endif
      @if($_customsQuantity)<td @if($_customsQuantity_percent) width="{{$_customsQuantity_percent}}%" @endif
        class="center">
        <div> @lang('layout.CustomsQuantity') </div>
      </td>@endif
      @if($_measure)<td @if($_measure_percent) width="{{$_measure_percent}}%" @endif class="center">
        <div> @lang('layout.Measure') </div>
      </td>@endif
      @if(!$expense_category_name) @if($_category)<td @if($_category_percent) width="{{$_category_percent}}%" @endif
        class="center">
        <div> @lang('layout.Category')</div>
      </td>@endif @endif

 
      @if($_reference_number)<td @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif
      class="center">
      <div> @lang('layout.ReferenceNumber')</div>
      </td>@endif 
     
      @if($_reference_name)<td @if($_reference_name_percent) width="{{$_reference_name_percent}}%" @endif
      class="center">
      <div> @lang('layout.ReferenceName')</div>
      </td>@endif 


      @if($_type)<td @if($_type_percent) width="{{$_type_percent}}%" @endif class="center">
        <div> @lang('layout.Type')</div>
      </td>@endif
      @if($_license_name)<td @if($_license_name_percent) width="{{$_license_name_percent}}%" @endif class="center">
        <div> @lang('layout.CompanyLicense')</div>
      </td>@endif
      @if($_member)<td @if($_member_percent) width="{{$_member_percent}}%" @endif class="center">
        <div> @lang('layout.Vendor')</div>
      </td>@endif
      @if($_account)<td @if($_account_percent) width="{{$_account_percent}}%" @endif class="center">
        <div> @lang('layout.Account')</div>
      </td>@endif
      @if(!$currency) @if($_currency)<td @if($_currency_percent) width="{{$_currency_percent}}%" @endif class="center">
        <div> @lang('layout.Currency')</div>
      </td>@endif @endif
      @if($_rate)<td @if($_rate_percent) width="{{$_rate_percent}}%" @endif class="center">
        <div> @lang('layout.Rate')</div>
      </td>@endif
      @if($_total)<td @if($_total_percent) width="{{$_total_percent}}%" @endif class="center">
        <div> @lang('layout.Amount')</div>
      </td>@endif
      @if($_user)<td @if($_user_percent) width="{{$_user_percent}}%" @endif class="center">
        <div> @lang('layout.User')</div>
      </td>@endif
    </tr>
  </thead>
  <?php
$count = 0;
 $total_home_currency=0;
  $currencies=[];

?>
  @foreach($data AS $record)
  <?php

   $total_home_currency+=$record->amount/$record->rate;
   if(array_key_exists($record->currency, $currencies))
   {
    $currencies[$record->currency]=$currencies[$record->currency]+$record->amount;
  }
  else
  {
    $currencies[$record->currency]=$record->amount;
  }
  ?>
  <tr>

    @if($_record)<td class="center">{{++$count}}</td>@endif
    @if($_number)<td class="center">{{$record->number}}</td>@endif
    @if($_date)<td class="center"> {{convertDate($record->date)}}</td>@endif
    @if($_hour)
    <td class="center">
      @if(getHourType() == 24)
      {{ (($record->hour != null)?(date_format(date_create($record->hour), 'H:i')):'') }}
      @else
      {{ (($record->hour != null)?(date_format(date_create($record->hour), 'h:i:a')):'') }}
      @endif
    </td>
    @endif
    @if($_description)<td class="center" style="@if($_description_percent) text-align: justify @endif">
      {{$record->description}}</td>@endif
    @if($_vehicle)<td class="center">{{$record->vehicle_name}}</td>@endif
    @if($_item)<td class="center">{{$record->item}}</td>@endif
    @if($_quantity)<td class="center">{{$record->quantity}}</td>@endif
    @if($_customsQuantity)<td class="center">{{$record->customs_quantity}}</td>@endif
    @if($_measure)<td class="center">{{$record->measure}}</td>@endif
    @if(!$expense_category_name) @if($_category)<td class="center">{{$record->category}}</td>@endif @endif
    @if($_reference_number)<td class="center">{{$record->ref_number}}</td>@endif
    @if($_reference_name)<td class="center">{{$record->ref_name}}</td>@endif
    @if($_type)<td class="center">{{__('layout.'.ucfirst($record->expense_type))}}</td>@endif
    @if($_license_name)<td class="center">{{$record->license_name}}</td>@endif
    @if($_member)<td class="center">{{$record->member}}</td>@endif
    @if($_account)<td class="center">{{$record->account}}</td>@endif
    @if(!$currency) @if($_currency)<td class="center">{{$record->currency}}</td>@endif @endif
    @if($_rate)<td class="center">{{$record->rate}}</td>@endif
    @if($_total)<td class="center">{{myRound($record->amount)}}</td>@endif
    @if($_user)<td class="center">{{$record->user}}</td>@endif

  </tr>
  @endforeach
</table>
<table class="main-table">
  <tr class="bg">
    <td colspan="3">
      <div class="center">@lang('layout.PerCurrency')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
  </tr>
  <?php
$count=0;
foreach($currencies As $key=>$currency )
{
  ?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency)}}</div>
    </td>

  </tr>
  <?php
}
?>
  <tr>
    <td colspan="2">
      <div class="center">@lang('layout.HomeCurrencyTotal')</div>
    </td>
    <td>
      <div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>

  </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection