@extends('layouts.app')

@section('style')
    <style>
        .iconStyle{
            font-size: 20px;
        }

        .modal-container {
            max-height: 600px;
            width: 30% !important;
            max-width: 30% !important;
        }

    </style>
@endsection

@section('content')

<div id="print-modal" >

<report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
    v-if="is_show" 
    :value-type="'customs_details'"
    
    @closed="closeModal" >

    <div slot="body">
         <input type="hidden" name="id" value="{{$customs->id}}"/>
    </div>
</report-modal>
</div>


  





    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.CustomsShow')
            </div>
            <div class="tools">
            </div>
        </div>


    </div>

    <div class="row">
    <div class="col-md-12 col-sm-12">
        <div class="portlet green-meadow box">
            <div class="portlet-title">
                <div class="caption">
                </div>
                <div class="tools"></div>
                <div class="actions">
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                </div>
          
            </div>

            <div class="portlet-body">
                <div class="row static-info">
                    <div class="col-md-12 value">

                        <table class="table">
                            <thead>
                                <tr class="active">
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.AccdNumber')</th>
                                    <th>@lang('layout.Item')</th>
                                    <th>@lang('layout.Unit')</th>
                                    <th>@lang('layout.Quantity')</th>
                                    <th>@lang('layout.ItemValue')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Description')</th>


                                </tr>
                            </thead>
                            <tbody>
                                <tr class="active">
                                    <td>{{$customs->number}}</td>
                                    <td>{{convertDate($customs->date)}}</td>
                                    <td>{{$customs->accd_number}}</td>
                                    <td>{{$customs->item_name}}</td>
                                    <td>{{$customs->measure_name}}</td>
                                    <td>{{$customs->qty}}</td>
                                    <td>{{$customs->item_value}}</td>
                                    <td>{{$customs->currency}}</td>
                                    <td>{{$customs->description}}</td>
                                </tr>
                            </tbody>
                        </table>
                        <br>

                        <div >
                            <table class="table table-bordered" >
                                <tbody>
                                    <?php 
                                        $accd_total = 0;    
                                    ?>
                                    @foreach ($customs_field as $item)
                                    <?php 
                                    $accd_total+=$item->cust_qty;
                                    ?>
                                        <tr>
                                            
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->cust_qty}}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                                <h4 style="font-weight:bold;text-align:center;color:rgb(245, 123, 9)">@lang('layout.AccdTotal')</h4>
                                <h4 style="font-weight:bold;text-align:center;color:rgb(245, 123, 9)">{{myRound($accd_total)}} {{$customs->currency}}</h4>
                        </div>
                    
                         
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@push('scripts')

    <script>
 



    var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
            },

            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
            });

            new Vue({
            el:'#anchore-modal',
            methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
            }
            });
    </script>


@endpush
