@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('layout.CustomsReport')</h4>
  @if($from_date || $to_date)
  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
  <br>
  @endif
<table class="main-table">
    <thead>
    <tr>
      <th class="center">@lang('layout.Number')</th>
      <th class="center">@lang('layout.Date')</th>
      <th class="center">@lang('layout.AccdNumber')</th>
      <th class="center">@lang('layout.Item')</th>
      <th class="center">@lang('layout.Quantity')</th>
      <th class="center">@lang('layout.ItemValue')</th>
      <th class="center">@lang('menu.CustomsField')</th>
      <th class="center">@lang('layout.AccdTotal')</th>
    </tr>
    </thead>

    <?php
      $count = 0;

    ?>
    <tbody>
    @foreach($data AS $record)
    <?php
      $customs_field = $record['customs_field'];
    ?>
    <tr>
      <td class="center">{{$record['number']}}</td>
      <td class="center">{{convertDate($record['date'])}}</td>
      <td class="center">{{$record['accd_number']}}</td>
      <td class="center">{{$record['item_name']}}</td>
      <td class="center">{{myRound($record['qty'])}} {{$record['measure_name']}}</td>
      <td class="center">{{myRound($record['item_value'])}}</td>

      
	  <td>
      <table class="main-table" style="width:100%">
        <tr class="bg">
          @foreach($customs_field AS $row)
          <td  class="center">{{$row['name']}}</td>
          @endforeach
        </tr>
        <tr>
          @foreach($customs_field AS $row)
          <td class="center">{{myRound($row['cust_qty'])}}</td>

          @endforeach
        </tr>
	  </table>
	  </td>

    <td class="center">{{myRound($record['total_accd'])}}</td>

    </tr>


    @endforeach
  </tbody>
</table>

<br>

<table  class="main-table">
  <tr class="bg">
    <td colspan="2"><b>@lang('layout.Total')</b></td>
  </tr>
      @foreach($customs_totals AS $total)
      <tr>
        <td class="center">{{$total->name}}</td>
        <td class="center">{{myRound($total->qty)}}</td>
      </tr>    
      @endforeach
</table> 

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection