@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomsEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>

            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($customs, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['customs.update',$customs->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    {{Form::text('number',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.AccdNumber')</label>
                                    {{Form::text('accd_number',null,['class' => 'form-control'])}}
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date'])}}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.CarNumber')</label>
                                    {{Form::text('vehicle_number',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Quantity')</label>
                                    {{Form::number('qty',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.ItemValue')</label>
                                    {{Form::number('item_value',null,['class' => 'form-control'])}}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                    <v-select class="vue-select2" v-model="selected_item" label="name"  :options="customs_item" >
                                    </v-select>
                                    <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Unit') </label>
                                    <v-select class="vue-select2" v-model="selected_measure_customs" label="measure_name"  :options="customs_measure" >
                                    </v-select>
                                    <input type="hidden" name="um_id" :value="!selected_measure_customs?null:selected_measure_customs.measure_id" >
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Currency') </label>
                                    <v-select class="vue-select2" v-model="selected_currency" label="code"  :options="currency" >
                                    </v-select>
                                    <input type="hidden" name="currency" :value="!selected_currency?null:selected_currency.code" >

                                    
                                    
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control">{{$customs->description}}</textarea>
                            </div>
                        </div>
                    </div>
                    <br>
                    <table id="table_content" class="table table-bordered">
                        <thead style="background-color: #36c6d3; color:white"> 
                        <tr>
                            @foreach ($customsField as $key=>$value)
                            <th >{{$value['name']}}</th>
                            @endforeach
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            @foreach ($customsField as $key=>$value)
                            <td class="highlight">
                                <input type="text" name="customes_field[{{$value['id']}}]" class="form-control" autocomplete="off" value="{{$value['cust_qty']}}">
                            </td> 
                            @endforeach

                        </tr> 
                        </tbody>
                    </table>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{url()->previous()}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>

            <!-- END FORM-->
        </div>



    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        var customs_item = {!! $customs_item!!}
        var selected_item = {!! $selected_item!!}

        var measureUnitList  = {!! $measureUnitList!!}
        var selected_measure = {!! $selected_measure!!}



        var currency = {!! $currency!!}


        





     new Vue({
            el: '#app',
            data: {
                customs_item:customs_item,
                selected_item:selected_item,
                customs_measure:measureUnitList,
                selected_measure_customs:selected_measure,
                currency:currency,
                selected_currency:{!! $selected_currency!!}
            },
            mounted: function () {
             
            },
            methods: {
             
            }
        })
    </script>

@endpush
 