@extends('layouts.app')
@section('style')
    <!-- <link rel="stylesheet" type="text/css" href="{{URL::asset('profile/profile-2.min.css')}}"> -->
    <style type="text/css">
        .padding {
            padding: 0px;
        }
        .modal-container{
            width: 80% !important;
        }
        .v-select .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
    <style type="text/css">
    </style>
@stop
@section('content')
    <div id="print_modal_member_info">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show" 
            :value-type="'member_information_details'"
            
            @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="id" value="{{$customer->member_id}}"/>
            </div>
        </report-modal>
    </div> 
    <div id="print_modal_member_farmer_contract">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show" 
            :value-type="'member_farmer_contract'"
            @closed="closeModal">
            <div slot="body">
                    <input type="hidden" name="member_id" value="{{$customer->member_id}}"/>
                    <input class="form-control" type="hidden" name="customer_all" value="all" /> 
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.SelectType')</label>
                                    <select class="form-control" name="report_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="summary">@lang('layout.Summary')</option>
                                        <option value="details">@lang('layout.Details')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.FarmerContract')</label>
                                <v-select class="vue-select2" label="name"
                                        :options="farmer_contract_list" v-model="selectedFarmerContract">
                                </v-select>
                                <input type="hidden" name="contract_farmer_id"
                                        v-model.number="(!selectedFarmerContract)?null:selectedFarmerContract.id">
                            </div>
                        </div>
                    </div>                
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </report-modal>
    </div> 
    <div id="print_modal_inventory">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show"  :value-type="'member_item_stock'"
            @closed="closeModal">
            <div slot="body">
                    <input type="hidden" name="member_id" value="{{$customer->member_id}}"/>
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Site')</label>
                                <v-select class="vue-select2" label="name" :options="{{$inventorySite}}" v-model="selectedSite">
                                </v-select>
                                <input type="hidden" name="site_id" v-model.number="(!selectedSite)?null:selectedSite.id">
                            </div>
                        </div>
                    </div>                
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </report-modal>
    </div> 
    {{-- Start Transfer Inventory............................... --}}
    <div id="print_modal_inventory_transfer">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show"  :value-type="'inventory_transfer_detail'"
            @closed="closeModal">
            <div slot="body">
                    <input type="hidden" name="customer_id" value="{{$customer->id}}"/>                
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.SelectType')</label>
                                    
                                        <select name="report_type" class="form-control">
                                            <option value="general">@lang('layout.General')</option>
                                        </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </report-modal>
    </div> 
    {{-- End of transfer inventory..................................... --}}
    {{-- Start Transfer Rol Inventory............................... --}}
    <div id="print_modal_inventory_transfer_roll">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show"  :value-type="'inventory_transfer_detailRoll'"
            @closed="closeModal">
            <div slot="body">
                    <input type="hidden" name="customer_id" value="{{$customer->id}}"/>                
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.SelectType')</label>
                                    
                                        <select name="report_type" class="form-control">
                                            <option value="general">@lang('layout.General')</option>
                                        </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </report-modal>
    </div> 
    {{-- End of transfer Rol inventory..................................... --}}
    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="''"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="member_id" value="{{$customer->member_id}}"/>
                <input type="hidden" name="type" :value="type"/>
				<input class="form-control" type="hidden" name="customer_all" value="all" /> 
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <div id="print-modal_statement">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'vendorStatement'" 
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="type_name" value="Customer"/>
                <input type="hidden" name="member_id" value="{{$customer->member_id}}"/>

                    <!----------------------------------------------
                    ----Begin Report Body And Custome Report------- 
                    ----------------------------------------------->
                    <div class="row" v-cloak>
                             <div class="tabbable tabbable-tabdrop">

                                <ul class="nav nav-tabs">
                                    
                                    <li class="active">
                                        <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                    </li>
                                    @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                        <li class="">
                                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                        </li>
                                        @endpermission
                                        @endif
                                </ul>
                                <div class="tab-content">
                                     <div class="tab-pane active" id="tab1"> 
                                            <div class="portlet light bordered">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label>@lang('layout.HomeCurency')</label>
                                                                <input class="mt-checkbox" type="checkbox" name="home_currency" checked="">
                                                            </div>
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label>@lang('layout.SumPreviousBalance')</label>
                                                                <input class="mt-checkbox" type="checkbox" name="sum_previous_balance" >
                                                            </div>  
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label>@lang('layout.Driver')</label>
                                                                <input class="mt-checkbox" type="checkbox" name="driver" >
                                                            </div>  
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <label class="control-label ">@lang('layout.Currency') </label>
                                                                <select name="currency" class="form-control">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    @foreach(currencyList() AS $currency)
                                                                        <option value="{{$currency->code}}">{{$currency->code}}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <label class="control-label ">@lang('layout.SelectType') </label>
                                                                <select name="category" class="form-control">
                                                                    <option selected="selected" value="">@lang('layout.WithoutItem')</option>
                                                                    @if(systemConfig()[23] == 1)
                                                                    <option value="item">@lang('layout.WithItem')</option>
                                                                    <option value="afghan">@lang('layout.Satement1')</option>
                                                                    <option value="satement_item">@lang('layout.Satement2') @lang('layout.WithItem')</option>
                                                                    @endif
                                                                </select>
                                                            </div>    
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <label class="control-label ">@lang('layout.SatementStyle') </label>
                                                                <select name="style" class="form-control" v-model="statement_style">
                                                                    <option >@lang('layout.Select')</option>
                                                                    <option value="statement1">@lang('layout.Satement1')</option>
                                                                    <option value="multi_currency_statement">@lang('layout.MultiCurrencyStatement')</option>
                                                                    
                                                                </select>
                                                            </div>
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12" v-if="statement_style=='multi_currency_statement'">
                                                                <label class="control-label ">@lang('layout.Currency') </label>
                                                                <v-select class="vue-select2" v-model="selected_statement_currency" label="code" :options="statement_currency" :multiple="true"> </v-select>
                                                                <input type="hidden" name="statement_currency_id" :value="statement_currency_id.length > 0 ? statement_currency_id:null">
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <label class="control-label ">@lang('layout.ReportType') </label>
                                                                <select name="report_type" id="" class="form-control">
                                                                    <option value="">@lang('layout.SelectReportType')</option>
                                                                    <option value="Receivable">@lang('layout.Payable')</option>
                                                                    <option value="Payable">@lang('layout.Receivable')</option>
                                                                </select>
                                                            </div>    
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                                    <div class="input-group">
                                                                        <input class="form-control date" id="range-from-example" name="from_date"
                                                                               autocomplete="off">
    
                                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                                        <input class="form-control date" id="range-to-example" name="to_date"
                                                                               autocomplete="off">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                            </div>
                                    </div> 

                                    <div class="tab-pane" id="tab2"> 
                                       <div class="portlet light bordered">
                                            <div class="portlet-body">

                                                <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                    @csrf
                                                    <input type="hidden" name="part_name" value="statement">


                                                    <div class="col-md-12 col-sm-12 col-xs-12">

                                                        <div class="mt-checkbox-inline col-lg-2 col-md-2 col-sm-12 col-xs-12" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                            <div class="form-group">

                                                            <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>

                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>

                                                                        </td>
                                                                    </tr>
                                                                </table>

                                                                 <!-- <label> @{{ row.Name }}</label>

                                                                  <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                 <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                      <span class="slider round"></span>
                                                                </label> -->

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="margiv-top-10">
                                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                        <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                    </div>
                                            </form>
                                            </div>
                                    </div>
                            </div>
                            </div>
                        </div>
                    </div>
                    <!----------------------------------------------
                    ----Begin Report Body And Custome Report-------
                    ----------------------------------------------->

            </div>
        </report-modal>
    </div>
    <div class="portlet" >
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.CustomerInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="tabbable-line tabbable-full-width">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#tab_1_1" data-toggle="tab"> @lang('layout.Overview') </a>
                    </li>
                    <li>
                        <a href="#tab_1_3" data-toggle="tab"> @lang('layout.Info') </a>
                    </li>
                    @if(systemConfig()[16] != 0)
                    <li>
                        <a href="#tab_1_4" data-toggle="tab"> @lang('layout.Guarantor') </a>
                    </li>
                    @endif
                    <div class="btn-group pull-right">

                    <span id="anchore-modal-member_info">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                          @lang('layout.InformationReport')  <i class="fa fa-print"></i>
                        </a>
                    </span>

                    <span id="app" v-cloak>
                        <button v-if="!checkStatus" class="btn btn-success" onclick="location.href='{{route('memberOpeningBalance.create',$customer->id)}}'">@lang('layout.OpeningBalance')</button>
                        @if(systemConfig()[23] == 1)
                        <button v-if="!checkStatus" class="btn btn-success" onclick="location.href='{{route('customerOpeningStock.edit',$customer->id)}}'">@lang('layout.OnHandItems')</button>
                        @endif
                        <button v-if="!checkStatus" type=button id="show-modal" class="btn btn-success" v-on:click="prepaidModal = true">@lang('layout.Prepaid')</button>
                        <button v-if="!checkStatus" type=button  class="btn btn-success" v-on:click="checkoutModal = true">@lang('layout.Checkout')</button>

                    <!-- use the modal component, pass in the prop -->
                    <modal v-if="prepaidModal" @close="prepaidModal = false">

                        <div slot="body">
                        <div class="row">
                            <div class="form-group">
                            {{Form::open(['route'=>['customer.prepaid',$customer->id],'method'=>'post','class'=> 'form-horizontal','id'=>'customer-prepaid-balance'])}}

                                <div class="col-md-12"> 
                                <div class="form-group">


                                {{--<div class="input-group ">--}}
                                    {{--<label class="control-label ">@lang('layout.SelectAccountReceivable')</label>--}}

                                    {{--{{Form::select('account',$accountReceivable,null,['class'=>'form-control '])}}--}}

                                    {{--</div>--}}


                                    <label class="control-label ">@lang('layout.SelectCurrency')</label>

                                <select class="form-control" v-model="selectedCurrency">

                                    <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>

                                </select>

                                <input type="hidden" name="currency" :value="selectedCurrency.code">

                                <div v-show="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'" class="input-group ">
                                    <span class="input-group-addon">@lang('layout.Rate')</span>
                                    <input name="rate" type="number" v-model="selectedCurrency.exchange_rate" min="0" step="0.01"
                                        data-number-stepfactor="100" class="form-control currency" id="c2"/>

                                </div>

                                <label class="control-label ">@lang('layout.Account') </label>


                                <select class="form-control" name="bank_account">
                                    <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}</option>
                                </select>

                                <label class="control-label ">@lang('layout.Balance')</label>
                                <div class="input-group ">
                                    <span class="input-group-addon">@{{  selectedCurrency.code }}</span>

                                    <input name="balance" type="number" v-model="amount" min="0" step="0.01"
                                        data-number-stepfactor="100" class="form-control currency" id="c2"/>
                                    <span class="input-group-addon">@{{ selectedCurrency.symbol}}</span>
                                </div>

                                </div>
                            </div>

                                {{Form::close()}}
                            </div>

                        </div>
                        </div>
                        <h3 slot="header">@lang('layout.Prepaid')</h3>

                        <div slot="footer">
                        <button type=button class="btn btn-success" v-on:click="prepaidSubmit">
                            @lang('layout.OK')
                        </button>
                        <button type=button class="btn btn-danger"
                                v-on:click="prepaidModal = false">
                        @lang('layout.Cancel')
                        </button>
                        </div>
                    </modal>

                    <!-- use the modal component, pass in the prop -->
                    <modal v-if="checkoutModal" @close="checkoutModal = false">
                        <h3 slot="header">@lang('layout.Checkout')</h3>
                        <div slot="body">
                        <div class="row">
                            <div class="form-group">
                            {{Form::open(['route'=>['customer.checkout',$customer->id],'method'=>'post','class'=> 'form-horizontal','id'=>'customer-checkout'])}}
                                <div class="col-md-12"> 
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.TransactionID')</label>
                                        <input type="number" name="transaction_id" class="form-control" >
                                        <input type="hidden" name="form_type" v-model="form_type" >
                                    </div>
                                </div>
                                {{Form::close()}}
                            </div>
                        </div>
                        </div>
                        <div slot="footer">
                        <button type=button class="btn btn-success" v-on:click="checkoutSubmit('add')">
                            @lang('layout.OK')
                        </button>
                        <button type=button class="btn btn-danger" v-on:click="checkoutSubmit('delete')">
                            @lang('layout.Delete')
                        </button>
                        <button type=button class="btn btn-danger" v-on:click="checkoutModal = false">
                        @lang('layout.Cancel')
                        </button>
                    </div>
                    </modal>
                    </span>


                    </div>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1_1">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; padding: 0px 0px 0px 0px;">
                                <div style="display: flex;justify-content: space-around;flex-wrap: wrap;">
                                    <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-left: 10px !important; padding: 10px;margin-bottom: 10px;">
                                        <div style="display: flex;align-items: center;">
                                            <div title="{{$customer->name}}" class="twPc-avatarLink" style="margin-left: 10px;">
                                                @if($customer->photo ==Null)
                                                <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}" style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @else
                                                <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$customer->photo)!!}" style="width:150px; height:150px;border-radius: 50%; border: 5px solid rgb(80, 129, 141);">
                                                @endif
                                            </div>
                                            {{-- <h2 class="font-black text-center" style="width: 100%;">{{$customer->name}}</h2> --}}
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th colspan="2" class="text-center" style="font-size: 20px;font-weight: bold;">{{$customer->name}}</th>
                                                </tr>
                                                <tr>
                                                    @if($customer->phone)
                                                    <th class="text-center"><i class="fa fa-mobile"></i></th>
                                                    <td>{{$customer->phone}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($customer->email)
                                                    <th class="text-center"><i class="fa fa fa-envelope"></i></th>
                                                    <td>{{$customer->email}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($customer->ref_no)
                                                    <th class="text-center"><i class="fa fa-reply-all"></i></th>
                                                    <td>{{$customer->ref_no}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($customer->city)
                                                    <th class="text-center"><i class="fa fa-home"></i></th>
                                                    <td>{{$customer->city}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($customer->reg_date)
                                                    <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                                                    <td>{{convertDate($customer->reg_date)}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($customer->price_level_name)
                                                    <th class="text-center"><i class="fa fa-dollar"></i></th>
                                                    <td>{{($customer->price_level_name)}}</td>
                                                    @endif
                                                </tr>
                                            </table>
                                            {{-- <ul style="width: 100%;display: align-items: center;flex-wrap: wrap; list-style-type: none;"> --}}
                                                {{-- <li>
                                                    <p style="font-size: 1.2em;"><i class="fa fa-user"></i> {{$customer->name}}</p>
                                                </li> --}}
                                                {{-- @if($customer->phone)
                                                <li style="padding: 0px !important;margin-bottom: -10px;">
                                                    <p style="font-size: 1rem;"><i class="fa fa-mobile"></i> {{$customer->phone}}</p>
                                                </li>
                                                @endif --}}
                                                {{-- @if($customer->email)
                                                <li style="padding: 0px !important;margin-bottom: -10px;">
                                                    <p style="font-size: 1em;"><i class="fa fa fa-envelope"></i> {{$customer->email}}</p>
                                                </li>
                                                @endif --}}
                                                {{-- @if($customer->ref_no)
                                                <li style="padding: 0px !important;margin-bottom: -10px;">
                                                    <p style="font-size: 1.2em;"><i class="fa fa-reply-all"></i>{{$customer->ref_no}}</p>
                                                </li>
                                                @endif --}}
                                                {{-- @if($customer->city) 
                                                <li style="padding: 0px !important;margin-bottom: -10px;">
                                                    <p style="font-size: 1.2em;"><i class="fa fa-home"></i> {{$customer->city}}
                                                    </p>   
                                                </li>
                                                @endif --}}
                                                {{-- @if($customer->reg_date)
                                                <li style="padding: 0px !important;margin-bottom: -10px;">
                                                    <p style="font-size: 1.2em;"><i class="fa fa-calendar-plus-o"></i>{{convertDate($customer->reg_date)}}</p>
                                                </li>
                                                @endif --}}
                                                @if($customer->price_level_name)
                                                <li style="padding: 0px !important;">
                                                    <p style="font-size: 1.2em;"><i class="fa fa-dollar"></i>{{($customer->price_level_name)}}</p>
                                                </li>
                                                @endif
                                            {{-- </ul> --}}
                                        </div>
                                    </div>
                                    {{-- <div class="col-lg-1 col-md-12 col-sm-12 col-xs-12"></div> --}}
                                    <div class="col-lg-5 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                        <div class="portlet sale-summary">
                                            <div class="portlet-title" >
                                                <div class=" font-black sbold text-center" style="font-size: 20px;margin-top: 5px;color: black !important;"> @lang('layout.CustomerSummary') </div>
                                                {{-- <div class="tools">
                                                    <a class="reload" href="javascript:;"> </a>
                                                </div> --}}
                                            </div>
                                            <div class="portlet-body" id="member_statement" v-cloak>
                                                <div v-if="isLoading">
                                                    <div class="table-scrollable">
                                                        <table class="table">
                                                            <tr>
                                                                <td colspan="3" style="text-align: center">
                                                                    <img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div v-else>
                                                    <div class="table-scrollable">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <thead>
                                                            <tr>
                                                                <th class="text-center">
                                                                    <i class="fa fa-money"></i> @lang('layout.Currency')
                                                                </th>
                                                                <th class="text-center">
                                                                    <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                                </th>
                                                                <th class="text-center">
                                                                    <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                                </th>
                                                            </tr>
                                                            </thead>
                                                                <tbody v-if="summary">
                                                                    <tr v-for="summ in summary">
                                                                        <td> @{{ summ.currency }} </td>
                                                                        <td> @{{format_number(Number(summ.invoice)) }} </td>
                                                                        <td> @{{ format_number(Number(summ.payment)) }}</td>
                                                                    </tr>
                                                                </tbody>
                                                        </table>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="">
                            <div class="col-md-2">
                                <ul class="list-unstyled profile-nav">
                                    <li>
                                        
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-10" >
                                <div class="row">
                                    <div class="col-md-6 profile-info">
                                        
                                        <div>
                                            
                                        </div> 
                                    </div>
                                    <div class="col-md-6">
                                        
                                    </div>
                                </div> 
                            </div>
                        </div> --}}
                        <div class="">
                            <div class="tabbable-line tabbable-custom-profile">
                                <ul class="nav nav-tabs">
                                    @if(systemConfig()[23] == 1)
                                    <li class="">
                                        <a href="#Purchases" data-toggle="tab" id="Purch-table">
                                            <i class=" icon-basket-loaded"></i><b> @lang('layout.Sales') </b></a>
                                    </li>
                                   
                                    <li class="">
                                        <a href="#Invoices" data-toggle="tab" id="cus-invoices">
                                            <i class="icon-note"></i><b>@lang('layout.Invoices')</b> </a>
                                    </li>
                                    @endif
                                    <li class="">
                                        <a href="#cus_prepaid" data-toggle="tab" id="cus_prepaids">
                                            <i class="fa  "></i><b> @lang('layout.Prepaid') </b></a>
                                    </li>
                                    <li class="">
                                        <a href="#payments" data-toggle="tab" id="cus-payments">
                                            <i class="fa  "></i><b> @lang('layout.Receive') </b></a>
                                    </li>
                                    <li class="active">
                                        <a href="#statement" data-toggle="tab" id=cus-statement>
                                            <i class="icon-credit-card"></i><b> @lang('layout.Statements') </b></a>
                                    </li>
                                    @if(systemConfig()[13] != 0 )
                                    <li class="">
                                        <a href="#memberCloth" data-toggle="tab" id="memberCloth-table">
                                            <i class="fa fa-tasks"></i><b> @lang('menu.Membercloth') </b></a>
                                    </li>
                                    @endif
                                    @if(systemConfig()[16] != 0)
                                    <li class="">
                                        <a href="#FarmerContract" data-toggle="tab" id="FarmerContract-table">
                                            <i class="fa fa"></i><b> @lang('layout.FarmerContract') </b></a>
                                    </li>
                                    @endif
                                    @if(systemConfig()[23] == 1)
                                    @if(ShowSaveTempItemToCustomer() == "true")
                                    <li class="">
                                        <a href="#inventory" data-toggle="tab" id="inventory-table">
                                            <i class="fa fa"></i><b> @lang('layout.Inventory') </b></a>
                                    </li>
                                    @endif
                                    @endif
                                    
                                    @permission('inventoryTransfer-list')   
                                    <li class="">
                                    <a href="#InventoryTransferslist" data-toggle="tab" id="inventoryTransfer-table">
                                        <i class="fa fa"></i><b> @lang('layout.InventoryTransferslist') </b></a>
                                    </li>
                                    <li class="">
                                    <a href="#InventoryTransferRollList" data-toggle="tab" id="inventoryTransferRoll-table">
                                        <i class="fa fa"></i><b> @lang('layout.InventoryTransferRollList') </b></a>
                                    </li>
                                    @endpermission   
                                </ul>
                                <div class="tab-content padding" style="padding: 0px;" cellspacing="0">
                                    <div class="tab-pane " id="Purchases">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.SaleDetails')</span>
                                                    </div>
                                                    <div class="actions">
                                      
                                                        <span id="anchore-modal">
                                                            <a href="#" @click.prevent="showModal('SaleList')" id="" class="btn  btn-success">
                                                                <i class="fa fa-print"></i>
                                                            </a>
                                                        </span>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="pur">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.SalesNumber')</th>
                                                            <th>@lang('layout.ReferenceNumber')</th>
                                                            <th>@lang('layout.SalesType')</th>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Discount')</th>
                                                            <th>@lang('layout.Description')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--tab-pane-->
                                    <div class="tab-pane" id="Invoices">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.InvoiceDetails')</span>
                                                    </div>
                                                    <div class="actions">
                                                        <button onclick="openModal('invoicelist')" id="" class="btn  btn-success">
                                                                <i class="fa fa-print"></i>
                                                        </button>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="Invoice" cellspacing="0">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.InvoiceNumber')</th>
                                                            <th>@lang('layout.ReferenceNumber')</th>
                                                            <th>@lang('layout.SalesType')</th>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Discount')</th>
                                                            <th>@lang('layout.Description')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--tab-pane-->
                                    <!--  -->
                                    <div class="tab-pane" id="payments">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.RecieveDetials')</span>
                                                    </div>
                                                    <div class="actions">


                                                        <button onclick="openModal('receive')" id=""
                                                                class="btn  btn-success"><i class="fa fa-print"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="payment-table" cellspacing="0">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.Number')</th>
                                                            <th>@lang('layout.ReferenceNumber')</th>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Rate')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--  -->
                                    <!--  -->

                                    <!--  -->
                                    <div class="tab-pane" id="cus_prepaid">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.RecieveDetials')</span>
                                                    </div>
                                                    <div class="actions">
                                                        <button onclick="openModal('receive')" id="" class="btn  btn-success">
                                                            <i class="fa fa-print"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover" id="prepaid_table">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Rate')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--  -->
                                    
                                    <!--  -->
                                    <div class="tab-pane active" id="statement">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.StatementDetails')</span>
                                                        </div>
                                                        <div class="actions"> 
                                                            <button onclick="openModal('statment',true)" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="statement-table">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.TransactionID')</th>
                                                                <th>@lang('layout.Description')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Rate')</th>
                                                                <th>@lang('layout.Type')</th>
                                                                <th>@lang('layout.Receivable')</th>
                                                                <th>@lang('layout.Payable')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                @if(getItemWithStatment() == 'true')
                                                                <th>@lang('layout.Item')</th>
                                                                <th>@lang('layout.Qty')</th>
                                                                <th>@lang('layout.Measure')</th>
                                                                <th>@lang('layout.Cost')</th>
                                                                @endif
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <!--  -->

                                    <div class="tab-pane" id="memberCloth">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('menu.Membercloth')</span>
                                                    </div>
                                                    <div class="actions">
                                      

                                                        <button onclick="openModal('MemberCloth')" id=""
                                                                class="btn  btn-success"><i class="fa fa-print"></i>
                                                        </button>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="memberCloth_table">
                                                        <thead>
                                                        <tr>
                                                        <th>@lang('layout.Number')</th>
                                                        <th>@lang('menu.ClothCategory')</th>
                                                        <th>@lang('layout.Date')</th> 
                                                        <th>@lang('layout.Description')</th>
                                                        <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--  -->

                                    <div class="tab-pane" id="FarmerContract">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.FarmerContract')</span>
                                                    </div>
                                                    <div class="actions">
                                                        <span id="anchore-modal-member_farmer_contract">
                                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success"> 
                                                            <i class="fa fa-print"></i>
                                                            </a>
                                                        </span>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="FarmerContract_table">
                                                        <thead>
                                                        <tr>
                                                        <td><div class="center" style="color: white;"> @lang('layout.Number') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.ReferenceNumber') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.Date') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.LandSize') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.DrawingAmount') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.Measure') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.SeedAmount') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.Measure') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.OverdueDate') </div></td>
                                                        <td><div class="center" style="color: white;"> @lang('layout.Description') </div></td>
                                                        <th class="text-center" style="color: white;">@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="inventory">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.Inventory')</span>
                                                    </div>
                                                    <div class="actions">
                                                        <span id="modal-inventory">
                                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success"> 
                                                            <i class="fa fa-print"></i>
                                                            </a>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover" id="inventory_table">
                                                        <thead>
                                                        <tr>
                                                        <th>@lang('layout.Type')</th>
                                                        <th>@lang('layout.Number')</th>
                                                        <th>@lang('layout.Member')</th>
                                                        <th>@lang('layout.ReferenceNumber')</th>
                                                        <th>@lang('layout.Date')</th>
                                                        <th>@lang('layout.Item')</th>
                                                        <th>@lang('layout.SiteName')</th>
                                                        <th>@lang('layout.Category')</th>
                                                        <th>@lang('layout.Quantity')</th>
                                                        <th>@lang('layout.Measure')</th>
                                                        <th>@lang('layout.Price')</th>
                                                        <th>@lang('layout.Total')</th>
                                                        <th>@lang('layout.User')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="InventoryTransferslist">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.InventoryTransferslist')</span>
                                                    </div>  
                                                    <div class="actions">
                                                        <span id="modal-inventoryTransfer">
                                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success"> 
                                                            <i class="fa fa-print"></i>
                                                            </a>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover" id="inventory_transfer_table">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.ID')</th>
                                                            <th>@lang('layout.Number')</th>
                                                            <th>@lang('layout.WayBillNumber')</th>
                                                            <th>@lang('layout.PlateNumber')</th>
                                                            <th>@lang('layout.TotalQty')</th>
                                                            <th>@lang('layout.Driver')</th>
                                                            <th>@lang('layout.Responsible')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            @if(systemConfig()[20] == 1)
                                                            <th>@lang('layout.Transfer') @lang('layout.Contract')</th>
                                                            @endif
                                                            <th>@lang('layout.User')</th>
                                                            <th>@lang('layout.Description')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- start Inventory Transfer List Roll............................................ --}}
                                    <div class="tab-pane" id="InventoryTransferRollList">
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-title"> 
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.InventoryTransferRollList')</span>
                                                    </div>
                                                    <div class="actions">
                                                        <span id="modal-inventoryTransferRoll">
                                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success"> 
                                                            <i class="fa fa-print"></i>
                                                            </a>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover" id="inventory_transfer_table_roll">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.ID')</th>
                                                            <th>@lang('layout.Number')</th>
                                                            <th>@lang('layout.WayBillNumber')</th>
                                                            <th>@lang('layout.PlateNumber')</th>
                                                            <th>@lang('layout.TotalQty')</th>
                                                            <th>@lang('layout.Driver')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Description')</th>
                                                            <th>@lang('layout.User')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                   {{-- End Inventory Transfer List Roll............................................ --}}


                                    <!--  -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--tab_1_2-->
                    <div class="tab-pane" id="tab_1_3">
                        <div class=" profile-account">
                            <div class="col-md-3">
                                <ul class="ver-inline-menu tabbable margin-bottom-10">
                                    <li class="active">
                                        <a data-toggle="tab" href="#tab_1-1">
                                            <i class="icon-user"></i> @lang('layout.PersonalInfo') </a>
                                        <span class="after"> </span>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_2-2">
                                            <i class="icon-home"></i> @lang('layout.AddressInfo') 
                                        </a>
                                    </li> 
                                    <li>
                                        <a data-toggle="tab" href="#tab_3-3">
                                            <i class="fa fa-bars"></i> @lang('layout.OtherInformations') 
                                        </a>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_4-4">
                                            <i class="fa fa-bars"></i> @lang('layout.Attachments') 
                                        </a>
                                    </li>
                                    @if(systemConfig()[29] == 1)
                                    <li>
                                        <a data-toggle="tab" href="#tab_5-5">
                                            <i class="fa fa-bars"></i> @lang('layout.Shareholder') 
                                        </a>
                                    </li>
                                    @endif
                                    @if(systemConfig()[29] == 1)
                                    <li>
                                        <a href="#tab_6-6" data-toggle="tab">
                                            <i class="fa fa-bars"></i> @lang('layout.Transaction')
                                        </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                            <div class="col-md-9">
                                <div class="tab-content">
                                    <div id="tab_1-1" class="tab-pane active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table" id="ppp">
                                                    <tr style="background-color: rgb(80, 129, 141) !important;color: white !important;">
                                                        <th>@lang('layout.Name')</th>
                                                        <th>@lang('layout.Email')</th>
                                                        <th>@lang('layout.Password')</th>
                                                        <th>@lang('layout.Phone')</th>
                                                        <th>@lang('layout.Phone2')</th>
                                                        <th>@lang('layout.Code')</th>
                                                        <th>@lang('layout.Gender')</th>
                                                        <th>@lang('layout.DateOfBirth')</th>
                                                        <th>@lang('layout.Membership')</th>
                                                        <th>@lang('layout.Date')</th>
                                                    </tr>
                                                    <tr class="active">
                                                        <td class=""> {{ $customer->name }}  </td>
                                                        <td class=""> {{ $customer->email }}  </td>
                                                        <td class=""> {{ $customer->password }} <a type="button" class="btn green hidden-print" name="btnprint" onclick="printPass()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>  </td>
                                                        <td class=""> {{ $customer->phone }}  </td>
                                                        <td class=""> {{ $customer->phone2 }}  </td>
                                                        <td class=""> {{ $customer->code }}  </td>
                                                        <td class="">  {{__("type.".$customer->gender)}}  </td>
                                                        <td class=""> {{ convertDate($customer->date_of_birth)}}  </td>
                                                        <td class="">  {{__("type.".$customer->membership)}}  </td>
                                                        <td class=""> {{ convertDate($customer->reg_date) }}  </td>
                                                    </tr> 
                                                    
                                                    <tr>
                                                        @if(systemConfig()[22] == 1) 
                                                        <th>@lang('layout.RiskStep')</th>
                                                        @endif
                                                        <th>@lang('layout.FatherName')</th>
                                                        <th>@lang('layout.GFname')</th>
                                                        <th>@lang('layout.ReferenceNumber')</th>
                                                        @if(getActiveSale() == "true")
                                                        <th>@lang('layout.FreeCardTimes')</th>
                                                        @endif
                                                        <th>@lang('layout.Description')</th>
                                                    </tr>
                                                    <tr class="active">
                                                        @if(systemConfig()[22] == 1) 
                                                        <td class=""> @if($customer->risk_step) {{__("type.".$customer->risk_step)}} @endif </td>
                                                        @endif
                                                        <td class=""> {{ $customer->father_name }}  </td>
                                                        <td class=""> {{ $customer->grand_father_name }}  </td>
                                                        <td class=""> {{ $customer->ref_no }}  </td>
                                                        @if(getActiveSale() == "true")
                                                        <td class=""> {{ $customer->free_card_times }}  </td>
                                                        @endif
                                                        <td class=""> {{ $customer->description }}  </td>
                                                    </tr>
                                                </table>
                                            </div>

                                            @if($customer->fingerprint != Null && $customer->fingerprint != '')
                                            <div class="col-xs-6 col-sm-3 col-md-2 col-lg-2" style="padding: 2px !important;">
                                                <p>@lang('layout.Fingerprint')</p>
                                                <ul class="list-unstyled profile-nav" style="margin: 0px !important;">
                                                    <li>
                                                        <div class="twPc-avatarLink">
                                                        <a href="{!! asset('uploads/fingerprint/' . $customer->fingerprint) !!}" target='_blank'>
                                                            <img class=" twPc-avatarImg" src="{!!url('/uploads/fingerprint/'.$customer->fingerprint)!!}" style="width: 100%;">
                                                        </a>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                            @endif
                                            
                                        </div>
                                    </div>
                                    <div id="tab_2-2" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        
                                                        
                                                        <th>@lang('layout.Country')</th>
                                                        <th>@lang('layout.City')</th>
                                                        <th>@lang('layout.District')</th>
                                                        <th>@lang('layout.Village')</th>
                                                        <th>@lang('layout.Address1')</th>
                                                        <th>@lang('layout.Address2')</th>
                                                        <th>@lang('layout.PostCode')</th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                       
                                                        <td class=""> {{ $customer->country }}  </td>
                                                        <td class=""> {{ $customer->city }}  </td>
                                                        <td class=""> {{ $customer->district }}  </td>
                                                        <td class=""> {{ $customer->village }}  </td>
                                                        <td class=""> {{ $customer->address1 }}  </td>
                                                        <td class=""> {{ $customer->address2 }}  </td>
                                                        <td class=""> {{ $customer->post_code }}  </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="tab_3-3" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.LicenseNumber')</th>
                                                        <th>@lang('layout.IdentifyType')</th>
                                                        <th>@lang('layout.LicenseIssueDate')</th>
                                                        <th>@lang('layout.LicenseExpireDate')</th>
                                                        <th>@lang('layout.PassportNumber')</th>
                                                        <th>@lang('layout.SSID')</th>
                                                        <th>@lang('layout.BossName')</th>
                                                        <th>@lang('layout.BossSSN')</th>
                                                        <th>@lang('layout.BossPassport')</th>
                                                        <th>@lang('layout.AssistantName')</th>
                                                        <th>@lang('layout.AssistantSSN')</th>
                                                        <th>@lang('layout.AssistantPassport')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class=""> {{ $customer->company_license_number }}  </td> 
                                                        @if($customer->identify_type != '')
                                                        <td class=""> {{__("layout.".$customer->identify_type)}}  </td>
                                                        @else
                                                        <td class=""> </td>
                                                        @endif
                                                        <td class=""> {{ convertDate($customer->license_issue_date) }}  </td>
                                                        <td class=""> {{ convertDate($customer->license_expire_date) }}  </td>
                                                        <td class=""> {{ $customer->passport }}  </td>
                                                        <td class=""> {{ $customer->ss_id }}  </td>
                                                        <td class=""> {{ $customer->boss_name }}  </td>
                                                        <td class=""> {{ $customer->boss_ssn }}  </td>
                                                        <td class=""> {{ $customer->boss_passport }}  </td>
                                                        <td class=""> {{ $customer->assistant_name }}  </td>
                                                        <td class=""> {{ $customer->assistant_ssn }}  </td>
                                                        <td class=""> {{ $customer->assistant_passport }}  </td>
                                                    </tr>


                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th>@lang('layout.CardOwner')</th>
                                                        <th>@lang('layout.CardNumber')</th>
                                                        <th>@lang('layout.ShabaNumber')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class=""> {{ $customer->card_owner }}  </td>
                                                        <td class=""> {{ $customer->card_number }}  </td>
                                                        <td class=""> {{ $customer->shaba_number }}  </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="tab_4-4" class="tab-pane">
                                        <div class="portlet light bordered">
                                            <div class="portlet-body">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                                                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data" style="padding: 0.5% 1%;">
                                                                @csrf
                                                                <input type="hidden" name="redirect_route" value="customer.show">
                                                                <input type="hidden" name="foreign_data_id" value="{{$customer->member_id}}">
                                                                <input type="hidden" name="path" value="uploads/customer">
                                                                <input type="hidden" name="table_name" value="members">
                                                                <div class="row">
                                                                    <div class="col-lg-12">
                                                                        <div class="form-group">
                                                                            <label class="control-label"><i class="icon-settings font-dark"></i> @lang('layout.AttachmentTitle')</label>
                                                                            <input type="text" name="title" class="form-control">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <label class="control-label">@lang('layout.Description')</label>
                                                                            <textarea name="description" class="form-control" rows="8" style="resize: none;"></textarea>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                                                <div>
                                                                                    <span class="btn default btn-file">
                                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                                                    </span>
                                                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                                </div>
                                                                                <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                                                    <img src="" alt=""> 
                                                                                </div>
                                                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 165px; line-height: 10px;"> 
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="margin-top-0 text-center">
                                                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                                    <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <table class="table table-striped table-bordered table-hover" id="attachment">
                                            <thead>
                                                <tr>  
                                                    <th>@lang('layout.AttachmentTitle')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    @if(systemConfig()[29] == 1)
                                    <div id="tab_5-5" class="tab-pane">
                                        <table class="table table-striped table-bordered table-hover" id="shareholder">
                                            <thead>
                                                <tr>  
                                                    <th>@lang('layout.Name')</th>
                                                    <th>@lang('layout.FatherName')</th>
                                                    <th>@lang('layout.Type')</th>
                                                    <th>@lang('layout.Address')</th>
                                                    <th>@lang('layout.Phone')</th>
                                                    <th>@lang('layout.Email')</th>
                                                    <th>@lang('layout.PassportNumber')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    @endif
                                    @if(systemConfig()[29] == 1)
                                    <div id="tab_6-6" class="tab-pane">
                                        <table class="table table-striped table-bordered table-hover" id="transaction">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.TransactionType')</th>
                                                    <th>@lang('layout.BusinessType')</th>
                                                    <th>@lang('layout.MonetarySource')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            <!--end col-md-9-->
                        </div>
                    </div>
                    <!--end tab-pane-->
                    <!--BEGIN Guarantor-->
                    @if(systemConfig()[16] != 0)
                    <div class="tab-pane" id="tab_1_4">
                    <div class="">    
                        <div class="col-md-12">
                            <!--begin: widget 1-2 -->
                            <div class="mt-widget-1">
                                <div class="mt-icon">
                                    <a title="{{btnTitle('Edit')}}"  href="{{ route('customer.edit', ['id' => $customer->id]) }}">
                                        <i class="fa fa-pencil"></i>
                                    </a>
                                </div>
                                <div class="mt-img">
                                    @if($member_guar && $member_guar->photo !=Null)
                                            
                                            <img class=" twPc-avatarImg"
                                            src="{!!url('/uploads/'.$member_guar->photo)!!}"
                                            style="width:120px; height:120px;">

                                    @else
                                    <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                            style="width:120px; height:120px;">
                                    @endif
                                    
                                </div>
                                <div class="mt-body">
                                    <h3 class="mt-username"><i class="fa fa-user"></i> {{($member_guar)? $member_guar->name:'' }}</h3>
                                    <p class="mt-user-title"> <i class="fa fa-phone"></i> {{ ($member_guar)? $member_guar->phone:'' }}  </p>
                                    <div class="mt-stats">
                                        <div class="btn-group btn-group btn-group-justified">
                                        <table class="table">
                                                    <tr style="background-color: rgb(80, 129, 141) !important;color: white;">
                                                        <th class="text-center">@lang('layout.Name')</th>
                                                        <th class="text-center">@lang('layout.FatherName')</th>
                                                        <th class="text-center">@lang('layout.Phone')</th>
                                                    </tr>
                                                    <tr class="active">
                                                        <td class=""> {{ ($member_guar)? $member_guar->name:'' }}  </td>
                                                        <td class=""> {{ ($member_guar)? $member_guar->father_name:''}}  </td>
                                                        <td class=""> {{ ($member_guar)? $member_guar->phone:'' }}  </td>
                                                    </tr> 
                                                    
                                                </table>
                                                <table class="table">
                                                    <thead>
                                                    <tr style="background-color: #d4d7dc;">
                                                        
                                                        <th>@lang('layout.Country')</th>
                                                        <th>@lang('layout.City')</th>
                                                        <th>@lang('layout.District')</th>
                                                        <th>@lang('layout.Village')</th>
                                                        <th>@lang('layout.Address')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr class="active">
                                                        <td class=""> {{ ($member_guar)? $member_guar->country:'' }}  </td>
                                                        <td class=""> {{ ($member_guar)? $member_guar->city:'' }}  </td>
                                                        <td class=""> {{ ($member_guar)? $member_guar->district:'' }}  </td>
                                                        <td class=""> {{ ($member_guar)? $member_guar->village:'' }}  </td>
                                                        <td class=""> {{ ($member_guar)? $member_guar->address:'' }}  </td>


                                                    </tr>
                                                    </tbody>
                                                </table>
                                        </div>
                                      
                                    </div>
                                </div>
                            </div>
                            <!--end: widget 1-2 -->
                        </div>
                        
                    </div>
                    </div>
                    @endif
                    <!--END Guarantor-->
                    <!--end tab-pane-->
                </div>
            </div>
        </div>
    </div>
    <!-- for factor begin -->
    <div id="factor-obj">
    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>
    <!-- end for factor -->
@endsection
@include('print.modal')
@include('customers.modal')
@push('scripts')
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script>

        @if (Session('transfer_id'))
                printTransferBill("{{Session('transfer_id')}}")

                @endif
        function printTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('printTransferBill')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }


        @if (Session('transfer_id'))
        printTransferBill("{{Session('transfer_id')}}")
        @endif
        function printTransferBillRoll(id) {
            var a = document.createElement('a');
            a.href = "{{url('printTransferBillRoll')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }


        var member_contract_farmer  = {!!json_encode($member_contract_farmer)!!}
        var cust_rep = {!!customeReportNewData('statement')!!}; 

        Vue.component("v-select", VueSelect.VueSelect);

        function printVoucher(id) {

            document.location.href = "{{url('printReceive')}}/" + id;

        }

        Vue.component('modal', {
            template: '#modal-template'
        });


        var Banks = {!! $banks!!}
        new Vue({
            el: '#app',
            data: {
                balance: {},

                amount: null,
                selectedCurrency:{!! json_encode(Currency()->getCurrency()) !!},
                currency:{!!  json_encode(getCurrencies()) !!},
                showModal: false,
                prepaidModal: false,
                checkoutModal: false,
                form_type: 'add',
                checkStatus: "{{$customer->status}}"
            },
            computed: {

                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
            },
            methods: {
                routeAndModal(e) {
                    regForm(this);
                    location.href = '{{route('memberOpeningBalance.create',$customer->id)}}';
                },
                openingSubmit() {

                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-opening-balance").submit()

                            } else {

                            }
                        });
                },
                prepaidSubmit() {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        text: "",
                        icon: "info",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    })

                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-prepaid-balance").submit()

                            } else {

                            }
                        });
                },
                checkoutSubmit(form_type) {
                    this.form_type = form_type;
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        text: "",
                        icon: "info",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    })

                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-checkout").submit();
                            } else {

                            }
                        });
                }
            }

        });

        // alert('adads');
        
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#Purch-table').on('shown.bs.tab', function (event) {
                $('#pur').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true, 
                    ajax: { 
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'purchase'}
                    }, 
                    columns: [
                        {data: 'number', name: 'sales.number'},
                        {data: 'ref_no', name: 'sales.ref_no'},
                        {data: 'type', name: 'sales.type'},
                        {data: 'account_name', name: 'accounts.name'},
                        {data: 'date', name: 'date', searchable: false},
                        {data: 'currency', name: 'currency', orderable: false, searchable: false},
                        {data: 'amount', name: 'account', orderable: false, searchable: false},
                        {data: 'discount', name: 'account', orderable: false, searchable: false},
                        {data: 'description', name: 'description', orderable: false, searchable: false},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });
            });
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-invoices').on('shown.bs.tab', function (event) {
                $('#Invoice').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'invoice'}
                    },
                    columns: [
                        {data: 'number', name: 'sales.number'},
                        {data: 'ref_no', name: 'sales.ref_no'},
                        {data: 'type', name: 'sales.type'},
                        {data: 'account_name', name: 'accounts.name'},
                        {data: 'date', name: 'date', searchable: false},
                        {data: 'currency', name: 'transactions.unit'},
                        {data: 'amount', name: 'amount', orderable: false, searchable: false},
                        {data: 'discount', name: 'discount', orderable: false, searchable: false},
                        {data: 'description', name: 'description', orderable: false, searchable: false},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });
            });
            $(document).ready(function () {
                $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#attachment').DataTable({
                    ajax:{
                        url:'{{route("customer.show",$customer->member_id)}}',
                        data:{type:'attachment'}
                    },
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    columns: [
                        { data: 'title', name: 'attachments.title'},
                        { data: 'description', name: 'attachments.description'},
                        { data: 'actions',         name: 'actions', orderable:false,searchable:false},
                    ]
                });
            });
        });
        // Payments scripts
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#payment-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true, 
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'payment'}
                    },
                    columns: [
                        {data: 'number', name: 'receivable_payments.number'},
                        {data: 'ref_no', name: 'receivable_payments.ref_no'},
                        {data: 'Account', name: 'accounts.name'},
                        {data: 'Date', name: 'Date', searchable: false},
                        {data: 'Amount', name: 'Amount', orderable: false, searchable: false},
                        {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                        {data: 'Currency', name: 'transactions.unit'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                }); 
        });

        // Pyaments  scripts end
        // shareholders scripts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#shareholder').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true, 
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'shareholder'}
                    },
                    columns: [
                        { data: 'shareholder_name', name: 'shareholder_name'},
                        { data: 'shareholder_fathername', name: 'shareholder_fathername'},
                        { data: 'shareholderType', name: 'shareholderType'},
                        { data: 'shareholder_address', name: 'shareholder_address'},
                        { data: 'shareholder_phone_number', name: 'shareholder_phone_number'},
                        { data: 'shareholder_email', name: 'shareholder_email'},
                        { data: 'shareholder_passport_number', name: 'shareholder_passport_number'},
                    ]
                });
        });

        // Shareholders  scripts end

        // transactions scripts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#transaction').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true, 
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'transaction'}
                    },
                    columns: [
                        { data: 'exchangeType', name: 'exchangeType'},
                        { data: 'businessType', name: 'businessType'},
                        { data: 'monetarySource', name: 'monetarySource'},
                    ]
                });
        });

        // transactions  scripts end

        // Payments scripts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus_prepaids').on('shown.bs.tab', function (event) {

                $('#prepaid_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,

                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'prepaid'}
                    },
                    columns: [
                        {data: 'Account', name: 'Account'},
                        {data: 'Date', name: 'Date'},
                        {data: 'Amount', name: 'Amount'},
                        {data: 'Rate', name: 'Rate'},
                        {data: 'Currency', name: 'Currency'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });

        // Pyaments  scripts end
        //statement
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-statement').on('shown.bs.tab', function (event) {
                $('#statement-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    paging: true,
                    retrieve: true,
                    order: [[7, "desc"]],
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'statements'}
                    },
                    columns: [
                        {data: 'Account', name: 'Account'},
                        {data: 'Description', name: 'Description'},
                        {data: 'Currency', name: 'Currency'},
                        {data: 'Rate', name: 'Rate'},
                        {data: 'Type', name: 'Type'},
                        {data: 'Receiable', name: 'Receiable'},
                        {data: 'Payable', name: 'Payable'},
                        {data: 'Date', name: 'Date'},
                        @if(getItemWithStatment() == 'true')
                        {data: 'itemName', name: 'itemName'},
                        {data: 'Qty', name: 'Qty'},
                        {data: 'Measure', name: 'Measure'},
                        {data: 'Cost', name: 'Cost'},
                        @endif

                    ]
                });
            });            

            $('#statement-table').DataTable({
                scrollCollapse: true,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                retrieve: true,
                order: [[7, "desc"]],
                ajax: {
                    url: '{{route("customer.show",$customer->member_id)}}',
                    data: {type: 'statements'}
                },
                columns: [
                    {data: 'Account', name: 'Account'},
                    {data: 'transaction_id', name: 'transaction_id'},
                    {data: 'Description', name: 'Description'},
                    {data: 'Currency', name: 'Currency'},
                    {data: 'Rate', name: 'Rate'},
                    {data: 'Type', name: 'Type'},
                    {data: 'Receiable', name: 'Receiable'},
                    {data: 'Payable', name: 'Payable'},
                    {data: 'Date', name: 'Date'},
                    @if(getItemWithStatment() == 'true')
                    {data: 'itemName', name: 'itemName'},
                    {data: 'Qty', name: 'Qty'},
                    {data: 'Measure', name: 'Measure'},
                    {data: 'Cost', name: 'Cost'},
                    @endif
                ]
            });
        });

        //end statement

        //Begin memberCloth
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#memberCloth-table').on('shown.bs.tab', function (event) {

                $('#memberCloth_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,


                    ajax: {

                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'memberCloth'}
                    },
                    columns: [
                        {data: 'number', name: 'member_cloths.number'},
                        {data: 'cloth_cat', name: 'cloth_categories.name'},
                        {data: 'Date', name: 'member_cloths.date'},
                        {data: 'description', name: 'member_cloths.description'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });
        //End memberCloth


        //Begin FarmerContract
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#FarmerContract-table').on('shown.bs.tab', function (event) {

                $('#FarmerContract_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'FarmerContract'}
                    },
                    columns: [
                        {data: 'number', name: 'contract_farmer.number'},
                        {data: 'ref_no', name: 'contract_farmer.ref_no'},
                        {data: 'Date', name: 'Date', orderable: false, searchable: false},
                        {data: 'land_size', name: 'contract_farmer.land_size'},
                        {data: 'land_drawing_amount', name: 'contract_farmer.land_drawing_amount'},
                        {data: 'land_measure', name: 'land_measure', orderable: false, searchable: false},
                        {data: 'seed_amount', name: 'contract_farmer.seed_amount'},
                        {data: 'measure', name: 'measure', orderable: false, searchable: false},
                        {data: 'overdueDate', name: 'overdueDate', orderable: false, searchable: false},
                        {data: 'sale_description', name: 'contract_farmer.sale_description'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });
        //End FarmerContract


        //Begin Inventory
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#inventory-table').on('shown.bs.tab', function (event) {

                $('#inventory_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'inventory'}
                    },
                    columns: [
                        { data: 'type',          name: 'type', searchable:false,orderable:true },
                        { data: 'number',        name: 'number', searchable:false,orderable:true },
                        { data: 'from_customer', name: 'from_customer', searchable:false,orderable:true },
                        { data: 'ref_no',        name: 'ref_no', searchable:false,orderable:true },
                        { data: 'date',          name: 'date', searchable:false,orderable:true },
                        { data: 'name',          name: 'name', searchable:false,orderable:true },
                        { data: 'siteName',      name: 'siteName', searchable:false,orderable:false },
                        { data: 'cat',           name: 'cat', searchable:false,orderable:false },
                        { data: 'quantity',      name: 'quantity', searchable:false,orderable:false },
                        { data: 'measure',       name: 'measure', searchable:false,orderable:false },
                        { data: 'cost',          name: 'cost', searchable:false,orderable:false },
                        { data: 'total',         name: 'total', searchable:false,orderable:false },
                        { data: 'user',          name: 'user', searchable:false,orderable:false }
                    ]
                });

            });
        });
        //End inventory
        //Begin Inventory Transfer
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#inventoryTransfer-table').on('shown.bs.tab', function (event) {

                $('#inventory_transfer_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'inventory_transfer'}
                    },
                    columns: [
                        {data: 'id', name: 'inventory_transfers.id'},
                        {data: 'number', name: 'inventory_transfers.number'},
                        {data: 'way_bill_number', name: 'inventory_transfers.way_bill_number'},
                        {data: 'plate_number', name: 'inventory_transfers.plate_number'},
                        {data: 'total_bori', name: 'inventory_transfers.total_bori'},
                        {data: 'name', name: 'members.name'},
                        {data: 'employee', name: 'emp.name'},
                        {data: 'Date', name: 'inventory_transfers.date'},
                        @if(systemConfig()[20] == 1)
                        {data: 'contract_type', name: 'contract_type', orderable: false, searchable: false},
                        @endif
                        {data: 'user_name', name: 'users.name', orderable: false, searchable: false},
                        {data: 'description', name: 'inventory_transfers.description'},
                        {data: 'action', name: 'action', orderable: false, searchable: false},

                    ]
                });

            });
        });
        //End inventory Transfer


        //Begin Inventory Transfer Roll...............................................
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#inventoryTransferRoll-table').on('shown.bs.tab', function (event) {
                $('#inventory_transfer_table_roll').DataTable({
                    scrollCollapse: true, 
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("customer.show",$customer->member_id)}}',
                        data: {type: 'inventory_transfer_roll'}
                    },
                    columns: [
                        {data: 'id', name: 'inventory_transfers.id'},
                        {data: 'number', name: 'inventory_transfers.number'},
                        {data: 'way_bill_number', name: 'inventory_transfers.way_bill_number'},
                        {data: 'plate_number', name: 'inventory_transfers.plate_number'},
                        {data: 'total_bori', name: 'inventory_transfers.total_bori'},
                        {data: 'name', name: 'members.name'},
                        {data: 'Date', name: 'inventory_transfers.date'},
                        {data: 'description', name: 'inventory_transfers.description'},
                        {data: 'user', name: 'user', searchable: false},
                        {data: 'action', name: 'action', orderable: false, searchable: false},
                    ]
                });

            });
        });
        //End inventory Transfer ROll...................................................

        function factorPrint(id) {
            document.location.href = "{{url('invoiceFactorPrint')}}/" + id;

            // $.ajax({
            //           // This PHP file will generate the PDF and save it to your server
            //           // $pdf->Output('path/to/pdf/file.pdf', 'F');
            //           url: "{{url('/')}}/invoiceFactorPrint/"+id,
            //           type: 'get',
            //           cache: false,

            //         }).done(function () {

            //           var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

            //           $('#factor-obj').html(s);

            //           // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            //         })
            //         .fail(function () {
            //           console.log("error");
            //         });

        }


        function openModal(type, is_statment = false) {
            if (is_statment == false) {

                anchorM.showModal(type);
            }
            else {
                vm_statement.$data.is_show = true;
            }
        }


        var ms = new Vue({

            el: '#member_statement',
            data: {
                summary: [],
                isLoading:true
            },
            mounted: function() {
                var member = {{$customer->member_id}};
                this.getSummary(this, member);
            },
            methods: {
                getSummary(vm, member) {
                if (member) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: member,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.summary = response.data;
                                vm.isLoading = false;
                            } else {
                                vm.summary = [];
                                vm.isLoading = false;
                            }
                        })
                        .catch(function(error) {
                            vm.summary = [];
                            console.log(error);
                        });
                }
            },
            }
        });        
        

        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });        
        
        var vm_member_info = new Vue({

            el: '#print_modal_member_info',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

       var anchorM_member_info= new Vue({
            el: '#anchore-modal-member_info',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_member_info.$data.is_show = true;

                }
            }
        });       
        
         var vm_member_farmer_contract = new Vue({

            el: '#print_modal_member_farmer_contract',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: null,
                farmer_contract_list:member_contract_farmer,
                selectedFarmerContract:null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

       var anchorM_member_farmer_contract= new Vue({
            el: '#anchore-modal-member_farmer_contract',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_member_farmer_contract.$data.is_show = true;

                }
               
            }
        }); 

         var vm_inventory = new Vue({
            el: '#print_modal_inventory',
            data: {
                is_show: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',
                type: null,
                selectedSite:null
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });


         var vm_inventory_transfer = new Vue({
            el: '#print_modal_inventory_transfer',
            data: {
                is_show: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',
                type: null,
                selectedSite:null
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });


         var vm_inventory_transferRoll = new Vue({
            el: '#print_modal_inventory_transfer_roll',
            data: {
                is_show: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',
                type: null,
                selectedSite:null
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });
       var modal_inventory= new Vue({
            el: '#modal-inventory',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_inventory.$data.is_show = true;
                }  
            }
        });  
       var modalInventoryTransfer= new Vue({
            el: '#modal-inventoryTransfer',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_inventory_transfer.$data.is_show = true;
                } 
            }
        });  
       var modalInventoryTransferRoll = new Vue({
            el: '#modal-inventoryTransferRoll',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_inventory_transferRoll.$data.is_show = true;
                } 
            }
        });  
        var anchorM = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function (type = null) {
                    vm.$data.type = type;
                    console.log('trr', type)
                    vm.$data.is_show = true;   
                }
            }
        });
        var statement_currency = {!!currencyList()!!}
        var vm_statement = new Vue({
            el: '#print-modal_statement',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                type: null,
                statement_currency:statement_currency,
                selected_statement_currency:null,
                statement_style:null,
                statement_currency_id:[],
                customReportData:
                [
                 {Name: '@lang("layout.Code")', column_name: 'customer_code',checkedColumn:(cust_rep.customer_code)?'checked':'',column_percentage:(cust_rep.customer_code___percent)?cust_rep.customer_code___percent:''},
                 {Name: '@lang("layout.Email")', column_name: 'customer_email',checkedColumn:(cust_rep.customer_email)?'checked':'',column_percentage:(cust_rep.customer_email___percent)?cust_rep.customer_email___percent:''},
                 {Name: '@lang("layout.Phone")', column_name: 'customer_phone',checkedColumn:(cust_rep.customer_phone)?'checked':'',column_percentage:(cust_rep.customer_phone___percent)?cust_rep.customer_phone___percent:''},
                 {Name: '@lang("layout.JobTitle")', column_name: 'customer_job',checkedColumn:(cust_rep.customer_job)?'checked':'',column_percentage:(cust_rep.customer_job___percent)?cust_rep.customer_job___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.TransactionID")', column_name: 'transactionID',checkedColumn:(cust_rep.transactionID)?'checked':'',column_percentage:(cust_rep.transactionID___percent)?cust_rep.transactionID___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.SaleArea")', column_name: 'area',checkedColumn:(cust_rep.area)?'checked':'',column_percentage:(cust_rep.area___percent)?cust_rep.area___percent:''},
                 {Name: '@lang("layout.MemberClass")', column_name: 'member_class',checkedColumn:(cust_rep.member_class)?'checked':'',column_percentage:(cust_rep.member_class___percent)?cust_rep.member_class___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.SReceivable")', column_name: 'receivable',checkedColumn:(cust_rep.receivable)?'checked':'',column_percentage:(cust_rep.receivable___percent)?cust_rep.receivable___percent:''},
                 {Name: '@lang("layout.SPayable")', column_name: 'payable',checkedColumn:(cust_rep.payable)?'checked':'',column_percentage:(cust_rep.payable___percent)?cust_rep.payable___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(cust_rep.balance)?'checked':'',column_percentage:(cust_rep.balance___percent)?cust_rep.balance___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.SReceivable") {{getHomeCurrency()["code"]}}', column_name: 'receivable_home_currency',checkedColumn:(cust_rep.receivable_home_currency)?'checked':'',column_percentage:(cust_rep.receivable_home_currency___percent)?cust_rep.receivable_home_currency___percent:''},
                 {Name: '@lang("layout.SPayable") {{getHomeCurrency()["code"]}}', column_name: 'payable_home_currency',checkedColumn:(cust_rep.payable_home_currency)?'checked':'',column_percentage:(cust_rep.payable_home_currency___percent)?cust_rep.payable_home_currency___percent:''},
                 {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_rep.item)?'checked':'',column_percentage:(cust_rep.item___percent)?cust_rep.item___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalItems")', column_name: 'total_item',checkedColumn:(cust_rep.total_item)?'checked':'',column_percentage:(cust_rep.total_item___percent)?cust_rep.total_item___percent:''},
                 {Name: '@lang("layout.ReportTotal")', column_name: 'report_total',checkedColumn:(cust_rep.report_total)?'checked':'',column_percentage:(cust_rep.report_total___percent)?cust_rep.report_total___percent:''},
                 {Name: '@lang("layout.HesabSabiqa")', column_name: 'hesab_sabiqa',checkedColumn:(cust_rep.hesab_sabiqa)?'checked':'',column_percentage:(cust_rep.hesab_sabiqa___percent)?cust_rep.hesab_sabiqa___percent:''},
                 {Name: '@lang("layout.CustomerSummary")', column_name: 'customer_summary',checkedColumn:(cust_rep.customer_summary)?'checked':'',column_percentage:(cust_rep.customer_summary___percent)?cust_rep.customer_summary___percent:''},
                 {Name: '@lang("layout.Total") {{getHomeCurrency()["code"]}}', column_name: 'total_home_currency',checkedColumn:(cust_rep.total_home_currency)?'checked':'',column_percentage:(cust_rep.total_home_currency___percent)?cust_rep.total_home_currency___percent:''}, 
                 {Name: '@lang("layout.Details")', column_name: 'details',checkedColumn:(cust_rep.details)?'checked':'',column_percentage:(cust_rep.details___percent)?cust_rep.details___percent:''},
                 {Name: '@lang("layout.Measure1")', column_name: 'measure1',checkedColumn:(cust_rep.measure1)?'checked':'',column_percentage:(cust_rep.measure1___percent)?cust_rep.measure1___percent:''},
                 {Name: '@lang("layout.Measure2")', column_name: 'measure2',checkedColumn:(cust_rep.measure2)?'checked':'',column_percentage:(cust_rep.measure2___percent)?cust_rep.measure2___percent:''},
                 {Name: '@lang("layout.OtherMeasure")', column_name: 'otherMeasure',checkedColumn:(cust_rep.otherMeasure)?'checked':'',column_percentage:(cust_rep.otherMeasure___percent)?cust_rep.otherMeasure___percent:''},
                 {Name: '@lang("layout.OtherMeasure2")', column_name: 'otherMeasure2',checkedColumn:(cust_rep.otherMeasure2)?'checked':'',column_percentage:(cust_rep.otherMeasure2___percent)?cust_rep.otherMeasure2___percent:''},
                 {Name: '@lang("layout.TransferCode")', column_name: 'transferCode',checkedColumn:(cust_rep.transferCode)?'checked':'',column_percentage:(cust_rep.transferCode___percent)?cust_rep.transferCode___percent:''},
                 {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                 {Name: '@lang("layout.PlateNumber")', column_name: 'plateNumber',checkedColumn:(cust_rep.plateNumber)?'checked':'',column_percentage:(cust_rep.plateNumber___percent)?cust_rep.plateNumber___percent:''},
                 {Name: '@lang("layout.Expense")', column_name: 'expense',checkedColumn:(cust_rep.expense)?'checked':'',column_percentage:(cust_rep.expense___percent)?cust_rep.expense___percent:''},
                 {Name: '@lang("layout.Remain")', column_name: 'remain',checkedColumn:(cust_rep.remain)?'checked':'',column_percentage:(cust_rep.remain___percent)?cust_rep.remain___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'',column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep.ref_no)?'checked':'',column_percentage:(cust_rep.ref_no___percent)?cust_rep.ref_no___percent:''},
                  ], 
                  cust_rep:cust_rep
            },
            watch: {
                selected_statement_currency: function(newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function(e) {
                    x.push(e.id);
                    });
                    this.statement_currency_id = x;
                }
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });
        function printPass(){
            // var b = document.getElementById('ppp');
            // console.log(b);
            var a = window.open('','','height=500,width=500');
            a.document.write('<h2>');
            a.document.write('Name :  {{ $customer->name }}');
            a.document.write('<br/>');
            a.document.write('Email :  {{ $customer->email }}');
            a.document.write('<br/>');
            a.document.write('Password :  {{ $customer->password }}');
            a.document.write('</h2>');
            a.document.write('<p>');
            a.document.write('Address :  {{ url("/member/login") }}');
            a.document.write('</p>');
            a.document.close();
            a.print();
        }
    </script>
@endpush