@extends('layouts.app')
@section('style')
	
        <!-- BEGIN PAGE LEVEL STYLES -->
        <link href="{{url('assets/pages/css/search.css')}}" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL STYLES -->
@endsection

@section('content')

<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.SearchMember')</span>
            </div>

		</div>
		<div class="portlet-body">
			<div class="search-page search-content-4" id="app">
			    <div class="search-bar" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
			        <div class="row" style="display: flex;justify-content: center;">
			            <div class="col-lg-12 col-md-12 col-sm-12">
			                <search></search>
			            </div>
			        </div>
			    </div>
			</div>
		</div>
	</div>
</div>
@endsection
@push('scripts')
	<script>
		Vue.component('search',{
			template:`<div class="input-group col-lg-12 col-md-12 col-sm-12 input-icon" style="position: relative;">
						<i class="icon-magnifier" style="position: absolute;left:20px;top:7px;font-size: 1.5em;color: red;"></i>
	                    <input type="text" class="form-control "  placeholder="{{__('layout.SearchFor')}}" v-model="searchquery" v-on:keyup="autoComplete" style="border-radius: 10px;color: black;border: 1px solid rgba(172, 171, 171, 0.877);">
						<div v-if="isLoading">
							<div class="table-scrollable">
								<table class="table table-hover">
									<tr>
										<td colspan="3" style="text-align: center">
											<img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
										</td>

									</tr>
								</table>
							</div>
						</div>

                	    <div  v-if="data_results.length">
					        <table class="table table-bordered table-hover">
					            <thead class="bg-blue">
					                <tr class="bg-success">
					                    <th style="text-align:center;">
					                    	<i class="fa fa-list-ol"></i>
					                        {{__('layout.Code')}}
					                    </th>
					                    <th style="text-align:center;">
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.Name')}}
					                    </th>
					                    <th style="text-align:center;">
					                    	<i class="fa fa-mobile"></i>
					                        {{__('layout.Phone')}}
					                    </th> 
					                    <th style="text-align:center;">
					                    	<i class="fa fa-envelope"></i>
					                        {{__('layout.Email')}}
					                    </th>
					                    <th style="text-align:center;">
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.Type')}}
					                    </th> 
					                    <th style="text-align:center;">
					                        {{__('layout.Show')}}
					                    </th>
					                </tr>
					            </thead>
					            <tbody>
					                <tr v-for="result in data_results" style="text-align:center;">
					                    <td class="table-date font-dark">
					                        <p>@{{result.code}}</p>
					                    </td>
					                    <td class="table-date font-dark">
					                        <p>@{{result.name}}</p>
					                    </td>
					                    <td class="table-date font-dark">
					                        <p>@{{result.phone}}</p>
					                    </td>
					                    <td class="table-date font-dark">
					                        <p>@{{result.email}}</p>
					                    </td>
					                    <td class="table-date font-dark">
					                        <p v-if="result.type=='Customer'">
					                       		 @lang('layout.Customer')
					                        </p>
					                        <p v-if="result.type=='Employee'">
					                       		 @lang('layout.Employee')
					                        </p> 
					                        <p v-if="result.type=='Vendor'">
					                        	@lang('layout.Vendor')
					                        </p>  
					                        <p v-if="result.type=='Owner'">
					                        	@lang('layout.Owner')
					                        </p> 
					                        <p v-if="result.type=='Driver'">
					                        	@lang('layout.Driver')
					                        </p>
					                        <p v-if="result.type=='Shareholder'">
					                        	@lang('layout.Shareholder')
					                        </p>
					                        <p v-if="result.type=='Supervisor'">
					                        	@lang('layout.Supervisor')
					                        </p>
					                    </td>
					                    <td class="table-date font-dark">
						                    <a @click="getUrl(result.type,result.id)" class="btn btn-success">
						                        <i class = "fa fa-info-circle"></i>
						                    </a>
					                    </td>
					                </tr>
					            </tbody>
					        </table>
					    </div>
	                </div>`, 
	        data: function(){
	        	return {
	        		searchquery: '',
	        		data_results: [],
					isLoading:false
	        	}
	        },
	        methods: {
	        	autoComplete(){
	        		this.data_results = [];
					this.isLoading= true

	        		if(this.searchquery.length){
	        			axios.get('{{route("searchMember.search")}}',
	        				{params:{
	        					searchquery:this.searchquery,
	        				}})

	        			.then(response=>{
							// console.log(123, response.data);
	        				this.data_results = response.data;
							this.isLoading= false
	        			
	        			});
	        		}
					else
					{
						this.isLoading= false
					}
	        	},
	        	getUrl(type,id)
	        	{
	        		window.location.href   ="{{url('/')}}"+'/'+type.toLowerCase()+'/'+id;
	        		
	        	}
	        },
		})


		const app = new Vue({
			el: "#app"
		});
	</script>
@endpush

    