@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InStock')</h3>

    <?php
    if($member){
    ?>
    <h4>
    </h4>
    <table class="main-table">
        <tr class="center">
            <td colspan="2">@lang('layout.Name') : {{$member[0]->name}}</td>
            <td>@lang('layout.Code') : {{$member[0]->code}}</td>
            <td>@lang('layout.Email') : {{$member[0]->email}}</td>
            <td>@lang('layout.Phone') : {{$member[0]->phone}}, {{$member[0]->phone2}}</td>

        </tr>
    </table>
    <?php
    }
    ?>
    <br>
    
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td><div class="center"> #</div></td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Location')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Volume')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Weight') @lang('layout.Package')</th>
            <th>@lang('layout.Volume') @lang('layout.Package')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Discount')</th>
            <th>@lang('layout.Expense')</th>
            <th>@lang('layout.ExpenseDetails')</th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <?php
            $total = 0;

            // $total = ($record->amount + (($record->ex_amount)?$record->ex_amount:0) - (($record->discount)?$record->discount:0));
            $total = ($record->amount);

            $total_home_currency += $total / $record->rate;
            if (array_key_exists($record->currency, $currencies)) {
                $currencies[$record->currency] = $currencies[$record->currency] + $total;
            } else {

                $currencies[$record->currency] = $total;
            }
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{onlineConvertDate($record->date)}}</td>
                <td class="center">{{$record->source_name}}</td>
                <td class="center">{{$record->item_description1}}</td>
                <td class="center">{{$record->width}}</td>
                <td class="center">{{$record->length}}</td>
                <td class="center">{{$record->height}}</td>
                <td class="center">{{$record->volume}}</td>
                <td class="center">{{$record->weight}}</td>
                <td class="center">{{$record->quantity_in}}</td>
                <td class="center">{{round($record->weight * $record->quantity_in,4)}}</td>
                <td class="center">{{round($record->volume * $record->quantity_in,4)}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{round($record->price,4)}}</td>
                <td class="center">{{round($record->discount,4)}}</td>
                <td class="center">{{round($record->ex_amount,4)}}</td>
                <td class="center">{{$record->ex_description}}</td>
                <td class="center">{{round($total,4)}}</td>
            </tr>
        @endforeach

    </table>
    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency )
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
    </table>


@endsection