@extends('layouts.factor-master')
@section('style')
<style>

  /* hr.border_hr{
    border: 2px solid red !important;
  } */

  .tdata{
    font-weight: bold;
    height: 30px;
  }  
  .tdata1{
    height: 30px;
  }
</style>
@endsection

@section('content')



    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventorySiteReport')</h3>
    <table class="main-table"> 
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
<br>
<!----------------------------------------
------BEGIN Information-------------------
------------------------------------------>
<table class="main-table">
  <tbody>
    <tr>
      <td width="70%">
        <table class="main-table" style="width:100%">
        <thead>
          <tr class="bg">
              <td class="center tdata">@lang('layout.Customer')</td>
              <td class="center tdata">@lang('layout.Code')</td>
              <td class="center tdata">@lang('layout.Phone')</td>
              <td class="center tdata">@lang('layout.City')</td>
              <td class="center tdata">@lang('layout.Address')</td>
          </tr>
        </thead>
            <tr>
            <td class="center tdata1">{{ $customer->name }}</td>
            <td class="center tdata1">{{ $customer->code }}</td>
            <td class="center tdata1"> {{ $customer->phone }}  </td>
            <td class="center tdata1"> {{ $customer->city }}  </td>
            <td class="center tdata1"> {{ $customer->address1 }}  </td>
            </tr>
        </table>
      </td>
    </tr>
  </tbody>
</table>
<br>


<!----------------------------------------
------END Information---------------------
------------------------------------------>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <th class="tdata">#</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Item')</th>
            <th>@lang('layout.SiteName')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.User')</th>
        </tr>
        </thead>
        <?php
        // dd($data);
        $count = 0;
        $in=0;
        $out=0;
        $outAmount=0;
        $inAmountCost=0;
        $inAmountUnitCost=0;
        $total_balance_amount=0;
        $total_balance_qty=0; 
        $items = [];
        $totalQuantityItem = 0;
        $totalQuantityPrice = 0;
        ?>
        @foreach($data AS $record)
            <?php
            $items[$record->name]['measure'] = $record->measure;

            $totalQuantityItem += $record->quantity;
            $totalQuantityPrice += $record->total;

            if($record->cat == 'in'){
              // Handle 'in' category   
              if (array_key_exists($record->name, $items)) {
                  $items[$record->name]['in'] = isset($items[$record->name]['in']) 
                      ? $items[$record->name]['in'] + $record->quantity 
                      : $record->quantity;
              } else {
                  $items[$record->name]['in'] = $record->quantity;
              }

              $in +=$record->quantity;
              
              $inAmountCost +=$record->quantity*$record->cost;
              $inAmountUnitCost +=$record->quantity*$record->total;

              $total_balance_amount += ($record->total);
              $total_balance_qty += $record->quantity;
            }
            if($record->cat == 'out'){
              // Handle 'out' category
              if (array_key_exists($record->name, $items)) {
                  $items[$record->name]['out'] = isset($items[$record->name]['out']) 
                      ? $items[$record->name]['out'] + $record->quantity 
                      : $record->quantity;
              } else {
                  $items[$record->name]['out'] = $record->quantity;
              } 
              $out +=$record->quantity;
              $outAmount +=$record->quantity*$record->cost;
              
              $total_balance_amount -= ($record->total);
              $total_balance_qty -= $record->quantity;
            }  

            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{__('type.' . $record->type)}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{$record->from_customer}}</td>
                <td class="center">{{$record->ref_no}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">{{$record->name}}</td>
                <td class="center">{{$record->siteName}}</td>
                <td class="center">{{__('type.' . $record->cat)}}</td>
                <td class="center">{{$record->quantity}}</td>
                <td class="center">{{$record->measure}}</td>
                <td class="center">{{$record->cost}}</td>
                <td class="center">{{$record->total}}</td>
                <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach

      @if(count($items) <= 1)
        <tr class="bg">
          <td colspan="9" class="center">  @lang('layout.Total')  </td>
          <td class="center">{{$totalQuantityItem}}</td>
          <td colspan="2"></td>
          <td colspan="1" class="center">{{$totalQuantityPrice}}</td>
        </tr>
      @endif


    </table>

<table class="main-table">
    <tr class="bg">
      <th>@lang('layout.InItems')</th>
      <th>@lang('layout.OutItems')</th>
      <th>@lang('layout.Total')</th>
      <th>@lang('layout.Total') @lang('layout.Price')</th>
    </tr>
  <tbody>
    <tr>
      <td style="text-align: center;">{{myRound($in)}}</td>
      <td style="text-align: center;">{{myRound($out)}}</td>
      <td style="text-align: center;">{{myRound($in-$out)}}</td>
      <td style="text-align: center;">{{myRound($total_balance_amount)}}</td>
    </tr>
  </tbody>
</table>
<br>

<table class="main-table">
 <tr class="bg">
  <th colspan="6" class="center"><h3>@lang('layout.Items')</h3></th>
</tr>
<tr>
  <th class="center">  @lang('layout.Record') </th>
  <th class="center"> @lang('layout.Item') </th>
  <th class="center"> @lang('layout.Unit') </th>
  <th class="center"> @lang('layout.QutIn') </th>
  <th class="center"> @lang('layout.QutOut') </th>
  <th class="center"> @lang('layout.Remain') </th>
</tr>
<?php
$count=0;
// dd($items);
$totalQuantityIn = 0;
$totalQuantityOut = 0;
$totalQuantityRemaining = 0;

foreach($items As $key=>$item)
{
  $remain = ((isset($item['in']))? $item['in']:0) - ((isset($item['out']))?$item['out']:0);
  $totalQuantityIn += ((isset($item['in']))? $item['in']:0);
  $totalQuantityOut += ((isset($item['out']))?$item['out']:0);
  $totalQuantityRemaining += $remain
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$key}}</td>
    <td class="center">{{$item['measure']}}</td>
    <td class="center">{{(isset($item['in']))?myRound($item['in']):0}} </td>
    <td class="center">{{(isset($item['out']))?myRound($item['out']):0}} </td>
    <td class="center">{{myRound($remain)}} </td> 
  </tr>

  @if(count($items) <= 1)
  <tr>
    <td colspan="3" class="center"> @lang('layout.Total') </td>
    <td class="center"> {{$totalQuantityIn}} </td>
    <td class="center"> {{$totalQuantityOut}} </td>
    <td class="center"> {{$totalQuantityRemaining}} </td>
  </tr>
  @endif




  <?php
}
?>
{{-- <tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
 <td colspan="2"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
 <td colspan="2"><div class="center">{{myRound($total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
<tr style="@if($total_comm_amount < 0) background-color: #fbc0c0; @endif">
 <td colspan="2"><div class="center"><h3>@lang('layout.Total') @lang('layout.Commission') </h3></div></td>
 <td colspan="2"><div class="center">{{myRound($total_comm_amount)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr> --}}
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection