@extends('layouts.app')
@section('style')

<style>

.center { text-align: center !important; }

.bg {
    background-color: #e1fafd;
  }

.th {
    background-color: #cfe9ff;
  }
</style>
@stop
@section('content')

<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberStatement') </span>
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">

            <div id="app" v-cloak>
                <!-- BEGIN FORM-->
                <div class="row">
                  

                </div>
            </div>

            @if($dataStatement && $dataStatement !=[])

            <?php
            $balance_per_currency_receive = [];
            $balance_per_currency_payable = [];
            $balance_per_currency_rec_pay = [];

            ?>

            <div class="row" style=" overflow-y: scroll; height:600px;">
                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr style="background-color: #d9e0dc;">
                            <th class="center" >#</th>
                            <th class="center" >@lang('layout.Code') </th>
                            <th class="center" >@lang('layout.Name') </th>
                            <th class="center" >@lang('layout.Phone') </th>
                            <th class="center" >@lang('layout.Address') </th>
                            <th class="center" >@lang('layout.PayableTotal') </th>
                            <th class="center" >@lang('layout.ReceivableTotal') </th>
                            <th class="center" >@lang('layout.TotalBalances') {{getHomeCurrency()[getCurrencyType()]}} </th>
                            <th class="center"  width="40%">@lang('layout.Currency') @lang('layout.Balance') </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                        $count = 0;
                        $tempName = '';
                        $totalP = 0;
                        $totalR = 0;

                        $name_array = [];


                        $test = 0;
                        ?>
                        @foreach($dataStatement AS $key=>$value)


                        <?php

                        $member_type = getMemberType($value['id']);
                        
                        $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);

                        $p = $result['a'];
                        $r = $result['b'];


                        if ($p != 0) {
                            $totalP += $p;
                        } elseif ($r != 0) {
                            $totalR += $r;
                        }

                        ?>

                        <tr>
                            <td class="center">{{++$count}}</td>
                            <td class="center">
                            <a href="{{url('/')}}/{!! lcfirst($member_type) !!}/{{$value['id']}}" class="btn btn-success">
                            {{$value['code']}} <i class = "fa fa-info-circle"></i>
                            </a>
                            </td>
                            <td class="center">
                            <a href="{{url('/')}}/{!! lcfirst($member_type) !!}/{{$value['id']}}">
                            <b>{{$key}}</b>
						    </a>
                            </td>
                            <td class="center">{{$value['Phone']}}</td>
                            <td class="center">{{$value['Address']}}</td>
                            <td class="center bg">{{myRound($value['TotalAmountP'])}} {{getHomeCurrency()[getCurrencyType()]}}</td>
                            <td class="center bg">{{myRound($value['TotalAmountR'])}} {{getHomeCurrency()[getCurrencyType()]}}</td>
                            <td class="center">
                                <?php

                                $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);

                                $p = $result['a'];
                                $r = $result['b'];

                                if ($p != 0) {

                                    if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
                                    } else {

                                        $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
                                        // $totalP+=$p;
                                    }

                                    echo myRound($p) . ' ' . __('layout.Payable');
                                } elseif ($r != 0) {


                                    if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
                                    } else {

                                        $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
                                        // $totalR+=$r;
                                    }

                                    echo myRound($r) . ' ' . __('layout.Receivable');
                                } else {
                                    echo '0';
                                }

                                ?>

                            </td>
                            <td>
                                <table class="table table-striped table-bordered table-hover">
                                    <thead>
                                        <tr class="th">
                                            <th>
                                                <div class="center"> @lang('layout.Currency') </div>
                                            </th>
                                            <th>
                                                <div class="center"> @lang('layout.Receivable') </div>
                                            </th>
                                            <th>
                                                <div class="center"> @lang('layout.Payable') </div>
                                            </th>
                                            <th>
                                                <div class="center"> @lang('layout.Balance') </div>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($value['Currency'] AS $key1=>$rec)

                                        <?php

                                        $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                                        $r1 = $result1['b'];
                                        $p1 = $result1['a'];
                                        if ($r1 != 0) {
                                            if (array_key_exists($key1, $balance_per_currency_receive)) {
                                                $balance_per_currency_receive[$key1] = $balance_per_currency_receive[$key1] + $r1;
                                            } else {
                                                $balance_per_currency_receive[$key1] = $r1;
                                            }

                                            if (array_key_exists($key1, $balance_per_currency_rec_pay)) {
                                                $balance_per_currency_rec_pay[$key1]['rec'] = $balance_per_currency_rec_pay[$key1]['rec'] + $r1;
                                            } else {
                                                $balance_per_currency_rec_pay[$key1]['rec'] = $r1;
                                                $balance_per_currency_rec_pay[$key1]['pay'] = 0;
                                            }
                                        }
                                        if ($p1 != 0) {
                                            if (array_key_exists($key1, $balance_per_currency_payable)) {
                                                $balance_per_currency_payable[$key1] = $balance_per_currency_payable[$key1] + $p1;
                                            } else {
                                                $balance_per_currency_payable[$key1] = $p1;
                                            }

                                            if (array_key_exists($key1, $balance_per_currency_rec_pay)) {
                                                $balance_per_currency_rec_pay[$key1]['pay'] = $balance_per_currency_rec_pay[$key1]['pay'] + $p1;
                                            } else {
                                                $balance_per_currency_rec_pay[$key1]['pay'] = $p1;
                                                $balance_per_currency_rec_pay[$key1]['rec'] = 0;
                                            }
                                        }

                                        ?>

                                        <tr>
                                            <td class="center">{{$key1}}</td>
                                            <td class="center">{{myRound($rec['Receivable'])}}</td>
                                            <td class="center"> {{myRound($rec['Payable'])}}</td>


                                            <td class="center">
                                                <?php
                                                $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                                                $p1 = $result1['a'];
                                                $r1 = $result1['b'];
                                                ?>
                                                @if($r1 !=0)
                                                {{myRound($r1)}}
                                                @lang('layout.Receivable')

                                                @elseif($p1 !=0)

                                                {{myRound($p1)}}
                                                @lang('layout.Payable')

                                                @endif
                                            </td>

                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </td>
                            @endforeach
                        </tr>

                    </tbody>
                </table>
            </div>

            @endif

        </div>

    </div>
    <!-- END FORM-->
</div>

@endsection
@push('scripts')


<script type="text/javascript">
    Vue.component("v-select", VueSelect.VueSelect);

    var member_class = {!! $member_class !!}

    new Vue({
        el: '#app',
        data: {
            category: member_class,
            selected_class: null,
            items: null,
            selectedAll: false,
            member_class: member_class,

        },



        methods: {
            changeCategory(e) {
                var value = e.event.target.value;
                for (var i = 0; i < this.items.length; i++) {
                    this.items[i].selected = null;
                    if (this.items[i].class_id == value) {
                        this.items[i].selected = true;
                    }
                }
            },
            toggleCheck(index) {
                this.items[index].selected = !this.items[index].selected;
            },
            //Select * Records
            selectAll(e) {

                for (var i = 0; i < this.items.length; i++) {
                    if (this.selectedAll == true) {
                        this.items[i].selected = true;
                    } else {
                        this.items[i].selected = false;
                    }

                }
            }
        }
    });
</script>
@endpush