@extends('layouts.factor-master')
@section('style')
<style>

  /* hr.border_hr{
    border: 2px solid red !important;
  } */

  .tdata{
    font-weight: bold;
    height: 30px;
  }  
  .tdata1{
    height: 30px;
  }
</style>
@endsection

@section('content')


    <h3 class="table-caption" style="text-align: center;">@lang('layout.FarmerContractReport')</h3>
    <table class="main-table">

        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
<br>




<!----------------------------------------
------BEGIN Information-------------------
------------------------------------------>

<table class="main-table">
  <tbody>
    <tr>
      <td width="70%">
        <table class="main-table" style="width:100%">
        <thead>
          <tr class="bg">
              <td class="center tdata" rowspan="2">@lang('layout.Customer')</td>
              <td class="center tdata" rowspan="2" colspan="2">{{ $customer->name }} </td>
              <td class="center tdata">@lang('layout.Phone')</td>
              <td class="center tdata">@lang('layout.Phone2')</td>
              <td class="center tdata">@lang('layout.City')</td>
              <td class="center tdata">@lang('layout.District')</td>
              <td class="center tdata">@lang('layout.Village')</td>
              <td class="center tdata">@lang('layout.Address')</td>
          </tr>
        </thead>
        <tr>
          <td class="center tdata1"> {{ $customer->phone }}  </td>
          <td class="center tdata1"> {{ $customer->phone2 }}  </td>
          <td class="center tdata1"> {{ $customer->city }}  </td>
          <td class="center tdata1"> {{ $customer->district }}  </td>
          <td class="center tdata1"> {{ $customer->village }}  </td>
          <td class="center tdata1"> {{ $customer->address1 }}  </td>
        </tr>
          @if(systemConfig()[16] != 0)
          @if(($member_guar)? $member_guar->name:'')

              <tr style="background-color: #cbc9e8;" >
                  <td class="center tdata" rowspan="2">@lang('layout.Guarantor')</td>
                  <td class="center tdata" rowspan="2" colspan="2">{{ ($member_guar)? $member_guar->name:'' }}</td>
                  <td class="center tdata" >@lang('layout.FatherName')</td>
                  <td class="center tdata" >@lang('layout.Phone')</td>
                  <td class="center tdata">@lang('layout.City')</td>
                  <td class="center tdata">@lang('layout.District')</td>
                  <td class="center tdata">@lang('layout.Village')</td>
                  <td class="center tdata">@lang('layout.Address')</td>
              </tr> 
              <tr  >
                <td  class="center tdata1"> {{ ($member_guar)? $member_guar->father_name:''}}  </td>
                <td  class="center tdata1"> {{ ($member_guar)? $member_guar->phone:'' }}  </td>
                <td class="center tdata1"> {{ ($member_guar)? $member_guar->city:'' }}  </td>
                <td class="center tdata1"> {{ ($member_guar)? $member_guar->district:'' }}  </td>
                <td class="center tdata1"> {{ ($member_guar)? $member_guar->village:'' }}  </td>
                <td class="center tdata1"> {{ ($member_guar)? $member_guar->address:'' }}  </td>
              </tr>

          @endif
          @endif
        </table>
      </td>
    </tr>
  </tbody>
</table>
<br>


<!----------------------------------------
------END Information---------------------
------------------------------------------>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <th class="tdata">#</th>
            <th class="tdata">@lang('layout.Number')</th>
            <th class="tdata">@lang('layout.ReferenceNumber')</th>
            <th class="tdata">@lang('layout.LandSize')</th>
            <th class="tdata">@lang('layout.DrawingAmount')</th>
            <th class="tdata">@lang('layout.Unit')</th>
            <th class="tdata">@lang('layout.SeedAmount')</th>
            <th class="tdata">@lang('layout.Unit')</th>
            <th class="tdata">@lang('layout.Date')</th> 
            <th class="tdata">@lang('layout.OverdueDate')</th> 
            <th class="tdata">@lang('layout.Description')</th>

        </tr>
        </thead>
        <?php
        $count = 0;
        // dd($data);
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{$record->ref_no}}</td>
                <td class="center">{{$record->land_size}}</td>
                <td class="center">{{$record->land_drawing_amount}}</td>
                <td class="center">{{$record->land_measure}}</td>
                <td class="center">{{$record->seed_amount}}</td>
                <td class="center">{{$record->measure}}</td>
                <td class="center">{{convertDate($record->Date)}}</td>
                <td class="center">{{convertDate($record->overdueDate)}}</td>
                <td class="center">

                    @if(isset($report_format))
                    {{$record->sale_description}}
                    @else
                    {!! wordwrap($record->sale_description,40,"<br/>\n",false) !!}
                    @endif

                </td>


            </tr>
        @endforeach
    </table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection