@extends('layouts.app')
@section('content')  
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                    :value-type="'member_statment'"
                    @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="type_name" value="Customer"/>
                <!----------------------------------------------
                ----Begin Report Body  And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                                @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">
                                            <div class="row">
                                                <div class="form-group"> 
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.SelectType') </label>
                                                        <select name="category" id="" class="form-control">
                                                            <option value="" selected="selected">@lang('layout.WithStatment')</option>
                                                            <option value="2">@lang('layout.WithoutStatment')</option>
                                                            <option value="3">@lang('layout.MemberWithoutTransaction')</option>
                                                            <option value="1">@lang('layout.All')</option>
                                                        </select>
                                                    </div> 
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.SelectMember') </label>
                                                        <v-select class="vue-select2"
                                                                  v-model="selectedMember"
                                                                  :multiple="true" label="name"
                                                                  @search="onMemberSearch"
                                                                  :options="memberlist">
                                                        </v-select>
                                                        <input type="hidden" name="member_id"
                                                               :value="member_id.length > 0 ? member_id:null">
                                                    </div> 

                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.SelectClass')</label>
                                                        <v-select class="vue-select2"
                                                                  v-model="selected_class"
                                                                  label="name"
                                                                  :options="member_class">
                                                        </v-select>
                                                        <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.ReportType') </label>
                                                    <select name="report_type" id="" class="form-control">
                                                        <option value="">@lang('layout.SelectReportType')</option>
                                                        <option value="Receivable">@lang('layout.Payable')</option>
                                                        <option value="Payable">@lang('layout.Receivable')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Style') </label>
                                                    <select name="style" class="form-control">
                                                        <option  value="" selected="selected">@lang('layout.Default')</option>
                                                        <option  value="1">@lang('layout.Style') 1</option>
                                                    </select>
                                                </div>
                                                @if(getFinancialClass() =='true') 
                                                @permission('financialClass-list')
                                                <div class="col-md-4">
                                                    <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                    <select name="financial_class_id" class="form-control" >
                                                        <option value="">@lang('layout.SelectClass')</option>
                                                        <option value="Unclassified">Unclassified</option>
                                                        <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                    </select>
                                                </div>
                                                @endpermission
                                                @endif
                                            </div>

                                            <div class="row">
                                                <div class="form-group">
                                                    <div class="col-md-4">
                                                        <label class="control-label">@lang('layout.IdentifyType')</label>
                                                        <select name="identify_type" class="form-control">
                                                            <option value=""> @lang('layout.Select') </option>
                                                            <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                                            <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                                                        </select>
                                                      </div> 
                                                    <div class="col-md-4">
                                                    <label class="control-label">@lang('layout.Currency') </label>
                                                    <select class="form-control" v-model="selected_currency" >
                                                        <option v-for="curre in currencies" :value="curre">@{{ curre.code }}</option>
                                                    </select>
                                                    <input type="hidden" name="currency" v-bind:value="(selected_currency)?selected_currency.code:null"/>
                                                    </div>
                                                    <div class="col-md-6">
                                                    <span v-if="selected_currency">
                                                        <span v-if="selected_currency.code != code">
                                                        <label class="control-label">@lang('layout.Rate') </label>
                                                                <div class="input-group">
                                                                    <input v-model="selected_currency.rate" class="form-control" name="currency_rate"
                                                                        type="number" step="any" min="0"  >
                                                                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                                </div>
                                                        </span>
                                                    </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <label for="">@lang('layout.Village')</label>
                                                    <input type="text" class="form-control" name="village">
                                                </div>
                                            </div>

                                            <div class="row">
                                            <div class="form-group">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Date')</label>
                                                            <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                            <option value="CustomDates">@lang('type.CustomDates')</option>
                                                            <option value="Today">@lang('type.Today')</option>
                                                            <option value="Yesterday">@lang('type.Yesterday')</option>
                                                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                            <option value="LastWeek">@lang('type.LastWeek')</option>
                                                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                            <option value="ThisYear">@lang('type.ThisYear')</option>
                                                            <option value="YearToDate">@lang('type.YearToDate')</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-8" v-show="period == 'CustomDates'">
                                                        <div class="form-group">
                                                            <label class="control-label"> @lang('layout.Date')</label>
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="member_statment">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">

                                                            <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>

                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>

                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                             <!-- <label v-if="row.checkedColumn!='rep2'"> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch" v-if="row.checkedColumn!='rep2'">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label>
                                                            <br>
                                                            <div v-if="row.checkedColumn=='rep2'">
                                                                <hr style="border-top: 2px solid red">
                                                                <p>@lang('layout.WithoutStatment')</p>
                                                            </div> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
             

            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CustomerList')</span>
                </div>
                <div class="tools"></div>

                <div class="pull-right">
                    @permission('customers-export')


                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>


                    @endpermission
                    @permission('customers-create')
                    <a href="{{route('customer.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    <a href="{{route('customerImport.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('menu.ImportExcel')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="customer">
                    <thead>
                    <tr>
                        {{--<th>Code</th>--}}

                        <th>@lang('layout.Code') </th>
                        <th>@lang('layout.FullName')</th> 
                        @if(getCustomerStatement() =="true")
                            <th>@lang('layout.TotalBalances')
                                @if(getCustomerStatementType() == "currency")
                                <span></span>
                                @else
                                    {{getHomeCurrency()["code"]}} 
                                @endif
                            </th>
                        @endif
                        <th>@lang('layout.Phone')</th>
                        <!-- <th>@lang('layout.CreatedAt')</th> -->
                        <th>@lang('layout.Address')</th>
                        @if(member_class_customer_list()=="true")
                        <th>@lang('layout.Class')</th>
                        @endif
                        @if(systemConfig()[22] == 1) 
                        <th>@lang('layout.RiskStep')</th>
                        @endif
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

       
    </div>
    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
    <script>
        function factorPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('customerSenderPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }  
        var cust_rep      = {!!customeReportNewData('member_statment')!!};
        var member_class  = {!!json_encode($member_class)!!}

        Vue.component("v-select", VueSelect.VueSelect);

        $(document).ready(function () {
            // $.fn.dataTable.ext.errMode='alert';
            // $.fn.dataTable.ext.errMode='none';
            // $.fn.dataTable.ext.errMode='throw';
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            
            $('#customer').DataTable({
                ajax: '{{route("customer.index")}}',
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                // pagingType:'full_numbers',
                // pagingType:'simple',
                // pagingType:'simple_numbers',
                pagingType:'{{paginationType()}}',
                fixedHeader:true,
                serverSide: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'name', name: 'name'},
                    @if(getCustomerStatement() =="true") 
                        {
                            data: 'totalBalances',
                            name: 'totalBalances',
                            orderable: false,
                            searchable: false
                        }, 
                    @endif
                    {
                        data: 'phone', name: 'phone'
                    },
                    // {data: 'created_at', name: 'created_at', orderable: false, searchable: false},
                    {data: 'address1', name: 'member_informations.address1'},
                    @if(member_class_customer_list()=="true")
                    {data: 'member_class', name: 'member_classes.name'},
                    @endif
                    @if(systemConfig()[22] == 1) 
                    {data: 'risk_step', name: 'risk_step'},
                    @endif
                    {data: 'status', name: 'status'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},

                ]
            });
        });

        var currencies = {!! $currencies !!};
        var code = '{!! getHomeCurrency()['code'] !!}';

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: [],
                memberlist: [],
                member_id: [],
                selected_class:null,
                member_class:member_class,
                class_id:null,
                currencies: currencies,
                selected_currency: null,
                code: code,
                financial_classes: {!!getFinancialClassList()!!},
                customReportData:
                [    
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(cust_rep.phone)?'checked':'',column_percentage:(cust_rep.phone___percent)?cust_rep.phone___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'member_class',checkedColumn:(cust_rep.member_class)?'checked':'',column_percentage:(cust_rep.member_class___percent)?cust_rep.member_class___percent:''},
                 {Name: '@lang("layout.City")', column_name: 'city1',checkedColumn:(cust_rep.city1)?'checked':'',column_percentage:(cust_rep.city1___percent)?cust_rep.city1___percent:''},
                 {Name: '@lang("layout.Address")', column_name: 'address1',checkedColumn:(cust_rep.address1)?'checked':'',column_percentage:(cust_rep.address1___percent)?cust_rep.address1___percent:''},
                 {Name: '@lang("layout.PayableTotal")', column_name: 'payable_home_currency',checkedColumn:(cust_rep.payable_home_currency)?'checked':'',column_percentage:(cust_rep.payable_home_currency___percent)?cust_rep.payable_home_currency___percent:''},
                 {Name: '@lang("layout.ReceivableTotal")', column_name: 'receivable_home_currency',checkedColumn:(cust_rep.receivable_home_currency)?'checked':'',column_percentage:(cust_rep.receivable_home_currency___percent)?cust_rep.receivable_home_currency___percent:''},
                 {Name: '@lang("layout.TotalBalances")', column_name: 'total_balance',checkedColumn:(cust_rep.total_balance)?'checked':'',column_percentage:(cust_rep.total_balance___percent)?cust_rep.total_balance___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Receivable")', column_name: 'receivable',checkedColumn:(cust_rep.receivable)?'checked':'',column_percentage:(cust_rep.receivable___percent)?cust_rep.receivable___percent:''},
                 {Name: '@lang("layout.Payable")', column_name: 'payable',checkedColumn:(cust_rep.payable)?'checked':'',column_percentage:(cust_rep.payable___percent)?cust_rep.payable___percent:''},
                 {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(cust_rep.balance)?'checked':'',column_percentage:(cust_rep.balance___percent)?cust_rep.balance___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalPerCurrency")', column_name: 'total_per_currency',checkedColumn:(cust_rep.total_per_currency)?'checked':'',column_percentage:(cust_rep.total_per_currency___percent)?cust_rep.total_per_currency___percent:''},
                 {Name: '@lang("layout.JobTitle")', column_name: 'job_title',checkedColumn:(cust_rep.job_title)?'checked':'',column_percentage:(cust_rep.job_title___percent)?cust_rep.job_title___percent:''},
                 {Name: '@lang("layout.Salary")', column_name: 'salary',checkedColumn:(cust_rep.salary)?'checked':'',column_percentage:(cust_rep.salary___percent)?cust_rep.salary___percent:''},
                 {Name: '@lang("layout.FatherName")', column_name: 'father_name',checkedColumn:(cust_rep.father_name)?'checked':'',column_percentage:(cust_rep.father_name___percent)?cust_rep.father_name___percent:''},
                 {Name: '@lang("layout.BloodGroup")', column_name: 'blood_group',checkedColumn:(cust_rep.blood_group)?'checked':'',column_percentage:(cust_rep.blood_group___percent)?cust_rep.blood_group___percent:''},
                 {Name: '@lang("layout.Email")', column_name: 'email',checkedColumn:(cust_rep.email)?'checked':'',column_percentage:(cust_rep.email___percent)?cust_rep.email___percent:''},
                ],
                cust_rep:cust_rep

            },

            watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.member_id = x;
                    console.log('x value');
                    console.log(x);
                },
            },



            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush


@section('vselectStyle')
    <style type="text/css">
        .v-select .selected-tag {
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@endsection