@extends('layouts.factor-master')

@section('style')
<style>

  /* hr.border_hr{
    border: 2px solid red !important;
  } */

  .tdata{
    font-weight: bold;
    height: 30px;
  }  
  .tdata1{
    height: 30px;
  }
</style>
@endsection
@section('content')


<h4 class="table-caption" style="text-align: center;">@lang('layout.FarmerContractReport')</h4>

<table class="main-table">

<tr>
    @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
    @endif
    @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
    @endif
</tr>
</table>
<br>





<!----------------------------------------
------Begin Data--------------------------
------------------------------------------>
<?php
  $count = 0;
?>
@foreach($data AS $record)
<?php
  $contract_farmer_details = $record['contract_farmer_details'];
?>
<table class="main-table">
  <tbody>
    <tr>
      <td width="70%">
        <table class="main-table" style="width:100%">
        <thead>
          <tr class="bg">
              <td class="center tdata" rowspan="2">@lang('layout.Contract')</td>
              <td class="center tdata">#</td>
              <td class="center tdata">@lang('layout.Number') </td> 
              <td class="center tdata">@lang('layout.Customer')</td>
              <td class="center tdata">@lang('layout.Phone')</td>
              <td class="center tdata"> @lang('layout.LandSize')</td>
              <td class="center tdata">@lang('layout.DrawingAmount')</td>
              <td class="center tdata">@lang('layout.SeedAmount')</td>
              <td class="center tdata">@lang('layout.Date')</td>
              <td class="center tdata" >@lang('layout.OverdueDate')</td>
          </tr>
        </thead>
        <tr>
            <td class="center tdata">{{++$count}}</td>
            <td class="center tdata">{{$record['number']}} - {{$record['ref_no']}}</td>
            <td class="center tdata">{{$record['member_name']}}</td>
            <td class="center tdata">{{$record['member_phone']}}</td>
            <td class="center tdata">{{$record['land_size']}}</td>
            <td class="center tdata">{{$record['land_drawing_amount']}}({{$record['land_measure']}})</td>
            <td class="center tdata">{{$record['seed_amount']}}({{$record['measure']}})</td>
            <td class="center tdata">{{convertDate($record['date'])}}</td>
            <td class="center tdata" >{{convertDate($record['overdueDate'])}}</td>
            

        </tr>

          <tr style="background-color: #3ab0bb;">
            <td class="center" width="5%">
               @lang('layout.Number')
            </td>
            <td class="center" width="10%">
              @lang('layout.Date')
            </td> 
            <td class="center" width="10%">
              @lang('layout.Type')
            </td>
            <td class="center" width="15%">
              @lang('layout.Item')
            </td>
            
            <td class="center" width="10%">
              @lang('layout.Quantity')
            </td>
            <td class="center" width="10%">
              @lang('layout.Unit')
            </td>
            <td class="center" width="10%">
              @lang('layout.Cost')
            </td>
            <td class="center" width="10%">
              @lang('layout.Currency')
            </td>
            <td class="center" width="10%">
              @lang('layout.Rate')
            </td>
            <td class="center" width="10%">
              @lang('layout.Total')
            </td>

          </tr>
          <?php
          $totalOut = 0;
          $measureTotalOut=[];

          $total_seed = 0;
          $total_drawing = 0;
          $total_CompanyDecrease = 0;
          $total_WastageDecrease = 0;
          ?>
          @foreach($contract_farmer_details AS $row)
          <?php
            if($row['type'] =="Seed")
            {
                $total_seed += ($row['quantity']*$row['unit_details'])/$record['measure_unit_base'];   
            }
            if($row['type'] =="Drawing")
            {
                $total_drawing += ($row['quantity']*$row['unit_details'])/$record['measure_unit_base'];   
            }
            if($row['type'] =="CompanyDecrease")
            {
                $total_CompanyDecrease += ($row['quantity']*$row['unit_details'])/$record['measure_unit_base'];   
            } 
            if($row['type'] =="WastageDecrease")
            {
                $total_WastageDecrease += ($row['quantity']*$row['unit_details'])/$record['measure_unit_base'];   
            }
          ?>

          <tr>
            <td class="center">{{$row['number']}} </td>
            <td class="center">{{convertDate($row['date'])}}</td>
            <td class="center">{{__('type.'.$row['type'])}}</td>
            <td class="center">{{$row['item_name']}}</td>
            <td class="center">{{myRound($row['quantity'])}}</td>
            <td class="center">{{$row['measure']}}</td>
            <td class="center">{{myRound($row['cost'])}}</td>
            <td class="center">{{$row['currency']}}</td>
            <td class="center">{{$row['rate']}}</td>
            <td class="center">{{myRound($row['quantity']*$row['cost'])}}</td>
          </tr>
          @endforeach
              <tr style="background-color: #cbc9e8;" >
                <td class="center tdata" rowspan="4">@lang('layout.Total')</td>
                <td class="center" colspan="2">@lang('type.Seed')</td>
                <td class="center" colspan="2">{{myRound($total_seed)}} ({{$record['measure']}})</td>
                <td class="center tdata" rowspan="4" >@lang('layout.Description')</td>
                <td class="center" rowspan="4" colspan="4" > 
                    @if(isset($report_format))
                    {{$record['sale_description']}}
                    @else
                    {!! wordwrap($record['sale_description'],40,"<br/>\n",false) !!}
                    @endif

                  </td>
              </tr> 
              <tr style="background-color: #cbc9e8;" >
                <td class="center" colspan="2">@lang('type.Drawing')</td>
                <td class="center" colspan="2">{{myRound($total_drawing)}} ({{$record['measure']}})</td>
              </tr>
              <tr style="background-color: #cbc9e8;" >
                <td class="center" colspan="2">@lang('type.CompanyDecrease')</td>
                <td class="center" colspan="2">{{myRound($total_CompanyDecrease)}} ({{$record['measure']}})</td>
              </tr> 
              <tr style="background-color: #cbc9e8;" >
                <td class="center" colspan="2">@lang('type.WastageDecrease')</td>
                <td class="center" colspan="2">{{myRound($total_WastageDecrease)}} ({{$record['measure']}})</td>
              </tr>
        </table>
      </td>
    </tr>
  </tbody>
</table>
<br>
@endforeach


<!----------------------------------------
------END Data--------------------------
------------------------------------------>




<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection