@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <style>
        .select_style{
            outline:1px solid #c2cad8 !important
        }
        .multipleClass .vue-select2 .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .multipleClass .vue-select2 .selected-tag > button >span{
            display: none !important;
        }
        .inputNumber{
            background-color: lightgray;
        }
    </style>
@stop
@section('content')
{{-- {{dd($customer->)}} --}}
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit')  </span>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomerInformation') </span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form"  id="app" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($customer,['method' => 'PATCH','route' => ['customer.update',$customer->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body" >
                    <div class="row" style="padding: 0px 15px;">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="border: 1px solid lightgray; padding: 5px;border-radius: 8px;">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.FullName')</label> 
                                {!! Form::text('name', null, array('placeholder' =>__('layout.FullName'),'class' => 'form-control','tabindex' =>'1','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'))) !!} 
                                <span class="required">@{{ errors.first('name') }}</span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.IdentifyType')</label>
                                <select name="identify_type" v-model="identify_type" id="" class="form-control">
                                    <option value=""> @lang('layout.Select') </option>
                                    <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                    <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Code')</label>
                                {!! Form::text('code',null, array('placeholder' => __('layout.Code'),'tabindex' =>'2','class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.AccountsReceivable')</label> 
                                <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                </v-select>
                                <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.AccountsPayable')</label>
                                <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                </v-select>
                                <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Type')</label> 
                                {!! Form::select('type[]', $type,$customer->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                            </div>
                            <div v-if="identify_type == 'IdentifyReal'" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px;">
                                <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.PersonalInfo')</h4></th>    
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.FatherName')</label>
                                                <div style="display: flex; flex-direction: column;width: 70%;">
                                                    {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'tabindex' =>'1','class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'))) !!}
                                                    <span class="required">@{{ errors.first('father_name') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.GFname')</label>
                                                {!! Form::text('grand_father_name', null, array('placeholder' => __('layout.GFname'),'style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.DateOfBirth')</label>
                                                <input type="text" id="date_of_birth" name="date_of_birth" value="{{convertDate($customer->date_of_birth)}}"  class="form-control date" style="width: 70%" autocomplete="off">
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Gender')</label>
                                                <div style="width: 70%;">
                                                    <input type="radio" name="gender" :checked="'{{$customer->gender}}' == 'male'" value="male"> @lang('layout.Male') &nbsp; &nbsp; &nbsp;
                                                    &nbsp; &nbsp;<input type="radio" name="gender" :checked="'{{$customer->gender}}' == 'female'" value="female" >@lang('layout.Female')
                                                </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr >
                                        <th style="text-align: right; background-color: white;" id="memberClassDiv">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.JobTitle')</label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    <v-select class="vue-select2" style="width: 100%" v-model="selectedJobTitle" label="name" :options="jobTitle" :multiple="true">
                                                    </v-select>
                                                    <input type="hidden" name="job_title_id" :value="jobTitle_id.length > 0 ? jobTitle_id:null">
                                                </div>
                                            </div>

                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%">@lang('layout.PassportNumber')</label>
                                                {!! Form::text('passport', null, array('tabindex' =>'3','style' =>'width:70%','autocomplete'=>'off','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr >
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%">@lang('layout.SSID')</label>
                                                <div style="display: flex; flex-direction: column;width: 70%;">
                                                    {!! Form::text('ss_id', null, array('class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.SSID'))) !!}
                                                    <span class="required">@{{ errors.first('ss_id') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;">
                                            @if (fingerprint() =='true')
                                                <label style="width: 20%;">@lang('layout.Fingerprint')</label>
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                    <input type="checkbox" name="addfinger" @if($customer->finger_device == 'on') checked="" @endif >
                                                    <span></span>
                                                </label>
                                            @endif
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Contacts')</h4></th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Phone')</label>
                                                <div style="display: flex;flex-direction: column; width: 70%;">
                                                    <div style="display: flex;">
                                                        {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','style' =>'width:100%','class' => 'inputNumber form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Phone'))) !!}
                                                        <span class="input-group-addon" style="padding: 8px 5px 8px 40px;margin-right: 10px;" v-if="selectedCountry!=null">
                                                            @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                        </span>
                                                    </div>
                                                    <span class="required">@{{ errors.first('phone') }}</span> 
                                                </div>
                                                
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white; width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Phone2')</label>
                                                {!! Form::number('phone2', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','class' => 'inputNumber form-control','style' =>'width:70%;')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;">
                                            <div style="display: flex; justify-content: space-between">
                                            <label style="width: 20%;">@lang('layout.Email')</label>
                                            {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'style' => 'width:70%','class'=>'form-control','autocomplete'=>'off','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                        </th>
                                        <th style="text-align: right;background-color: white;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Date')</label>
                                                <input type="text" id="reg_date" name="reg_date" value="{{convertDate($customer->reg_date)}}"  class="date form-control" autocomplete="off" style="width: 70%;" class="form-control">
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Address')</h4></th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Address1')</label>
                                                <div style="display: flex; flex-direction: column;width: 70%;">
                                                    {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'tabindex' =>'3','autocomplete'=>'off','class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Address1'))) !!}
                                                    <span class="required">@{{ errors.first('address1') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Address2')</label>
                                                {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.PostCode')</label>
                                                {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'style' =>'width:70%','class'=>'inputNumber form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.City')</label>
                                                {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'tabindex' =>'5','style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Country')</label>
                                                <v-select label="name" style="width: 70%;" class="form-control" v-model="selectedCountry" :options="countries">
                                                </v-select>
                                                <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.District')</label>
                                                {!! Form::text('district', null, array('placeholder' =>__('layout.District'),'tabindex' =>'3','style' =>'width:70%','autocomplete'=>'off','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Village')</label>
                                                {!! Form::text('village', null, array('placeholder' => __('layout.Village'),'style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Transaction')</h4></th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.TransactionType') </label>
                                                {!! Form::text('exchangeType', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.BusinessType') / @lang('layout.WorkType')</label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    {!! Form::text('businessType', null, array('class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.BusinessType'))) !!}
                                                    <span class="required">@{{ errors.first('businessType') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.MonetarySource') </label>
                                                {!! Form::text('monetarySource', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;">
                                            <h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.RiskStep')</h4>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between" v-show="riskStep_id.length > 0 &&  riskStep_id2.length > 0  &&  riskStep_id3.length > 0  &&  riskStep_id4.length > 0">
                                                <label style="width: 30%;">@lang('layout.RiskPercentage') </label>
                                                <input type="number" name="risk_percentage" :value="percentage" class="form-control" step="any" readonly style="width: 40%;border: 1px solid lightgray !important;">
                                                <label v-if="percentage > 70" style="width: 30%; background-color: #ff7692; text-align: center; padding: 4px; ">@lang('type.High') </label>
                                                <label v-if="percentage <= 70 && percentage > 30" style="width: 30%; background-color: #f5cb70; text-align: center; padding: 4px; ">@lang('type.Medium') </label>
                                                <label v-if="percentage <= 30 && percentage > 0" style="width: 30%; background-color: #9af78d; text-align: center; padding: 4px; ">@lang('type.Low') </label>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 30%;">@lang('type.CustomerTypes') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep" label="name" :options="riskSteplist" :multiple="true">
                                                    </v-select>
                                                    <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null" required v-validate='"required"' data-vv-as="{{__('type.CustomerTypes')}}">
                                                    <span class="required">@{{ errors.first('riskStep_id') }}</span>
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 30%;">@lang('type.ProductsAndServices') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep2" label="name" :options="riskSteplist2" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="riskStep_id2" :value="riskStep_id2.length > 0 ? riskStep_id2:null" required v-validate='"required"' data-vv-as="{{__('type.ProductsAndServices')}}">
                                                <span class="required">@{{ errors.first('riskStep_id2') }}</span>
                                            </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 30%;">@lang('type.DistributionChannels') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep3" label="name" :options="riskSteplist3" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="riskStep_id3" :value="riskStep_id3.length > 0 ? riskStep_id3:null" required v-validate='"required"' data-vv-as="{{__('type.DistributionChannels')}}">
                                                <span class="required">@{{ errors.first('riskStep_id3') }}</span>
                                            </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 30%;">@lang('type.GeographicalLocations') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep4" label="name" :options="riskSteplist4" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="riskStep_id4" :value="riskStep_id4.length > 0 ? riskStep_id4:null" required v-validate='"required"' data-vv-as="{{__('type.GeographicalLocations')}}">
                                                <span class="required">@{{ errors.first('riskStep_id4') }}</span>
                                            </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Photo')</h4></th>    
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;display: flex;background-color: white;">
                                            <label style="width: 30%;">@lang('layout.Photo')</label>
                                            <?php
                                                $photo = null;
                                                if($customer && $customer->photo!=null)
                                                {
                                                    $photo =  $customer->photo;
                                                }
                                            ?>
                                            <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                    <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                        style="max-width: 200px; max-height: 150px;"></div>
                                                    <div>
                                                            <span class="btn default btn-file">
                                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                <!-- <input type="file" name="photo">  -->
                                                                {!! Form::file('photo', []) !!}</span>
                                                        {!! Form::hidden('photo1', (!$customer)?null:$customer->photo) !!}
                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                        data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;">
                                            <div style="display: flex;">
                                                <label style="width: 30%;">@lang('layout.Fingerprint')</label>
                                                <?php
                                                    $fingerprint = null;
                                                    if($customer && $customer->fingerprint!=null)
                                                    {
                                                        $fingerprint =  $customer->fingerprint;
                                                    }
                                                ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="{!!url('/uploads/fingerprint/'.$fingerprint)!!}" alt=""/>
                                                            </div>
                                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"></div>
                                                            <div>
                                                                <span class="btn default btn-file">
                                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                {!! Form::file('fingerprint', []) !!}</span>
                                                                {!! Form::hidden('fingerprint1', (!$customer)?null:$customer->fingerprint) !!}
                                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </th>
                                    </tr>
                                </table>
                            </div>
                            <div v-if="identify_type == 'IdentifyUnreal'" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px;">
                                <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.CompanyInformation')</h4></th>    
                                    </tr> 
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width:20%;">@lang('layout.LicenseNumber')</label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    {{-- {!! Form::text('company_license_number', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.LicenseNumber'))) !!} --}}
                                                    {{-- <span class="required">@{{ errors.first('company_license_number') }}</span>  --}}
                                                    <input type="text" name="company_license_number" class="form-control" value="{{$customer->company_license_number}}" required v-validate='"required"' data-vv-as="{{__('layout.LicenseNumber')}}">
                                                    <span class="required">@{{ errors.first('company_license_number') }}</span>
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.LicenseIssueDate')</label>
                                                <input type="text"  name="license_issue_date" value="{{convertDate($customer->license_issue_date)}}"  class="date form-control" autocomplete="off" style="width: 70%;">
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.LicenseExpireDate')</label>
                                                <input type="text"  name="license_expire_date" value="{{convertDate($customer->license_expire_date)}}" style="width: 70%;" class="date form-control" autocomplete="off">
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;50%">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.BossName')</label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    {!! Form::text('boss_name', null, array('tabindex' =>'3','class'=>'form-control','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.BossName'))) !!}
                                                    <span class="required">@{{ errors.first('boss_name') }}</span> 
                                                </div>                                            
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.BossSSN')</label>
                                                {!! Form::text('boss_ssn', null, array('style' => 'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.BossPassport')</label>
                                                {!! Form::text('boss_passport', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.AssistantName')</label>
                                                {!! Form::text('assistant_name', null, array('tabindex' =>'3','style' => 'width:70%','autocomplete'=>'off','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.AssistantSSN')</label>
                                                {!! Form::text('assistant_ssn', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.AssistantPassport')</label>
                                                {!! Form::text('assistant_passport', null, array('style' => 'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            @if (fingerprint() =='true')
                                                <label style="width: 20%;">@lang('layout.Fingerprint')</label>
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                    <input type="checkbox" name="addfinger" @if($customer->finger_device == 'on') checked="" @endif >
                                                    <span></span>
                                                </label>
                                            @endif
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Contacts')</h4></th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Phone')</label>
                                                <div style="display: flex;flex-direction: column; width: 70%;">
                                                    <div style="display: flex; ">
                                                        {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','style' =>'width:100%','class' => 'inputNumber form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Phone'))) !!}
                                                        <span class="input-group-addon" style="padding: 8px 5px 8px 40px;margin-right: 10px;" v-if="selectedCountry!=null">
                                                            @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                        </span>
                                                    </div>
                                                    <span class="required">@{{ errors.first('phone') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Phone2')</label>
                                                {!! Form::number('phone2', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','class' => 'inputNumber form-control','style' =>'width:70%;')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Email')</label>
                                                {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'style' => 'width:70%','class'=>'form-control','autocomplete'=>'off','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Date')</label>
                                                <input type="text" id="reg_date" name="reg_date" value="{{convertDate($customer->reg_date)}}"  class="date form-control" autocomplete="off" style="width: 70%;">
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Address')</h4></th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Address1')</label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'tabindex' =>'3','autocomplete'=>'off','class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Address1'))) !!}
                                                    <span class="required">@{{ errors.first('address1') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width:50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Address2')</label>
                                                {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.PostCode')</label>
                                                {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'style' =>'width:70%','class'=>'inputNumber form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.City')</label>
                                                {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'tabindex' =>'5','style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Country')</label>
                                                <v-select label="name" style="width: 70%;" v-model="selectedCountry" :options="countries">
                                                </v-select>
                                                <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.District')</label>
                                                {!! Form::text('district', null, array('placeholder' =>__('layout.District'),'tabindex' =>'3','style' =>'width:70%','autocomplete'=>'off','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.Village')</label>
                                                {!! Form::text('village', null, array('placeholder' => __('layout.Village'),'style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Transaction')</h4></th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.TransactionType') </label>
                                                {!! Form::text('exchangeType', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.BusinessType') / @lang('layout.WorkType')</label>
                                                <div style="display: flex;flex-direction: column; width: 70%;">
                                                    {!! Form::text('businessType', null, array('class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.BusinessType'))) !!}
                                                    <span class="required">@{{ errors.first('businessType') }}</span> 
                                                </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('layout.MonetarySource') </label>
                                                {!! Form::text('monetarySource', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;">
                                            <h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.RiskStep')</h4>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div style="display: flex; justify-content: space-between" v-show="riskStep_id.length > 0 &&  riskStep_id2.length > 0  &&  riskStep_id3.length > 0  &&  riskStep_id4.length > 0">
                                                <label style="width: 30%;">@lang('layout.RiskPercentage') </label>
                                                <input type="number" name="risk_percentage" :value="percentage" class="form-control" step="any" readonly style="width: 40%;border: 1px solid lightgray !important;">
                                                <label v-if="percentage > 70" style="width: 30%; background-color: #ff7692; text-align: center; padding: 4px; ">@lang('type.High') </label>
                                                <label v-if="percentage <= 70 && percentage > 30" style="width: 30%; background-color: #f5cb70; text-align: center; padding: 4px; ">@lang('type.Medium') </label>
                                                <label v-if="percentage <= 30 && percentage > 0" style="width: 30%; background-color: #9af78d; text-align: center; padding: 4px; ">@lang('type.Low') </label>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('type.CustomerTypes') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                    <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep" label="name" :options="riskSteplist" :multiple="true">
                                                    </v-select>
                                                    <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null" required v-validate='"required"' data-vv-as="{{__('type.CustomerTypes')}}">
                                                    <span class="required">@{{ errors.first('riskStep_id') }}</span>
                                                </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('type.ProductsAndServices') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep2" label="name" :options="riskSteplist2" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="riskStep_id2" :value="riskStep_id2.length > 0 ? riskStep_id2:null" required v-validate='"required"' data-vv-as="{{__('type.ProductsAndServices')}}">
                                                <span class="required">@{{ errors.first('riskStep_id2') }}</span>
                                            </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('type.DistributionChannels') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep3" label="name" :options="riskSteplist3" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="riskStep_id3" :value="riskStep_id3.length > 0 ? riskStep_id3:null" required v-validate='"required"' data-vv-as="{{__('type.DistributionChannels')}}">
                                                <span class="required">@{{ errors.first('riskStep_id3') }}</span>
                                            </div>
                                            </div>
                                        </th>
                                        <th style="text-align: right;background-color: white;width: 50%;">
                                            <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                <label style="width: 20%;">@lang('type.GeographicalLocations') </label>
                                                <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep4" label="name" :options="riskSteplist4" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="riskStep_id4" :value="riskStep_id4.length > 0 ? riskStep_id4:null" required v-validate='"required"' data-vv-as="{{__('type.GeographicalLocations')}}">
                                                <span class="required">@{{ errors.first('riskStep_id4') }}</span>
                                            </div>
                                            </div>
                                        </th>
                                    </tr>
                                </table>
                                <table id="table_content" class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="7"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Shareholder_Agent')</h4></th>
                                        </tr>
                                        <tr v-for="(item,index) in shareholders">
                                            <td style="display: flex;justify-content: space-between;background-color: white;">
                                                <label>@lang('layout.Name')</label>
                                                <input type="text" name="shareholder_name[]" v-model="(!item)?null:item.shareholder_name" class="form-control" style="width: 65%;">
                                            </td>
                                            <td style="background-color: white;">
                                                <div style="display: flex;justify-content: space-between">
                                                    <label>@lang('layout.FatherName')</label>
                                                    <input type="text" name="shareholder_fathername[]" v-model="(!item)?null:item.shareholder_fathername" style="width: 65%;" class="form-control">
                                                </div>
                                            </td>
                                            <td style="background-color: white;">
                                                <div style="display: flex;justify-content: space-between">
                                                    <label>@lang('layout.Address')</label>
                                                    <input type="text" name="shareholder_address[]" v-model="(!item)?null:item.shareholder_address" style="width: 65%;" class="form-control">
                                                </div>
                                            </td>
                                            <td style="background-color: white;">
                                                <div style="display: flex;justify-content: space-between">
                                                    <label>@lang('layout.Phone')</label>
                                                    <input type="text" name="shareholder_phone_number[]" v-model="(!item)?null:item.shareholder_phone_number" style="width: 65%;" class="form-control">
                                                </div>
                                            </td>
                                            <td style="background-color: white;">
                                                <div style="display: flex;justify-content: space-between">
                                                    <label>@lang('layout.Email')</label>
                                                    <input type="text" name="shareholder_email[]" v-model="(!item)?null:item.shareholder_email" style="width: 65%;" class="form-control">
                                                </div>
                                            </td>
                                            <td style="background-color: white;">
                                                <div style="display: flex;justify-content: space-between">
                                                    <label>@lang('layout.PassportNumber')</label>
                                                    <input type="text" name="shareholder_passport_number[]" v-model="(!item)?null:item.shareholder_passport_number" style="width: 65%;" class="form-control">
                                                </div>
                                            </td>
                                            <td style="background-color: white;">
                                                <div style="display: flex;justify-content: space-between">
                                                    <label>@lang('layout.Type')</label>
                                                    <select name="shareholderType[]" class="form-select form-control" v-model="(!item)?null:item.shareholderType">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="shareholder">@lang('layout.Shareholder')</option>
                                                        <option value="agent">@lang('layout.Agent')</option>
                                                    </select>
                                                </div>
                                            </td>
                                            <td colspan="6" style="text-align: right;background-color: white;">
                                                <button type="button" @click="deleteItem1('shareholder')" class="btn btn-danger">
                                                    <i class="fa fa-minus"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        <tr style="background-color: #ffffff;border: none;">
                                            <td colspan="7">
                                                <center>
                                                    <button type="button" @click="addNew1('shareholder',1000)" class="btn btn-success">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </center>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div> 
                    </div>

                        <br>


                        <!----------------------------------------------------------------------------------
                        ------------------------------------------------------------------------------------
                        ----------------------Begin Other INformations--------------------------------------
                        ------------------------------------------------------------------------------------>
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN TAB PORTLET-->
                                <div class="portlet light bordered">      
                                    <div class="portlet-body">
                                        <div class="tabbable tabbable-tabdrop">
                                            <ul class="nav nav-pills">
                                                @if(systemConfig()[29] == 1)
                                                <li class="active">
                                                    <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                                </li> 
                                                @endif
                                                <li class="">
                                                    <a href="#tab4" data-toggle="tab" aria-expanded="true"><i class="fa fa-warning"></i> @lang('layout.RiskManagement')</a>
                                                </li>
                                                @if(systemConfig()[29] != 1) 
                                                <li class="">
                                                    <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                                </li>
                                                @endif
                                                @if(systemConfig()[16] != 0)
                                                <li class="">
                                                    <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-user"></i> @lang('layout.Guarantor')</a>
                                                </li>
                                                @endif
                                                <li v-if="identify_type == 'IdentifyReal'">
                                                    <a href="#tab10" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.CompanyInformation')</a>
                                                </li>
                                                <li v-if="identify_type == 'IdentifyUnreal'">
                                                    <a href="#tab11" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.PersonalInfo')</a>
                                                </li>
                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane" id="tab4">
                                                    <!---start currency----->
                                                    <div class="col-md-12" style="margin-top: 8px">
                                                    <div class="col-md-12">
                                                        <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                            <thead>
                                                                <th style="min-width: 150px">@lang('layout.ID')</th>
                                                                <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                                <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                                <th style="min-width: 500px">@lang('layout.Amount')</th>
                                                            </thead>
                                                            <tbody>
                                                                <tr v-for="currencies in currency">
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <span>@{{currencies.id}}</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.code}}</label>
                                                                            <input type="hidden" name="currency_code[]" :value="(!currencies)?null:currencies.code">
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.exchange_rate}}</label>
                                                                            <input type="hidden" name="currency_rate[]" :value="(!currencies)?null:currencies.exchange_rate">
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <input class="form-control" type="number" name="level[]" :value="(!currencies)?null:currencies.level">
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div> 
                                                    </div>
                                                    <!-----end currency------>
                                                </div>
                                                <div class="tab-pane @if(systemConfig()[29] == 1) active @endif" id="tab8"> 
                                                    <div class="row">
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Class')</label>
                                                                {!! Form::select('class', $class,$customer->class_id, array('class' => 'form-control select_style')) !!}
                                                            </div>
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                {!! Form::text('ref_no',null, array('placeholder' => __('layout.ReferenceNumber'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" rows="1" class="form-control">{{$customer->description}}</textarea> 
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.PriceLevel')</label>
                                                                <v-select label="name" :options="priceLevel" v-model="selected_priceLevel"></v-select>
                                                                <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id" >
                                                            </div>
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Membership')</label>
                                                                <div style="border: 1px dotted ;">
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="professiona" >
                                                                        @lang('layout.Professional') </label>
                                                                </div>
                                                            </div> 
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Site')</label>
                                                                {!! Form::select('multy_site_id[]', $sites,$select_site, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'sites')) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.CardOwner')</label>
                                                                {!! Form::text('card_owner', null, array('placeholder' => __('layout.CardOwner'),'class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.CardNumber')</label>
                                                                {!! Form::text('card_number', null, array('placeholder' => __('layout.CardNumber'),'class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.ShabaNumber')</label>
                                                                {!! Form::text('shaba_number', null, array('placeholder' => __('layout.ShabaNumber'),'class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                

                                                            @if(getTelegramBot()=="true")
                                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                    <label class="control-label">@lang('layout.TelegramID')</label>
                                                                    <v-select label="name" v-model="selected_telegram_id" :options="telegram_id"></v-select>
                                                                    <input type="hidden" name="telegram_id"  :value="(!selected_telegram_id)?null:selected_telegram_id.chat_id">
                                                                </div>
                                                            @endif
                                                            @if(getActiveSale() == "true")
                                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                    <label class="control-label">@lang('layout.FreeCardTimes')</label> 
                                                                    <input type="number" name="free_card_times" value="{{$customer->free_card_times}}" class="form-control">
                                                                </div>
                                                            @endif
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Password')</label>
                                                                {!! Form::text('password', null, array('placeholder' => __('layout.Password'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                @if(systemConfig()[16] != 0)
                                                <div class="tab-pane" id="tab9">
                                                            
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Name')</label>
                                                                {!! Form::text('gu_name', null, array('placeholder' =>__('layout.Name'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.FatherName')</label>
                                                                {!! Form::text('gu_father_name', null, array('placeholder' =>__('layout.FatherName'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label" >@lang('layout.Phone')</label>
                                                                {!! Form::text('gu_phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                    </div> 

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.Address')</label>
                                                                {!! Form::text('gu_address', null, array('placeholder' =>__('layout.Address'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.City')</label>
                                                                    {!! Form::text('gu_city', null, array('placeholder' =>__('layout.City'),'tabindex' =>'5','class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label  ">@lang('layout.Country')</label>
                                                            <v-select label="name" v-model="selectedCountry1" :options="countries"> </v-select>
                                                            <input type="hidden" name="gu_country" :value="(selectedCountry1==null)?null:selectedCountry1.name">
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.District')</label>
                                                            {!! Form::text('gu_district', null, array('placeholder' =>__('layout.District'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.Village')</label>
                                                            {!! Form::text('gu_village', null, array('placeholder' => __('layout.Village'),'class' => 'form-control')) !!}
                                                        </div>
                                                      



                                                            <?php
                                                                $gu_photo = null;
                                                                if($customer && $customer->gu_photo!=null)
                                                                {
                                                                    $gu_photo =  $customer->gu_photo;
                                                                }
                                                            ?>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                        <img src="{!!url('/uploads/'.$gu_photo)!!}" alt=""/>
                                                                    </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <!-- <input type="file" name="gu_photo">  -->
                                                                                    {!! Form::file('gu_photo', []) !!}</span>
                                                                            {!! Form::hidden('gu_photo1', (!$customer)?null:$customer->gu_photo) !!}
                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                    </div>

                                                </div>
                                                @endif
                                                <div class="tab-pane" id="tab10" v-if="identify_type == 'IdentifyReal'">
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.LicenseNumber')</label>
                                                            {!! Form::text('company_license_number', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.LicenseIssueDate')</label>
                                                            <input type="text"  name="license_issue_date" value="{{convertDate($customer->license_issue_date)}}"  class="date form-control" autocomplete="off">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.LicenseExpireDate')</label>
                                                            <input type="text"  name="license_expire_date" value="{{convertDate($customer->license_expire_date)}}" class="date form-control" autocomplete="off">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.BossName')</label>
                                                            {!! Form::text('boss_name', null, array('tabindex' =>'3','class'=>'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.BossSSN')</label>
                                                            {!! Form::text('boss_ssn', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.BossPassport')</label>
                                                            {!! Form::text('boss_passport', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.AssistantName')</label>
                                                            {!! Form::text('assistant_name', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.AssistantSSN')</label>
                                                            {!! Form::text('assistant_ssn', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.AssistantPassport')</label>
                                                            {!! Form::text('assistant_passport', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            @if (fingerprint() =='true')
                                                                <label class="control-label">@lang('layout.Fingerprint')</label>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="addfinger" @if($customer->finger_device == 'on') checked="" @endif >
                                                                    <span></span>
                                                                </label>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane" id="tab11" v-if="identify_type == 'IdentifyUnreal'">
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.FatherName')</label>
                                                            {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'tabindex' =>'1','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.GFname')</label>
                                                            {!! Form::text('grand_father_name', null, array('placeholder' => __('layout.GFname'),'class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                            <input type="text" id="date_of_birth" name="date_of_birth" value="{{convertDate($customer->date_of_birth)}}"  class="form-control date" autocomplete="off">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.Gender')</label>
                                                            &nbsp; &nbsp;<input type="radio" name="gender" :checked="'{{$customer->gender}}' == 'male'" value="male"> @lang('layout.Male') &nbsp; &nbsp; &nbsp;
                                                            <input type="radio" name="gender" :checked="'{{$customer->gender}}' == 'female'" value="female" >@lang('layout.Female')
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            {{-- <label class="control-label">@lang('layout.JobTitle')</label> --}}
                                                            {{-- {!! Form::select('job_title_id[]', $jobTitle,$customer->memberJobtitle, array('class' => 'form-control','multiple'=>'multiple','id'=>'job_title1')) !!}  --}}
                                                            <div class="multipleClass">
                                                                <label class="control-label">@lang('layout.JobTitle')</label>
                                                                <br>
                                                                <v-select class="vue-select2" v-model="selectedJobTitle" label="name" :options="jobTitle" :multiple="true">
                                                                </v-select>
                                                                <input type="hidden" name="job_title_id" :value="jobTitle_id.length > 0 ? jobTitle_id:null">
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.PassportNumber')</label>
                                                            {!! Form::text('passport', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.SSID')</label>
                                                            {!! Form::text('ss_id', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            @if (fingerprint() =='true')
                                                                <label class="control-label">@lang('layout.Fingerprint')</label>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="addfinger" @if($customer->finger_device == 'on') checked="" @endif >
                                                                    <span></span>
                                                                </label>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
----------------------End Other INformations--------------------------------------
------------------------------------------------------------------------------------>
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                     {{-- <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button> --}}
                                     <button type="button"  @click="handleSubmit($event)"  class="btn green" tabindex ='6'>@lang('layout.Submit')</button>
                                    <a href="{{route('customer.index')}}" type="button" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    Vue.component('v-select', VueSelect.VueSelect);

    var gen = {!! json_encode($customer) !!}
    
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });

  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $customer !!};
  var member_class = {!!$class!!};
  var currency={!! json_encode($currency) !!};
  var level_info={!! json_encode($level_info) !!};

  var countries = {!!$countries!!};
  var selectedCountry = {!!$selectedCountry!!};
  var selectedCountry1 = {!!$selectedCountry1!!};

  var priceLevel = {!!$priceLevel!!};
  var selected_priceLevel = {!!$selected_priceLevel!!};
  var telegram_id = {!!$telegram_id!!};
  var riskStep = {!!$riskStep1!!};
  var selectedRiskStep = {!!$selectedRiskStep1!!};
  var riskStep2 = {!!$riskStep2!!};
  var selectedRiskStep2 = {!!$selectedRiskStep2!!};
  var riskStep3 = {!!$riskStep3!!};
  var selectedRiskStep3 = {!!$selectedRiskStep3!!};
  var riskStep4 = {!!$riskStep4!!};
  var selectedRiskStep4 = {!!$selectedRiskStep4!!};
  var memberShareHolder = {!!$memberShareHolder!!};
  var jobTitle = {!!$jobTitle!!};
  var selectedjobTitle = {!!$selectedjobTitle!!};
//   console.log('asdf',countries, selectedCountry)
  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
        member_class:member_class,
        selectedClass:"{!!$customer->class!!}",
        currency:currency,
        level_info:level_info,
        countries:countries,
        selectedCountry:selectedCountry,
        selectedCountry1:selectedCountry1, 

        selectedRiskStep: selectedRiskStep,
        riskSteplist: riskStep,
        riskStep_id: [],
        selectedRiskStep2: selectedRiskStep2,
        riskSteplist2: riskStep2,
        riskStep_id2: [],
        selectedRiskStep3: selectedRiskStep3,
        riskSteplist3: riskStep3,
        riskStep_id3: [],
        selectedRiskStep4: selectedRiskStep4,
        riskSteplist4: riskStep4,
        riskStep_id4: [],
        percentage: 0,

        priceLevel:priceLevel,
        selected_priceLevel:selected_priceLevel,

        telegram_id:telegram_id,
        selected_telegram_id:null, 
        identify_type: null,
        shareholder_type: null,
        shareholders:memberShareHolder,
        jobTitle: jobTitle,
        selectedJobTitle: selectedjobTitle,
        jobTitle_id: [],
    },
    watch: {
        selectedRiskStep: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id = x;
        },
        selectedRiskStep2: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id2 = x;
        },
        selectedRiskStep3: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id3 = x;
        },
        selectedRiskStep4: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id4 = x;
        },
        selectedJobTitle: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
                x.push(e.id);
            });
            this.jobTitle_id = x;
        }
    },
    methods: {
        percentages() {
            // console.log(123, this.selectedRiskStep);
            let count = 0;
            let percentage = 0;
            if (this.selectedRiskStep) {
                this.selectedRiskStep.forEach(function(e) {
                    count++;
                    percentage += e.percentage;
                });
            }
            if (this.selectedRiskStep2) {
                this.selectedRiskStep2.forEach(function(e) {
                    count++;
                    percentage += e.percentage;
                });
            }
            if (this.selectedRiskStep3) {
                this.selectedRiskStep3.forEach(function(e) {
                    count++;
                    percentage += e.percentage;
                });
            }
            if (this.selectedRiskStep4) {
                this.selectedRiskStep4.forEach(function(e) {
                    count++;
                    percentage += e.percentage;
                });
            }
            if (count > 0) {
                this.percentage = Number.parseFloat(percentage / count).toFixed(2);
            } else {
                this.percentage = 0;
            }
        },
        addNew1(type = null, index) {
            this.temp_items = [];
            if (type != null) {
                if (type == 'shareholder') {
                    // console.log(this.shareholders);
                    if (this.shareholders[index + 1] == undefined) {
                        this.temp_items = [];
                        this.shareholders.push({
                            shareholder: null,
                        });
                    }
                }
            }
        },
        // delete item from list
        deleteItem1(type = null, index) {
            if (type != null) {
                if (type == 'shareholder') {
                    this.shareholders.splice(index, 1);
                }
            }
        },
        handleSubmit(e) {
            this.$validator.validate().then(valid => {
                if (valid) {
                    regForm(e.target);
                }
            });
        },
    },
    mounted:function(){
        if (customer.identify_type) {
                this.identify_type = customer.identify_type;
        }
        if(customer.shareholder_type){
            this.shareholder_type = customer.shareholder_type;
        }
        if (customer.risk_percentage) {
                this.percentage = customer.risk_percentage;
        }

        if (selectedRiskStep) {
            let x = [];
            selectedRiskStep.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id = x;
        }

        if (selectedjobTitle) {
            let x = [];
            selectedjobTitle.forEach(function(e) {
                x.push(e.id);
            });
            this.jobTitle_id = x;
        }

        if (selectedRiskStep2) {
            let x = [];
            selectedRiskStep2.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id2 = x;
        }
        if (selectedRiskStep3) {
            let x = [];
            selectedRiskStep3.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id3 = x;
        }
        if (selectedRiskStep4) {
            let x = [];
            selectedRiskStep4.forEach(function(e) {
                x.push(e.id);
            });
            this.percentages();
            this.riskStep_id4 = x;
        }

        // console.log('ffffff',customer, customer.risk_percentage)

        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
            //    if(this.receivable[j].id==this.customer.receivable_id)
            //   {
                  
            //      this.selected_receivable=this.receivable[j];
            //   }
              
          }        
          
          for(var r=0;r<this.receivable.length;r++)
          {
            //   if(this.payable[r].id==this.customer.payable_id)
            //   {
            //      this.selected_payable=this.payable[r];
            //   }
            if(this.receivable[r].id==this.customer.receivable_id)
              {
                  
                 this.selected_receivable=this.receivable[r];
              }
              
          }
         
            for(i=0;i<this.currency.length;i++)
            {
                for(m = 0; m < this.level_info.length ; m++)
                {
                if(this.level_info[m].code == this.currency[i].code)
                {
                    this.currency[i].level=this.level_info[m].amount;
                }
                }
            }

            if(this.customer.telegram_id != null)
            {
                this.selected_telegram_id = _.find(this.telegram_id, (t) =>t.chat_id == this.customer.telegram_id);
            }


          
    },

  });
        //     new Vue({
        //     el:'#countries',
        //     data:{
        //         countries:countries,
        //         selectedCountry:selectedCountry
        //     }
        //   });
        $('#type').multiselect({
            //  columns: 3,
            placeholder: "@lang('layout.SelectType')"
        });
        $('#job_title').multiselect({
            // columns: 3,
            placeholder: "@lang('layout.SelectJobTitle')",
        });
        $('#job_title1').multiselect({
            // columns: 3,
            placeholder: "@lang('layout.SelectJobTitle')",
        });
        $('#sites').multiselect({
            // columns: 3,
            placeholder: "@lang('layout.SelectSite')",
        });
    
</script>
@endpush