@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
 <style>
     .select_style{
        outline:1px solid #c2cad8 !important
     }

    .multipleClass .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .multipleClass .v-select .selected-tag > button >span{
        display: none !important;
    }
 </style>
@stop
@section('content')
{{-- {{dd($customer->)}} --}}
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit')  </span>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomerInformation') </span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form"  id="app" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($customer,['method' => 'PATCH','route' => ['customer.update',$customer->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body" >
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.FullName')</label> 
                                    {!! Form::text('name', null, array('placeholder' =>__('layout.FullName'),'class' => 'form-control','tabindex' =>'1','autocomplete'=>'off')) !!} 
                                </div>
                            </div>  
                            <div class="row">
                                <div class="col-md-9">
                                    <label class="control-label">@lang('layout.Type')</label> 
                                    {!! Form::select('type[]', $type,$customer->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                                </div>
                                @if(getActiveSale() == "true")
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.FreeCardTimes')</label> 
                                    <input type="number" name="free_card_times" value="{{$customer->free_card_times}}" class="form-control">
                                </div>
                                @endif
                            </div>
                            <div class="row">
                                <div class="col-md-8">
                                    <label class="control-label">@lang('layout.AccountsReceivable')</label> 
                                    <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.IdentifyType')</label>
                                    <select name="identify_type" v-model="identify_type" id="" class="form-control">
                                        <option value=""> @lang('layout.Select') </option>
                                        <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                        <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                                    </select>
                                </div> 
                            </div> 
                            @if(systemConfig()[22] == 1) 
                            <div class="row">
                                <div class="col-md-8 multipleClass">
                                    <label class="control-label ">@lang('layout.RiskStep') </label>
                                    <v-select class="vue-select2" v-model="selectedRiskStep" label="name" :options="riskSteplist" :multiple="true">
                                    </v-select>
                                    <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.RiskPercentage') </label>
                                    <input type="number" name="risk_percentage" :value="percentage" step="any" class="form-control" >
                                </div>
                            </div> 
                            @endif  
                        </div>  
                        <div class="col-md-6">
                            <div class="row">
                                    
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Code')</label>
                                    {!! Form::text('code',null, array('placeholder' => __('layout.Code'),'tabindex' =>'2','class' => 'form-control')) !!}
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    {!! Form::text('ref_no',null, array('placeholder' => __('layout.ReferenceNumber'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                </div>
                                
                            </div> 
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.FatherName')</label>
                                    {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'tabindex' =>'1','class' => 'form-control')) !!} 
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" rows="1" class="form-control">{{$customer->description}}</textarea>   
                                </div>
                            </div>
                            
                            <div class="row">
                                    
                                <div class="col-md-9">
                                    <label class="control-label">@lang('layout.AccountsPayable')</label>
                                        <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                        </v-select>
                                        <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                </div>
                                @if (fingerprint() =='true')
                                <div class="col-md-3">
                                    <label>@lang('layout.Fingerprint')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="addfinger" @if($customer->finger_device == 'on') checked="" @endif >
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                @endif
                            </div>  
                        </div> 
                    </div>

                        <br>


                        <!----------------------------------------------------------------------------------
                        ------------------------------------------------------------------------------------
                        ----------------------Begin Other INformations--------------------------------------
                        ------------------------------------------------------------------------------------>
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN TAB PORTLET-->
                                <div class="portlet light bordered">
                                    
                                    <div class="portlet-body">
                                        <div class="tabbable tabbable-tabdrop">
                                            <ul class="nav nav-pills">
                                                @if(systemConfig()[29] == 1)
                                                <li class="active">
                                                    <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                                </li> 
                                                @endif
                                                <li class="@if(systemConfig()[29] != 1) active @endif">
                                                    <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab4" data-toggle="tab" aria-expanded="true"><i class="fa fa-warning"></i> @lang('layout.RiskManagement')</a>
                                                </li>
                                             
                                                <li class="">
                                                    <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                                </li> 
                                                @if(systemConfig()[29] != 1) 
                                                <li class="">
                                                    <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                                </li>
                                                @endif
                                                @if(systemConfig()[16] != 0)
                                                <li class="">
                                                    <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-user"></i> @lang('layout.Guarantor')</a>
                                                </li>
                                                @endif
                                                
                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane @if(systemConfig()[29] != 1) active @endif" id="tab1">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address1')</label>
                                                                    {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        
                                                            </div>
                                                            <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address2')</label>
                                                                    {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.PostCode')</label>
                                                                        {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                    <label class="control-label">@lang('layout.City')</label>
                                                                        {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'tabindex' =>'5','class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                    <label class="control-label  ">@lang('layout.Country')</label>

                                                                        <v-select label="name" v-model="selectedCountry" :options="countries">
                                                                        </v-select>
                                                                        <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                                        <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.District')</label>
                                                                {!! Form::text('district', null, array('placeholder' =>__('layout.District'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Village')</label>
                                                                {!! Form::text('village', null, array('placeholder' => __('layout.Village'),'class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                <div class="tab-pane" id="tab2">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                            <div class="col-md-7">
                                                                {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','class' => 'form-control')) !!}
                                                            </div>
                                                            <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                                                @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::number('phone2', null, array('placeholder' =>__('layout.Phone'),'tabindex' =>'4','class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control','autocomplete'=>'off','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                                              
                                                                <!-- ,'v-validate' =>'"email"','data-vv-as' => __('layout.ResetPasswordEmail') -->

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Password')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::text('password', null, array('placeholder' => __('layout.Password'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                
                                                </div>
                                                @if(getTelegramBot()=="true")
                                                <div class="row" >
                                                    <div class="col-md-3">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.TelegramID')</label>
                                                            <div class="col-md-7">
                                                                    <v-select label="name" v-model="selected_telegram_id" :options="telegram_id"></v-select>
                                                                    <input type="hidden" name="telegram_id"  :value="(!selected_telegram_id)?null:selected_telegram_id.chat_id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif

                                                </div>

                                                <!-- <div class="tab-pane " id="tab3">
                                                    <div class="col-md-12" style="margin-top: 8px">
                                                    <div class="col-md-12">
                                                     
                                                    </div> 
                                                    </div>

                                                </div> -->
                                                <div class="tab-pane " id="tab4">
                                                    <!---start currency----->
                                                    <div class="col-md-12" style="margin-top: 8px">
                                                    <div class="col-md-12">
                                                        <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                            <thead>
                                                                <th style="min-width: 150px">@lang('layout.ID')</th>
                                                                <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                                <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                                <th style="min-width: 500px">@lang('layout.Amount')</th>
                                                            </thead>
                                                            <tbody>
                                                                <tr v-for="currencies in currency">
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <span>@{{currencies.id}}</span>
                                                                        
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.code}}</label>
                                                                            <input type="hidden" name="currency_code[]" :value="(!currencies)?null:currencies.code">
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.exchange_rate}}</label>
                                                                            <input type="hidden" name="currency_rate[]" :value="(!currencies)?null:currencies.exchange_rate">
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <input class="form-control" type="number" name="level[]" :value="(!currencies)?null:currencies.level">
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div> 
                                                    </div>
                                                    <!-----end currency------>
                                                </div>
                                              
                                                <div class="tab-pane" id="tab5">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Date')</label>
                                                            <div class="col-md-9">
                                                                <input type="text" id="reg_date" name="reg_date" value="{{convertDate($customer->reg_date)}}"  class="form-control date" autocomplete="off">
                                                                
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                                            <div class="col-md-9">
                                                                <input type="text" id="date_of_birth" name="date_of_birth" value="{{convertDate($customer->date_of_birth)}}"  class="form-control date" autocomplete="off">
                                                                
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane" id="tab6">
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                            <?php
                                                                $photo = null;
                                                                if($customer && $customer->photo!=null)
                                                                {
                                                                    $photo =  $customer->photo;
                                                                }
                                                            ?>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                        <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                                    </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <!-- <input type="file" name="photo">  -->
                                                                                    {!! Form::file('photo', []) !!}</span>
                                                                            {!! Form::hidden('photo1', (!$customer)?null:$customer->photo) !!}
                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Fingerprint')</label>
                                                            <?php
                                                                $fingerprint = null;
                                                                if($customer && $customer->fingerprint!=null)
                                                                {
                                                                    $fingerprint =  $customer->fingerprint;
                                                                }
                                                            ?>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                            <img src="{!!url('/uploads/fingerprint/'.$fingerprint)!!}" alt=""/>
                                                                        </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                            <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            {!! Form::file('fingerprint', []) !!}</span>
                                                                            {!! Form::hidden('fingerprint1', (!$customer)?null:$customer->fingerprint) !!}
                                                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane" id="tab7">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label col-md-3">@lang('layout.Class')</label>
                                                        <div class="col-md-9">
                                                            <select name="class" class="form-control select_style">
                                                                <option value="">کلاس را انتخاب کنید</option>
                                                                @forEach($class as $key => $value)
                                                                    <option value="{{$key}}" {{$customer-> class_id == $key ? 'selected' : ''}}>{{$value}}</option>
                                                                @endforeach
                                                            </select>
                                                            {{-- {!! Form::select('class', $class,$customer->class_id, array('class' => 'form-control select_style')) !!} --}}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.PriceLevel')</label>
                                                            <div class="col-md-9">
                                                                <v-select label="name" :options="priceLevel" v-model="selected_priceLevel" ></v-select>
                                                                <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id" >
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                                            <div class="col-md-9">
                                                              
                                                                {!! Form::select('job_title_id[]', $jobTitle,$customer->memberJobtitle, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'job_title')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                         </div>
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Site')</label>
                                                        <div class="col-md-9"> 
                                                            {!! Form::select('multy_site_id[]', $sites,$select_site, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'sites')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Gender')</label>
                                                        <div class="col-md-9" >
                                                            <div style="border: 1px dotted ;">
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="gender" :checked="'{{$customer->gender}}' == 'male'" value="male"> @lang('layout.Male') </label>
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="gender" :checked="'{{$customer->gender}}' == 'female'" value="female" >
                                                                    @lang('layout.Female') </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> 
                                                <div class="col-md-3">
                                                    <div class="form-group" >
                                                        <label class="control-label col-md-3">@lang('layout.Membership')</label>
                                                        <div class="col-md-9" >
                                                            <div style="border: 1px dotted ;">
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="membership" value="professiona" >
                                                                    @lang('layout.Professional') </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            
                                            </div> 

                                            <div class="row">
                                                <div class=""> 
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.GFname')</label>
                                                        {!! Form::text('grand_father_name', null, array('placeholder' => __('layout.GFname'),'class' => 'form-control')) !!}
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.CardOwner')</label>
                                                        {!! Form::text('card_owner', null, array('placeholder' => __('layout.CardOwner'),'class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.CardNumber')</label>
                                                        {!! Form::text('card_number', null, array('placeholder' => __('layout.CardNumber'),'class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.ShabaNumber')</label>
                                                        {!! Form::text('shaba_number', null, array('placeholder' => __('layout.ShabaNumber'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div>

                                                </div>
                                                <div class="tab-pane @if(systemConfig()[29] == 1) active @endif" id="tab8">

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.LicenseNumber')</label>
                                                                {!! Form::text('company_license_number', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                            <label class="control-label">@lang('layout.LicenseIssueDate')</label>
                                                            <input type="text"  name="license_issue_date" value="{{convertDate($customer->license_issue_date)}}"  class="form-control date" autocomplete="off">
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.LicenseExpireDate')</label>
                                                                <input type="text"  name="license_expire_date" value="{{convertDate($customer->license_expire_date)}}" class="form-control date" autocomplete="off">
                                                        </div>
                                                    </div> 
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.PassportNumber')</label>
                                                                {!! Form::text('passport', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.SSID')</label>
                                                                {!! Form::text('ss_id', null, array('class' => 'form-control')) !!}
                                                        </div> 
                                                         
                                                    
                                                    </div>  

                                
                                                <!--Begin Company Boss And Assistant Informations-->
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.BossName')</label>
                                                                {!! Form::text('boss_name', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.BossSSN')</label>
                                                                {!! Form::text('boss_ssn', null, array('class' => 'form-control')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.BossPassport')</label>
                                                                {!! Form::text('boss_passport', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                    </div>                    

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.AssistantName')</label>
                                                                {!! Form::text('assistant_name', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.AssistantSSN')</label>
                                                                {!! Form::text('assistant_ssn', null, array('class' => 'form-control')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.AssistantPassport')</label>
                                                                {!! Form::text('assistant_passport', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                <!--End Company Boss And Assistant Informations-->

                                                </div>

                                                @if(systemConfig()[16] != 0)
                                                <div class="tab-pane" id="tab9">
                                                            
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Name')</label>
                                                                {!! Form::text('gu_name', null, array('placeholder' =>__('layout.Name'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.FatherName')</label>
                                                                {!! Form::text('gu_father_name', null, array('placeholder' =>__('layout.FatherName'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label" >@lang('layout.Phone')</label>
                                                                {!! Form::text('gu_phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                    </div> 

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.Address')</label>
                                                                {!! Form::text('gu_address', null, array('placeholder' =>__('layout.Address'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.City')</label>
                                                                    {!! Form::text('gu_city', null, array('placeholder' =>__('layout.City'),'tabindex' =>'5','class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label  ">@lang('layout.Country')</label>
                                                            <v-select label="name" v-model="selectedCountry1" :options="countries"> </v-select>
                                                            <input type="hidden" name="gu_country" :value="(selectedCountry1==null)?null:selectedCountry1.name">
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.District')</label>
                                                            {!! Form::text('gu_district', null, array('placeholder' =>__('layout.District'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.Village')</label>
                                                            {!! Form::text('gu_village', null, array('placeholder' => __('layout.Village'),'class' => 'form-control')) !!}
                                                        </div>
                                                      



                                                            <?php
                                                                $gu_photo = null;
                                                                if($customer && $customer->gu_photo!=null)
                                                                {
                                                                    $gu_photo =  $customer->gu_photo;
                                                                }
                                                            ?>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                        <img src="{!!url('/uploads/'.$gu_photo)!!}" alt=""/>
                                                                    </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <!-- <input type="file" name="gu_photo">  -->
                                                                                    {!! Form::file('gu_photo', []) !!}</span>
                                                                            {!! Form::hidden('gu_photo1', (!$customer)?null:$customer->gu_photo) !!}
                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                    </div>

                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
----------------------End Other INformations--------------------------------------
------------------------------------------------------------------------------------>
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                     <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <a href="{{route('customer.index')}}" type="button" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
    Vue.component('v-select', VueSelect.VueSelect);

    var gen = {!! json_encode($customer) !!}
    
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });

    var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $customer !!};
  var member_class = {!!$class!!};
  var currency={!! json_encode($currency) !!};
  var level_info={!! json_encode($level_info) !!};

  var countries = {!!$countries!!};
  var selectedCountry = {!!$selectedCountry!!};
  var selectedCountry1 = {!!$selectedCountry1!!};

  var priceLevel = {!!$priceLevel!!};
  var selected_priceLevel = {!!$selected_priceLevel!!};
  var telegram_id = {!!$telegram_id!!};
  var riskStep = {!!$riskStep!!};
  var selectedRiskStep = {!!$selectedRiskStep!!};
//   console.log('asdf',countries, selectedCountry)
  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
        member_class:member_class,
        selectedClass:"{!!$customer->class!!}",
        currency:currency,
        level_info:level_info,
        countries:countries,
        selectedCountry:selectedCountry,
        selectedCountry1:selectedCountry1, 

        selectedRiskStep: selectedRiskStep,
        riskSteplist: riskStep,
        riskStep_id: [],
        percentage: 0,

        priceLevel:priceLevel,
        selected_priceLevel:selected_priceLevel,

        telegram_id:telegram_id,
        selected_telegram_id:null, 
        identify_type: null

    },
    watch: {
        selectedRiskStep: function(newVal, oldVal) {
            let x = [];
            let count = 0;
            let percentage = 0;
            newVal.forEach(function(e) {
                count++;
                percentage += e.percentage;
                x.push(e.id);
            });

            if (count > 0) {
                // console.log(12, count, percentage);
                this.percentage = Number.parseFloat(percentage / count).toFixed(2);
            }
            this.riskStep_id = x;
        }
    },
    mounted:function(){
        if (customer.identify_type) {
                this.identify_type = customer.identify_type;
        }
        if (customer.risk_percentage) {
                this.percentage = customer.risk_percentage;
        }

        if (selectedRiskStep) {
            let x = [];
            let count = 0;
            let percentage = 0;
            selectedRiskStep.forEach(function(e) {
                count++;
                percentage += e.percentage;
                x.push(e.id);
            });
            if (count > 0) {
                this.percentage = Number.parseFloat(percentage / count).toFixed(2);
            }
            this.riskStep_id = x;
        }

        // console.log('ffffff',customer, customer.risk_percentage)

        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
            //    if(this.receivable[j].id==this.customer.receivable_id)
            //   {
                  
            //      this.selected_receivable=this.receivable[j];
            //   }
              
          }        
          
          for(var r=0;r<this.receivable.length;r++)
          {
            //   if(this.payable[r].id==this.customer.payable_id)
            //   {
            //      this.selected_payable=this.payable[r];
            //   }
            if(this.receivable[r].id==this.customer.receivable_id)
              {
                  
                 this.selected_receivable=this.receivable[r];
              }
              
          }
         
            for(i=0;i<this.currency.length;i++)
            {
                for(m = 0; m < this.level_info.length ; m++)
                {
                if(this.level_info[m].code == this.currency[i].code)
                {
                    this.currency[i].level=this.level_info[m].amount;
                }
                }
            }

            if(this.customer.telegram_id != null)
            {
                this.selected_telegram_id = _.find(this.telegram_id, (t) =>t.chat_id == this.customer.telegram_id);
            }


          
    },

  });

//     new Vue({
//     el:'#countries',
//     data:{
//         countries:countries,
//         selectedCountry:selectedCountry
//     }
   
//   });
        $('#type').multiselect({
            //  columns: 3,
            placeholder: "@lang('layout.SelectType')"

    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });
    $('#sites').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectSite')",
    });
    
</script>
@endpush