@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <style>
        input:invalid{
            border-color: red;
        }
        .multipleClass .v-select .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .multipleClass .v-select .selected-tag > button >span{
            display: none !important;
        }
        .inputNumber{
            background-color: lightgray;
        }
        .vue-select2{
            width: 50%;
        }
    </style>
@endsection
@section('content') 
    @include('inventories.cmodal')  
    @include('inventories.modal')
    @include('customers.amodal')
    <div class="row"  id="app" v-cloak> 
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewCustomer')</span>
                    {{-- <span class="caption-helper">some info...</span> --}}
                </div>
                <div class="tools"></div>
            </div>
            <div  class="portlet-body form" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'customer.store','method'=>'POST','class'=>'form-horizontal','id'=>'member-form','files'=> true)) !!}
                    {{ csrf_field() }}
                    <div class="form-body" >
                        <div class="row" style="padding: 0px 15px;">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="border: 1px solid lightgray; padding: 5px;border-radius: 8px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.FullName')</label> 
                                    {!! Form::text('name', null, array('class' => 'form-control','tabindex' =>'1','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'))) !!} 
                                    <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.IdentifyType')</label>
                                    <select name="identify_type" id="" class="form-control" v-model="identify_type">
                                        <option value=""> @lang('layout.Select') </option>
                                        <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                        <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Code')</label>
                                    {!! Form::text('code',$code, array('tabindex' =>'2','class' => 'form-control')) !!}
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.AccountsReceivable')</label> 
                                    <div class="input-group">
                                        <v-select label="name" v-model="selected_receivable" :options="receivable">
                                        </v-select>
                                        <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                        <span class="btn btn-success  input-group-addon" @click="showcModalAccount = true, acount_type = 'accountsReceivable'" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.AccountsPayable')</label>
                                    <div class="input-group">
                                        <v-select label="name" v-model="selected_payable" :options="payable">
                                        </v-select>
                                        <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                        <span class="btn btn-success  input-group-addon" @click="showcModalAccount = true, acount_type = 'accountsPayable'" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Type')</label> 
                                    <select role="button"    name="type[]" multiple="multiple"  class="list-style form-control" id="type">
                                        @foreach($type as $key=>$value)
                                            @if($value == __('type.Customer'))
                                                <option selected value="{{$key}}">{{$value}}</option>
                                            @else
                                                <option value="{{$key}}">{{$value}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                                <div v-if="identify_type == 'IdentifyReal'" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px;">
                                    <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">  
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.PersonalInfo')</h4></th>    
                                        </tr>                       
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.FatherName')</label>
                                                    <div style="display: flex; flex-direction: column;width: 70%;">
                                                        <input type="text" name="father_name" class="form-control" v-validate='"required"' data-vv-as="{{__('layout.FatherName')}}">
                                                        {{-- {!! Form::text('father_name', null, array('class' =>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.FatherName'))) !!}   --}}
                                                        <span class="required">@{{ errors.first('father_name') }}</span>     
                                                    </div> 
                                                </div> 
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.GFname')</label>
                                                    {!! Form::text('grand_father_name', null, array('style' =>'width:70%;','class' =>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.DateOfBirth')</label>
                                                    <input type="text" id="date_of_birth" name="date_of_birth"  class="form-control date" autocomplete="off" style="width: 70%">
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Gender')</label>
                                                    <div style="width: 70%; border: 1px solid lightgray;" class="form-control">
                                                        &nbsp;<input type="radio" name="gender" checked="" value="male"> @lang('layout.Male')  &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                                                        <input type="radio" name="gender" value="female" >@lang('layout.Female') 
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr >
                                            <th style="text-align: right;background-color: white;width: 50%;" id="memberClassDiv">
                                                {{-- <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.JobTitle')</label>
                                                    <select role="button" name="job_title_id[]" multiple="multiple" class="list-style form-control" id="job_title" style="width: 70%;">
                                                        @foreach($jobTitle as $key=>$value)
                                                            @if($value == 'Customer')
                                                                <option selected value="{{$key}}">{{$value}}</option>
                                                            @else
                                                                <option value="{{$key}}">{{$value}}</option>
                                                            @endif
                                                        @endforeach
                                                    </select> 
                                                </div> --}}

                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.JobTitle') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedJobTitle" label="name" :options="jobTitle_new" :multiple="true">
                                                        </v-select>
                                                        {{-- <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null"> --}}
                                                        <input type="hidden" name="job_title_id" :value="jobTitle_id.length > 0 ? jobTitle_id:null">
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%">@lang('layout.PassportNumber')</label>
                                                    {!! Form::text('passport', null, array('tabindex' =>'3','style' =>'width:70%','autocomplete'=>'off','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr >
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%">@lang('layout.SSID')</label>
                                                    <div style="width: 70%;display: flex; flex-direction: column;">
                                                        {!! Form::text('ss_id', null, array('class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.SSID'))) !!}
                                                        <span class="required">@{{ errors.first('ss_id') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                @if (fingerprint() =='true')
                                                    <label style="width: 30%;">@lang('layout.Fingerprint')</label>
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="addfinger">
                                                        <span></span>
                                                    </label>
                                                @endif
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Contacts')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Phone')</label>
                                                    <div style="display: flex;width: 70%; flex-direction: column;">
                                                        <div style="display: flex;">
                                                            {!! Form::number('phone', null, array('tabindex' =>'4','style' =>'width:90%','class' => 'inputNumber form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Phone'))) !!}
                                                            <span class="input-group-addon" style="padding: 8px 5px 8px 40px;margin-right: 10px;" v-if="selectedCountry!=null">
                                                                @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                            </span>
                                                        </div>
                                                        <span class="required">@{{ errors.first('phone') }}</span>   
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Phone2')</label>
                                                    {!! Form::number('phone2', null, array('tabindex' =>'4','style' =>'width:70%;','class' => 'inputNumber form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Email')</label>
                                                    <div style="display: flex; flex-direction: column;width: 70%">
                                                        {!! Form::text('email', null, array('class' => 'form-control','autocomplete'=>'off','v-validate' =>'"email"','style' =>'width:100%','data-vv-as' => __('layout.Email'))) !!}
                                                        <span class="required">@{{ errors.first('email') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Date')</label>
                                                    <input type="text" id="reg_date" name="reg_date"  class="date form-control" autocomplete="off" style="width: 70%;">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Address')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Address1')</label>
                                                    <div style="display: flex;flex-direction: column; width: 70%;">
                                                        {!! Form::text('address1', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Address1'))) !!}
                                                        <span class="required">@{{ errors.first('address1') }}</span> 
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Address2')</label>
                                                    {!! Form::text('address2', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.PostCode')</label>
                                                    {!! Form::number('post_code', null, array('style' =>'width:70%','class' => 'inputNumber form-control')) !!}
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.City')</label>
                                                    {!! Form::text('city', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Country')</label>
                                                    <v-select label="name" style="width: 70%;" v-model="selectedCountry" :options="countries">
                                                    </v-select>
                                                    <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                    <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.District')</label>
                                                    {!! Form::text('district', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Village')</label>
                                                    {!! Form::text('village', null, array('style' =>'width:70%','class' => 'form-control')) !!}
                                                    </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Transaction')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.TransactionType') </label>
                                                    <input type="text" name="exchangeType" class="form-control" style="width: 70%;border: 1px solid lightgray !important;">
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.BusinessType') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <input type="text" name="businessType" class="form-control" style="border: 1px solid lightgray !important;" required v-validate='"required"' data-vv-as="{{__('layout.BusinessType')}}">
                                                        <span class="required">@{{ errors.first('businessType') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.MonetarySource') </label>
                                                    <input type="text" name="monetarySource" class="form-control" style="width: 70%;border: 1px solid lightgray !important;">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.RiskStep')</h4></th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between" v-show="riskStep_id.length > 0 &&  riskStep_id2.length > 0  &&  riskStep_id3.length > 0  &&  riskStep_id4.length > 0">
                                                    <label style="width: 30%;">@lang('layout.RiskPercentage') </label>
                                                    <input type="number" name="risk_percentage" :value="percentage" class="form-control" step="any" readonly style="width: 40%;border: 1px solid lightgray !important;">
                                                    <label v-if="percentage > 70" style="width: 30%; background-color: #ff7692; text-align: center; padding: 4px; ">@lang('type.High') </label>
                                                    <label v-if="percentage <= 70 && percentage > 30" style="width: 30%; background-color: #f5cb70; text-align: center; padding: 4px; ">@lang('type.Medium') </label>
                                                    <label v-if="percentage <= 30 && percentage > 0" style="width: 30%; background-color: #9af78d; text-align: center; padding: 4px; ">@lang('type.Low') </label>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.CustomerTypes') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep" label="name" :options="riskSteplist" :multiple="true">
                                                        </v-select>
                                                        {{-- <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null"> --}}
                                                        <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null" class="form-control" required v-validate='"required"' data-vv-as="{{__('type.CustomerTypes')}}">
                                                        <span class="required">@{{ errors.first('riskStep_id') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.ProductsAndServices') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep2" label="name" :options="riskSteplist2" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="riskStep_id2" :value="riskStep_id2.length > 0 ? riskStep_id2:null" required v-validate='"required"' data-vv-as="{{__('type.ProductsAndServices')}}" >
                                                        <span class="required">@{{ errors.first('riskStep_id2') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.DistributionChannels') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep3" label="name" :options="riskSteplist3" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="riskStep_id3" :value="riskStep_id3.length > 0 ? riskStep_id3:null" required v-validate='"required"' data-vv-as="{{__('type.DistributionChannels')}}" >
                                                        <span class="required">@{{ errors.first('riskStep_id3') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.GeographicalLocations') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep4" label="name" :options="riskSteplist4" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="riskStep_id4" :value="riskStep_id4.length > 0 ? riskStep_id4:null" required v-validate='"required"' data-vv-as="{{__('type.GeographicalLocations')}}" >
                                                        <span class="required">@{{ errors.first('riskStep_id4') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Photo')</h4></th>    
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;display: flex;background-color: white;">
                                                <label style="width: 30%;">@lang('layout.Photo')</label>
                                                <?php
                                                // $logo = null;
                                                // if($company && $company->logo!=null)
                                                // {
                                                //     $logo =  $company->logo;
                                                // }
                                                ?>
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                            <img src="#" alt=""/>
                                                        </div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"></div>
                                                        <div>
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <!-- <input type="file" name="photo">  -->
                                                            {!! Form::file('photo', []) !!}
                                                        </span>
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;">
                                                <div style="display: flex;">
                                                    <label style="width: 30%;">@lang('layout.Fingerprint')</label>
                                                    <div class="form-group">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="#" alt=""/>
                                                                </div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                                        style="max-width: 200px; max-height: 150px;"></div>
                                                                    <div>
                                                                            <span class="btn default btn-file">
                                                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                {!! Form::file('fingerprint', []) !!}</span>
                                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                                        data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Attachments')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2">
                                                <label style="width: 30%;">@lang('layout.AttachmentTitle')</label>
                                                {!! Form::text('title', null, array('class' => 'form-control','style' =>'width:60%')) !!}
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;">
                                                <label style="width: 30%;" class="col-lg-3">@lang('layout.Description')</label>
                                                {!! Form::textarea('attachmentDescription', null, array('style' =>'width:50%;resize:none;','rows'=>"8")) !!}
                                            </th>
                                            <th style="text-align: right; display: flex;background-color: white;" colspan="2">
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%; display: flex;">
                                                    <div style="width: 30%;">
                                                        <span class="btn default btn-file" style="cursor: pointer !important;">
                                                            <span class="fileinput-new" style="color: black !important; cursor: pointer !important;">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists" style="cursor: pointer !important;">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name="">
                                                            <input type="hidden" name="path" value="uploads/customer">
                                                            <input type="file" name="attchmentFile"> 
                                                        </span>
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput" style="cursor: pointer;"> @lang('layout.Remove') </a>
                                                    </div>
                                                    <div class="fileinput-new thumbnail" style="width: 50%; height: 165px;">
                                                        <img src="" alt=""> </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 90%; max-height: 165px; line-height: 10px;"></div>
                                                </div>
                                            </th>
                                        </tr>
                                    </table>
                                </div>
                                <div v-if="identify_type == 'IdentifyUnreal'" class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px;">
                                    <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">  
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.CompanyInformation')</h4></th>    
                                        </tr>  
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.LicenseNumber')</label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <input type="text" name="company_license_number" class="form-control" required v-validate='"required"' data-vv-as="{{__('layout.LicenseNumber')}}">
                                                        {{-- {!! Form::text('company_license_number', null, array('autocomplete'=>'off','class'=>'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.LicenseNumber'))) !!}  --}}
                                                        <span class="required">@{{ errors.first('company_license_number') }}</span>  
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.LicenseIssueDate')</label>
                                                    <input type="text"  name="license_issue_date"  class="date form-control" autocomplete="off" style="width: 70%;">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.LicenseExpireDate')</label>
                                                    <input type="text"  name="license_expire_date"  class="date form-control" style="width: 70%;" autocomplete="off">
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.BossName')</label>
                                                    {{-- {!! Form::text('boss_name', null, array('tabindex' =>'3','style' =>'width:70%','autocomplete'=>'off','class'=>'form-control')) !!} --}}
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <input type="text" name="boss_name" class="form-control" required v-validate='"required"' data-vv-as="{{__('layout.BossName')}}">
                                                        <span class="required">@{{ errors.first('boss_name') }}</span> 
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.BossSSN')</label>
                                                    {!! Form::text('boss_ssn', null, array('style' => 'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.BossPassport')</label>
                                                    {!! Form::text('boss_passport', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.AssistantName')</label>
                                                    {!! Form::text('assistant_name', null, array('tabindex' =>'3','style' => 'width:70%','autocomplete'=>'off','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.AssistantSSN')</label>
                                                    {!! Form::text('assistant_ssn', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.AssistantPassport')</label>
                                                    {!! Form::text('assistant_passport', null, array('style' => 'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                @if (fingerprint() =='true')
                                                    <label style="width: 30%;">@lang('layout.Fingerprint')</label>
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="addfinger">
                                                        <span></span>
                                                    </label>
                                                @endif
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Contacts')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Phone')</label>
                                                    <div style="width: 70%; display: flex;flex-direction: column;">
                                                        {{-- {!! Form::number('phone', null, array('tabindex' =>'4','style' =>'width:100%','class' => 'inputNumber form-control')) !!} --}}
                                                        <div style="display: flex;">
                                                            <input type="text" name="phone" class="form-control inputNumber" required v-validate='"required"' data-vv-as="{{__('layout.Phone')}}">
                                                            <span class="input-group-addon" style="padding: 8px 5px 8px 40px;margin-right: 10px;" v-if="selectedCountry!=null">
                                                                @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                            </span>
                                                        </div>
                                                        <span class="required">@{{ errors.first('phone') }}</span> 
                                                    </div>

                                                    {{-- <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <input type="text" name="boss_name" class="form-control" required v-validate='"required"' data-vv-as="{{__('layout.BossName')}}">
                                                        <span class="required">@{{ errors.first('boss_name') }}</span> 
                                                    </div> --}}
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Phone2')</label>
                                                    {!! Form::number('phone2', null, array('tabindex' =>'4','style' =>'width:70%;','class' => 'inputNumber form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Email')</label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        {!! Form::text('email', null, array('class' => 'form-control','autocomplete'=>'off','v-validate' =>'"email"','style' =>'width:100%','data-vv-as' => __('layout.Email'))) !!}
                                                        <span class="required">@{{ errors.first('email') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Date')</label>
                                                    <input type="text" id="reg_date" name="reg_date"  class="date form-control" autocomplete="off" style="width: 70%;">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Address')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Address1')</label>
                                                    {{-- {!! Form::text('address1', null, array('tabindex' =>'3','style' =>'width:70%','autocomplete'=>'off','class'=>'form-control')) !!} --}}
                                                    <div style="display: flex; flex-direction: column;width: 70%;">
                                                        <input type="text" name="address1" class="form-control" required v-validate='"required"' data-vv-as="{{__('layout.Address1')}}">
                                                        <span class="required">@{{ errors.first('address1') }}</span> 
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Address2')</label>
                                                    {!! Form::text('address2', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.PostCode')</label>
                                                    {!! Form::number('post_code', null, array('style' =>'width:70%','class' => 'inputNumber form-control')) !!}
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.City')</label>
                                                    {!! Form::text('city', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Country')</label>
                                                    <v-select label="name" style="width: 70%;" v-model="selectedCountry" :options="countries">
                                                    </v-select>
                                                    <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                    <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.District')</label>
                                                    {!! Form::text('district', null, array('class' => 'form-control','style' =>'width:70%')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.Village')</label>
                                                    {!! Form::text('village', null, array('style' =>'width:70%','class'=>'form-control')) !!}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Transaction')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.TransactionType') </label>
                                                    <input type="text" name="exchangeType" class="form-control" style="width: 70%;border: 1px solid lightgray !important;">
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.BusinessType') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <input type="text" name="businessType" class="form-control" required v-validate='"required"' data-vv-as="{{__('layout.BusinessType')}}">
                                                        <span class="required">@{{ errors.first('businessType') }}</span> 
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('layout.MonetarySource') </label>
                                                    <input type="text" name="monetarySource" class="form-control" style="width: 70%;border: 1px solid lightgray !important;">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.RiskStep')</h4></th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div style="display: flex; justify-content: space-between" v-show="riskStep_id.length > 0 &&  riskStep_id2.length > 0  &&  riskStep_id3.length > 0  &&  riskStep_id4.length > 0">
                                                    <label style="width: 30%;">@lang('layout.RiskPercentage') </label>
                                                    <input type="number" name="risk_percentage" :value="percentage" class="form-control" step="any" readonly style="width: 40%;border: 1px solid lightgray !important;">
                                                    <label v-if="percentage > 70" style="width: 30%; background-color: #ff7692; text-align: center; padding: 4px; ">@lang('type.High') </label>
                                                    <label v-if="percentage <= 70 && percentage > 30" style="width: 30%; background-color: #f5cb70; text-align: center; padding: 4px; ">@lang('type.Medium') </label>
                                                    <label v-if="percentage <= 30 && percentage > 0" style="width: 30%; background-color: #9af78d; text-align: center; padding: 4px; ">@lang('type.Low') </label>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.CustomerTypes') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep" label="name" :options="riskSteplist" :multiple="true">
                                                        </v-select>
                                                        {{-- <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null"> --}}
                                                        <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null" class="form-control" required v-validate='"required"' data-vv-as="{{__('type.CustomerTypes')}}">
                                                        <span class="required">@{{ errors.first('riskStep_id') }}</span> 
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.ProductsAndServices') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep2" label="name" :options="riskSteplist2" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="riskStep_id2" :value="riskStep_id2.length > 0 ? riskStep_id2:null" required v-validate='"required"' data-vv-as="{{__('type.ProductsAndServices')}}">
                                                        <span class="required">@{{ errors.first('riskStep_id2') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.DistributionChannels') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep3" label="name" :options="riskSteplist3" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="riskStep_id3" :value="riskStep_id3.length > 0 ? riskStep_id3:null" required v-validate='"required"' data-vv-as="{{__('type.DistributionChannels')}}">
                                                        <span class="required">@{{ errors.first('riskStep_id3') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                            <th style="text-align: right;background-color: white;width: 50%;">
                                                <div class="multipleClass" style="display: flex; justify-content: space-between">
                                                    <label style="width: 20%;">@lang('type.GeographicalLocations') </label>
                                                    <div style="display: flex; flex-direction: column; width: 70%;">
                                                        <v-select class="vue-select2" style="width: 100%" v-model="selectedRiskStep4" label="name" :options="riskSteplist4" :multiple="true">
                                                        </v-select>
                                                        <input type="hidden" name="riskStep_id4" :value="riskStep_id4.length > 0 ? riskStep_id4:null" required v-validate='"required"' data-vv-as="{{__('type.GeographicalLocations')}}">
                                                        <span class="required">@{{ errors.first('riskStep_id4') }}</span>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Attachments')</h4></th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;" colspan="2">
                                                <label style="width: 30%;">@lang('layout.AttachmentTitle')</label>
                                                {!! Form::text('title', null, array('class' => 'form-control','style' =>'width:60%')) !!}
                                            </th>
                                        </tr>
                                        <tr>
                                            <th style="text-align: right;background-color: white;">
                                                <label style="width: 30%;" class="col-lg-3">@lang('layout.Description')</label>
                                                {!! Form::textarea('attachmentDescription', null, array('style' =>'width:50%;resize:none;','rows'=>"8")) !!}
                                            </th>
                                            <th style="text-align: right; display: flex;background-color: white;" colspan="2">
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%; display: flex;">
                                                    <div style="width: 30%;">
                                                        <span class="btn default btn-file" style="cursor: pointer !important;">
                                                            <span class="fileinput-new" style="color: black !important; cursor: pointer !important;">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists" style="cursor: pointer !important;">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name="">
                                                            <input type="hidden" name="path" value="uploads/customer">
                                                            <input type="file" name="attchmentFile"> 
                                                        </span>
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput" style="cursor: pointer;"> @lang('layout.Remove') </a>
                                                    </div>
                                                    <div class="fileinput-new thumbnail" style="width: 50%; height: 165px;">
                                                        <img src="" alt=""> </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 90%; max-height: 165px; line-height: 10px;"></div>
                                                </div>
                                            </th>
                                        </tr>
                                    </table>
                                    <table id="table_content" class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th style="text-align: right;background-color: white;" colspan="7"><h4 style="background-color: rgb(232, 180, 180);width: fit-content;padding: 12px;">@lang('layout.Shareholder_Agent')</h4></th>
                                            </tr>
                                            <tr v-for="(item,index) in shareholders">
                                                <td style="display: flex;justify-content: space-between;background-color: white;">
                                                    <label>@lang('layout.Name')</label>&nbsp;
                                                    <input type="text" name="shareholder_name[]" class="form-control" style="width: 65%;">
                                                </td>
                                                <td style="background-color: white;">
                                                    <div style="display: flex;justify-content: space-between">
                                                        <label>@lang('layout.FatherName')</label>&nbsp;
                                                        <input type="text" name="shareholder_fathername[]" class="form-control" style="width: 65%;">
                                                    </div>
                                                </td>
                                                <td style="background-color: white;">
                                                    <div style="display: flex;justify-content: space-between">
                                                        <label>@lang('layout.Address')</label>&nbsp;
                                                        <input type="text" name="shareholder_address[]" class="form-control" style="width: 65%;">
                                                    </div>
                                                </td>
                                                <td style="background-color: white;">
                                                    <div style="display: flex;justify-content: space-between">
                                                        <label>@lang('layout.Phone')</label>&nbsp;
                                                        <input type="text" name="shareholder_phone_number[]" class="form-control" style="width: 65%;">
                                                    </div>
                                                </td>
                                                <td style="background-color: white;">
                                                    <div style="display: flex;justify-content: space-between">
                                                        <label>@lang('layout.Email')</label>&nbsp;
                                                        <input type="text" name="shareholder_email[]" class="form-control" style="width: 65%;">
                                                    </div>
                                                </td>
                                                <td style="background-color: white;">
                                                    <div style="display: flex;justify-content: space-between">
                                                        <label>@lang('layout.PassportNumber')</label>&nbsp;
                                                        <input type="text" name="shareholder_passport_number[]" class="form-control" style="width: 60%;">
                                                    </div>
                                                </td>
                                                <td style="background-color: white;">
                                                    <div style="display: flex;justify-content: space-between">
                                                        <label>@lang('layout.Type')</label>&nbsp;
                                                        <select name="shareholderType[]" class="form-select form-control">
                                                            <option value=""> @lang('layout.Select') </option>
                                                            <option value="shareholder">@lang('layout.Shareholder')</option>
                                                            <option value="agent">@lang('layout.Agent')</option>
                                                        </select>
                                                        {{-- <input type="text" name="shareholder_passport_number[]" class="form-control" style="width: 65%;"> --}}
                                                    </div>
                                                </td>
                                                <td colspan="6" style="text-align: right;background-color: white;">
                                                    <button type="button" @click="deleteItem1('shareholder')" class="btn btn-danger">
                                                        <i class="fa fa-minus"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #ffffff;border: none;">
                                                <td colspan="7">
                                                    <center>
                                                        <button type="button" @click="addNew1('shareholder',1000)" class="btn btn-success">
                                                            <i class="fa fa-plus"></i>
                                                        </button>
                                                    </center>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div> 
                        </div>
                        <br>
                        <!----------------------------------------------------------------------------------
                        ------------------------------------------------------------------------------------
                        ----------------------Begin Other INformations--------------------------------------
                        ------------------------------------------------------------------------------------>
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN TAB PORTLET-->
                                <div class="portlet light bordered">
                                    
                                    <div class="portlet-body">
                                        <div class="tabbable tabbable-tabdrop">
                                            <ul class="nav nav-pills">
                                                <li class="">
                                                    <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                                </li> 
                                                <li class="">
                                                    <a href="#tab3" data-toggle="tab" aria-expanded="false"><i class="fa fa-money"></i> @lang('layout.OpeningBalance')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab4" data-toggle="tab" aria-expanded="true"><i class="fa fa-warning"></i> @lang('layout.RiskManagement')</a>
                                                </li>
                                                @if(ShowSaveTempItemToCustomer() == "true")
                                                <li class="">
                                                    <a href="#tab-item" data-toggle="tab" aria-expanded="false"><i class="fa fa-list-alt"></i> @lang('layout.OnHandItems')</a>
                                                </li>
                                                @endif
                                                @if(systemConfig()[16] != 0)
                                                <li class="">
                                                    <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-user"></i> @lang('layout.Guarantor')</a>
                                                </li>
                                                @endif
                                                <li v-if="identify_type == 'IdentifyUnreal'">
                                                    <a href="#tab10" data-toggle="tab" aria-expanded="false"><i class="fa fa-user"></i> @lang('layout.PersonalInfo')</a>
                                                </li>
                                                <li v-if="identify_type == 'IdentifyReal'">
                                                    <a href="#tab11" data-toggle="tab" aria-expanded="false"><i class="fa fa-user"></i> @lang('layout.CompanyInformation')</a>
                                                </li>
                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane " id="tab3">
                                                    <!---start currency----->
                                                    <div class="col-md-12" style="margin-top: 8px">
                                                    <div class="col-md-12">
                                                        <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                            <thead>
                                                                <th style="min-width: 150px">@lang('layout.ID')</th>
                                                                <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                                <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                                <th style="min-width: 300px">@lang('layout.Receivable')</th>
                                                                <th style="min-width: 300px">@lang('layout.Payable')</th>
                                                                <th style="min-width: 300px">@lang('layout.Description')</th>
                                                            </thead>
                                                            <tbody>
                                                                <tr v-for="(currencies,index) in currency">
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <span>@{{currencies.id}}</span>
                                                                        
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.code}}</label>
                                                                            <input type="hidden" :name="'op_currency_code['+index+']'" :value="(!currencies)?null:currencies.code" />
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                            <input type="number" :name="'op_currency_rate['+index+']'" v-model="(!currencies)?null:currencies.exchange_rate"  :readonly="(!currencies)?null:currencies.code == defaultCurrency()['code']" class="form-control" />
                                                                    </td>
                                                                    <td class="hilight">
                                                                                <input type="number" :name="'op_receivable['+index+']'" class="form-control" :disabled="!!currencies.payable"
                                                                                    v-model.number="currencies.receivable" />
                                                                                
                                                                                <input type="hidden" :name="'op_type['+index+']'" class="form-control"
                                                                                    :value="(currencies.payable && currencies.payable !=null && currencies.payable !=0)?'payable':(currencies.receivable && currencies.receivable !=null && currencies.receivable !=0)?'receivable':''">
                                                                    </td>
                                                                    <td class="hilight">
                                                                            <input type="number" :name="'op_payable['+index+']'" class="form-control" :disabled="!!currencies.receivable"
                                                                                v-model.number="currencies.payable" />
                                                                        </td>
                                                                        <td class="hilight">
                                                                            <textarea name="descriptionTwo[]" id="" cols="30" rows="1" class="form-control"></textarea>

                                                                        </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div> 
                                                    </div>
                                                    <!-----end currency------>

                                                </div>

                                                <div class="tab-pane " id="tab4">
                                                    <!---start currency----->
                                                    <div class="col-md-12" style="margin-top: 8px">
                                                    <div class="col-md-12">
                                                        <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                            <thead>
                                                                <th style="min-width: 150px">@lang('layout.ID')</th>
                                                                <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                                <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                                <th style="min-width: 500px">@lang('layout.Amount')</th>
                                                            </thead>
                                                            <tbody>
                                                                <tr v-for="currencies in currency">
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <span>@{{currencies.id}}</span>
                                                                        
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.code}}</label>
                                                                            <input type="hidden" name="currency_code[]" :value="(!currencies)?null:currencies.code">
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <label>@{{currencies.exchange_rate}}</label>
                                                                            <input type="hidden" name="currency_rate[]" :value="(!currencies)?null:currencies.exchange_rate">
                                                                        </div>
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <div class="input-group">
                                                                            <input class="form-control" type="number" name="level[]">
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div> 
                                                    </div>
                                                    <!-----end currency------>
                                                </div>

                                                <!---start OnHand Items----->
                                                <div class="tab-pane " id="tab-item">
                                                    <div class="col-md-12" style="margin-top: 8px">
                                                        <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                            <thead>
                                                            <th>#</th>
                                                            <th style="min-width: 130px; text-align:center;">@lang('layout.ItemName') </th>
                                                            <th style="min-width: 130px; text-align:center;">@lang('layout.Site') </th>
                                                            <th style="min-width: 100px; text-align:center;">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 100px; text-align:center;">@lang('layout.Measure') </th>
                                                            <th></th>
                                                            </thead>
                                                            <tbody>
                                                                <tr v-for="(item,index) in inventories">
                                                                    <td>@{{index+1}}</td>
                                                                    <td class="highlight">
                                                                        <v-select label="name" v-model="item.item" :options="temp_items" @search="onItemSearch"></v-select>
                                                                        <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                    </td>
                                                                    <td class="highlight">
                                                                        <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                            <option value="null">@lang('layout.Select')</option>
                                                                            <span v-if="(item.item != null)">
                                                                                <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                                    @{{site.name}}
                                                                                </option>
                                                                            </span>
                                                                        </select>
                                                                        <input type="hidden" :name="'site_id['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.id)">
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                                    </td>
                                                                    <td class="highlight">
                                                                        <select v-model="(item.item == null)?null:item.item.measure" class="form-control">
                                                                            <option value="null">@lang('layout.Select')</option>
                                                                            <span v-if="(item.item ==null)?false:true">
                                                                                <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                                    @{{measure.measure_name}}
                                                                                </option>
                                                                            </span>
                                                                        </select>
                                                                        <input type="hidden" :name="'inventory_measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                                    </td>
                                                                    <td>
                                                                        <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                                    </td>
                                                                </tr>
                                                                <tr style="background-color: #ffffff;">
                                                                    <td></td>
                                                                    <td>
                                                                        <center>
                                                                            <button type="button" @click="addNew('inventory',100)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                                        </center>
                                                                    </td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-----end OnHand Items------>
                                                <div class="tab-pane " id="tab8">                      
                                                    <div class="row">
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-4" id="memberClassDiv">
                                                                <label class="control-label">@lang('layout.Class')</label>
                                                                <select name="class" class="form-control" style="outline:1px solid #c2cad8 !important">
                                                                    <option  value="">@lang('layout.SelectClass')</option> 
                                                                        @foreach($class AS $rec)
                                                                            <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                                        @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                {!! Form::text('ref_no',null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" rows="1" class="form-control"></textarea>   
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            @if(getTelegramBot()=="true")
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('layout.TelegramID')</label>
                                                                <v-select label="name" v-model="selected_telegram_id" :options="telegram_id"></v-select>
                                                                <input type="hidden" name="telegram_id"  :value="(!selected_telegram_id)?null:selected_telegram_id.chat_id">
                                                            </div>
                                                            @endif
                                                            @if(getActiveSale() == "true")
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('layout.FreeCardTimes')</label> 
                                                                <input type="number" name="free_card_times" class="form-control">
                                                            </div>
                                                            @endif
                                                        </div>
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-4" id="memberClassDiv">
                                                                <label class="control-label">@lang('layout.PriceLevel')</label>
                                                                <v-select label="name" :options="priceLevel" v-model="selected_priceLevel" ></v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id" >
                                                            </div> 
                                                            <div class="col-md-4" id="memberClassDiv">
                                                                <label class="control-label">@lang('layout.Membership')</label>
                                                                <div style="border: 1px dotted ;">
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="professiona" >
                                                                        @lang('layout.Professional') </label>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4" id="memberClassDiv">
                                                                <label class="control-label">@lang('layout.Site')</label>
                                                                <select role="button" name="multy_site_id[]" multiple="multiple"  class="list-style form-control" id="sites">
                                                                    @foreach($sites as $key=>$value)
                                                                        <option value="{{$key}}">{{$value}}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.CardOwner')</label>
                                                                {!! Form::text('card_owner', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.CardNumber')</label>
                                                                {!! Form::text('card_number', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.ShabaNumber')</label>
                                                                {!! Form::text('shaba_number', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @if(systemConfig()[16] != 0)
                                                <div class="tab-pane" id="tab9">    
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <label class="control-label">@lang('layout.Name')</label>
                                                            {!! Form::text('gu_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.FatherName')</label>
                                                                {!! Form::text('gu_father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label" >@lang('layout.Phone')</label>
                                                                {!! Form::text('gu_phone', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                    </div> 

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.Address')</label>
                                                                {!! Form::text('gu_address', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.City')</label>
                                                                    {!! Form::text('gu_city', null, array('tabindex' =>'5','class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label  ">@lang('layout.Country')</label>
                                                            <v-select label="name" v-model="selectedCountry1" :options="countries"> </v-select>
                                                            <input type="hidden" name="gu_country" :value="(selectedCountry1==null)?null:selectedCountry1.name">
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-4" style="border: 1px solid red;">
                                                            <label class="control-label ">@lang('layout.District')</label>
                                                            {!! Form::text('gu_district', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.Village')</label>
                                                            {!! Form::text('gu_village', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                        <div class="form-group">
                                                                <label class="control-label col-md-2">@lang('layout.Photo')</label>
                                                                <div class="col-md-8">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="padding-top: 7px;"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                        <img src="#" alt=""/>
                                                                        </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <!-- <input type="file" name="photo">  -->
                                                                                    {!! Form::file('gu_photo', []) !!}</span>
                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                @endif
                                                <div class="tab-pane" id="tab10" v-if="identify_type == 'IdentifyUnreal'">
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.FatherName')</label>
                                                            {{-- {!! Form::text('father_name', null, array('class' =>'form-control')) !!}  --}}
                                                            <input type="text" name="father_name" class="form-control">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.GFname')</label>
                                                            {!! Form::text('grand_father_name', null, array('class' =>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                            <input type="text" id="date_of_birth" name="date_of_birth"  class="form-control date" autocomplete="off">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.Gender')</label><br>
                                                            <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male')  &nbsp;
                                                            <input type="radio" name="gender" value="female" >@lang('layout.Female') 
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            {{-- <label class="control-label">@lang('layout.JobTitle')</label>
                                                            <select role="button" name="job_title_id[]" multiple="multiple" class="list-style form-control" id="job_title">
                                                                @foreach($jobTitle as $key=>$value)
                                                                    @if($value == 'Customer')
                                                                        <option selected value="{{$key}}">{{$value}}</option>
                                                                    @else
                                                                        <option value="{{$key}}">{{$value}}</option>
                                                                    @endif
                                                                @endforeach
                                                            </select>  --}}
                                                            <div class="multipleClass">
                                                                <label class="control-label">@lang('layout.JobTitle') </label>
                                                                <v-select class="vue-select2" style="width: 100%" v-model="selectedJobTitle" label="name" :options="jobTitle_new" :multiple="true">
                                                                </v-select>
                                                                {{-- <input type="hidden" name="riskStep_id" :value="riskStep_id.length > 0 ? riskStep_id:null"> --}}
                                                                <input type="hidden" name="job_title_id" :value="jobTitle_id.length > 0 ? jobTitle_id:null">
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.PassportNumber')</label>
                                                            {!! Form::text('passport', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.SSID')</label>
                                                            {!! Form::text('ss_id', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            @if (fingerprint() =='true')
                                                                <label class="control-label">@lang('layout.Fingerprint')</label>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="addfinger">
                                                                    <span></span>
                                                                </label>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane" id="tab11" v-if="identify_type == 'IdentifyReal'">
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.LicenseNumber')</label>
                                                            {!! Form::text('company_license_number', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.LicenseIssueDate')</label>
                                                            <input type="text"  name="license_issue_date"  class="date form-control" autocomplete="off">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.LicenseExpireDate')</label>
                                                            <input type="text"  name="license_expire_date"  class="date form-control" autocomplete="off">
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.BossName')</label>
                                                            {!! Form::text('boss_name', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.BossSSN')</label>
                                                            {!! Form::text('boss_ssn', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.BossPassport')</label>
                                                            {!! Form::text('boss_passport', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.AssistantName')</label>
                                                            {!! Form::text('assistant_name', null, array('tabindex' =>'3','autocomplete'=>'off','class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.AssistantSSN')</label>
                                                            {!! Form::text('assistant_ssn', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <label class="control-label">@lang('layout.AssistantPassport')</label>
                                                            {!! Form::text('assistant_passport', null, array('class'=>'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            @if (fingerprint() =='true')
                                                                <label class="control-label">@lang('layout.Fingerprint')</label>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="addfinger">
                                                                    <span></span>
                                                                </label>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                        <!----------------------------------------------------------------------------------
                        ------------------------------------------------------------------------------------
                        ----------------------End Other INformations--------------------------------------
                        ------------------------------------------------------------------------------------>
                        <!-- <div class="row">
                            <div class="col-md-6">
                                <div id="my_camera"></div>
                                <br>
                                <input type="button" value="Take Snapshot" onclick="take_snapshot()">
                                <input type="hidden" name="image" class="image-tag">
                            </div> 
                            
                            <div class="col-md-6">
                                <div id="results">Your Image</div>
                            </div>
                        </div> -->
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        <!-- <button type="button" onClick="regForm(this)" class="btn green">@lang('layout.Submit')</button> -->
                                        <button type="button"  @click="handleSubmit($event)"  class="btn green" tabindex ='6'>@lang('layout.Submit')</button>
                                        <button type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                        <a href="{{route('customer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6"></div>
                        </div>
                    </div>
                {!! Form::close() !!}
                <!-- END FORM-->
                <!--******************************************************************************************
                **************************Begin Add New Account Form Modal************************************
                **********************************************************************************************-->
                {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                    {{ csrf_field() }}                                        
                    <amodal :show="showcModalAccount" @close="showcModalAccount = false">
                        <h3 slot='cheader'>@lang('layout.CreateNewAccountStep')</h3>
                        <div slot="cbody">
                        @if(getAccountNumber()=="true")
                            <label class="cform-label" for="name">@lang('layout.AccountNumber'):</label>
                            <input type="number" name="number" class="cform-control"  v-model="numberAcc"  autocomplete="off">
                            <span class="required">@{{account_errors.number}}</span>
                        @endif
                        <label class="cform-label" for="name">@lang('layout.AccountName'):</label>
                        {{Form::text('name','null',['class' => 'cform-control','v-model'=>'nameAcc','autocomplete'=>'off'])}}
                        <span class="required">@{{account_errors.name}}</span>
                        {{--<label class="cform-label" for="name">@lang('layout.AccountType'):</label>
                        <select name="type" v-model="typeAcc" class="form-control">
                            <option value="income">@lang('layout.Income')</option>
                            <option value="costOfGoodSold">@lang('layout.CostOfGoodSold')</option>
                            <option value="otherCurrentAsset">@lang('layout.OtherCurrenctAsset')</option>
                        </select>--}}
                        {{--<label class="cform-label" for="parent">@lang('layout.ParentID'):</label>
                        {{Form::select('parent_id',$parent,Null,['class' => 'cform-control','placeholder' => __('layout.SelectParent'),'v-model'=>'parentAcc'])}}--}}
                        <label class="cform-label" for="description">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('class' => 'cform-control','rows' => 4, 'cols' => 30,'v-model'=>'descriptionAcc')) !!}
                        </div>
                        <div slot="cfooter">
                            <button type="button" class="modal-default-button btn btn-success" @click="saveAccount">
                                @lang('layout.Submit')
                            </button>
                        </div>
                    </amodal>
                {!! Form::close() !!}
                <!--******************************************************************************************
                ************************** End Add New Account Form Modal*************************************
                **********************************************************************************************-->  
            </div>
        </div>
    </div>
@endsection
@push('scripts')
<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
      Vue.component('v-select', VueSelect.VueSelect);
    var Modal = Vue.component('cmodal',
    {
        template:'#cmodal-template',
        props: ['show'],
    });
        Vue.component('modal', {
        template: '#vendor-template'
    })
    Vue.component('modal', {
        template: '#modal-template'
    })
    Vue.component('amodal', {
      template: '#amodal-template',
      props: ['show']
    });
    var receivable={!! $receivable !!};
    var payable={!! $payable !!};
    var currency={!! json_encode($currency) !!};
    var countries = {!!$countries!!};
    var priceLevel = {!!$priceLevel!!};
    var telegram_id = {!!$telegram_id!!};
    var riskStep1 = {!!$riskStep1!!};
    var jobTitle_new = {!!json_encode($jobTitle_new)!!};
    var riskStep2 = {!!$riskStep2!!};
    var riskStep3 = {!!$riskStep3!!};
    var riskStep4 = {!!$riskStep4!!};
    var vu = new Vue({
        el:'#app',
        data:{
            payable:payable,
            selected_payable:null,
            receivable:receivable,
            selected_receivable:null,
            currency:currency,
            priceLevel:priceLevel,
            selected_priceLevel:null,
            telegram_id:telegram_id,
            selected_telegram_id:null,
            selectedRiskStep: null,
            selectedJobTitle: null,
            jobTitle_id: [],
            jobTitle_new: jobTitle_new,
            riskSteplist: riskStep1,
            riskStep_id: [],
            selectedRiskStep2: null,
            riskSteplist2: riskStep2,
            riskStep_id2: [],
            selectedRiskStep3: null,
            riskSteplist3: riskStep3,
            riskStep_id3: [],
            selectedRiskStep4: null,
            riskSteplist4: riskStep4,
            riskStep_id4: [],
            percentage: 0,
            countries:countries,
            selectedCountry:{
                id:'Afghanistan',
                name:'Afghanistan',
                dial_code:'0093'
            },
            selectedCountry1:{
                id:'Afghanistan',
                name:'Afghanistan',
                dial_code:'0093'
            },
            showcModal: false,
            errorMessage: '',
            fieldErrors: [],
            className: null,
            description: null,
            showcModalAccount: false,
            disabled: false,
            //Begin Account Modal
            nameAcc: null,
            numberAcc: null,
            typeAcc: null,
            // parentAcc: null,
            descriptionAcc: null,
            acount_type:'',
            account_errors: '',
            account_success: '',
            temp_items: [],
            //End Account Modal
            inventories: [{
                inventory: null,
                item: null
            }, ],
            shareholders: [{
                shareholder: null,
            },],
            identify_type:"IdentifyReal"
        },
        watch: {
            selectedRiskStep: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.percentages();
                this.riskStep_id = x;
            },
            selectedRiskStep2: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.percentages();
                this.riskStep_id2 = x;
            },
            selectedRiskStep3: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.percentages();
                this.riskStep_id3 = x;
            },
            selectedRiskStep4: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.percentages();
                this.riskStep_id4 = x;
            },
            selectedJobTitle: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.jobTitle_id = x;
            }
        },
        methods:{
            percentages() {
                // console.log(123, this.selectedRiskStep);
                let count = 0;
                let percentage = 0;
                if (this.selectedRiskStep) {
                    this.selectedRiskStep.forEach(function(e) {
                        count++;
                        percentage += e.percentage;
                    });
                }
                if (this.selectedRiskStep2) {
                    this.selectedRiskStep2.forEach(function(e) {
                        count++;
                        percentage += e.percentage;
                    });
                }
                if (this.selectedRiskStep3) {
                    this.selectedRiskStep3.forEach(function(e) {
                        count++;
                        percentage += e.percentage;
                    });
                }
                if (this.selectedRiskStep4) {
                    this.selectedRiskStep4.forEach(function(e) {
                        count++;
                        percentage += e.percentage;
                    });
                }
                if (count > 0) {
                    this.percentage = Number.parseFloat(percentage / count).toFixed(2);
                } else {
                    this.percentage = 0;
                }
            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        regForm(e.target);
                    }
                });
            },
            // begin item search
            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'itemesSearchSimple',
                        keyword: search
                    }
                })
                .then(function(response) {
                    vu.temp_items = [];
                    if (response.data.length > 0) {
                        vu.temp_items = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                }) 
                loading(false);
            }, getDebounceTime()),
            // generic function for adding item to list
            addNew(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        // console.log(this.inventories);
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null
                            });
                        }
                    }
                }
            },
            addNew1(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'shareholder') {
                        // console.log(this.shareholders);
                        if (this.shareholders[index + 1] == undefined) {
                            this.temp_items = [];
                            this.shareholders.push({
                                shareholder: null,
                            });
                        }
                    }
                }
            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }
                }
            },
            // delete item from list
            deleteItem1(type = null, index) {
                if (type != null) {
                    if (type == 'shareholder') {
                        this.shareholders.splice(index, 1);
                    }
                }
            },
            //Function to add MemberCLass
            addClass(){
                axios.post("{{route('memberClass.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    this.className = null;
                    this.description = null;
                    location.reload();
                });
                this.showcModal = false;
            },
            saveAndNew() {
                this.$validator.validate()
                .then(valid => {
                    if (valid) {
                        vu.disabled = true;
                        var url = "{{route('customer.store')}}";
                        form_id = 'member-form';
                        var data = $('#' + form_id).serialize();
                        toggleBlock(true);
                        axios.post(url, data)
                        .then(function (response) {
                            toggleBlock(0);
                            if (response.data.result == 1) {
                                $('#' + form_id).trigger('reset');
                                //$('#success-sound')[0].play();
                                toastr.success('', response.data.message);
                                location.reload();
                            }
                            else {
                                var message = "{{__('message.Warning')}}";
                                vu.disabled = false;
                                toastr.warning('', message);
                            }
                        })
                        .catch(function (error) {
                            toggleBlock(0);
                            vu.disabled = false;
                            console.log(error);
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        });
                    }
                })
            },
            saveAccount: function () {
                if(this.numberAcc != null)
                {
                var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,number:this.numberAcc,add: true};
                }
                else{
                    var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,add: true};
                }
                var req = axios.post("{{route('account.addAccount')}}",test)
                .then(function (response) {
                    if (response) {
                        if(response.data.account.type == "accountsReceivable"){
                            vu.selected_receivable = response.data.account;
                        } if(response.data.account.type == "accountsPayable"){
                            vu.selected_payable = response.data.account;
                        } 
                        vu.account_success = response.data.message;
                        if(vu.account_success)
                        {
                            toastr.success(vu.account_success)
                        }
                        vu.showcModalAccount = false;
                        vu.nameAcc           = null,
                        vu.numberAcc           = null,
                        vu.descriptionAcc    = null,
                        vu.typeAcc           = null;
                        vu.acount_type       = '';   
                    }
                })
                .catch(function (error) {
                    vu.account_errors = error.response.data.errors;
                });
            },
        },
        mounted:function(){
            if(this.payable)
            {
                this.selected_payable=this.payable[0];
            }
            if(this.receivable)
            {
                this.selected_receivable=this.receivable[0];
            }
        }
    });  
    $('#type').multiselect({
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        placeholder: "@lang('layout.SelectJobTitle')",
    });
    $('#sites').multiselect({
        placeholder: "@lang('layout.SelectSite')",
    });
</script>
@endpush