﻿@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferBill')</h3>
    <table class="main-table">

        <tr>
             <th> @lang('layout.WayBillNumber')</th> 
            <th> @lang('layout.PlateNumber')</th> 
            <th> @lang('layout.TotalQty')</th> 
            <th> @lang('layout.Driver')</th>

            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Accountant')</th>
        </tr>
        <tr>
             <td class="hidden-xs"> {{ $transfer->way_bill_number}}  </td>
            <td class="hidden-xs"> {{ $transfer->plate_number}}  </td>
            <td class="hidden-xs"> {{ $transfer->total_bori}}  </td>
            <td class="hidden-xs"> {{ $transfer->name}}  </td>
            <td align="center">{{$transfer->id}}</td>
            <td align="center">{{convertDate($transfer->Date)}}</td>
            <td align="center">{{$user}}</td>
        </tr>

    </table>

    <br>





    <table class="main-table">
        <thead>
        <tr>
            <th> @lang('layout.Item') </th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Unit/M')</th>
            <th>@lang('layout.FromSite')</th>
            <th>@lang('layout.ToSite')</th>

        </tr>
        </thead>
        <tbody>
        @foreach($transferDetail as $key )
            <tr>
                <td>
                    {{$key->ItemName}}
                </td>
                <td>
                    {{$key->quantity}}
                </td>
                <td>
                    {{$key->Measure}}
                </td>
                <td>
                    {{$key->from_site}}
                </td>
                <td>
                    {{$key->to_site}}
                </td>
            </tr>
        @endforeach

        </tbody>
    </table>
    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th width="70%"> @lang('layout.Description') </th>
            <th>@lang('layout.MohrAndSignature')</th>


        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="70%">{{$transfer->description}}</td>
            <td style="width: 30%;height: 50px"></td>
        </tr>


        </tbody>
    </table>




    @if(company()['inventory_transfer_message'])
        <table width="100%">
            <tr>
                <td style="font-size: 14px;">{!!company()['inventory_transfer_message']!!}</td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>


        </table>
    @endif
@endsection
