@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption"><i
                        class=""></i>@lang('layout.CustomerTransferItemShow')

            </div>
            <div class="tools"><a
                        href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-
                   original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table
                        class="table table-striped table-bordered table-advance table-hover">
                    <thead>

                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.From') @lang('layout.Customer')</th>
                        <th>@lang('layout.To') @lang('layout.Customer')</th>
                        <th>@lang('layout.TotalQty')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                    </tr>

                    </thead>
                    <tbody>

                    <tr>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->number}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->ref_no}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->from_customer}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->to_customer}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->totalQty}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:convertDate($firstTransfer->date)}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->user_name}}  </td>
                        <td class="hidden-xs"> {{ (!$firstTransfer)?null:$firstTransfer->description}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.CustomerTransferItemShow')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.InventoryDetails')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'customerTransferItem.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="customer_inventory_transfer_detail"/>
                                        <input type="hidden" name="report_format" value="excel"/>
                                        <input type="hidden" name="inventory_transfer_id"
                                               value="{{(!$firstTransfer)?null:$firstTransfer->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'customerTransferItem.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="customer_inventory_transfer_detail"/>
                                        <input type="hidden" name="report_format" value="pdf"/>
                                        <input type="hidden" name="inventory_transfer_id"
                                               value="{{(!$firstTransfer)?null:$firstTransfer->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover"
                                           id="inventory_transfer_detail">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.FromSite')</th>
                                            <th>@lang('layout.ToSite')</th>
                                            <!-- <th>@lang('layout.Total') @lang('layout.UnitCost') </th> -->
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="customerTransferItem.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$firstTransfer->id}}">
                                        <input type="hidden" name="path" value="uploads/customerTransferItem">
                                        <input type="hidden" name="table_name" value="customer_transfer_items">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('customerTransferItem.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#inventory_transfer_detail').DataTable({
                ajax: {

                    url: '{{route("customerTransferItem.show",$id)}}',
                    data: {type: 'customerTransferItem'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'ItemName', name: 'ItemName'},
                    {data: 'Measure', name: 'Measure'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'from_site', name: 'from_site'},
                    {data: 'to_site', name: 'to_site'},
                    // { data: 'AssetValue', name: 'AssetValue' },
                ]

            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("customerTransferItem.show",$id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

        });

    </script>


@endpush

