@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CustomerTransferItemReport') </h3>

    <table class="main-table">
 
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td class="center"> @lang('layout.Record') </td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.From') @lang('layout.Customer')</th>
            <th>@lang('layout.To') @lang('layout.Customer')</th>
            <th>@lang('layout.TotalQty')</th>
            
            <th>@lang('layout.User')</th>
            
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)

            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{$record->ref_no}}</td>
                <td class="center">{{convertDate($record->Date)}}</td>
                <td  class="center">{{$record->description}}</td>
                <td class="center">{{$record->from_customer}}</td>
                <td class="center">{{$record->to_customer}}</td>
                <td class="center">{{$record->totalQty}}</td>
               
                <td  class="center">{{$record->user_name}}</td>
               
            </tr>

        @endforeach
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection