@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CustomerTransferItemReport') </h3>

    <table class="main-table">
    @if($info)
        <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.From') @lang('layout.Customer')</th>
            <th>@lang('layout.To') @lang('layout.Customer')</th>
            <th>@lang('layout.TotalQty')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.User')</th>
            <th>@lang('layout.Description')</th>
        </tr>
        </thead>
            <tr>
                <td class="center">{{$info->number}}</td>
                <td class="center">{{$info->ref_no}}</td>
                <td class="center">{{$info->from_customer}}</td>
                <td class="center">{{$info->to_customer}}</td>
                <td class="center">{{$info->totalQty}}</td>
                <td class="center">{{convertDate($info->date)}}</td>
                <td  class="center">{{$info->user_name}}</td>
                <td  class="center">{{$info->description}}</td>
            </tr>

        @endif
    </table>
    <br/>
    <br/>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td>#</td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.FromSite')</th>
            <th>@lang('layout.ToSite')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->ItemName}}</td>
                <td class="center">{{$record->Measure}}</td>
                <td class="center">{{$record->quantity}}</td>
                <td class="center">{{$record->from_site}}</td>
                <td class="center">{{$record->to_site}}</td>
            </tr>

        @endforeach
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection