@extends('layouts.app') 
@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'customer_inventory_transfer'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist"> </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                        <label class="control-label">@lang('layout.Customer')</label>
                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                v-model="selectedCustomer" label="name" :options="{{$customer}}">
                        </v-select>
                        <input type="hidden" name="customer_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id" />
                    </div>
                </div>     
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CustomerTransferItemList')</span>
                </div>
                <div class="pull-right">
                    @permission('CustomerTransferItem-export')
                    <span id="anchore-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                </span>

                    @endpermission
                    @permission('CustomerTransferItem-create')
                    <a href="{{route('customerTransferItem.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="InventoryTransfer">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.From') @lang('layout.Customer')</th>
                        <th>@lang('layout.To') @lang('layout.Customer')</th>
                        <th>@lang('layout.TotalQty')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

    <iframe id="transferFrames" style="display: none;"></iframe>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        @if (Session('transfer_id'))
        printTransferBill("{{Session('transfer_id')}}")

        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        function printTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('printTransferBill')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#InventoryTransfer').DataTable({
                ajax: '{{route("customerTransferItem.index")}}',
                pageLength: '{{getPageRows()}}',
                // scrollY:        450,
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'customer_transfer_items.number'},
                    {data: 'ref_no', name: 'customer_transfer_items.ref_no'},
                    {data: 'from_customer', name: 'members.name'},
                    {data: 'to_customer', name: 'members.name'},
                    {data: 'totalQty', name: 'totalQty', orderable: false, searchable: false},
                    {data: 'Date', name: 'customer_transfer_items.date'},
                    {data: 'user_name', name: 'users.name', orderable: false, searchable: false},
                    {data: 'description', name: 'customer_transfer_items.description'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("customerTransferItem.report") !!}',
                excelRoute: '{!! route("customerTransferItem.report") !!}',
                selectedItem: null,
                itemlist: [],
                selectedCustomer: null,

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get items
                onItemSearch(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                        vm.itemlist = response.data;
                        // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush

