@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
    .required {
        padding-left: 0px !important;
        color: red;
    }
</style>
@stop
@section('content')
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CustomerTransferItemCreate')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="app" class="portlet-body">

                <div class="tabbable tabbable-tabdrop">


                    <div>
                        {{Form::open(['route' => 'customerTransferItem.store','method' => 'POST','class' => 'form-horizontal','id'=>'transfer-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <!-- begin inputs -->


                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Number')</label>
                                                        <input type="text" name="number" value="{{$number}}" class="form-control" placeholder="@lang('layout.Number')">

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                        <input type="text" name="ref_no" class="form-control" placeholder="@lang('layout.ReferenceNumber')">

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.From') @lang('layout.Customer')</label>
                                                        <v-select label="name" v-model="selected_customer1" @input="memberChange()" :options="customer">
                                                        </v-select>
                                                        <input type="hidden" name="customer1_id" :value="(!selected_customer1)?null:selected_customer1.id">

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.To') @lang('layout.Customer')</label>
                                                        <v-select label="name" v-model="selected_customer2" :options="customer">
                                                        </v-select>
                                                        <input type="hidden" name="customer2_id" :value="(!selected_customer2)?null:selected_customer2.id">

                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Date')</label>

                                                        <input type="text" name="date" class="form-control date now" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Description')</label>

                                                        <textarea name="description" class="form-control" rows="1"></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="row" style="overflow-x: scroll;">
                                            <table id="table_content" class="table table-bordered table-advance">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: 130px; text-align:center;">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 130px; text-align:center;">@lang('layout.FromSite') </th>
                                                        <th style="min-width: 130px; text-align:center;">@lang('layout.ToSite') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Measure') </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" @input="onItemload(index)" v-model="item.inventory" :options="temp_items" @search="onItemSearch"></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                            <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                        </td>
                                                        <td class="highlight">

                                                            <div class="input-group">
                                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item != null)">
                                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                            @{{site.site_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>

                                                                <input type="hidden" name="from_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">

                                                                <span class="input-group-addon">@{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-if="(item.item !=null)">
                                                                <!-- <div class="input-group"> -->
                                                                    <select class="form-control input_style" placeholder="@lang('layout.ToSite')" required="required" v-model="!item.item?null:item.item.to_site">

                                                                        <option v-for="si in (item.item==null)?null:site" :value="si">@{{si.name}}
                                                                        </option>
                                                                    </select>
                                                                    <!-- <span class="input-group-addon">@{{myRound((item.item==null)?null:ToSiteItemQuantity(item.item,item.item.quantity))}}</span> -->
                                                                <!-- </div> -->
                                                            </span>
                                                            <input type="hidden" name="to_site[]" :value="(!item.item)?null:(item.item.to_site)?item.item.to_site.site_id:null">
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>

                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" disabled>
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('inventory',100)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tbody>
                                            </table>


                                        </div>


                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                        <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>

                                        <a href="{{route('customerTransferItem.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>

                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                </div>

                            </div>


                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>
@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);
    var site = {!! $site !!};
    var customer = {!! $customer !!};
    
    var v = new Vue({
        el: '#app',
        data: {
            showModal: false,
            temp_items: [],
            selected_index: 0,
            site: site,
            customer: customer,
            selected_customer1: null,
            selected_customer2: null,
            inventories: [{
                inventory: null,
                item: null
            }, ],

        },
        computed: {

            // check data validation
            isError: function() {
                var isError = false;
                var flag = false;
                /**for (var i = 0; i < this.inventories.length; i++)
                     {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/

                return isError;
            },

        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        v.submitForm(e.target);
                    }
                });
            },

            memberChange() {
                this.temp_items = [];
                this.inventories = [];
                this.inventories.push({
                    inventory: null,
                    item: null
                });
            },

            // begin item search
            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                let customer_id = (v.selected_customer1 != undefined) ? v.selected_customer1.id : '';
                if (customer_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchCustomer',
                            keyword: search,
                            customer_id: customer_id
                        }
                    })
                    .then(function(response) {
                        v.temp_items = [];
                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    }) 
                }
                loading(false);
            }, getDebounceTime()),


            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let customer_id = (v.selected_customer1 != undefined) ? v.selected_customer1.id : '';
                    if (customer_id) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'loadItemTransferCustomer',
                                inventory_id: inventory_id,
                                customer_id: customer_id

                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            if (response.data.length > 0) {
                                v.inventories[index].item = response.data[0];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                    }
                }
            },

            //ajax call to get items
            setIndex(e) {
                //v.temp_items=[];
                this.selected_index = e;
            },

            // end item search

            //get item quantity
            ToSiteItemQuantity(item = null, quantity = null, edit_quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.to_site) {
                        result = (item.to_site.OnHand * item.measure_unit) / (item.measure.measure_unit) + Number(quantity);


                    }
                    if (edit_quantity != null) {
                        result += Number(edit_quantity);
                    }
                    return result;
                }
            },

            // contract search


            // generic function for adding item to list
            addNew(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null
                            });
                        }
                    }


                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }

                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("transfer-form").submit()

                    } else {

                    }
                });

            },
            defaultValue() {
                this.selected_index = 0;

                this.inventories = [{
                    item: null,
                    item_category: this.selected_iventory_category
                }, ];

                this.temp_items = [];

            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('customerTransferItem.store')}}";
                            form_id = 'transfer-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        toastr.success('', response.data.message);
                                        location.reload();
                                        v.defaultValue();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },
        created: function() {

        }

    });
</script>


@endpush