@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption"><i class=""></i>@lang('layout.CustomerStockShow')
            </div>
            <div class="tools"><a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                      <tr class="bg">
                          <th>@lang('layout.Customer')</th>
                          <th>@lang('layout.Code')</th>
                          <th>@lang('layout.Phone')</th>
                          <th>@lang('layout.City')</th>
                          <th>@lang('layout.Address')</th>
                      </tr>
                    </thead>
                    <tr>
                    <td class="center">{{ $customer->name }}</td>
                    <td class="center">{{ $customer->code }}</td>
                    <td class="center">{{ $customer->phone }}  </td>
                    <td class="center">{{ $customer->city }}  </td>
                    <td class="center">{{ $customer->address1 }}  </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.CustomerStockShow')</a>
                </li>
                {{-- <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li> --}}
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Inventory')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'customerStock.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="customer_stock_detail"/>
                                        <input type="hidden" name="report_format" value="excel"/>
                                        <input type="hidden" name="customer_id" value="{{(!$customer)?null:$customer->id}}"/>
                                        <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'customerStock.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="customer_stock_detail"/>
                                        <input type="hidden" name="report_format" value="pdf"/>
                                        <input type="hidden" name="customer_id" value="{{(!$customer)?null:$customer->id}}"/>
                                        <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover"
                                           id="customer_stock">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Type')</th>
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.ReferenceNumber')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Item')</th>
                                            <th>@lang('layout.SiteName')</th>
                                            <th>@lang('layout.Category')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Price')</th>
                                            <th>@lang('layout.Total')</th>
                                            <th>@lang('layout.User')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="customerDeliveryItem.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$customer->id}}">
                                        <input type="hidden" name="path" value="uploads/customerDeliveryItem">
                                        <input type="hidden" name="table_name" value="customer_delivery_items">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('customerDeliveryItem.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

@endsection

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#customer_stock').DataTable({
                ajax: {

                    url: '{{route("customerStock.show",$id)}}',
                    data: {type: 'customerStock'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    { data: 'type',          name: 'type' },
                    { data: 'number',        name: 'number' },
                    { data: 'ref_no',        name: 'ref_no' },
                    { data: 'date',          name: 'date', searchable:false },
                    { data: 'name',          name: 'name' },
                    { data: 'siteName',      name: 'siteName' },
                    { data: 'cat',           name: 'cat', searchable:false },
                    { data: 'quantity',      name: 'quantity', searchable:false },
                    { data: 'measure',       name: 'measure', searchable:false },
                    { data: 'cost',          name: 'cost', searchable:false },
                    { data: 'total',         name: 'total', searchable:false },
                    { data: 'user',          name: 'user' }
                ]

            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("customerStock.show",$id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

        });

    </script>


@endpush

