@extends('layouts.factor-master')

@section('content')
    <h3 class="table-caption" style="text-align: center;">@lang('layout.CustomerStockReport') </h3>

    <table class="main-table">
 
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif 
            
            @if($member_class_name)
                <td>
                    <span>@lang('layout.MemberClass')</span>:
                    <BDO >{{$member_class_name}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table"> 
        <thead>
        <tr class="bg">
            <th style="width: 10%;">@lang('layout.Record') </th>
            <th style="width: 20%;">@lang('layout.Customer')</th>
            <th style="width: 20%;">@lang('layout.Site')</th>
            <th style="width: 20%;">@lang('layout.Item')</th>
            <th style="width: 10%;">@lang('layout.Quantity')</th>
            <th style="width: 10%;">@lang('layout.StockNearCustomer')</th>
            <th style="width: 10%;">@lang('layout.Measure')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $items = [];
        $measures = [];
        $totalQuantity = 0;
        $countItem = 0;
        $countItemCustomer = 0;
        ?>
        @foreach($data AS $record)
        <?php  
            $totalQuantity += $record->qty; 
            
            if($record->qty > 0){
                $countItem += $record->qty;
            }
            if($record->qty < 0){
                $countItemCustomer += $record->qty;
            }
            
            $items[$record->name]['measure'] = $record->measure;
            if(array_key_exists($record->name, $items)){
                $items[$record->name]['qty'] =  isset($items[$record->name]['qty']) 
                ? $items[$record->name]['qty']+ $record->qty
                : $record->qty;

                $items[$record->name]['in_qty'] =  isset($items[$record->name]['in_qty']) 
                ? $items[$record->name]['in_qty']+ $record->in_qty
                : $record->in_qty; 
                
                $items[$record->name]['out_qty'] =  isset($items[$record->name]['out_qty']) 
                ? $items[$record->name]['out_qty']+ $record->out_qty
                : $record->out_qty;
 
            }else{
                $items[$record->name]['qty'] = $record->qty;
                $items[$record->name]['in_qty'] = $record->in_qty;
                $items[$record->name]['out_qty'] = $record->out_qty;
            }
            
            if(array_key_exists($record->measure, $measures)){
                $measures[$record->measure] = $measures[$record->measure] + $record->qty;
            }else{
                $measures[$record->measure] = $record->qty;
            } 
        ?>

            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->customer}}</td>
                <td class="center">{{$record->siteName}}</td>
                <td class="center">{{$record->name}}</td>
                @if($record->qty > 0)
                <td class="center">{{$record->qty}}</td>
                @else
                <td></td>
                @endif
                @if($record->qty < 0)
                <td class="center">{{abs($record->qty)}}</td>
                @else 
                <td></td>
                @endif
                <td class="center">{{$record->measure}}</td>
            </tr> 
        @endforeach
            @if(count($measures) <= 1)
        <tr class="bg">
            <td class="center" colspan="4"> @lang('layout.Total') </td>
            <td class="center"> {{$countItem}} </td>
            <td  colspan="1" class="center"> {{abs($countItemCustomer)}} </td>
        </tr>
        @endif 
    </table>
    <br>

    <table class="main-table">
        <tr class="bg">
         <th colspan="4" class="center"><h3>@lang('layout.Total') - @lang('layout.Items')</h3></th>
       </tr>
       <tr>
         <th class="center">  @lang('layout.Record') </th>
         <th class="center"> @lang('layout.Item') </th>
         <th class="center"> @lang('layout.Unit') </th>
         {{-- <th class="center"> @lang('layout.QutIn') </th>
         <th class="center"> @lang('layout.QutOut') </th> --}}
         <th class="center"> @lang('layout.Quantity') </th>
       </tr>
       <?php
       $count=0;
       // dd($items);
       $totalFinalQuqantity = 0;
       
       foreach($items As $key=> $item)
       {
        $totalFinalQuqantity += $item['qty'];
         ?>
         <tr>
           <td class="center">{{++$count}}</td>
           <td class="center">{{$key}}</td>
           <td class="center">{{$item['measure']}}</td>
           {{-- <td class="center">{{myRound($item['in_qty'])}} </td>
           <td class="center">{{myRound($item['out_qty'])}} </td> --}}
           <td class="center">{{myRound($item['qty'])}} </td> 
         </tr>
         <?php
       }
       ?>

       @if(count($measures) <= 1)
        <tr class="bg">
            <td colspan="3" class="center"> @lang('layout.Total') </td>
            <td class="center"> {{$totalFinalQuqantity}} </td>
        </tr>
        @endif

       </table>


     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection