@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'customer_stock'" @closed="closeModal">
            <div slot="body">
                <div class="row">

                    <div class="col-md-3">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist"> </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.item_id">
                    </div>
 
                    <div class="col-md-3" style="margin-bottom: 20px;">
                        <label class="control-label ">@lang('layout.SelectClass')</label>
                        <v-select class="vue-select2"
                                  v-model="selectedmemberClass"
                                  label="name"
                                  :options="memberClass">
                        </v-select>
                        <input type="hidden" name="class_id" :value="(!selectedmemberClass)?null:selectedmemberClass.id">
                    </div>

                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <label class="control-label">@lang('layout.Customer')</label>
                        <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedCustomer" label="name" :options="memberlist" @search="onMemberSearch">
                        </v-select>
                        <input type="hidden" name="customer_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id" />
                    </div>

                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <label class="control-label">@lang('layout.Site')</label>
                        <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedSite" label="name" :options="{{$inventorySite}}">
                        </v-select>
                        <input type="hidden" name="site_id" v-model.number="(!selectedSite)?null:selectedSite.id" />
                    </div>


                </div>     
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CustomerStockList')</span>
                </div>
                <div class="pull-right">
                    @permission('CustomerDeliveryItem-export')
                    <span id="anchore-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                </span>

                    @endpermission
                    {{-- @permission('CustomerDeliveryItem-create')
                    <a href="{{route('customerDeliveryItem.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission --}}
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="InventoryTransfer">
                    <thead>
                    <tr>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Site')</th>
                        <th>@lang('layout.Item')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

    <iframe id="transferFrames" style="display: none;"></iframe>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        Vue.component('v-select', VueSelect.VueSelect);
        function printTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('printCustomerDeliveryItem')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#InventoryTransfer').DataTable({
                ajax: '{{route("customerStock.index")}}',
                pageLength: '{{getPageRows()}}',
                // scrollY:        450,
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'customer', name: 'members.name'},
                    {data: 'siteName', name: 'inventory_sites.name'},
                    {data: 'name', name: 'items.name'},
                    {data: 'qty', name: 'qty', searchable: false},
                    {data: 'measure', name: 'measure_units.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });


        var memberClass ={!! $memberClass !!}

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("customerStock.report") !!}',
                excelRoute: '{!! route("customerStock.report") !!}',
                selectedItem: null,
                memberClass: memberClass,
                selectedmemberClass: null,
                itemlist: [],
                memberlist: [],
                selectedCustomer: null,
                selectedSite: null,

            },
            methods: {

                //ajax call to get items
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()),

                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get items
                onItemSearch(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                        vm.itemlist = response.data;
                        // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush

