@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('build');
$_date=in_array('date', $report);
$_build_number=in_array('build_number', $report);
$_item_name=in_array('item_name', $report);
$_measure=in_array('measure', $report);
$_quantity=in_array('quantity', $report);
$_purchase_rate=in_array('purchase_rate', $report);
$_TotalExpense=in_array('_TotalExpense', $report);

?>

    <h4></h4>
	<h4 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferReport')</h4>
      <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
      </table>
      <br>
<table class="main-table">
    <thead>
    <tr>
      <th style="height: 40px"><div class="center"><b> @lang('layout.ID')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.WayBillNumber')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.PlateNumber')</b> </div></th>
      <th style="height: 40px" ><div class="center"><b> @lang('layout.TotalQty')</b></div></th>
      <th style="height: 40px" ><div class="center"><b> @lang('layout.Driver')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.Date')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.Contract')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.WagonNumber')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.Description')</b></div></th>
      <th style="height: 40px" ><div class="center"><b> @lang('layout.Item')</b></div></th>
    </tr>
    </thead>



    <?php
      $count = 0;
  
    ?>
    <tbody>
    @foreach($data AS $record)
    <?php
      $Item = $record['Item'];
    ?>
    <tr>
      <td  class="center">{{$record['id']}}</td>
      <td  class="center">{{$record['way_bill_number']}}</td>
      <td  class="center">{{$record['plate_number']}}</td>
      <td  class="center">{{$record['total_bori']}}</td>
      <td  class="center">{{$record['Driver']}}</td>
      <td class="center">{{convertDate($record['Date'])}}</td>
      <td  class="center">{{$record['company_name']}}</td>
      <td  class="center">{{$record['wagon_number']}}</td>
      <td  class="center">{{$record['description']}}</td>
      
	  <td >
      <table class="main-table" style="width:100%">
        <tr class="bg">
          <td width="50%"><div class="center"> @lang('layout.ItemName') </div></td>
          <td width="50%"><div class="center"> @lang('layout.Quantity') </div></td>
          <td width="50%"><div class="center"> @lang('layout.Unit') </div></td>
          <td width="50%"><div class="center"> @lang('layout.FromSite') </div></td>
          <td width="50%"><div class="center"> @lang('layout.ToSite') </div></td>
        </tr>


		<?php
		$totalOut = 0;
		?>
	  @foreach($Item AS $row)
	  <?php
		
		?>
		<tr>
			<td class="center">{{$row['ItemName']}}</td>
      <td class="center">{{$row['quantity']}}</td>
      <td class="center">{{$row['Measure']}}</td>
      <td class="center">{{$row['from_site']}}</td>
      <td class="center">{{$row['to_site']}}</td>




		</tr>
	  @endforeach
	  </table>
	  </td>
	  

    </tr>
    @endforeach

  </tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection