@extends('layouts.factor-master')


@section('content')

    <table width="100%">
        <tr>
             <td style="text-align: center;">@lang('layout.DeliveryItemBill')</td>
        </tr>
    </table>
    <table width="100%" style="font-size: 16px; margin-top: 2px;" >
        <tr>
            <td> @lang('layout.CustomerStatement') : {{ $deliveryItem->customer}}</td> 
            <td> @lang('layout.Date') : {{convertDate($deliveryItem->date)}}</td>
            <td> @lang('layout.InvoiceNumber') : {{ $deliveryItem->ref_no}}</td> 
            <td> @lang('layout.Number') : {{ $deliveryItem->number}}</td> 
        </tr>
    </table>
    <table class="main-table" style="margin-top: 4px;">
        <thead>
        <tr class="bg">
            <th> @lang('layout.Number') </th>
            <th> @lang('layout.Item') </th>
            <th> @lang('layout.Site')</th>
            <th> @lang('layout.Quantity')</th>
            @if($deliveryItem->driver_type)
            <th>@lang('layout.Driver') </th>
            <th>@lang('layout.PaletNumber') </th>
            <th>@lang('layout.Phone') </th>
            <th>@lang('layout.Responsible') </th>
            @endif
            <th> @lang('layout.Description')</th>
        </tr>
        </thead>
        <tbody>
        <?php $count = 1; $total_count = 0; ?>
        @foreach($deliveryItemDetail as $key )
            <tr>
                <td>
                    {{$count++}}
                </td>
                <td>
                    {{$key->ItemName}}
                </td>
                <td>
                    {{$key->site}}
                </td>
                <td>
                    {{$key->quantity}} {{$key->Measure}}
                </td>
                @if($deliveryItem->driver_type)
                <td>
                    {{$key->driver}}
                </td>
                <td>
                    {{$key->palet_number}}
                </td>
                <td>
                    {{$key->phone}}
                </td>
                <td>
                    {{$key->responsible}}
                </td>
                @endif
                <td>
                    {{$key->description}}
                </td>
            </tr>
            <?php $total_count += $key->quantity; ?>
        @endforeach
        </tbody>
    </table>
    <table width="100%" style="margin-top: 2px; font-size: 14px;">
        <tr>
            <td> @lang('layout.Note') : {{ $deliveryItem->description}}</td> 
        </tr>
    </table>

    <table width="100%" style="margin-top: 2px; font-size: 14px;">
        @if(!$deliveryItem->driver_type)
        <tr>
             <td> @lang('layout.Driver'): {{ $deliveryItem->driver}}  </td>
             <td colspan="2"> @lang('layout.Color') - @lang('layout.PaletNumber'): {{ $deliveryItem->palet_number}} {{ $deliveryItem->color}}  </td>
             <td> @lang('layout.Phone'): {{ $deliveryItem->phone}}  </td>
        </tr>
        @endif
        <tr>
             <td> @lang('layout.Source'): {{ $deliveryItem->source}}  </td>
             <td> @lang('layout.Destination'): {{ $deliveryItem->destination}}  </td>
             <td> @lang('layout.Commissar'): {{ $deliveryItem->commissar}}  </td>
             <td> @lang('layout.LoadPlace'): {{ $deliveryItem->load_place}}  </td>
        </tr>
        <tr>
             <td> @lang('layout.Prepaid'): {{ $deliveryItem->prepaid}} </td>
             <td> @lang('layout.Amount'): {{ $deliveryItem->amount}} {{ $deliveryItem->currency}} </td>
             <td colspan="2"> @lang('layout.TotalTransferFee'): {{$total_count * $deliveryItem->amount}} </td>
        </tr>
    </table>
    <table width="100%" class="main-table" style="margin-top: 2px;">
        <tr>
            <td><b> بار بصورت کامل و سالم به موتروان تحویل داده شده و مسئولیت خراب شدن بار بدوش موتروان می باشد. </b></td> 
        </tr>
    </table>
    <table width="100%" style="margin-top: 2px;">
        <tr>
             <td> @lang('layout.MohrAndSignature') @lang('layout.Company'):  </td>
             <td style="text-align: center;"> @lang('layout.MohrAndSignature') @lang('layout.Driver'):  </td>
        </tr>
    </table>
    <table width="100%" style="margin-top: 10px; font-size: 12px;">
        <tr>
            <td><b> آدرس: ولایت فراه روبروی امنیت ملی مندوی کود فروشان. </b></td> 
        </tr>
    </table>
@endsection
