@extends('layouts.factor-master')
@section('content')
<?php 
    $report = customeReportNew('CustomerDelivery_index');
    $_number = !in_array('number', $report);
    $_ref_no = !in_array('ref_no', $report);
    $_date = !in_array('date', $report);
    $_description = !in_array('description', $report);
    $_customer = !in_array('customer', $report);
    $_driver = !in_array('driver', $report);
    $_phone = !in_array('phone', $report);
    $_plate_number = !in_array('plate_number', $report);
    $_total_quantity = !in_array('total_quantity', $report);
    $_user = !in_array('user', $report);

    $report_percent = customeReportNewPercent('CustomerDelivery_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
    $_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null;
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
    $_phone_percent= (array_key_exists('phone___percent', $report_percent))?$report_percent['phone___percent']:null;
    $_pleteNumber_percent= (array_key_exists('plate_number___percent', $report_percent))?$report_percent['plate_number___percent']:null;
    $_totalQty_percent= (array_key_exists('total_quantity___percent', $report_percent))?$report_percent['total_quantity___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    

?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CustomerDeliveryItemReport') </h3>
    @if ($negative_delivery)
    <p>@lang('layout.NegativeDelivery') </p> 
    @endif
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
            @if($member_name)
            <td>
                <span>@lang('layout.Customer')</span>:
                {{$member_name}}
            </td>
        @endif
        @if($member_class_name)
                <td>
                    <span>@lang('layout.MemberClass')</span>:
                    <BDO >{{$member_class_name}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
        <thead>
            <tr class="bg">
                <td> @lang('layout.Record') </td>
                @if($_number)
                <th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>
                @endif
                @if($_ref_no)
                <th @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif>@lang('layout.ReferenceNumber')</th>
                @endif
                @if($_date)
                <th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>
                @endif
                @if($_description)
                <th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>
                @endif
                @if($_customer)
                @if(!$member_name)
                <th @if($_customer_percent) width="{{$_customer_percent}}%" @endif>@lang('layout.Customer')</th>
                @endif
                @endif
                @if($_driver)
                <th @if($_driver_percent) width="{{$_driver_percent}}%" @endif>@lang('layout.Driver')</th>
                @endif
                @if($_phone)
                <th @if($_phone_percent) width="{{$_phone_percent}}%" @endif>@lang('layout.Phone')</th>
                @endif
                @if($_plate_number)
                <th @if($_pleteNumber_percent) width="{{$_pleteNumber_percent}}%" @endif>@lang('layout.PaletNumber')</th>
                @endif
                @if($_total_quantity)
                <th @if($_totalQty_percent) width="{{$_totalQty_percent}}%" @endif>@lang('layout.TotalQty')</th>
                @endif
                @if($_user)
                <th @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</th>
                @endif
            </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_number)
                <td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif>{{$record->number}}</td>
                @endif
                @if($_ref_no)
                <td class="center" @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif>{{$record->ref_no}}</td>
                @endif
                @if($_date)
                <td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>{{convertDate($record->Date)}}</td>
                @endif
                @if($_description)
                <td  class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>{{$record->description}}</td>
                @endif
                @if($_customer)
                @if(!$member_name)
                <td class="center" @if($_customer_percent) width="{{$_customer_percent}}%" @endif>{{$record->customer}}</td>
                @endif
                @endif
                @if($_driver)
                <td class="center" @if($_driver_percent) width="{{$_driver_percent}}%" @endif>{{$record->driver}}</td>
                @endif
                @if($_phone)
                <td class="center" @if($_phone_percent) width="{{$_phone_percent}}%" @endif>{{$record->phone}}</td>
                @endif
                @if($_plate_number)
                <td class="center" @if($_pleteNumber_percent) width="{{$_pleteNumber_percent}}%" @endif>{{$record->palet_number}}</td>
                @endif
                @if($_total_quantity)
                <td class="center" @if($_totalQty_percent) width="{{$_totalQty_percent}}%" @endif>{{$record->totalQty}}</td>
                @endif
                @if($_user)
                <td  class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>{{$record->user_name}}</td>
                @endif
            </tr>
        @endforeach
    </table>
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table>
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection