@extends('layouts.factor-master') 
@section('content') 


<?php
$report = customeReportNew('CustomerDelivery_index'); 
$_number= !in_array('number', $report);
$_ref_no= !in_array('ref_no', $report);
$_date= !in_array('date', $report);
$_description= !in_array('description', $report);
$_customer= !in_array('customer', $report);
$_site= !in_array('site', $report);
$_driver= !in_array('driver', $report);
$_phone= !in_array('phone', $report);
$_plate_number= !in_array('plate_number', $report);
$_total_quantity= !in_array('total_quantity', $report);
$_user= !in_array('user', $report);
$_item_name= !in_array('item_name', $report);
$_measure= !in_array('measure', $report);
$_value= !in_array('value', $report);
$_site= !in_array('site', $report);
$_responsible= !in_array('responsible', $report);

 
$report_percent = customeReportNewPercent('CustomerDelivery_index'); 
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null;
$_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
$_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
$_phone_percent= (array_key_exists('phone___percent', $report_percent))?$report_percent['phone___percent']:null;
$_plate_number_percent= (array_key_exists('plate_number___percent', $report_percent))?$report_percent['plate_number___percent']:null;
$_total_quantity_percent= (array_key_exists('total_quantity___percent', $report_percent))?$report_percent['total_quantity___percent']:null;
$_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
$_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
$_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
$_value_percent= (array_key_exists('value___percent', $report_percent))?$report_percent['value___percent']:null;
$_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null;
$_responsible_percent= (array_key_exists('responsible___percent', $report_percent))?$report_percent['responsible___percent']:null;
// dd($report, $report_percent); 

// dd($_date_percent);

?>
  
    <h3 class="table-caption" style="text-align: center;">@lang('layout.CustomerDeliveryItemReport') </h3> 
    
    @if ($negative_delivery)
    <p>@lang('layout.NegativeDelivery') </p> 
    @endif
    <table class="main-table"> 
        <thead>
        <tr class="bg"> 
            <td> @lang('layout.Record') </td>
            @if($_number)
            <th  @if($_number_percent) width="{{$_number_percent}}%" @endif >@lang('layout.Number')</th>
            @endif
            @if($_date)
            <th  @if($_date_percent) width="{{$_date_percent}}%" @endif >@lang('layout.Date')</th>
            @endif
            @if($_ref_no)
            <th  @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif >@lang('layout.ReferenceNumber')</th>
            @endif
            @if($_customer)
            <th  @if($_customer_percent) width="{{$_customer_percent}}%" @endif >@lang('layout.Customer')</th>
            @endif
            @if($_item_name)
            <th  @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif >@lang('layout.ItemName')</th>
            @endif
            @if($_measure)
            <th  @if($_measure_percent) width="{{$_measure_percent}}%" @endif >@lang('layout.Measure')</th>
            @endif
            @if($_total_quantity)
            <th  @if($_total_quantity_percent) width="{{$_total_quantity_percent}}%" @endif >@lang('layout.Quantity')</th>
            @endif
            @if($_site)
            <th  @if($_site_percent) width="{{$_site_percent}}%" @endif >@lang('layout.Site')</th>
            @endif
            @if($_driver)
            <th  @if($_driver_percent) width="{{$_driver_percent}}%" @endif >@lang('layout.Driver') </th>
            @endif
            @if($_plate_number)
            <th  @if($_plate_number_percent) width="{{$_plate_number_percent}}%" @endif >@lang('layout.PaletNumber') </th>
            @endif
            @if($_phone)
            <th  @if($_phone_percent) width="{{$_phone_percent}}%" @endif >@lang('layout.Phone') </th>
            @endif
            @if($_responsible)
            <th  @if($_responsible_percent) width="{{$_responsible_percent}}%" @endif >@lang('layout.Responsible') </th>
            @endif
        </tr>
       
        </thead>
        <?php
        $count = 0;
        $measures = [];
        $totalQuantity = 0;
        $items = [];
        $itemsName = [];

        ?>
        @foreach($data AS $record) 
        <?php 
            $totalQuantity  += $record->quantity; 
            if(array_key_exists($record->ItemName, $items)){
                $items[$record->ItemName]['quantity'] =  isset($items[$record->ItemName]['quantity']) 
                ? $items[$record->ItemName]['quantity']+ $record->quantity
                : $record->quantity; 
                $items[$record->ItemName]['count'] = $items[$record->ItemName]['count'] + 1; 

                $items[$record->ItemName]['start_date'] =  (date_timestamp_get(date_create($items[$record->ItemName]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $items[$record->ItemName]['start_date']; 
                $items[$record->ItemName]['end_date'] =  (date_timestamp_get(date_create($items[$record->ItemName]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $items[$record->ItemName]['end_date']; 
            }else{
                $items[$record->ItemName]['count'] = 1; 
                $items[$record->ItemName]['quantity'] = $record->quantity; 
                $items[$record->ItemName]['Measure'] = $record->Measure;
                $items[$record->ItemName]['start_date'] = $record->Date;
                $items[$record->ItemName]['end_date'] = $record->Date; 
            } 
            $customersItem = $record->ItemName.'_'.$record->customer;  
            if(array_key_exists($customersItem, $itemsName)){
                $itemsName[$customersItem]['quantity'] =  isset($itemsName[$customersItem]['quantity']) 
                ? $itemsName[$customersItem]['quantity']+ $record->quantity
                : $record->quantity; 
                $itemsName[$customersItem]['count'] = $itemsName[$customersItem]['count'] + 1; 
                $itemsName[$customersItem]['start_date'] =  (date_timestamp_get(date_create($itemsName[$customersItem]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $itemsName[$customersItem]['start_date']; 
                $itemsName[$customersItem]['end_date'] =  (date_timestamp_get(date_create($itemsName[$customersItem]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $itemsName[$customersItem]['end_date']; 
            
            }else{
                $itemsName[$customersItem]['count'] = 1; 
                $itemsName[$customersItem]['quantity'] = $record->quantity; 
                $itemsName[$customersItem]['Measure'] = $record->Measure;
                $itemsName[$customersItem]['start_date'] = $record->Date;
                $itemsName[$customersItem]['end_date'] = $record->Date;
                $itemsName[$customersItem]['customer']=$record['customer'];
                $itemsName[$customersItem]['ItemName']=$record['ItemName'];
            }
 
            if (array_key_exists($record->Measure, $measures)) {
                $measures[$record->Measure] = $measures[$record->Measure] + $record->quantity;
            } else {
                $measures[$record->Measure] = $record->quantity;
            } 
        ?>

            <tr>
                <td class="center">{{++$count}}</td>
                @if($_number)
                <td class="center">{{$record->number}}</td>
                @endif
                @if($_date)
                <td class="center">{{convertDate($record->Date)}}</td>
                @endif
                @if($_ref_no)
                <td class="center">{{$record->ref_no}}</td>
                @endif
                @if($_customer)
                <td class="center">{{$record->customer}}</td>
                @endif
                @if($_item_name)
                <td class="center">{{$record->ItemName}}</td>
                @endif
                @if($_measure)
                <td class="center">{{$record->Measure}}</td>
                @endif
                @if($_total_quantity)
                <td class="center">{{$record->quantity}}</td>
                @endif
                @if($_site)
                <td class="center">{{$record->site}}</td>
                @endif

                @if($record->driver_type)
                @if($_driver)
                <td  class="center" >
                    {{$record->driver}}
                </td>
                @endif
                @if($_plate_number)
                <td  class="center" >
                    {{$record->palet_number}}
                </td>
                @endif
                @if($_phone)
                <td  class="center" >
                    {{$record->phone}}
                </td>
                @endif
                @else 
                @if($_driver)
                <td  class="center" >
                    {{$record->driver_info_name}}
                </td>
                @endif
                @if($_plate_number)
                <td  class="center" >
                    {{$record->driver_plate_number}}
                </td>
                @endif
                @if($_phone)
                <td  class="center" >
                    {{$record->drive_phone}}
                </td>
                @endif
                @endif  
                @if($_responsible)
                <td  class="center" >
                    {{$record->responsible}}
                </td>
                @endif
            </tr> 
        @endforeach

        @if(count($measures) <= 1)
        <tr>
           <td colspan="7" class="center"> @lang('layout.Total') </td>
           <td class="center"> {{$totalQuantity}} </td>
        </tr>
        @endif

    </table> 
     <!--  signature -->

     {{-- <table class="main-table" style="margin-top: 20px;">
            <tr class="bg"> 
                <td  class="center">
                    @lang('layout.Record')
                </td>
                <td  class="center">
                     @lang('layout.Measure') 
                </td>
                <td  class="center">
                     @lang('layout.Quantity') 
                </td>
            </tr>
            <?php
            $count = 0;
            foreach ($measures as $key => $meas) {
            ?>
                <tr>
                    <td  class="center">
                        {{++$count}}
                    </td>
                    <td  class="center">
                        {{$key}}
                    </td>
                    <td  class="center">
                        {{myRound($meas)}}
                    </td>
                </tr>
            <?php
            }
        ?>
     </table> --}}
 
     <table class="main-table" style="margin-top: 20px;">
        <tr class="bg">
         <th colspan="7" class="center"><h3>@lang('layout.Total') - @lang('layout.Items')</h3></th>
       </tr>
       <tr>
         <th class="center">  @lang('layout.Record') </th>
         <th class="center"> @lang('layout.Count') </th>
         <th class="center"> @lang('layout.StartDate') </th>
         <th class="center"> @lang('layout.EndDate') </th>
         <th class="center"> @lang('layout.Item') </th>
         <th class="center"> @lang('layout.Unit') </th> 
         <th class="center"> @lang('layout.Quantity') </th>
       </tr>
       <?php
       $count=0;
       // dd($items);
       $totalFinalQuqantity = 0;
       $totalCount = 0;
       
       foreach($items As $key=> $item)
       {
        $totalFinalQuqantity += $item['quantity'];
        $totalCount += $item['count'];
         ?>
         <tr>
           <td class="center">{{++$count}}</td>
           <td class="center">{{$item['count']}}</td>
           <td class="center">{{convertDate($item['start_date'])}}</td>
           <td class="center">{{convertDate($item['end_date'])}}</td>
           <td class="center">{{$key}}</td>
           <td class="center">{{$item['Measure']}}</td>
           {{-- <td class="center">{{myRound($item['in_qty'])}} </td>
           <td class="center">{{myRound($item['out_qty'])}} </td> --}}
           <td class="center">{{myRound($item['quantity'])}} </td> 
         </tr>
         <?php
       }
       ?>
 
        <tr class="bg">
            <td colspan="1" class="center"> @lang('layout.Total') </td>
            <td colspan="" class="center"> {{$totalCount}} </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            @if(count($measures) <= 1)
            <td class="center"> {{$totalFinalQuqantity}} </td>
            @else
            <td class="center">  </td>
            @endif
        </tr>

       </table>
  
  
  
  
  
  
       <table class="main-table" style="margin-top: 20px;">
        <tr class="bg">
         <th colspan="7" class="center"><h3>@lang('layout.Total') -  @lang('layout.Items') - @lang('layout.Customer')</h3></th>
       </tr>
       <tr class="bg">
         <th class="center">  @lang('layout.Record') </th>
         <th class="center"> @lang('layout.Count') </th>
         <th class="center"> @lang('layout.StartDate') </th>
         <th class="center"> @lang('layout.EndDate') </th>
         <th class="center"> @lang('layout.Customer') </th>
         <th class="center"> @lang('layout.Item') </th>
         <th class="center"> @lang('layout.Unit') </th> 
         <th class="center"> @lang('layout.Quantity') </th>
       </tr>
       <?php
       $count=0;
       // dd($items);
       $totalFinalQuqantity = 0;
       $totalCount = 0;
      
       foreach($itemsName As $key=> $itemn)
       {
        $totalFinalQuqantity += $itemn['quantity'];
        $totalCount += $itemn['count'];
         ?>
         <tr>
           <td class="center">{{++$count}}</td>
           <td class="center">{{$itemn['count']}}</td>
           <td class="center">{{convertDate($itemn['start_date'])}}</td>
           <td class="center">{{convertDate($itemn['end_date'])}}</td>
           <td class="center">{{$itemn['customer']}}</td>
           <td class="center">{{$itemn['ItemName']}}</td>
           <td class="center">{{$itemn['Measure']}}</td>
           {{-- <td class="center">{{myRound($itemn['in_qty'])}} </td>
           <td class="center">{{myRound($itemn['out_qty'])}} </td> --}}
           <td class="center">{{myRound($itemn['quantity'])}} </td> 
         </tr>
         <?php
       }
       ?>

        <tr class="bg">
            <td colspan="1" class="center"> @lang('layout.Total') </td>
            <td colspan="" class="center"> {{$totalCount}} </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            <td colspan="" class="center"> </td>
            @if(count($measures) <= 1)
            <td class="center"> {{$totalFinalQuqantity}} </td>
            @else 
            <td></td>
            @endif 
        </tr>
       </table>
 
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection



  