@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CustomerDeliveryItemReport') </h3>

    <table class="main-table">
    @if($info)
        <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Customer')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.TotalQty')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.User')</th>
            <th>@lang('layout.Description')</th>
        </tr>
        </thead>
            <tr>
                <td class="center">{{$info->number}}</td>
                <td class="center">{{$info->ref_no}}</td>
                <td class="center">{{$info->customer}}</td>
                <td class="center">{{$info->currency}}</td>
                <td class="center">{{$info->totalQty}}</td>
                <td class="center">{{convertDate($info->date)}}</td>
                <td  class="center">{{$info->user_name}}</td>
                <td  class="center">{{$info->description}}</td>
            </tr>

        <thead>
        <tr class="bg">
            @if(!$info->driver_type)
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.Phone')</th>
            <th>@lang('layout.PaletNumber')</th>
            @endif
            <th>@lang('layout.Color')</th>
            <th>@lang('layout.Commissar')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Prepaid')</th>
            <th>@lang('layout.Source')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.LoadPlace')</th>
        </tr>
        </thead>
            <tr>
                @if(!$info->driver_type)
                <td class="center">{{$info->driver}}</td>
                <td class="center">{{$info->phone}}</td>
                <td class="center">{{$info->palet_number}}</td>
                @endif
                <td class="center">{{$info->color}}</td>
                <td class="center">{{$info->commissar}}</td>
                <td class="center">{{$info->amount}}</td>
                <td  class="center">{{$info->prepaid}}</td>
                <td  class="center">{{$info->source}}</td>
                <td  class="center">{{$info->destination}}</td>
                <td  class="center">{{$info->load_place}}</td>
            </tr>

        @endif
    </table>
    <br/>
    <br/>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td> @lang('layout.Record') </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Site')</th>
            @if($info->driver_type)
            <th>@lang('layout.Driver') </th>
            <th>@lang('layout.PaletNumber') </th>
            <th>@lang('layout.Phone') </th>
            <th>@lang('layout.Responsible') </th>
            @endif
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->ItemName}}</td>
                <td class="center">{{$record->Measure}}</td>
                <td class="center">{{$record->quantity}}</td>
                <td class="center">{{$record->site}}</td>
                @if($info->driver_type)
                <td>
                    {{$record->driver}}
                </td>
                <td>
                    {{$record->palet_number}}
                </td>
                <td>
                    {{$record->phone}}
                </td>
                <td>
                    {{$record->responsible}}
                </td>
                @endif
            </tr>

        @endforeach
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection