@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
         :value-type="'customer_delivery_transfer'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.SelectItem') </label>
                                            <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist"> </v-select>
                                            <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                                        </div>

                                        <div class="col-md-3" style="margin-bottom: 20px;">
                                            <label class="control-label ">@lang('layout.SelectClass')</label>
                                            <v-select class="vue-select2"
                                                      v-model="selectedmemberClass"
                                                      label="name"
                                                      :options="memberClass">
                                            </v-select>
                                            <input type="hidden" name="class_id" :value="(!selectedmemberClass)?null:selectedmemberClass.id">
                                        </div>

                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                            <label class="control-label">@lang('layout.Customer')</label>
                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                    v-model="selectedCustomer" label="name" :options="customer" @search="onMemberSearch" >
                                            </v-select>
                                            <input type="hidden" name="customer_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id" />
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <label class="control-label">@lang('layout.Details')</label>
                                            <select name="details" class="form-control" id="">
                                                <option value=""> @lang('layout.Select') </option>
                                                <option value="details"> @lang('layout.Details') </option>
                                            </select>
                                        </div>
                                        @if(getNegativeSale() == 'true')
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                    <table class="table table-striped table-bordered table-advance ">
                                                        <tr>
                                                            <td class="t_body">
                                                                <div style="display: flex; justify-content: center;">
                                                                    <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NegativeDelivery')
                                                                        <input type="checkbox" name="negative_delivery" value="on">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            @endif
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                    <span class="input-group-addon">@lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="CustomerDelivery_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 15px !important;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>  
                                                </div>
                                            </div>
                                            <div class="margin-top-10">
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CustomerDeliveryItemList')</span>
                </div>
                <div class="pull-right">
                    @permission('CustomerDeliveryItem-export')
                    <span id="anchore-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                </span>

                    @endpermission
                    @permission('CustomerDeliveryItem-create')
                    <a href="{{route('customerDeliveryItem.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="InventoryTransfer">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.PaletNumber')</th>
                        <th>@lang('layout.TotalQty')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        @if(getNegativeSale() == 'true')
                        <th>@lang('layout.NegativeDelivery')</th>
                        @endif
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

    <iframe id="transferFrames" style="display: none;"></iframe>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        var cust_rep = {!!customeReportNewData('CustomerDelivery_index')!!};

        Vue.component('v-select', VueSelect.VueSelect);
        function printTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('printCustomerDeliveryItem')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#InventoryTransfer').DataTable({
                ajax: '{{route("customerDeliveryItem.index")}}',
                pageLength: '{{getPageRows()}}',
                // scrollY:        450,
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'customer_delivery_items.id', searchable: false},
                    {data: 'number', name: 'customer_delivery_items.number'},
                    {data: 'ref_no', name: 'customer_delivery_items.ref_no'},
                    {data: 'customer', name: 'members.name'},
                    {data: 'driver', name: 'driver_info.name'},
                    {data: 'phone', name: 'driver_info.phone'},
                    {data: 'palet_number', name: 'driver_info.palet_number'},
                    {data: 'totalQty', name: 'totalQty', searchable: false},
                    {data: 'Date', name: 'customer_delivery_items.date'},
                    {data: 'user_name', name: 'users.name', searchable: false},
                    {data: 'description', name: 'customer_delivery_items.description'},
                    @if(getNegativeSale() == 'true')
                    {data: 'delivery_type', name: 'customer_delivery_items.delivery_type', searchable: false},
                    @endif
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });

        var memberClass ={!! $memberClass !!}

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("customerDeliveryItem.report") !!}',
                excelRoute: '{!! route("customerDeliveryItem.report") !!}',
                selectedItem: null,
                memberClass: memberClass,
                selectedmemberClass: null,
                itemlist: [],
                customer: [],
                selectedCustomer: null,
                customReportData:[
                    // {Name: '@lang("layout.Record")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                    {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep.ref_no)?'checked':'',column_percentage:(cust_rep.ref_no___percent)?cust_rep.ref_no___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                    {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                    {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                    {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                    {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(cust_rep.phone)?'checked':'',column_percentage:(cust_rep.phone___percent)?cust_rep.phone___percent:''},
                    {Name: '@lang("layout.PlateNumber")', column_name: 'plate_number',checkedColumn:(cust_rep.plate_number)?'checked':'',column_percentage:(cust_rep.plate_number___percent)?cust_rep.plate_number___percent:''},
                    {Name: '@lang("layout.TotalQuantity")', column_name: 'total_quantity',checkedColumn:(cust_rep.total_quantity)?'checked':'',column_percentage:(cust_rep.total_quantity___percent)?cust_rep.total_quantity___percent:''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                    {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                    {Name: '@lang("layout.Value")', column_name: 'value',checkedColumn:(cust_rep.value)?'checked':'',column_percentage:(cust_rep.value___percent)?cust_rep.value___percent:''},
                    {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                    {Name: '@lang("layout.Responsible")', column_name: 'responsible',checkedColumn:(cust_rep.responsible)?'checked':'',column_percentage:(cust_rep.responsible___percent)?cust_rep.responsible___percent:''},
                ]
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.customer = [];
                        if (response.data.length > 0) {
                            vm.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })

                }, getDebounceTime()),

                //ajax call to get items
                onItemSearch(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                        vm.itemlist = response.data;
                        // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush

