@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
    .required {
        padding-left: 0px !important;
        color: red;
    }
</style>
@stop
@section('content')
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CustomerDeliveryItemCreate')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="app" class="portlet-body"> 
                <div class="tabbable tabbable-tabdrop"> 
                    <div>
                        {{Form::open(['route' => 'customerDeliveryItem.store','method' => 'POST','class' => 'form-horizontal','id'=>'transfer-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <!-- begin inputs -->


                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Number')</label>
                                                        <input type="text" name="number" value="{{$number}}" class="form-control" placeholder="@lang('layout.Number')">

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                        <input type="text" name="ref_no" class="form-control" placeholder="@lang('layout.ReferenceNumber')">

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Customer')</label>
                                                        <v-select label="name" v-model="selected_customer" @input="memberChange()" :options="customer" @search="MemberSearch">
                                                        </v-select>
                                                        <input type="hidden" name="customer_id" :value="(!selected_customer)?null:selected_customer.id">

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Date')</label>

                                                        <input type="text" name="date" class="form-control date now" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Currency')</label>
                                                        <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                        <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                        <span class="required">@{{ errors.first('currency') }}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Rate')</label>
                                                        <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                        <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.UnitPrice')</label>
                                                        <input type="number" name="amount" class="form-control" placeholder="@lang('layout.UnitPrice')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Prepaid')</label>
                                                        <input type="number" name="prepaid" class="form-control" placeholder="@lang('layout.Prepaid')">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="!driver_type">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Driver')</label>
                                                        <input type="text" name="driver" class="form-control" placeholder="@lang('layout.Driver')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="!driver_type">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.PaletNumber')</label>
                                                        <input type="text" name="palet_number" class="form-control" placeholder="@lang('layout.PaletNumber')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Color')</label>
                                                        <input type="text" name="color" class="form-control" placeholder="@lang('layout.Color')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Commissar')</label>
                                                        <input type="text" name="commissar" class="form-control" placeholder="@lang('layout.Commissar')">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Source')</label>
                                                        <input type="text" name="source" class="form-control" placeholder="@lang('layout.Source')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Destination')</label>
                                                        <input type="text" name="destination" class="form-control" placeholder="@lang('layout.Destination')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.LoadPlace')</label>
                                                        <input type="text" name="load_place" class="form-control" placeholder="@lang('layout.LoadPlace')">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Phone')</label>
                                                        <input type="text" name="phone" class="form-control" placeholder="@lang('layout.Phone')">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label"> @lang('layout.DriverType')</label>
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="driver_type" v-model="driver_type" value="on" />
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            @if(getNegativeSale() == 'true')
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                    <table class="table table-striped table-bordered table-advance ">
                                                        <tr>
                                                            <td class="t_body">
                                                                <div style="display: flex; justify-content: center;">
                                                                    <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NegativeDelivery')
                                                                        <input type="checkbox" name="negative_delivery" value="on">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            @endif
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                        <textarea name="description" class="form-control" rows="1"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row" style="overflow-x: scroll;">
                                            <table id="table_content" class="table table-bordered table-advance">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: 130px; text-align:center;">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 130px; text-align:center;">@lang('layout.Site') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Measure') </th>
                                                        <th v-show="driver_type" style="min-width: 100px; text-align:center;">@lang('layout.Driver') </th>
                                                        <th v-show="driver_type" style="min-width: 100px; text-align:center;">@lang('layout.PaletNumber') </th>
                                                        <th v-show="driver_type" style="min-width: 100px; text-align:center;">@lang('layout.Phone') </th>
                                                        <th v-show="driver_type" style="min-width: 100px; text-align:center;">@lang('layout.Responsible') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Description') </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" @input="onItemload(index)" v-model="item.inventory" :options="temp_items" @search="onItemSearch"></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                            <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                        </td>
                                                        <td class="highlight">

                                                            <div class="input-group">
                                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item != null)">
                                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                            @{{site.site_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>

                                                                <input type="hidden" name="from_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">

                                                                <span class="input-group-addon">@{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" :name="'inventory_measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="driver_type">
                                                            <input type="text" :name="'inventory_driver['+index+']'" class="form-control input-style" placeholder="@lang('layout.Driver')">
                                                        </td>
                                                        <td v-show="driver_type">
                                                            <input type="text" :name="'inventory_palet_number['+index+']'" class="form-control input-style" placeholder="@lang('layout.PaletNumber')">
                                                        </td>
                                                        <td v-show="driver_type">
                                                            <input type="text" :name="'inventory_phone['+index+']'" class="form-control input-style" placeholder="@lang('layout.Phone')">
                                                        </td>
                                                        <td v-show="driver_type">
                                                            <input type="text" :name="'inventory_responsible['+index+']'" class="form-control input-style" placeholder="@lang('layout.Responsible')">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'inventory_description['+index+']'" class="form-control input-style" placeholder="@lang('layout.Description')">
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('inventory',100)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tbody>
                                            </table>


                                        </div>


                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                        <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>

                                        <a href="{{route('customerDeliveryItem.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>

                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                </div>

                            </div>


                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>
@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);
    var currency ={!! $currency !!};
    
    var v = new Vue({
        el: '#app',
        data: {
            showModal: false,
            driver_type: true,
            temp_items: [],
            selected_index: 0,
            customer: [],
            selected_customer: null,
            currency: currency,
            selected_currency: defaultCurrency(),
            rate: 0,
            inventories: [{
                inventory: null,
                item: null
            }, ],

        },
        computed: {
            selectedRate() {
                this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
            },

            // check data validation
            isError: function() {
                var isError = false;
                var flag = false;
                /**for (var i = 0; i < this.inventories.length; i++)
                     {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/

                return isError;
            },

        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        v.submitForm(e.target);
                    }
                });
            },

            memberChange() {
                this.temp_items = [];
                this.inventories = [];
                this.inventories.push({
                    inventory: null,
                    item: null
                });
            },

            // begin item search
            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                let customer_id = (v.selected_customer != undefined) ? v.selected_customer.id : '';
                if (customer_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchCustomer',
                            keyword: search,
                            customer_id: customer_id
                        }
                    })
                    .then(function(response) {
                        v.temp_items = [];
                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    }) 
                }
                loading(false);
            }, getDebounceTime()),


            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let customer_id = (v.selected_customer != undefined) ? v.selected_customer.id : '';
                    if (customer_id) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'loadItemTransferCustomer',
                                inventory_id: inventory_id,
                                customer_id: customer_id

                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            if (response.data.length > 0) {
                                v.inventories[index].item = response.data[0];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                    }
                }
            },

            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //ajax call to get items
            setIndex(e) {
                //v.temp_items=[];
                this.selected_index = e;
            },

            // end item search

            //get item quantity
            ToSiteItemQuantity(item = null, quantity = null, edit_quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.to_site) {
                        result = (item.to_site.OnHand * item.measure_unit) / (item.measure.measure_unit) + Number(quantity);


                    }
                    if (edit_quantity != null) {
                        result += Number(edit_quantity);
                    }
                    return result;
                }
            },

            // contract search


            // generic function for adding item to list
            addNew(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null
                            });
                        }
                    }
                }
            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }

                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("transfer-form").submit()

                    } else {

                    }
                });

            },
            defaultValue() {
                this.selected_index = 0;

                this.inventories = [{
                    item: null,
                    item_category: this.selected_iventory_category
                }, ];

                this.temp_items = [];

            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('customerDeliveryItem.store')}}";
                            form_id = 'transfer-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        toastr.success('', response.data.message);
                                        location.reload();
                                        v.defaultValue();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },
        created: function() {

        }

    });
</script>


@endpush